/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectCompressedPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectFullPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.structure.J9ObjectCompressed;
import com.ibm.j9ddr.vm29.structure.J9ObjectFull;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class J9ObjectHelper {
    private static int cacheSize;
    private static J9ObjectPointer[] keys;
    private static J9ClassPointer[] values;
    private static int[] counts;
    private static long probes;
    private static long hits;
    public static final boolean mixedReferenceMode;
    public static final boolean compressObjectReferences;
    private static Boolean isStringBackedByByteArray;

    public static boolean isIndexable(J9ObjectPointer objPointer) throws CorruptDataException {
        return ObjectModel.isIndexable(objPointer);
    }

    public static U32 flags(J9ObjectPointer objPointer) throws CorruptDataException {
        long bitmask = J9Consts.J9_REQUIRED_CLASS_ALIGNMENT - 1L;
        UDATA clazz = J9ObjectHelper.rawClazz(objPointer);
        return new U32(clazz.bitAnd(bitmask));
    }

    public static long headerSize() {
        if (mixedReferenceMode) {
            if (compressObjectReferences) {
                return J9ObjectCompressed.SIZEOF;
            }
            return J9ObjectFull.SIZEOF;
        }
        return J9Object.SIZEOF;
    }

    public static UDATA rawClazz(J9ObjectPointer objPointer) throws CorruptDataException {
        if (mixedReferenceMode) {
            try {
                if (compressObjectReferences) {
                    return J9ObjectCompressedPointer.cast(objPointer).clazz();
                }
                return J9ObjectFullPointer.cast(objPointer).clazz();
            }
            catch (NoSuchFieldException e) {
                throw new CorruptDataException(e);
            }
        }
        return UDATA.cast(objPointer.clazz());
    }

    public static J9ClassPointer clazz(J9ObjectPointer objPointer) throws CorruptDataException {
        J9ClassPointer classPointer = J9ObjectHelper.checkClassCache(objPointer);
        if (null == classPointer) {
            long bitmask = J9Consts.J9_REQUIRED_CLASS_ALIGNMENT - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            UDATA clazz = J9ObjectHelper.rawClazz(objPointer);
            classPointer = J9ClassPointer.cast(clazz.bitAnd(bitmask));
            J9ObjectHelper.setClassCache(objPointer, classPointer);
        }
        return classPointer;
    }

    public static UDATA monitor(J9ObjectPointer objPointer) throws CorruptDataException {
        throw new UnsupportedOperationException("lockNursery not supported yet");
    }

    public static String getClassName(J9ObjectPointer objPointer) throws CorruptDataException {
        return J9ClassHelper.getName(J9ObjectHelper.clazz(objPointer));
    }

    public static String getJavaName(J9ObjectPointer objPointer) throws CorruptDataException {
        return J9ClassHelper.getJavaName(J9ObjectHelper.clazz(objPointer));
    }

    public static String stringValue(J9ObjectPointer objPointer) throws CorruptDataException {
        Object[] value;
        J9ObjectPointer valueObject;
        if (!J9ObjectHelper.getClassName(objPointer).equals("java/lang/String")) {
            throw new IllegalArgumentException();
        }
        if (isStringBackedByByteArray == null) {
            try {
                J9ObjectHelper.getObjectField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "value", "[B"));
                isStringBackedByByteArray = true;
            }
            catch (NoSuchElementException e) {
                J9ObjectHelper.getObjectField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "value", "[C"));
                isStringBackedByByteArray = false;
            }
        }
        J9ObjectPointer j9ObjectPointer = valueObject = isStringBackedByByteArray != false ? J9ObjectHelper.getObjectField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "value", "[B")) : J9ObjectHelper.getObjectField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "value", "[C"));
        if (valueObject.isNull()) {
            return "<Uninitialized String>";
        }
        int stringLength = 0;
        boolean isStringCompressed = false;
        J9IndexableObjectPointer valueArray = J9IndexableObjectPointer.cast(valueObject);
        if (isStringBackedByByteArray.booleanValue()) {
            byte coder = J9ObjectHelper.getByteField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "coder", "B"));
            isStringCompressed = coder == 0;
            value = (byte[])J9IndexableObjectHelper.getData(valueArray);
            stringLength = value.length >> coder;
        } else {
            stringLength = J9ObjectHelper.getIntField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "count", "I"));
            String enableCompressionFieldName = AlgorithmVersion.getVersionOf("ALG_VM_JAVA_LANG_STRING_VERSION").getAlgorithmVersion() >= 1 ? "COMPACT_STRINGS" : "enableCompression";
            boolean enableCompression = J9ObjectHelper.getBooleanField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, enableCompressionFieldName, "Z"));
            if (enableCompression) {
                if (stringLength >= 0) {
                    isStringCompressed = true;
                } else {
                    stringLength &= Integer.MAX_VALUE;
                }
            }
        }
        char[] charValue = new char[stringLength];
        if (isStringBackedByByteArray.booleanValue()) {
            value = (byte[])J9IndexableObjectHelper.getData(valueArray);
            if (isStringCompressed) {
                for (int i = 0; i < stringLength; ++i) {
                    charValue[i] = J9ObjectHelper.byteToCharUnsigned(J9ObjectHelper.getByteFromArrayByIndex(value, i));
                }
            } else {
                for (int i = 0; i < stringLength; ++i) {
                    charValue[i] = J9ObjectHelper.getCharFromArrayByIndex(value, i);
                }
            }
        } else {
            value = (char[])J9IndexableObjectHelper.getData(valueArray);
            if (isStringCompressed) {
                for (int i = 0; i < stringLength; ++i) {
                    charValue[i] = J9ObjectHelper.byteToCharUnsigned(J9ObjectHelper.getByteFromArrayByIndex(value, i));
                }
            } else {
                for (int i = 0; i < stringLength; ++i) {
                    charValue[i] = J9ObjectHelper.getCharFromArrayByIndex(value, i);
                }
            }
        }
        return new String(charValue);
    }

    public static String getStringField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        J9ObjectPointer stringObject = J9ObjectHelper.getObjectField(objPointer, offset);
        if (stringObject.isNull()) {
            return null;
        }
        return J9ObjectHelper.stringValue(stringObject);
    }

    public static int getIntField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        I32Pointer pointer = offset.isStatic() ? I32Pointer.cast(J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress())) : I32Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(ObjectModel.getHeaderSize(objPointer)));
        return pointer.at(0L).intValue();
    }

    public static short getShortField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (short)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFFFF);
    }

    public static float getFloatField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        int data = J9ObjectHelper.getIntField(objPointer, offset);
        return Float.intBitsToFloat(data);
    }

    public static double getDoubleField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        long data = J9ObjectHelper.getLongField(objPointer, offset);
        return Double.longBitsToDouble(data);
    }

    public static char getCharField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (char)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFFFF);
    }

    public static byte getByteField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (byte)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFF);
    }

    public static boolean getBooleanField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return J9ObjectHelper.getIntField(objPointer, offset) != 0;
    }

    public static long getLongField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        I64Pointer pointer = offset.isStatic() ? I64Pointer.cast(J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress())) : I64Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(ObjectModel.getHeaderSize(objPointer)));
        return pointer.at(0L).longValue();
    }

    public static J9ObjectPointer getObjectField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        if (offset.isStatic()) {
            UDATAPointer pointer = J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress());
            return J9ObjectPointer.cast(pointer.at(0L));
        }
        return ObjectReferencePointer.cast(objPointer.addOffset(ObjectModel.getHeaderSize(objPointer)).addOffset(offset.getOffsetOrAddress())).at(0L);
    }

    private static J9ObjectFieldOffset getFieldOffset(J9ObjectPointer objPointer, String name, String signature) throws CorruptDataException {
        J9ObjectFieldOffset result = J9ClassHelper.checkFieldOffsetCache(J9ObjectHelper.clazz(objPointer), name, signature);
        if (result == null) {
            result = J9ObjectHelper.readFieldOffset(objPointer, name, signature);
            J9ClassHelper.setFieldOffsetCache(J9ObjectHelper.clazz(objPointer), result, name, signature);
        }
        return result;
    }

    private static J9ObjectFieldOffset readFieldOffset(J9ObjectPointer objPointer, String name, String signature) throws CorruptDataException {
        J9ClassPointer currentClass = J9ObjectHelper.clazz(objPointer);
        while (currentClass.notNull()) {
            Iterator<J9ObjectFieldOffset> fields = J9ClassHelper.getFieldOffsets(currentClass);
            while (fields.hasNext()) {
                J9ObjectFieldOffset field = fields.next();
                if (!field.getName().equals(name) || !field.getSignature().equals(signature)) continue;
                return field;
            }
            currentClass = J9ClassHelper.superclass(currentClass);
        }
        throw new NoSuchElementException(String.format("No field named %s with signature %s in %s", name, signature, J9ObjectHelper.getClassName(objPointer)));
    }

    private static J9ClassPointer checkClassCache(J9ObjectPointer objPointer) {
        ++probes;
        for (int i = 0; i < cacheSize; ++i) {
            if (!keys[i].equals(objPointer)) continue;
            ++hits;
            int n = i;
            counts[n] = counts[n] + 1;
            return values[i];
        }
        return null;
    }

    private static void setClassCache(J9ObjectPointer objPointer, J9ClassPointer classPointer) {
        int min = counts[0];
        int minIndex = 0;
        for (int i = 1; i < cacheSize; ++i) {
            if (counts[i] >= min) continue;
            min = counts[i];
            minIndex = i;
        }
        J9ObjectHelper.keys[minIndex] = objPointer;
        J9ObjectHelper.values[minIndex] = classPointer;
        J9ObjectHelper.counts[minIndex] = 1;
    }

    private static void initializeCache() {
        keys = new J9ObjectPointer[cacheSize];
        values = new J9ClassPointer[cacheSize];
        counts = new int[cacheSize];
        probes = 0L;
        hits = 0L;
        for (int i = 0; i < cacheSize; ++i) {
            J9ObjectHelper.keys[i] = J9ObjectPointer.NULL;
        }
    }

    public static byte getByteFromArrayByIndex(Object obj, int index) {
        Class<?> clazz = obj.getClass();
        if (clazz == byte[].class) {
            return ((byte[])obj)[index];
        }
        if (clazz == char[].class) {
            char[] array = (char[])obj;
            if (J9BuildFlags.env_littleEndian) {
                if (index % 2 == 1) {
                    return (byte)((array[index / 2] & 0xFF00) >>> 8);
                }
                return (byte)(array[index / 2] & 0xFF);
            }
            if (index % 2 == 1) {
                return (byte)(array[index / 2] & 0xFF);
            }
            return (byte)((array[index / 2] & 0xFF00) >>> 8);
        }
        throw new RuntimeException("Unknown array type for bit manipulation");
    }

    private static char getCharFromArrayByIndex(Object obj, int index) {
        Class<?> clazz = obj.getClass();
        if (clazz == byte[].class) {
            index <<= 1;
            byte[] array = (byte[])obj;
            if (J9BuildFlags.env_littleEndian) {
                return (char)(J9ObjectHelper.byteToCharUnsigned(array[index + 1]) << 8 | J9ObjectHelper.byteToCharUnsigned(array[index]) << 0);
            }
            return (char)(J9ObjectHelper.byteToCharUnsigned(array[index + 1]) << 0 | J9ObjectHelper.byteToCharUnsigned(array[index]) << 8);
        }
        if (clazz == char[].class) {
            return ((char[])obj)[index];
        }
        throw new RuntimeException("Unknown array type for bit manipulation");
    }

    private static char byteToCharUnsigned(byte b) {
        return (char)((char)b & 0xFF);
    }

    public static void reportClassCacheStats() {
        double hitRate = (double)hits / (double)probes * 100.0;
        System.out.println("J9ObjectHelper probes: " + probes + " hit rate: " + hitRate + "%");
        J9ObjectHelper.initializeCache();
    }

    static {
        block5: {
            cacheSize = 32;
            isStringBackedByByteArray = null;
            J9ObjectHelper.initializeCache();
            try {
                boolean bl = mixedReferenceMode = AlgorithmVersion.getVersionOf("MIXED_REFERENCE_MODE").getAlgorithmVersion() > 0;
                if (mixedReferenceMode) {
                    J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
                    try {
                        compressObjectReferences = vm.extendedRuntimeFlags2().anyBitsIn(J9Consts.J9_EXTENDED_RUNTIME2_COMPRESS_OBJECT_REFERENCES);
                        break block5;
                    }
                    catch (NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                }
                compressObjectReferences = J9BuildFlags.gc_compressedPointers;
            }
            catch (CorruptDataException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

