/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.IScalar;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;

public class U64
extends UDATA {
    public static final int SIZEOF = 8;
    public static final long MASK = -1L;
    public static final U64 MIN = new U64(0L);
    public static final U64 MAX = new U64(-1L);

    public U64(long value) {
        super(value);
        this.data = value;
    }

    public U64(Scalar parameter) {
        super(parameter);
    }

    public U64 add(int number) {
        return new U64(this.data + (long)number);
    }

    @Override
    public U64 add(long number) {
        return new U64(this.data + number);
    }

    @Override
    public U64 add(UScalar parameter) {
        return this.add(new U64(parameter));
    }

    @Override
    public U64 add(U64 parameter) {
        return new U64(this.data + parameter.data);
    }

    @Override
    public U64 add(IScalar parameter) {
        return this.add(new U64(parameter));
    }

    public U64 sub(int number) {
        return new U64(this.data - (long)number);
    }

    @Override
    public U64 sub(long number) {
        return new U64(this.data - number);
    }

    @Override
    public U64 sub(UScalar parameter) {
        return this.sub(new U64(parameter));
    }

    @Override
    public U64 sub(U64 parameter) {
        return new U64(this.data - parameter.data);
    }

    @Override
    public U64 sub(I8 parameter) {
        return this.sub(new U64(parameter));
    }

    @Override
    public U64 sub(I16 parameter) {
        return this.sub(new U64(parameter));
    }

    @Override
    public U64 sub(I32 parameter) {
        return this.sub(new U64(parameter));
    }

    public U64 sub(I64 parameter) {
        return this.sub(new U64(parameter));
    }

    @Override
    public int intValue() {
        long value = this.data;
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new InvalidDataTypeException("U64 contains value larger than Integer.MAX_VALUE");
        }
        return (int)value;
    }

    @Override
    public long longValue() {
        long value = this.data;
        if (value < 0L) {
            throw new InvalidDataTypeException("U64 contains value larger than Long.MAX_VALUE");
        }
        return value;
    }

    @Override
    public U64 bitOr(int number) {
        return new U64(this.data | (long)number);
    }

    @Override
    public U64 bitOr(long number) {
        return new U64(this.data | number);
    }

    @Override
    public U64 bitOr(UScalar parameter) {
        return this.bitOr(new U64(parameter));
    }

    @Override
    public U64 bitOr(U64 parameter) {
        return new U64(this.data | parameter.data);
    }

    @Override
    public U64 bitOr(I8 parameter) {
        return this.bitOr(new U64(parameter));
    }

    @Override
    public U64 bitOr(I16 parameter) {
        return this.bitOr(new U64(parameter));
    }

    @Override
    public U64 bitOr(I32 parameter) {
        return this.bitOr(new U64(parameter));
    }

    public U64 bitOr(I64 parameter) {
        return this.bitOr(new U64(parameter));
    }

    @Override
    public U64 bitXor(int number) {
        return new U64(this.data ^ (long)number);
    }

    @Override
    public U64 bitXor(long number) {
        return new U64(this.data ^ number);
    }

    @Override
    public U64 bitXor(Scalar parameter) {
        return this.bitXor(new U64(parameter));
    }

    @Override
    public U64 bitXor(U64 parameter) {
        return new U64(this.data ^ parameter.data);
    }

    @Override
    public U64 bitAnd(int number) {
        return new U64(this.data & (long)number);
    }

    @Override
    public U64 bitAnd(long number) {
        return new U64(this.data & number);
    }

    @Override
    public U64 bitAnd(UScalar parameter) {
        return this.bitAnd(new U64(parameter));
    }

    @Override
    public U64 bitAnd(U64 parameter) {
        return new U64(this.data & parameter.data);
    }

    @Override
    public U64 bitAnd(I8 parameter) {
        return this.bitAnd(new U64(parameter));
    }

    @Override
    public U64 bitAnd(I16 parameter) {
        return this.bitAnd(new U64(parameter));
    }

    @Override
    public U64 bitAnd(I32 parameter) {
        return this.bitAnd(new U64(parameter));
    }

    public U64 bitAnd(I64 parameter) {
        return this.bitAnd(new U64(parameter));
    }

    @Override
    public boolean gt(Scalar parameter) {
        this.checkComparisonValid(parameter);
        if ((this.data ^ parameter.data) < 0L) {
            return this.data < parameter.data;
        }
        return this.data > parameter.data;
    }

    @Override
    public boolean lt(Scalar parameter) {
        this.checkComparisonValid(parameter);
        if ((this.data ^ parameter.data) < 0L) {
            return this.data > parameter.data;
        }
        return this.data < parameter.data;
    }

    @Override
    public U64 leftShift(int i) {
        return new U64(this.data << i);
    }

    @Override
    public U64 rightShift(int i) {
        return new U64(this.data >>> i);
    }

    @Override
    public U64 bitNot() {
        return new U64(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public U64 mult(int parameter) {
        return new U64(this.data * (long)parameter);
    }

    @Override
    public U64 mult(long parameter) {
        return new U64(this.data * parameter);
    }

    @Override
    public boolean eq(long parameter) {
        return parameter == this.data;
    }

    @Override
    public boolean eq(Scalar parameter) {
        if (parameter.isSigned()) {
            return this.eq(new U64(parameter));
        }
        return this.data == parameter.data;
    }

    @Override
    public int sizeof() {
        return 8;
    }
}

