/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.ObjectHash;
import com.ibm.j9ddr.vm29_00.j9.ObjectModel;
import com.ibm.j9ddr.vm29_00.j9.gc.GCBase;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29_00.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm29_00.pointer.I32Pointer;
import com.ibm.j9ddr.vm29_00.pointer.VoidPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.GC_ObjectModelPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29_00.structure.GC_ObjectModel$ScanType;
import com.ibm.j9ddr.vm29_00.structure.J9Consts;
import com.ibm.j9ddr.vm29_00.structure.J9Object;
import com.ibm.j9ddr.vm29_00.types.I32;
import com.ibm.j9ddr.vm29_00.types.U32;
import com.ibm.j9ddr.vm29_00.types.UDATA;

class GCObjectModel_V1
extends GCObjectModel {
    private J9JavaVMPointer vm;
    private J9ClassPointer classClass;
    private J9ClassPointer classLoaderClass;
    private J9ClassPointer atomicMarkableReferenceClass;
    private VoidPointer tenureBase;
    private UDATA tenureSize;
    private static final long OBJECT_HEADER_REMEMBERED_BITS = J9BuildFlags.gc_arraylets ? J9Object.OBJECT_HEADER_AGE_MASK & (J9Consts.J9_GC_ARRAYLET_LAYOUT_MASK ^ 0xFFFFFFFFFFFFFFFFL) : J9Object.OBJECT_HEADER_AGE_MASK;
    private static final long STATE_REMEMBERED = J9Consts.J9_OBJECT_HEADER_REMEMBERED_BITS_TO_SET & OBJECT_HEADER_REMEMBERED_BITS;
    private static final long OBSOLETE_OBJECT_ALIGNMENT_IN_BYTES = 8L;

    protected GCObjectModel_V1() throws CorruptDataException {
        GC_ObjectModelPointer imageObjectModel = GCObjectModel_V1.getExtensions().objectModel();
        this.vm = GCBase.getJavaVM();
        this.classClass = imageObjectModel._classClass();
        this.classLoaderClass = imageObjectModel._classLoaderClass();
        this.atomicMarkableReferenceClass = imageObjectModel._atomicMarkableReferenceClass();
        this.tenureBase = GCObjectModel_V1.getExtensions()._tenureBase();
        this.tenureSize = GCObjectModel_V1.getExtensions()._tenureSize();
    }

    @Override
    public U32 getAge(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.flags(object).bitAnd(J9Object.OBJECT_HEADER_AGE_MASK).rightShift((int)J9Object.OBJECT_HEADER_AGE_SHIFT);
    }

    @Override
    public UDATA getConsumedSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        UDATA size = this.getSizeInBytesWithHeader(object);
        if (this.hasBeenMoved(object) && this.getHashcodeOffset(object).eq(size)) {
            size = size.add(UDATA.SIZEOF);
        }
        return this.adjustSizeInBytes(size);
    }

    @Override
    public UDATA getClassShape(J9ObjectPointer object) throws CorruptDataException {
        return this.getClassShape(J9ObjectHelper.clazz(object));
    }

    @Override
    public UDATA getSizeInBytesDeadObject(J9ObjectPointer object) throws CorruptDataException {
        if (this.isSingleSlotDeadObject(object)) {
            return this.getSizeInBytesSingleSlotDeadObject(object);
        }
        return this.getSizeInBytesMultiSlotDeadObject(object);
    }

    @Override
    public UDATA getSizeInBytesMultiSlotDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return GCHeapLinkedFreeHeader.fromJ9Object(object).getSize();
    }

    @Override
    public UDATA getSizeInBytesSingleSlotDeadObject(J9ObjectPointer object) {
        return new UDATA(UDATA.SIZEOF);
    }

    @Override
    public long getObjectAlignmentInBytes() {
        long result = 0L;
        try {
            result = this.vm.omrVM()._objectAlignmentInBytes().longValue();
            if (0L == result) {
                result = 8L;
            }
        }
        catch (NoSuchFieldError e) {
            result = 8L;
        }
        catch (CorruptDataException e) {
            result = 8L;
        }
        return result;
    }

    @Override
    public UDATA getSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        if (this.isIndexable(object)) {
            return this.indexableObjectModel.getSizeInBytesWithHeader(J9IndexableObjectPointer.cast(object));
        }
        return this.mixedObjectModel.getSizeInBytesWithHeader(object);
    }

    @Override
    public boolean isDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.flags(object).allBitsIn(J9Consts.J9_GC_OBJ_HEAP_HOLE);
    }

    @Override
    public boolean isIndexable(J9ObjectPointer object) throws CorruptDataException {
        return this.isIndexable(J9ObjectHelper.clazz(object));
    }

    @Override
    public boolean isIndexable(J9ClassPointer clazz) throws CorruptDataException {
        return J9ClassHelper.isArrayClass(clazz) || J9ClassHelper.isPackedArrayClass(clazz);
    }

    @Override
    public boolean isOld(J9ObjectPointer object) throws CorruptDataException {
        VoidPointer topOfTenure = this.tenureBase.addOffset(this.tenureSize);
        return object.gte(this.tenureBase) && object.lt(topOfTenure);
    }

    @Override
    public boolean isRemembered(J9ObjectPointer object) throws CorruptDataException {
        return this.getRememberedBits(object).gte(new UDATA(STATE_REMEMBERED));
    }

    @Override
    public boolean isSingleSlotDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.flags(object).bitAnd(J9Consts.J9_GC_OBJ_HEAP_HOLE_MASK).eq(J9Consts.J9_GC_SINGLE_SLOT_HOLE);
    }

    @Override
    public UDATA adjustSizeInBytes(UDATA sizeInBytes) {
        long bytes = sizeInBytes.longValue();
        if (!J9BuildFlags.env_data64 || J9BuildFlags.gc_compressedPointers && J9BuildFlags.gc_arraylets) {
            bytes = bytes + (ObjectModel.getObjectAlignmentInBytes() - 1L) & (ObjectModel.getObjectAlignmentInBytes() - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (J9BuildFlags.gc_minimumObjectSize && bytes < J9Consts.J9_GC_MINIMUM_OBJECT_SIZE) {
            bytes = J9Consts.J9_GC_MINIMUM_OBJECT_SIZE;
        }
        return new UDATA(bytes);
    }

    @Override
    public UDATA getSizeInElements(J9ObjectPointer object) throws IllegalArgumentException, CorruptDataException {
        if (this.isIndexable(object)) {
            return this.indexableObjectModel.getSizeInElements(J9IndexableObjectPointer.cast(object));
        }
        throw new IllegalArgumentException("this API is only valid on indexable objects");
    }

    @Override
    public UDATA getRememberedBits(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.flags(object).bitAnd(new UDATA(OBJECT_HEADER_REMEMBERED_BITS));
    }

    @Override
    public long getScanType(J9ObjectPointer object) throws CorruptDataException {
        J9ClassPointer clazz = J9ObjectHelper.clazz(object);
        long result = J9ClassHelper.isPacked(clazz) ? (this.isIndexable(object) ? (this.packedArrayObjectModel.isPackedObjectHeader(J9IndexableObjectPointer.cast(object)) ? GC_ObjectModel$ScanType.SCAN_PACKED_ARRAY_HEADER : GC_ObjectModel$ScanType.SCAN_PACKED_ARRAY) : (this.packedObjectModel.isPackedObjectHeader(object) ? GC_ObjectModel$ScanType.SCAN_PACKED_HEADER : GC_ObjectModel$ScanType.SCAN_PACKED_OBJECT)) : this.getScanType(clazz);
        return result;
    }

    private long getScanType(J9ClassPointer clazz) throws CorruptDataException {
        long shape = this.getClassShape(clazz).longValue();
        long result = shape == J9Object.OBJECT_HEADER_SHAPE_MIXED ? (J9ClassHelper.classFlags(clazz).anyBitsIn(J9Consts.J9_JAVA_CLASS_REFERENCE_MASK) ? GC_ObjectModel$ScanType.SCAN_REFERENCE_MIXED_OBJECT : (J9ClassHelper.classFlags(clazz).anyBitsIn(J9Consts.J9_JAVA_CLASS_GC_SPECIAL) ? this.getSpecialClassScanType(clazz) : GC_ObjectModel$ScanType.SCAN_MIXED_OBJECT)) : (shape == J9Object.OBJECT_HEADER_SHAPE_POINTERS ? GC_ObjectModel$ScanType.SCAN_POINTER_ARRAY_OBJECT : (shape == J9Object.OBJECT_HEADER_SHAPE_DOUBLES || shape == J9Object.OBJECT_HEADER_SHAPE_BYTES || shape == J9Object.OBJECT_HEADER_SHAPE_WORDS || shape == J9Object.OBJECT_HEADER_SHAPE_LONGS ? GC_ObjectModel$ScanType.SCAN_PRIMITIVE_ARRAY_OBJECT : GC_ObjectModel$ScanType.SCAN_INVALID_OBJECT));
        return result;
    }

    private long getSpecialClassScanType(J9ClassPointer clazz) throws CorruptDataException {
        long result = GC_ObjectModel$ScanType.SCAN_MIXED_OBJECT;
        result = clazz.eq(this.classClass) ? GC_ObjectModel$ScanType.SCAN_CLASS_OBJECT : (this.classLoaderClass.notNull() && J9ClassHelper.isSameOrSuperClassOf(this.classLoaderClass, clazz) ? GC_ObjectModel$ScanType.SCAN_CLASSLOADER_OBJECT : (this.atomicMarkableReferenceClass.notNull() && J9ClassHelper.isSameOrSuperClassOf(this.atomicMarkableReferenceClass, clazz) ? GC_ObjectModel$ScanType.SCAN_ATOMIC_MARKABLE_REFERENCE_OBJECT : GC_ObjectModel$ScanType.SCAN_INVALID_OBJECT));
        return result;
    }

    @Override
    public I32 getObjectHashCode(J9ObjectPointer object) throws CorruptDataException {
        I32 result = new I32(0L);
        if (J9BuildFlags.gc_modronCompaction || J9BuildFlags.gc_generational) {
            if (this.hasBeenMoved(object)) {
                result = I32Pointer.cast(object).addOffset(this.getHashcodeOffset(object).longValue()).at(0L);
            } else if (J9ObjectHelper.isPacked(object)) {
                J9ObjectPointer targetObj = this.getTargetObject(object);
                UDATA targetOffset = this.getTargetOffset(object);
                boolean rehashWithOffset = true;
                if (targetObj.notNull()) {
                    if (!targetObj.eq(object)) {
                        result = this.getObjectHashCode(targetObj);
                        if (targetOffset.eq(this.getTargetOffset(targetObj))) {
                            rehashWithOffset = false;
                        }
                    } else {
                        result = ObjectHash.convertObjectAddressToHash(this.vm, object);
                    }
                }
                if (rehashWithOffset) {
                    result = result.bitXor(ObjectHash.convertValueToHash(this.vm, targetOffset));
                }
            } else {
                result = ObjectHash.convertObjectAddressToHash(this.vm, object);
            }
        } else {
            result = ObjectHash.convertObjectAddressToHash(this.vm, object);
        }
        return result;
    }

    @Override
    public boolean hasBeenHashed(J9ObjectPointer object) throws CorruptDataException {
        if (J9BuildFlags.interp_flagsInClassSlot) {
            return J9ObjectHelper.flags(object).allBitsIn(J9Object.OBJECT_HEADER_HAS_BEEN_HASHED_MASK_IN_CLASS);
        }
        return J9ObjectHelper.flags(object).allBitsIn(J9Object.OBJECT_HEADER_HAS_BEEN_HASHED);
    }

    @Override
    public boolean hasBeenMoved(J9ObjectPointer object) throws CorruptDataException {
        if (J9BuildFlags.interp_flagsInClassSlot) {
            return J9ObjectHelper.flags(object).allBitsIn(J9Object.OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS);
        }
        return J9ObjectHelper.flags(object).allBitsIn(J9Object.OBJECT_HEADER_HAS_BEEN_MOVED);
    }

    @Override
    public UDATA getHashcodeOffset(J9ObjectPointer object) throws CorruptDataException {
        UDATA offset = new UDATA(0L);
        offset = this.isIndexable(object) ? this.indexableObjectModel.getHashcodeOffset(J9IndexableObjectPointer.cast(object)) : this.mixedObjectModel.getHashcodeOffset(object);
        return offset;
    }

    @Override
    public UDATA getHeaderSize(J9ObjectPointer object) throws CorruptDataException {
        if (this.isIndexable(object)) {
            return this.indexableObjectModel.getHeaderSize(J9IndexableObjectPointer.cast(object));
        }
        return this.mixedObjectModel.getHeaderSize(object);
    }

    @Override
    public UDATA getClassShape(J9ClassPointer clazz) throws CorruptDataException {
        return new UDATA(J9ClassHelper.classFlags(clazz).longValue() >> (int)J9Consts.J9_JAVA_CLASS_RAM_SHAPE_SHIFT & J9Object.OBJECT_HEADER_SHAPE_MASK);
    }

    @Override
    public VoidPointer getElementAddress(J9IndexableObjectPointer indexableObjectPointer, int elementIndex, int elementSize) throws CorruptDataException {
        return this.indexableObjectModel.getElementAddress(indexableObjectPointer, elementIndex, elementSize);
    }

    @Override
    public J9ObjectPointer getTargetObject(J9ObjectPointer object) throws CorruptDataException {
        if (!J9ObjectHelper.isPacked(object)) {
            throw new IllegalArgumentException("Object is not packed");
        }
        if (this.isIndexable(object)) {
            return this.packedArrayObjectModel.getTargetObject(J9IndexableObjectPointer.cast(object));
        }
        return this.packedObjectModel.getTargetObject(object);
    }

    @Override
    public UDATA getTargetOffset(J9ObjectPointer object) throws CorruptDataException {
        if (!J9ObjectHelper.isPacked(object)) {
            throw new IllegalArgumentException("Object is not packed");
        }
        if (this.isIndexable(object)) {
            return this.packedArrayObjectModel.getTargetOffset(J9IndexableObjectPointer.cast(object));
        }
        return this.packedObjectModel.getTargetOffset(object);
    }

    @Override
    public UDATA getPackedDataSize(J9ObjectPointer object) throws CorruptDataException {
        return this.getPackedDataSize(J9ObjectHelper.clazz(object));
    }

    @Override
    public UDATA getPackedDataSize(J9ClassPointer clazz) throws CorruptDataException {
        if (!J9ClassHelper.isPacked(clazz)) {
            throw new IllegalArgumentException("Object is not packed");
        }
        if (this.isIndexable(clazz)) {
            return this.packedArrayObjectModel.getPackedDataSize(clazz);
        }
        return this.packedObjectModel.getPackedDataSize(clazz);
    }

    @Override
    public boolean isPackedObjectHeader(J9ObjectPointer object) throws CorruptDataException {
        if (!J9ObjectHelper.isPacked(object)) {
            throw new IllegalArgumentException("Object is not packed");
        }
        if (this.isIndexable(object)) {
            return this.packedArrayObjectModel.isPackedObjectHeader(J9IndexableObjectPointer.cast(object));
        }
        return this.packedObjectModel.isPackedObjectHeader(object);
    }
}

