/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29_00.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapMap;
import com.ibm.j9ddr.vm29_00.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_HeapMapPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_IncrementalGenerationalGCPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_MarkMapPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_ParallelGlobalGCPointer;
import com.ibm.j9ddr.vm29_00.types.IDATA;
import com.ibm.j9ddr.vm29_00.types.UDATA;
import java.io.PrintStream;

public class MarkMapCommand
extends Command {
    protected static GCHeapMap markMap;

    public MarkMapCommand() {
        this.addCommand("markmap", "<command> <object>", "query the markmap");
    }

    private void printHelp(PrintStream out) {
        out.println("Usage: !markmap <command> <object>");
        out.println("Supported commands:");
        out.println("   help                    Print the help text");
        out.println("   ismarked <object>       Query the markmap to see if <object> is marked");
        out.println("   near <object>           Print out marked objects near <object>");
        out.println("   scanRange <start> <end> Print out marked objects in the specified range");
        out.println("   bits <object>           Show the address of the mark slot corresponding to <object>");
        out.println("   fromBits <addr>         Show the heap range covered by a mark slot");
        out.println("   source <object>         Try to find out where <object> was relocated from");
        out.println("   show                    Display the current markmap in use");
        out.println("   set <markMap>           Change the current markmap");
        out.println();
        out.println("WARNING: markmap data is almost certainly out of date at any time. Interpret these results with extreme care!");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        String subcommand;
        if (command.equals("!markmap")) {
            if (args.length < 1) {
                out.println("No command specified");
                this.printHelp(out);
                return;
            }
            subcommand = args[0];
        } else {
            subcommand = command.substring("!markmap".length());
        }
        if (subcommand.equalsIgnoreCase("ismarked")) {
            this.isMarked(args, context, out);
        } else if (subcommand.equalsIgnoreCase("near")) {
            this.near(args, context, out);
        } else if (subcommand.equalsIgnoreCase("bits")) {
            this.markBits(args, context, out);
        } else if (subcommand.equalsIgnoreCase("fromBits")) {
            this.fromBits(args, context, out);
        } else if (subcommand.equalsIgnoreCase("source")) {
            this.findSource(args, context, out);
        } else if (subcommand.equalsIgnoreCase("scanRange")) {
            this.scanRange(args, context, out);
        } else if (subcommand.equalsIgnoreCase("show")) {
            this.showMarkMap(args, context, out);
        } else if (subcommand.equalsIgnoreCase("set")) {
            this.setMarkMap(args, context, out);
        } else if (subcommand.equals("help")) {
            this.printHelp(out);
        } else {
            out.println("Unrecognised command: " + subcommand);
            this.printHelp(out);
        }
    }

    protected void isMarked(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
            J9ObjectPointer object = J9ObjectPointer.cast(address);
            GCHeapMap.MarkedObject result = markMap.queryObject(object);
            if (result != null) {
                if (result.wasRelocated()) {
                    out.format("Object %s is marked and relocated to %s\n", result.object.getHexAddress(), result.relocatedObject.getHexAddress());
                } else {
                    out.format("Object %s is marked\n", result.object.getHexAddress());
                }
            } else {
                out.format("Object %s is not marked\n", object.getHexAddress());
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    protected void near(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
            J9ObjectPointer object = J9ObjectPointer.cast(address);
            J9ObjectPointer base = object.untag(markMap.getPageSize(object) - 1);
            J9ObjectPointer top = base.addOffset(markMap.getPageSize(object));
            GCHeapMap.MarkedObject[] results = markMap.queryRange(base, top);
            this.reportResults(base, top, results, out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    protected void scanRange(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long baseAddress = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
            long topAddress = CommandUtils.parsePointer(args[2], J9BuildFlags.env_data64);
            J9ObjectPointer base = J9ObjectPointer.cast(baseAddress);
            J9ObjectPointer top = J9ObjectPointer.cast(topAddress);
            GCHeapMap.MarkedObject[] results = markMap.queryRange(base, top);
            this.reportResults(base, top, results, out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    protected void reportResults(J9ObjectPointer base, J9ObjectPointer top, GCHeapMap.MarkedObject[] results, PrintStream out) {
        if (results.length == 0) {
            out.format("No marked objects in the range %s -> %s\n", base.getHexAddress(), top.getHexAddress());
        } else {
            out.format("Marked objects in the range %s -> %s\n", base.getHexAddress(), top.getHexAddress());
            for (int i = 0; i < results.length; ++i) {
                GCHeapMap.MarkedObject result = results[i];
                if (result.wasRelocated()) {
                    out.format("\t!j9object %s -> !j9object %s\n", result.object.getHexAddress(), result.relocatedObject.getHexAddress());
                    continue;
                }
                out.format("\t!j9object %s\n", result.object.getHexAddress());
            }
        }
    }

    protected void markBits(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
            J9ObjectPointer object = J9ObjectPointer.cast(address);
            J9ObjectPointer base = J9ObjectPointer.cast(address).untag(markMap.getPageSize(object) - 1);
            J9ObjectPointer top = base.addOffset(markMap.getPageSize(object));
            GCHeapMap.MarkedObject[] result = markMap.queryRange(base, top);
            if (result.length > 0) {
                if (result[0].wasRelocated()) {
                    out.format("Mark bits for the compacted range %s -> %s: !j9x %s\n", base.getHexAddress(), top.getHexAddress(), result[0].markBitsSlot.getHexAddress());
                } else {
                    out.format("Mark bits for the range %s -> %s: !j9x %s\n", base.getHexAddress(), top.getHexAddress(), result[0].markBitsSlot.getHexAddress());
                }
            } else {
                try {
                    UDATA[] indexAndMask = markMap.getSlotIndexAndMask(base);
                    UDATAPointer markBitsSlot = markMap.getHeapMapBits().add(indexAndMask[0]);
                    out.format("Mark bits for the range %s -> %s: !j9x %s\n", base.getHexAddress(), top.getHexAddress(), markBitsSlot.getHexAddress());
                }
                catch (IllegalArgumentException ex) {
                    out.format("Object %s is not in the heap\n", object.getHexAddress());
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    protected void fromBits(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
        UDATAPointer markSlot = UDATAPointer.cast(address);
        UDATAPointer base = markMap.getHeapMapBits();
        UDATA maxOffset = markMap.getSlotIndexAndMask(J9ObjectPointer.cast(markMap.getHeapTop().subOffset(markMap.getObjectGrain())))[0];
        maxOffset = maxOffset.add(1L);
        UDATAPointer top = base.add(maxOffset);
        if (markSlot.gte(base) && markSlot.lte(top)) {
            IDATA delta = markSlot.sub(base);
            int pageSize = markMap.getPageSize(null);
            delta = delta.mult(pageSize);
            J9ObjectPointer rangeBase = J9ObjectPointer.cast(markMap.getHeapBase().addOffset(delta));
            J9ObjectPointer rangeTop = rangeBase.addOffset(pageSize);
            out.format("Mark bits at %s corresponds to heap range %s -> %s\n", markSlot.getHexAddress(), rangeBase.getHexAddress(), rangeTop.getHexAddress());
        } else {
            out.format("Address %s is not in the mark map\n", markSlot.getHexAddress());
        }
    }

    protected void findSource(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
            J9ObjectPointer object = J9ObjectPointer.cast(address);
            J9ObjectPointer scanPtr = J9ObjectPointer.cast(markMap.getHeapBase());
            J9ObjectPointer heapTop = J9ObjectPointer.cast(markMap.getHeapTop());
            if (object.gte(scanPtr) && object.lt(heapTop)) {
                int count = 0;
                while (scanPtr.lt(heapTop)) {
                    J9ObjectPointer base = scanPtr;
                    J9ObjectPointer top = base.addOffset(markMap.getPageSize(scanPtr));
                    GCHeapMap.MarkedObject[] results = markMap.queryRange(base, top);
                    for (int i = 0; i < results.length; ++i) {
                        GCHeapMap.MarkedObject result = results[i];
                        if (!result.wasRelocated() || !result.relocatedObject.eq(object)) continue;
                        out.format("Object %s was relocated to %s\n", result.object.getHexAddress(), result.relocatedObject.getHexAddress());
                        ++count;
                    }
                    scanPtr = top;
                }
                if (count > 0) {
                    out.format("%1 relocation candidates found\n", count);
                } else {
                    out.format("No relocation candidates found\n", new Object[0]);
                }
            } else {
                out.format("Object %s is not in the heap\n", object.getHexAddress());
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    protected void showMarkMap(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        this.showActiveMarkMap(out);
        try {
            out.format("\nKnown mark maps:\n", new Object[0]);
            MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
            if (GCExtensions.isStandardGC()) {
                MM_ParallelGlobalGCPointer pgc = MM_ParallelGlobalGCPointer.cast(extensions._globalCollector());
                MM_MarkMapPointer markMap = pgc._markingScheme()._markMap();
                out.format("\tactive: %s\n", markMap.getHexAddress());
            } else if (GCExtensions.isVLHGC()) {
                MM_IncrementalGenerationalGCPointer igc = MM_IncrementalGenerationalGCPointer.cast(extensions._globalCollector());
                out.format("\tprevious: %s\n", igc._markMapManager()._previousMarkMap().getHexAddress());
                out.format("\tnext: %s\n", igc._markMapManager()._nextMarkMap().getHexAddress());
            } else if (GCExtensions.isMetronomeGC()) {
                MM_MarkMapPointer markMap = extensions.realtimeGC()._markingScheme()._markMap();
                out.format("\tactive: %s\n", markMap.getHexAddress());
            } else {
                out.format("\tUnrecognized GC policy!\n", new Object[0]);
            }
            try {
                if (extensions.referenceChainWalkerMarkMap().notNull()) {
                    out.format("\treference chain walker: %s\n", extensions.referenceChainWalkerMarkMap().getHexAddress());
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    protected void showActiveMarkMap(PrintStream out) {
        out.format("Currently active mark map: !mm_heapmap %s\n", markMap.getHeapMap().getHexAddress());
        out.format("\tHeap: %s -> %s\n", markMap.getHeapBase().getHexAddress(), markMap.getHeapTop().getHexAddress());
        UDATA maxOffset = markMap.getSlotIndexAndMask(J9ObjectPointer.cast(markMap.getHeapTop().subOffset(markMap.getObjectGrain())))[0];
        maxOffset = maxOffset.add(1L);
        out.format("\tBits: %s -> %s\n", markMap.getHeapMapBits().getHexAddress(), markMap.getHeapMapBits().add(maxOffset).getHexAddress());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setMarkMap(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        GCHeapMap newMap = null;
        try {
            if (args[1].equalsIgnoreCase("active") || args[1].equalsIgnoreCase("default")) {
                newMap = GCHeapMap.from();
            } else if (args[1].equalsIgnoreCase("previous")) {
                if (!GCExtensions.isVLHGC()) throw new DDRInteractiveCommandException("Only valid when running balanced!");
                MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
                MM_IncrementalGenerationalGCPointer igc = MM_IncrementalGenerationalGCPointer.cast(extensions._globalCollector());
                newMap = GCHeapMap.fromHeapMap(igc._markMapManager()._previousMarkMap());
            } else if (args[1].equalsIgnoreCase("next")) {
                if (!GCExtensions.isVLHGC()) throw new DDRInteractiveCommandException("Only valid when running balanced!");
                MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
                MM_IncrementalGenerationalGCPointer igc = MM_IncrementalGenerationalGCPointer.cast(extensions._globalCollector());
                newMap = GCHeapMap.fromHeapMap(igc._markMapManager()._nextMarkMap());
            } else {
                long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                MM_HeapMapPointer heapMap = MM_HeapMapPointer.cast(address);
                newMap = GCHeapMap.fromHeapMap(heapMap);
            }
            newMap.queryObject(J9ObjectPointer.cast(newMap.getHeapBase()));
            newMap.queryObject(J9ObjectPointer.cast(newMap.getHeapTop().subOffset(newMap.getObjectGrain())));
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
        if (newMap == null) return;
        markMap = newMap;
        this.showActiveMarkMap(out);
    }

    static {
        try {
            markMap = GCHeapMap.from();
        }
        catch (CorruptDataException e) {
            markMap = null;
        }
    }
}

