/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.State;
import com.ibm.security.cert.UntrustedChecker;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;
import sun.security.util.Debug;

class ForwardState
implements State {
    private static final Debug debug = Debug.getInstance("certpath");
    X500Principal issuerDN;
    X509CertImpl cert;
    HashSet<GeneralNameInterface> subjectNamesTraversed;
    int traversedCACerts;
    private boolean init = true;
    UntrustedChecker untrustedChecker;
    ArrayList<PKIXCertPathChecker> forwardCheckers;
    boolean selfIssued;

    ForwardState() {
    }

    @Override
    public boolean isInitial() {
        return this.init;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("State [");
        sb.append("\n  issuerDN of last cert: ").append(this.issuerDN);
        sb.append("\n  traversedCACerts: ").append(this.traversedCACerts);
        sb.append("\n  init: ").append(String.valueOf(this.init));
        sb.append("\n  subjectNamesTraversed: \n").append(this.subjectNamesTraversed);
        sb.append("\n  selfIssued: ").append(this.selfIssued).append("\n");
        sb.append("]\n");
        return sb.toString();
    }

    public void initState(List<PKIXCertPathChecker> certPathCheckers) throws CertPathValidatorException {
        this.subjectNamesTraversed = new HashSet();
        this.traversedCACerts = 0;
        this.forwardCheckers = new ArrayList();
        for (PKIXCertPathChecker checker : certPathCheckers) {
            if (!checker.isForwardCheckingSupported()) continue;
            checker.init(true);
            this.forwardCheckers.add(checker);
        }
        this.init = true;
    }

    @Override
    public void updateState(X509Certificate cert) throws CertificateException, IOException, CertPathValidatorException {
        X509CertImpl icert;
        if (cert == null) {
            return;
        }
        this.cert = icert = X509CertImpl.toImpl((X509Certificate)cert);
        this.issuerDN = cert.getIssuerX500Principal();
        this.selfIssued = X509CertImpl.isSelfIssued((X509Certificate)cert);
        if (!this.selfIssued && !this.init && cert.getBasicConstraints() != -1) {
            ++this.traversedCACerts;
        }
        if (this.init || !this.selfIssued) {
            X500Principal subjName = cert.getSubjectX500Principal();
            X500Name subjX500Name = null;
            try {
                subjX500Name = new X500Name(subjName.getName());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage());
            }
            this.subjectNamesTraversed.add((GeneralNameInterface)subjX500Name);
            try {
                SubjectAlternativeNameExtension subjAltNameExt = icert.getSubjectAlternativeNameExtension();
                if (subjAltNameExt != null) {
                    GeneralNames gNames = subjAltNameExt.get("subject_name");
                    for (GeneralName gName : gNames.names()) {
                        this.subjectNamesTraversed.add(gName.getName());
                    }
                }
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.println("ForwardState.updateState() unexpected exception");
                    e.printStackTrace();
                }
                throw new CertPathValidatorException(e);
            }
        }
        this.init = false;
    }

    @Override
    public Object clone() {
        try {
            ForwardState clonedState = (ForwardState)super.clone();
            clonedState.forwardCheckers = (ArrayList)this.forwardCheckers.clone();
            ListIterator<PKIXCertPathChecker> li = clonedState.forwardCheckers.listIterator();
            while (li.hasNext()) {
                PKIXCertPathChecker checker = li.next();
                if (!(checker instanceof Cloneable)) continue;
                li.set((PKIXCertPathChecker)checker.clone());
            }
            clonedState.subjectNamesTraversed = (HashSet)this.subjectNamesTraversed.clone();
            return clonedState;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString(), e);
        }
    }
}

