/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHPKCS11ParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private static final Map<Integer, DHParameterSpec> dhCache = Collections.synchronizedMap(new HashMap());
    private int primeSize = 2048;
    private int exponentSize = 0;
    private SecureRandom random = null;
    private Provider provider = null;

    public DHPKCS11ParameterGenerator(Provider provider) {
        this.provider = provider;
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        if (keysize < 512 || keysize > 2048 || keysize % 64 != 0) {
            throw new InvalidParameterException("Keysize must be multiple of 64, and can only range from 512 to 2048 (inclusive)");
        }
        this.primeSize = keysize;
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(genParamSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        DHGenParameterSpec dhParamSpec = (DHGenParameterSpec)genParamSpec;
        this.primeSize = dhParamSpec.getPrimeSize();
        if (this.primeSize < 512 || this.primeSize > 2048 || this.primeSize % 64 != 0) {
            throw new InvalidAlgorithmParameterException("Modulus size must be multiple of 64, and can only range from 512 to 2048 (inclusive)");
        }
        this.exponentSize = dhParamSpec.getExponentSize();
        if (this.exponentSize < 0) {
            throw new InvalidAlgorithmParameterException("Exponent size must be greater than zero");
        }
        if (this.exponentSize >= this.primeSize) {
            throw new InvalidAlgorithmParameterException("Exponent size must be less than modulus size");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        if (this.exponentSize == 0) {
            this.exponentSize = this.primeSize >= 2048 ? 1024 : (this.primeSize >= 1024 ? 768 : 512);
        }
        if (this.random == null) {
            try {
                this.random = SecureRandom.getInstance("IBMSecureRandom", this.provider);
            }
            catch (NoSuchAlgorithmException e) {
                this.random = new SecureRandom();
            }
        }
        AlgorithmParameters algParams = null;
        try {
            DHParameterSpec dhParamSpec = dhCache.get(this.primeSize);
            if (dhParamSpec == null) {
                SessionManager sessionManager = ((IBMPKCS11Impl)this.provider).getSessionManager();
                int[] attTypes = new int[2];
                Object[] attValues = new Object[2];
                attTypes[0] = 0;
                attValues[0] = PKCS11Object.DOMAIN_PARAMETERS;
                attTypes[1] = 307;
                attValues[1] = new Integer(this.primeSize);
                Session session = null;
                PKCS11Object domainParams = null;
                try {
                    session = sessionManager.getObjSession();
                    domainParams = session.generateKey(8193, null, attTypes, attValues);
                    if (!session.getBoolAttributeValue(domainParams, 1)) {
                        session.addObject();
                    }
                    BigInteger prime = session.getBigIntegerAttributeValue(domainParams, 304);
                    BigInteger base = session.getBigIntegerAttributeValue(domainParams, 306);
                    dhParamSpec = new DHParameterSpec(prime, base, this.exponentSize);
                    dhCache.put(this.primeSize, dhParamSpec);
                }
                finally {
                    sessionManager.releaseSession(session);
                }
            }
            algParams = AlgorithmParameters.getInstance("DH", this.provider);
            algParams.init(dhParamSpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (PKCS11Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return algParams;
    }

    static {
        BigInteger p512 = new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16);
        BigInteger g512 = new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16);
        BigInteger p768 = new BigInteger("e9e642599d355f37c97ffd3567120b8e25c9cd43e927b3a9670fbec5d890141922d2c3b3ad2480093799869d1e846aab49fab0ad26d2ce6a22219d470bce7d777d4a21fbe9c270b57f607002f3cef8393694cf45ee3688c11a8c56ab127a3daf", 16);
        BigInteger g768 = new BigInteger("30470ad5a005fb14ce2d9dcd87e38bc7d1b1c5facbaecbe95f190aa7a31d23c4dbbcbe06174544401a5b2c020965d8c2bd2171d3668445771f74ba084d2029d83c1c158547f3a9f1a2715be23d51ae4d3e5a1f6a7064f316933a346d3f529252", 16);
        BigInteger p1024 = new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16);
        BigInteger g1024 = new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16);
        BigInteger p2048 = new BigInteger("b16ecb2513f672bb8a91a961c3ea57785b503af150156b7c084fa911b61cfe53b16ecb2513f672bb8a91a961c3ea57785b503af150156b7c084fa911b61cfe52b16ecb2513f672bb8a91a961c3ea57785b503af150156b7c084fa911b61cfe51b16ecb2513f672bb8a91a961c3ea57785b503af150156b7c084fa911b61cfe50b16ecb2513f672bb8a91a961c3ea57785b503af150156b7c084fa911b61cfe4fb16ecb2513f672bb8a91a961c3ea57785b503af150156b7c084fa911b61cfe4eb16ecb2513f672bb8a91a961c3ea57785b503af150156b7c084fa911b61cfe4d3f682851d89f071d0c91d3a9a2987666bf843f1354b5a7a032d0449cf2198725", 16);
        BigInteger g2048 = new BigInteger("6faf41038bfa938bff927173651b6f4a3327df4213c82483a2044d02372619ca02eebba13042cb460fc15b72f25770a2a60063e942b1abc4d934c1ac29cb4a092b81df42e4de57eec882096bfce1ca490675204709b77268c1046486a70dde5a9ddda1d9fed0e4138bc8c1ed4ef7e3a9f4bf1090f6ca07166e381af6f88a05ec4626aba5a61489ebbc86a5b148f02cea1d247710497d3a1d14ea47623e7ea2abefee6c8efea2efc94c2c581b7a538d40dd6b001e5d22dade4f3143c5c8e076864f71b109b283f26c59ab4ba07bec2ae079be7e5b20e6f4d3174490e8de533e8ac241184d67f0c7460697eb28506a0f09b03e2ca8d3f98caf34727c1840d2e5b7", 16);
        dhCache.put(512, new DHParameterSpec(p512, g512, 512));
        dhCache.put(768, new DHParameterSpec(p768, g768, 512));
        dhCache.put(1024, new DHParameterSpec(p1024, g1024, 768));
        dhCache.put(2048, new DHParameterSpec(p2048, g2048, 1024));
    }
}

