/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import ibm.security.internal.interfaces.TlsMasterSecret;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;

class PKCS11TlsMasterSecretKey
extends GeneralKey
implements TlsMasterSecret {
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11TlsMasterSecretKey";
    private final int majorVersion;
    private final int minorVersion;

    PKCS11TlsMasterSecretKey(Session session, PKCS11Object object, String algorithm, int major, int minor) throws InvalidKeyException {
        super(session, object, algorithm);
        this.majorVersion = major;
        this.minorVersion = minor;
    }

    @Override
    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " TLS Master Secret Key: ";
        if (this.getToken() != null) {
            output = output + "\n Token: " + this.getToken();
        }
        if (this.getPrivate() != null) {
            output = output + "\n Private: " + this.getPrivate();
        }
        if (this.getLabel() != null) {
            output = output + "\n Label: " + this.getLabel();
        }
        if (this.getModifiable() != null) {
            output = output + "\n Modifiable: " + this.getModifiable();
        }
        output = output + "\n KeyType: " + this.getAlgorithm();
        if (this.getID() != null) {
            try {
                output = output + "\n ID: " + new String(this.getID(), "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                output = output + "\n ID: " + new String(this.getID());
            }
        }
        if (this.getStartDate() != null) {
            output = output + "\n Start Date: " + this.getStartDate().toString();
        }
        if (this.getEndDate() != null) {
            output = output + "\n End Date: " + this.getEndDate().toString();
        }
        if (this.getDerive() != null) {
            output = output + "\n Derive: " + this.getDerive();
        }
        if (this.getLocal() != null) {
            output = output + "\n Local: " + this.getLocal();
        }
        if (this.getSensitive() != null) {
            output = output + "\n Sensitive: " + this.getSensitive();
        }
        if (this.getEncrypt() != null) {
            output = output + "\n Encrypt: " + this.getEncrypt();
        }
        if (this.getDecrypt() != null) {
            output = output + "\n Decrypt: " + this.getDecrypt();
        }
        if (this.getSign() != null) {
            output = output + "\n Sign: " + this.getSign();
        }
        if (this.getVerify() != null) {
            output = output + "\n Verify: " + this.getVerify();
        }
        if (this.getWrap() != null) {
            output = output + "\n Wrap: " + this.getWrap();
        }
        if (this.getUnwrap() != null) {
            output = output + "\n Unwrap: " + this.getUnwrap();
        }
        if (this.getExtractable() != null) {
            output = output + "\n Extractable: " + this.getExtractable();
        }
        if (this.getAlwaysSensitive() != null) {
            output = output + "\n Always Sensitive: " + this.getAlwaysSensitive();
        }
        if (this.getNeverExtractable() != null) {
            output = output + "\n Never Extractable: " + this.getNeverExtractable();
        }
        if (this.getValue() != null) {
            output = output + "\n value: " + this.getValue().toString();
        }
        output = output + "\n keySize in bytes: " + this.getKeySizeInBytes();
        output = output + "\n major version: " + this.majorVersion;
        output = output + "\n minor version: " + this.minorVersion;
        return output;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }
}

