/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import java.util.ArrayList;
import java.util.Collection;

class SessionQueue {
    ArrayList sessions = new ArrayList();
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static Debug debugSessionObjectCount = Debug.getInstance((String)"objectcount");

    SessionQueue() {
    }

    boolean isEmpty() {
        return this.sessions.isEmpty();
    }

    int size() {
        return this.sessions.size();
    }

    void add(Session sess) {
        this.sessions.add(sess);
    }

    Session poll() {
        if (this.sessions.isEmpty()) {
            return null;
        }
        return (Session)this.sessions.remove(this.sessions.size() - 1);
    }

    boolean cleanup(long time) {
        Session oldSession;
        boolean removed = false;
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionQueue", "cleanup");
        }
        if (!this.sessions.isEmpty() && !(oldSession = (Session)this.sessions.get(0)).isAlive(time)) {
            if (debug != null) {
                debug.text(16384L, (Object)"SessionQueue", "cleanup", "remove session " + oldSession.getID());
            }
            Session se = (Session)this.sessions.remove(0);
            SessionManager sessionManager = se.getSessionManager();
            sessionManager.closeSession(se);
            se.session = null;
            removed = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionQueue", "cleanup");
        }
        return removed;
    }

    boolean remove(Session sess) {
        boolean result = this.sessions.remove(sess);
        return result;
    }

    Collection allSessions() {
        return this.sessions;
    }

    protected void finalize() throws Throwable {
        this.sessions.removeAll(this.sessions);
    }
}

