/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaBuffer;
import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaFunction;
import com.ibm.cuda.CudaGrid;
import com.ibm.cuda.CudaModule;

public class CudaKernel {
    private final CudaFunction function;

    public CudaKernel(CudaModule module, CudaFunction function) {
        if (function.deviceId != module.deviceId) {
            throw new IllegalArgumentException();
        }
        this.function = function;
    }

    public CudaKernel(CudaModule module, String functionName) throws CudaException {
        this(module, module.getFunction(functionName));
    }

    public final int getAttribute(int attribute) throws CudaException {
        return this.function.getAttribute(attribute);
    }

    public final void launch(CudaGrid grid, Object ... parameters) throws CudaException {
        this.function.launch(grid, parameters);
    }

    public final void launch(CudaGrid grid, Parameters parameters) throws CudaException {
        this.function.launch(grid, parameters);
    }

    public final void setCacheConfig(CudaDevice.CacheConfig config) throws CudaException {
        this.function.setCacheConfig(config);
    }

    public final void setSharedMemConfig(CudaDevice.SharedMemConfig config) throws CudaException {
        this.function.setSharedMemConfig(config);
    }

    public static final class Parameters
    implements Cloneable {
        private long mask;
        final long[] values;

        public Parameters(int count) {
            if (0 > count || count > 64) {
                throw new IllegalArgumentException();
            }
            this.mask = count == 64 ? -1L : (1L << count) - 1L;
            this.values = new long[count];
        }

        public Parameters(Object ... values) {
            int count = values.length;
            this.mask = 0L;
            this.values = new long[count];
            for (int i = 0; i < count; ++i) {
                this.values[i] = CudaFunction.nativeValueOf(values[i]);
            }
        }

        public Parameters(Parameters that) {
            this.mask = that.mask;
            this.values = (long[])that.values.clone();
        }

        public Parameters add(byte value) {
            return this.add((long)value);
        }

        public Parameters add(char value) {
            return this.add((long)value);
        }

        public Parameters add(CudaBuffer value) {
            return this.add(value == null ? 0L : value.getAddress());
        }

        public Parameters add(double value) {
            return this.add(Double.doubleToRawLongBits(value));
        }

        public Parameters add(float value) {
            return this.add((long)Float.floatToRawIntBits(value));
        }

        public Parameters add(int value) {
            return this.add((long)value);
        }

        public Parameters add(long value) {
            if (this.isComplete()) {
                throw new IndexOutOfBoundsException();
            }
            int index = Long.numberOfTrailingZeros(this.mask);
            return this.set(index, value);
        }

        public Parameters add(short value) {
            return this.add((long)value);
        }

        public Parameters clone() {
            return new Parameters(this);
        }

        boolean isComplete() {
            return this.mask == 0L;
        }

        public Parameters set(int index, byte value) {
            return this.set(index, (long)value);
        }

        public Parameters set(int index, char value) {
            return this.set(index, (long)value);
        }

        public Parameters set(int index, CudaBuffer value) {
            return this.set(index, value == null ? 0L : value.getAddress());
        }

        public Parameters set(int index, double value) {
            return this.set(index, Double.doubleToRawLongBits(value));
        }

        public Parameters set(int index, float value) {
            return this.set(index, (long)Float.floatToRawIntBits(value));
        }

        public Parameters set(int index, int value) {
            return this.set(index, (long)value);
        }

        public Parameters set(int index, long value) {
            if (0 <= index && index < this.values.length) {
                this.mask &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
                this.values[index] = value;
                return this;
            }
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        public Parameters set(int index, short value) {
            return this.set(index, (long)value);
        }
    }
}

