/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassTokenHelper;
import com.ibm.oti.util.Msg;

final class SharedClassTokenHelperImpl
extends SharedClassAbstractHelper
implements SharedClassTokenHelper {
    SharedClassTokenHelperImpl(ClassLoader loader, int id, boolean canFind, boolean canStore) {
        this.initialize(loader, id, canFind, canStore);
        this.initializeShareableClassloader(loader);
    }

    private native boolean findSharedClassImpl2(int var1, String var2, ClassLoader var3, String var4, boolean var5, boolean var6, byte[] var7);

    private native boolean storeSharedClassImpl2(int var1, ClassLoader var2, String var3, Class<?> var4, byte[] var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] findSharedClass(String token, String className) {
        byte[] romClassCookie;
        boolean found;
        boolean doStore;
        boolean doFind;
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            this.printVerboseInfo(Msg.getString("K059f"));
            return null;
        }
        if (!this.canFind) {
            return null;
        }
        if (token == null) {
            this.printVerboseError(Msg.getString("K05a0"));
            return null;
        }
        if (className == null) {
            this.printVerboseError(Msg.getString("K05a1"));
            return null;
        }
        SharedClassFilter theFilter = this.getSharingFilter();
        if (theFilter != null) {
            SharedClassTokenHelperImpl sharedClassTokenHelperImpl = this;
            synchronized (sharedClassTokenHelperImpl) {
                doFind = theFilter.acceptFind(className);
                doStore = nativeFlags[0] == 0 ? theFilter.acceptStore(className) : true;
            }
        } else {
            doFind = true;
            doStore = true;
        }
        if (!(found = this.findSharedClassImpl2(this.id, className, loader, token, doFind, doStore, romClassCookie = new byte[this.ROMCLASS_COOKIE_SIZE]))) {
            return null;
        }
        return romClassCookie;
    }

    @Override
    public boolean storeSharedClass(String token, Class<?> clazz) {
        if (!this.canStore) {
            return false;
        }
        if (token == null) {
            this.printVerboseError(Msg.getString("K05a2"));
            return false;
        }
        if (clazz == null) {
            this.printVerboseError(Msg.getString("K05a3"));
            return false;
        }
        ClassLoader actualLoader = this.getClassLoader();
        if (!this.validateClassLoader(actualLoader, clazz)) {
            return false;
        }
        return this.storeSharedClassImpl2(this.id, actualLoader, token, clazz, nativeFlags);
    }

    @Override
    String getHelperType() {
        return "SharedClassTokenHelper";
    }
}

