/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.vm.VM;
import java.io.IOException;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.Attachment;
import openj9.internal.tools.attach.target.CommonDirectory;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.TargetDirectory;

final class WaitLoop
extends Thread {
    WaitLoop() {
        super("Attach API wait loop");
        this.setDaemon(true);
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attachment waitForNotification(boolean retry) throws IOException {
        Object myIN = AttachHandler.mainHandler.getIgnoreNotification();
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ignoreNotification entering");
        }
        Object object = myIN;
        synchronized (object) {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ignoreNotification entered");
            }
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification starting wait");
        }
        int status = 0;
        if (AttachHandler.startWaitingForSemaphore()) {
            status = CommonDirectory.waitSemaphore(AttachHandler.vmId);
            AttachHandler.endWaitingForSemaphore();
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ended wait");
        }
        if (AttachHandler.isAttachApiTerminated()) {
            if (AttachHandler.getDoCancelNotify()) {
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification cancelNotify");
                }
                CommonDirectory.cancelNotify(AttachHandler.getNumberOfTargets(), true);
            }
            return null;
        }
        if (status != 0) {
            if (retry) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification reopen semaphore");
                AttachHandler.AttachStateSync attachStateSync = AttachHandler.stateSync;
                synchronized (attachStateSync) {
                    if (!AttachHandler.isAttachApiTerminated()) {
                        try {
                            CommonDirectory.obtainControllerLock("WaitLoop.waitForNotification(" + retry + ")_1");
                            status = CommonDirectory.reopenSemaphore();
                            CommonDirectory.releaseControllerLock("WaitLoop.waitForNotification(" + retry + ")_2");
                        }
                        catch (IOException e) {
                            IPC.logMessage("waitForNotification: IOError on controller lock : ", e.toString());
                        }
                    }
                }
                if (0 == status && TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
                    if (CommonDirectory.tryObtainControllerLock("WaitLoop.waitForNotification(" + retry + ")_3")) {
                        IPC.logMessage("semaphore recovery: send test post");
                        int numTargets = CommonDirectory.countTargetDirectories();
                        AttachHandler.setNumberOfTargets(numTargets);
                        CommonDirectory.notifyVm(numTargets, true, "WaitLoop.waitForNotification");
                        CommonDirectory.releaseControllerLock("WaitLoop.waitForNotification(" + retry + ")_4");
                    }
                    return this.waitForNotification(false);
                }
            }
            AttachHandler.mainHandler.terminate(false);
            return null;
        }
        Attachment at = WaitLoop.checkReplyAndCreateAttachment();
        return at;
    }

    private static Attachment checkReplyAndCreateAttachment() throws IOException {
        Attachment at = AttachHandler.mainHandler.connectToAttacher();
        if (!TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
            AttachHandler.mainHandler.terminate(false);
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("checkReplyAndCreateAttachment iteration " + AttachHandler.notificationCount + " waitForNotification obtainLock");
        }
        if (!AttachHandler.mainHandler.syncFileLock.lockFile(true, "WaitLoop.checkReplyAndCreateAttachment")) {
            TargetDirectory.createMySyncFile();
        } else {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " checkReplyAndCreateAttachment releaseLock");
            }
            AttachHandler.mainHandler.syncFileLock.unlockFile("WaitLoop.checkReplyAndCreateAttachment");
        }
        try {
            IPC.logMessage("WaitLoop.checkReplyAndCreateAttachment before sleep");
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            IPC.logMessage("WaitLoop.checkReplyAndCreateAttachment Interrupted");
            return at;
        }
        return at;
    }

    @Override
    public void run() {
        VM.markCurrentThreadAsSystem();
        while (!AttachHandler.isAttachApiTerminated()) {
            try {
                this.waitForNotification(true);
            }
            catch (IOException e) {
                IPC.logMessage("WaitLoop.waitForNotification exception: AttachHandler.notificationCount = " + AttachHandler.notificationCount, e.toString());
            }
            catch (OutOfMemoryError e) {
                IPC.tracepoint(-2, e.getMessage());
                try {
                    IPC.logMessage("WaitLoop.waitForNotification OutOfMemoryError before sleep");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    IPC.logMessage("WaitLoop.waitForNotification OutOfMemoryError Interrupted");
                    continue;
                }
            }
            ++AttachHandler.notificationCount;
        }
        AttachHandler.mainHandler.syncFileLock = null;
    }
}

