/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jcmd {
    private static final String HELPTEXT = "Usage : jcmd <vmid> <arguments>%n%n   -J : supply arguments to the Java VM running jcmd%n   -l : list JVM processes on the local machine%n   -h : print this help message%n%n   <vmid> : Attach API VM ID as shown in jps or other Attach API-based tools%n%n   arguments:%n      help : print the list of diagnostic commands%n      help <command> : print help for the specific command%n      <command> [command arguments] : command from the list returned by \"help\"%n%nlist JVM processes on the local machine. Default behavior when no options are specified.%n%nNOTE: this utility might significantly affect the performance of the target JVM.%n    The available diagnostic commands are determined by%n    the target VM and may vary between VMs.%n";
    private static final String[] HELP_OPTIONS = new String[]{"-h", "help", "-help", "--help"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        String firstArgument;
        String command = null;
        String string = firstArgument = 0 == args.length ? "-l" : args[0];
        if ("-l".equals(firstArgument)) {
            List<AttachProvider> providers = AttachProvider.providers();
            AttachProvider myProvider = null;
            if (!providers.isEmpty()) {
                myProvider = providers.get(0);
            }
            if (null == myProvider) {
                System.err.println("no attach providers available");
                return;
            } else {
                for (VirtualMachineDescriptor vmd : myProvider.listVirtualMachines()) {
                    StringBuilder outputBuffer = new StringBuilder(vmd.id());
                    Util.getTargetInformation(myProvider, vmd, false, false, true, outputBuffer);
                    System.out.println(outputBuffer.toString());
                }
            }
            return;
        }
        if (args.length == 1 && null != firstArgument) {
            if (Arrays.stream(HELP_OPTIONS).anyMatch(firstArgument::equals)) {
                System.out.printf(HELPTEXT, new Object[0]);
                return;
            }
        }
        if ((command = DiagnosticUtils.makeJcmdCommand(args, 1)).isEmpty()) {
            System.err.printf("There is no jcmd command.%n", new Object[0]);
            System.out.printf(HELPTEXT, new Object[0]);
            return;
        }
        String vmid = firstArgument;
        AttacherDiagnosticsProvider diagProvider = new AttacherDiagnosticsProvider();
        try {
            diagProvider.attach(vmid);
            try {
                Util.runCommandAndPrintResult(diagProvider, command, command);
                return;
            }
            finally {
                diagProvider.detach();
            }
        }
        catch (IOException e) {
            Util.handleCommandException(vmid, e);
            System.out.printf(HELPTEXT, new Object[0]);
        }
    }
}

