/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.XECKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import ibm.security.internal.interfaces.XECPrivateKey;
import ibm.security.internal.spec.NamedParameterSpec;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyRep;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Optional;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class XDHPrivateKeyImpl
extends PrivateKeyInfo
implements XECPrivateKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = 6034044314589513430L;
    private IBMJCEPlusProvider provider;
    private Optional<byte[]> scalar;
    private NamedParameterSpec params;
    BigInteger bi1;
    BigInteger bi2;
    BigInteger bi3;
    private Exception exception;
    private static final byte TAG_PARAMETERS_ATTRS = 0;
    private transient boolean destroyed;
    private transient XECKey xecKey;
    private static final String[] z;

    private void a() throws Exception {
        if (this.key == null) {
            this.key = this.a(this.xecKey.getPrivateKeyBytes());
            this.scalar = Optional.of(this.key);
            this.algid = XECKey.getAlgId(this.params.getCurve());
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, XECKey xECKey) throws InvalidKeyException {
        this.provider = null;
        this.exception = null;
        this.destroyed = false;
        this.xecKey = null;
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[16]);
        }
        if (xECKey == null) {
            throw new InvalidKeyException(z[17]);
        }
        this.xecKey = xECKey;
        this.provider = iBMJCEPlusProvider;
        try {
            this.a();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage());
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = null;
        this.exception = null;
        this.destroyed = false;
        this.xecKey = null;
        this.provider = iBMJCEPlusProvider;
        try {
            byte[] byArray2 = this.b(byArray);
            this.xecKey = XECKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray2, this.params.getCurve());
            this.scalar = Optional.of(this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[11]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, AlgorithmParameterSpec algorithmParameterSpec, Optional<byte[]> optional) throws InvalidParameterException {
        block15: {
            this.provider = null;
            this.exception = null;
            this.destroyed = false;
            this.xecKey = null;
            if (iBMJCEPlusProvider == null) {
                throw new InvalidParameterException(z[8]);
            }
            if (!(algorithmParameterSpec instanceof NamedParameterSpec)) {
                throw new InvalidParameterException(z[9]);
            }
            this.params = (NamedParameterSpec)algorithmParameterSpec;
            try {
                if (XECKey.isFFDHE(this.params.getCurve())) {
                    throw new InvalidParameterException(z[10]);
                }
            }
            catch (Exception exception) {
                throw new InvalidParameterException(exception.getMessage());
            }
            this.provider = iBMJCEPlusProvider;
            this.scalar = optional;
            if (optional != null) {
                this.key = optional.get();
            }
            try {
                block14: {
                    if (this.key != null) break block14;
                    this.xecKey = XECKey.generateKeyPair(iBMJCEPlusProvider.a(), this.params.getCurve());
                    break block15;
                }
                this.algid = XECKey.getAlgId(this.params.getCurve());
                byte[] byArray = this.b();
                this.xecKey = XECKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray, this.params.getCurve());
            }
            catch (Exception exception) {
                InvalidParameterException invalidParameterException = new InvalidParameterException(z[7]);
                iBMJCEPlusProvider.a(invalidParameterException, (Throwable)exception);
                throw invalidParameterException;
            }
        }
    }

    private byte[] b() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(0);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.algid.getOID());
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOctetString(this.key);
        derOutputStream.putOctetString(derOutputStream3.toByteArray());
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream);
        return derOutputStream4.toByteArray();
    }

    private byte[] a(byte[] byArray) throws IOException {
        Object object;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        DerInputStream derInputStream2 = null;
        if (derValueArray.length > 1) {
            derInputStream2 = derValueArray[1].getData();
            if (derInputStream2.tag != 0) {
                throw new IOException(z[2]);
            }
            try {
                object = this.a(derInputStream2, null);
            }
            catch (Exception exception) {
                throw new IOException(z[1]);
            }
        }
        object = null;
        if (derValueArray.length > 2) {
            object = derValueArray[2].getOctetString();
            object = this.params.getName().contains(z[0]) ? new DerInputStream(object).getInteger().toByteArray() : new DerInputStream(object).getOctetString();
            return object;
        }
        return null;
    }

    private ObjectIdentifier a(DerInputStream derInputStream, DerOutputStream derOutputStream) throws IOException {
        NamedParameterSpec.CURVE cURVE;
        ObjectIdentifier objectIdentifier;
        block5: {
            DerOutputStream derOutputStream2;
            objectIdentifier = derInputStream.getOID();
            XECKey.checkOid(objectIdentifier);
            try {
                derOutputStream2 = derInputStream.getSequence(3);
                if (((DerValue[])derOutputStream2).length < 3) {
                    throw new IOException(z[6]);
                }
                this.bi1 = derOutputStream2[0].getInteger();
                this.bi2 = derOutputStream2[1].getInteger();
                this.bi3 = derOutputStream2[2].getInteger();
                int n2 = this.bi1.bitLength();
                cURVE = XECKey.getCurve(objectIdentifier, n2);
            }
            catch (IOException iOException) {
                cURVE = XECKey.getCurve(objectIdentifier, null);
            }
            if (derOutputStream == null) break block5;
            derOutputStream.putOID(objectIdentifier);
            if (!XECKey.isFFDHE(cURVE)) break block5;
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(this.bi1);
            derOutputStream2.putInteger(this.bi2);
            derOutputStream2.putInteger(this.bi3);
            derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        }
        this.params = new NamedParameterSpec(cURVE);
        return objectIdentifier;
    }

    private byte[] b(byte[] byArray) throws IOException {
        BigInteger bigInteger;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        DerOutputStream derOutputStream = new DerOutputStream();
        BigInteger bigInteger2 = derValueArray[0].getInteger();
        derOutputStream.putInteger(bigInteger2);
        Object var6_6 = null;
        ObjectIdentifier objectIdentifier = null;
        if (derValueArray.length < 3) {
            throw new IOException(z[3]);
        }
        if (derValueArray[1].getTag() != 48) {
            throw new IOException(z[4]);
        }
        Object object = derValueArray[1].toDerInputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        objectIdentifier = this.a((DerInputStream)object, derOutputStream2);
        this.algid = new AlgorithmId(objectIdentifier);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        object = derValueArray[2].getOctetString();
        derOutputStream2 = new DerInputStream((byte[])object);
        try {
            this.key = derOutputStream2.getOctetString();
        }
        catch (IOException iOException) {
            this.key = (byte[])object;
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (XECKey.isFFDHE(this.params.getCurve())) {
            bigInteger = new BigInteger(this.key);
            derOutputStream3.putInteger(bigInteger);
        } else {
            derOutputStream3.putOctetString(this.key);
        }
        derOutputStream.putOctetString(derOutputStream3.toByteArray());
        bigInteger = new DerOutputStream();
        bigInteger.write((byte)48, derOutputStream);
        return bigInteger.toByteArray();
    }

    public XECKey getICCKey() {
        return this.xecKey;
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public Optional<byte[]> getScalar() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return this.scalar;
    }

    public byte[] getKeyBytes() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getKeyBytes();
    }

    public AlgorithmId getAlgorithmId() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getAlgorithmId();
    }

    public String getAlgorithm() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getAlgorithm();
    }

    public static void putFFDHEIntegers(DerOutputStream derOutputStream, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(bigInteger);
        derOutputStream2.putInteger(bigInteger2);
        derOutputStream2.putInteger(bigInteger3);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encode(OutputStream outputStream) throws IOException {
        try {
            this.a();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(z[12]);
            this.provider.a(iOException, (Throwable)exception);
            throw iOException;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(0);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream3.putOID(this.algid.getOID());
        switch (this.params.getCurve()) {
            case X25519: 
            case X448: 
            case Ed25519: 
            case Ed448: {
                break;
            }
            case FFDHE2048: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE3072: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE4096: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE6144: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE8192: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
        }
        derOutputStream4.write((byte)48, derOutputStream3);
        derOutputStream.write(derOutputStream4.toByteArray());
        if (this.key != null) {
            derOutputStream.putOctetString(new DerValue(4, this.key).toByteArray());
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (this.exception != null) {
            String string = this.exception.getMessage();
            string = string + z[14];
            StackTraceElement[] stackTraceElementArray = this.exception.getStackTrace();
            int n2 = stackTraceElementArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    throw new DestroyFailedException(z[15] + string);
                }
                StackTraceElement stackTraceElement = stackTraceElementArray[n3];
                string = string + z[13] + stackTraceElement.toString() + "\n";
                ++n3;
            }
        }
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.xecKey = null;
            this.scalar = null;
            this.params = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[5]);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[18];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "j\u00072K";
        int n3 = -1;
        block25: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                block28: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block28;
                    n5 = n5;
                    if (n5 <= n4) break block29;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 44;
                            break;
                        }
                        case 1: {
                            n6 = 65;
                            break;
                        }
                        case 2: {
                            n6 = 118;
                            break;
                        }
                        case 3: {
                            n6 = 3;
                            break;
                        }
                        default: {
                            n6 = 123;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "x)\u001fp[O4\u0004u\u001e\f%\u0019f\b\f/\u0019w[_$\u0013n[X.Va\u001e\f \u0018##i\u0002Vl\t\f\u00070G3ia\u0015v\tZ$";
                    n3 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\f\u0015\u001ef[B$\u000ew[I/\u0015l\u001fI%Vp\u000f^4\u0015w\u000e^$Vn\u000e_5Va\u001e\f V`\u0014B5\u0013{\u000f\f\"\u0019m\bX3\u0003`\u000fI%VL2h";
                    n3 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "x)\u001fp[O4\u0004u\u001e\f%\u0019f\b\f/\u0019w[_$\u0013n[X.Va\u001e\f Vu\u001a@(\u0012##i\u0002YE=h\t3#\u0018Y3\u0000f";
                    n3 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "y/\u0013{\u000bI\"\u0002f\u001f\f/\u0019m[_$\u0007v\u001eB\"\u0013#\fD(\u001af[\\ \u0004p\u0012B&Vs\tE7\u0017w\u001e\f*\u0013z[N8\u0002f\b";
                    n3 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "x)\u001fp[G$\u000f#\u0012_a\u0018l[@.\u0018d\u001e^a\u0000b\u0017E%";
                    n3 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "x)\u001fp[O4\u0004u\u001e\f%\u0019f\b\f/\u0019w[_$\u0013n[X.Va\u001e\f Vu\u001a@(\u0012##i\u0002YE=h\t3#\u0018Y3\u0000f";
                    n3 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "j \u001fo\u001eHa\u0002l[O3\u0013b\u000fIa.F8\f1\u0004j\rM5\u0013#\u0010I8";
                    n3 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\\3\u0019u\u0012H$\u0004#\u0016Y2\u0002#\u0015C5Va\u001e\f/\u0003o\u0017";
                    n3 = 7;
                    continue block25;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\\ \u0004b\u0016_a\u001bv\bXa\u0014f[C'Vw\u0002\\$VM\u001aA$\u0012S\u001a^ \u001bf\u000fI3%s\u001eO";
                    n3 = 8;
                    continue block25;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "j\u00072K>\f \u001ad\u0014^(\u0002k\u0016_a\u0017q\u001e\f/\u0019w[_4\u0006s\u0014I3\u0002f\u001f";
                    n3 = 9;
                    continue block25;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "j \u001fo\u001eHa\u0002l[O3\u0013b\u000fIa.F8\f1\u0004j\rM5\u0013#\u0010I8";
                    n3 = 10;
                    continue block25;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "j \u001fo\u001eHa\u001fm[_$\u0002E\u0012I-\u0012p=^.\u001b[\u001eO*\u0013z";
                    n3 = 11;
                    continue block25;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0001a";
                    n3 = 12;
                    continue block25;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "&\u0012\u0002b\u0018G{|";
                    n3 = 13;
                    continue block25;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "m/Vf\u0003O$\u0006w\u0012C/Vl\u0018O4\u0004q\u001eHa\u0012v\tE/\u0011#\u000fD$Vf\u0003I\"\u0003w\u0012C/Vl\u001d\f5\u001ej\b\f.\u0014i\u001eO5L#";
                    n3 = 14;
                    continue block25;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\\3\u0019u\u0012H$\u0004#\u0018M/\u0018l\u000f\f#\u0013#\u0015Y-\u001a";
                    n3 = 15;
                    continue block25;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "T$\u0015H\u001eUa\u0015b\u0015B.\u0002#\u0019Ia\u0018v\u0017@";
                    n3 = 16;
                    continue block25;
                }
                case 16: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

