/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.scan.util.PredefinedSymbols;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;

public final class SymbolStringMappings
extends PredefinedSymbols {
    private static final int CHUNK_SHIFT = 13;
    private static final int CHUNK_SIZE = 8192;
    private static final int CHUNK_MASK = 8191;
    private static final int INITIAL_CHUNK_COUNT = 8;
    private SymbolTable fSymbolTable;
    private final boolean fCallIntern;
    private XMLString fTempString;
    private String[][] fStrings;
    private int fStringCount;

    public SymbolStringMappings(SymbolTable symbolTable) {
        this(symbolTable, true);
    }

    public SymbolStringMappings(SymbolTable symbolTable, boolean bl) {
        this.fSymbolTable = symbolTable;
        this.fCallIntern = bl;
        this.fTempString = new XMLString();
        this.fStrings = new String[8][];
        int n = 0;
        while (n < 8) {
            this.fStrings[n] = new String[8192];
            ++n;
        }
        this.fStringCount = 0;
        n = 0;
        while (n < 77) {
            this.cacheString(n);
            ++n;
        }
        this.fTempString.clear();
    }

    public void reset(boolean bl) {
        this.fTempString.clear();
        if (!bl) {
            int n = 77;
            while (n < this.fStringCount) {
                int n2 = n >>> 13;
                int n3 = n & 0x1FFF;
                this.fStrings[n2][n3] = null;
                ++n;
            }
            this.fStringCount = 77;
        }
    }

    public String toString(int n) {
        if (n >= 0) {
            String string;
            if (n < this.fStringCount && (string = this.fStrings[n >>> 13][n & 0x1FFF]) != null) {
                return string;
            }
        } else {
            return null;
        }
        return this.cacheString(n);
    }

    public int addSymbol(String string) {
        int n;
        if (string != null) {
            n = this.fSymbolTable.addStringSymbol(string);
            if (n >= 0) {
                if (n < this.fStringCount && this.fStrings[n >>> 13][n & 0x1FFF] != null) {
                    return n;
                }
                this.cacheString2(n, this.fCallIntern ? string.intern() : string);
            }
        } else {
            n = -1;
        }
        return n;
    }

    private String cacheString(int n) {
        this.fSymbolTable.setStringValues(n, this.fTempString);
        String string = this.fTempString.toString();
        if (this.fCallIntern) {
            string = string.intern();
        }
        this.cacheString2(n, string);
        return string;
    }

    private void cacheString2(int n, String string) {
        int n2 = n >>> 13;
        int n3 = n & 0x1FFF;
        this.fStringCount = n + 1;
        if (n2 < this.fStrings.length) {
            this.fStrings[n2][n3] = string;
        } else {
            this.grow(n2);
            this.fStrings[n2][n3] = string;
        }
    }

    private void grow(int n) {
        int n2 = this.fStrings.length;
        int n3 = n2 << 1;
        while (n3 <= n) {
            n3 <<= 1;
        }
        String[][] stringArrayArray = new String[n3][];
        System.arraycopy(this.fStrings, 0, stringArrayArray, 0, n2);
        this.fStrings = stringArrayArray;
        while (n2 < n3) {
            this.fStrings[n2++] = new String[8192];
        }
    }
}

