/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.ScannerHelper;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import com.ibm.xml.xlxp.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SymbolTable {
    public static final int RESULT_NONAME = 0;
    public static final int RESULT_COLON = 1;
    public static final int RESULT_ENDOFNAME = 2;
    public static final int RESULT_FORWARDSLASH = 4;
    public static final int RESULT_GREATERTHAN = 5;
    public static final int RESULT_WHITESPACE = 6;
    public static final int RESULT_EQUALSIGN = 7;
    public static final int RESULT_SEMICOLON = 8;
    private static final int NAMESTARTCHAR = 1;
    private static final int NAMECHAR = 2;
    private static final int COLON = 4;
    private static final int INVALID = 8;
    private static final int BUFFEREND = 12;
    private static final int WHITESPACE = 24;
    private static final int NAMESTART = 3;
    private static final int MULTIBYTE = 65280;
    private static final boolean COMPRESS_MULTIBYTE = false;
    private static final boolean DUMP_CACHE = false;
    private static final boolean CHECK_CACHE = false;
    private static final boolean DEBUG_CACHE = true;
    private static final boolean DEBUG_LOOKUPS = false;
    private static final boolean DEBUG_ADDITIONS = false;
    private static final boolean DEBUG_ALLOC = false;
    private static final boolean DEBUG_REBALANCE = false;
    private static final boolean DEBUG_COMPRESSION = false;
    private static final boolean COMPRESSION_STATS = false;
    private static final boolean TRACE_PUBLIC_METHODS = false;
    private static final byte[] nameStartCharMap;
    public static final byte[] nameCharMap;
    private static final int[] fgMultiByteLength;
    private static final int INITIAL_ALLOCATION_SIZE = 8192;
    private static final Node NODE_NULL;
    private static final int USER_VALUE_QNAME10 = 1;
    private static final int USER_VALUE_QNAME11 = 2;
    private static final int NEW_QNAME_INITIAL_STATE = 0;
    private static final int NEW_QNAME_NAMESTARTCHAR_NODE_NOT_FOUND = 1;
    private static final int NEW_QNAME_NAMESTARTCHAR_MULTIBYTE = 2;
    private static final int NEW_QNAME_NAMECHAR_NODE_NOT_FOUND = 3;
    private static final int NEW_QNAME_NAMECHAR_MULTIBYTE = 4;
    private static final int NEW_QNAME_NAMECHAR_NEXT_NODE_NULL = 5;
    private static final int NEW_QNAME_NAMECHAR_DECOMPRESS = 6;
    private static final int NEW_QNAME_NOT_NAMECHAR = 7;
    private static final int SYMBOLS_START_OFFSET_OFFSET = 0;
    private static final int SYMBOLS_END_OFFSET_OFFSET = 1;
    private static final int SYMBOLS_LOCAL_HANDLE_OFFSET = 2;
    private static final int SYMBOLS_PREFIX_HANDLE_OFFSET = 3;
    private static final int SYMBOLS_RECORD_SIZE = 4;
    private static final int SYMTABHDR_TYPE = 47802;
    private static final byte[] predefinedState;
    private int fNodeCount;
    private Node fGlobals;
    private Node fPrefixes;
    private Node fFreeList;
    private int fTreeCount;
    private Node[] fTrees;
    private int fSymbolCount;
    private int[] fSymbols;
    private XMLStringBuffer fStringBuffer;
    private CharConversionError fError;
    private DataBuffer fDataBuffer;
    private byte[] fDataBytes;
    private XMLString fStringInBuffer;
    private XMLString fQNameString;
    private XMLString fDebugString;
    private byte[] fSymbolDebugBytes;
    private int fSymbolDebugStackDepth;
    Node[] fSymbolDebugNodeStack;
    private int[] fSymbolDebugIntStack;
    private int[] fMultiByteCharInfo;
    private Node[] fParents;
    private ByteArrayInputStream fPredefinedSymbolStream;
    private StreamCompressor fStreamCompressor;
    private static final int COMPRESSOR_BUFFER_SIZE = 8192;

    private SymbolTable() {
    }

    public SymbolTable(DataBufferFactory dataBufferFactory) {
        this.fPredefinedSymbolStream = new ByteArrayInputStream(predefinedState);
        this.initialize(dataBufferFactory, this.fPredefinedSymbolStream);
    }

    public SymbolTable(DataBufferFactory dataBufferFactory, InputStream inputStream) {
        this.initialize(dataBufferFactory, inputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize(DataBufferFactory dataBufferFactory, InputStream inputStream) {
        this.fStringBuffer = new XMLStringBuffer(dataBufferFactory);
        this.fDataBuffer = dataBufferFactory.createBuffer();
        this.fStringInBuffer = new XMLString();
        this.fQNameString = new XMLString();
        this.fDebugString = new XMLString();
        this.fMultiByteCharInfo = new int[2];
        this.fFreeList = NODE_NULL;
        this.fGlobals = this.cacheNodeAllocate();
        this.fPrefixes = this.cacheNodeAllocate();
        this.fTrees = new Node[256];
        this.fSymbols = new int[8192];
        this.fParents = new Node[8];
        if (inputStream != null) {
            try {
                if (this.restore(inputStream)) return;
            }
            catch (IOException iOException) {}
            return;
        } else {
            this.fSymbolCount = 1;
            if (this.fDataBytes == null) {
                this.fDataBuffer.bytes = new byte[8192];
                this.fDataBytes = this.fDataBuffer.bytes;
            }
            this.fDataBuffer.endOffset = 0;
            this.loadPredefinedSymbols();
            {
                // empty if block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reset(boolean bl) {
        this.fStringInBuffer.clear();
        if (bl) return;
        try {
            if (this.fPredefinedSymbolStream == null) {
                this.fPredefinedSymbolStream = new ByteArrayInputStream(predefinedState);
            } else {
                this.fPredefinedSymbolStream.reset();
            }
            if (this.restore(this.fPredefinedSymbolStream)) return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int lookupStringSymbol(String string) {
        Node node = this.fGlobals;
        int n = 0;
        int n2 = string.length();
        this.fError = null;
        while (n < n2) {
            block46: {
                block55: {
                    block56: {
                        block57: {
                            block59: {
                                block58: {
                                    byte by;
                                    int n3;
                                    int n4;
                                    Node node2;
                                    block52: {
                                        block54: {
                                            block53: {
                                                block49: {
                                                    block51: {
                                                        block50: {
                                                            block48: {
                                                                block47: {
                                                                    node2 = node;
                                                                    node = node.next;
                                                                    if (node == NODE_NULL) break block46;
                                                                    if (node.byteValue == (n4 = string.charAt(n++))) break block47;
                                                                    node = SymbolTable.search(node, n4);
                                                                    if (node.byteValue != n4) break block48;
                                                                }
                                                                if ((n3 = node.endOffset) == 0) continue;
                                                                int n5 = node.startOffset;
                                                                while (n5 < n3) {
                                                                    if (n < n2) {
                                                                        if ((n4 = string.charAt(n++)) != this.fDataBytes[n5]) {
                                                                            if (n4 < 128) {
                                                                                return -1;
                                                                            }
                                                                            UntestedCode.needTest("needCode(1)");
                                                                        }
                                                                    } else {
                                                                        return -1;
                                                                    }
                                                                    ++n5;
                                                                }
                                                                continue;
                                                            }
                                                            if (n4 < 128) {
                                                                return -1;
                                                            }
                                                            if (n4 >= 2048) break block49;
                                                            node = node2.next;
                                                            by = (byte)(0xC0 | n4 >> 6);
                                                            if (node.byteValue != by) {
                                                                node = SymbolTable.search(node, by);
                                                                if (node.byteValue != by) {
                                                                    return -1;
                                                                }
                                                            }
                                                            if (node.endOffset != 0) {
                                                                UntestedCode.needTest("needCode(1)");
                                                            }
                                                            if (node.byteValue == (by = (byte)(0x80 | 0x3F & n4))) break block50;
                                                            node = SymbolTable.search(node, by);
                                                            if (node.byteValue != by) break block51;
                                                        }
                                                        if (node.endOffset == 0) continue;
                                                        UntestedCode.needTest("needCode(1)");
                                                        continue;
                                                    }
                                                    return -1;
                                                }
                                                if (n4 >= 55296 && n4 < 57344) break block52;
                                                node = node2.next;
                                                by = (byte)(0xE0 | n4 >> 12);
                                                if (node.byteValue != by) {
                                                    node = SymbolTable.search(node, by);
                                                    if (node.byteValue != by) {
                                                        return -1;
                                                    }
                                                }
                                                if (node.endOffset != 0) {
                                                    UntestedCode.needTest("needCode(1)");
                                                }
                                                node2 = node;
                                                node = node.next;
                                                by = (byte)(0x80 | 0x3F & n4 >> 6);
                                                if (node.byteValue != by) {
                                                    node = SymbolTable.search(node, by);
                                                    if (node.byteValue != by) {
                                                        return -1;
                                                    }
                                                }
                                                if (node.endOffset != 0) {
                                                    UntestedCode.needTest("needCode(1)");
                                                }
                                                node2 = node;
                                                node = node.next;
                                                by = (byte)(0x80 | 0x3F & n4);
                                                if (node.byteValue == by) break block53;
                                                node = SymbolTable.search(node, by);
                                                if (node.byteValue != by) break block54;
                                            }
                                            if (node.endOffset == 0) continue;
                                            UntestedCode.needTest("needCode(1)");
                                            continue;
                                        }
                                        return -1;
                                    }
                                    if (n4 >= 56320) break block55;
                                    node = node2.next;
                                    if (n >= n2) break block56;
                                    if ((n3 = (int)string.charAt(n++)) < 56320 || n3 >= 57344) break block57;
                                    by = (byte)(0xF0 | (n4 = 65536 + (n4 - 55296 << 10) + (n3 - 56320)) >> 18);
                                    if (node.byteValue != by) {
                                        node = SymbolTable.search(node, by);
                                        if (node.byteValue != by) {
                                            return -1;
                                        }
                                    }
                                    if (node.endOffset != 0) {
                                        UntestedCode.needTest("needCode(1)");
                                    }
                                    node2 = node;
                                    node = node.next;
                                    by = (byte)(0x80 | 0x3F & n4 >> 12);
                                    if (node.byteValue != by) {
                                        node = SymbolTable.search(node, by);
                                        if (node.byteValue != by) {
                                            return -1;
                                        }
                                    }
                                    if (node.endOffset != 0) {
                                        UntestedCode.needTest("needCode(1)");
                                    }
                                    node2 = node;
                                    node = node.next;
                                    by = (byte)(0x80 | 0x3F & n4 >> 6);
                                    if (node.byteValue != by) {
                                        node = SymbolTable.search(node, by);
                                        if (node.byteValue != by) {
                                            return -1;
                                        }
                                    }
                                    if (node.endOffset != 0) {
                                        UntestedCode.needTest("needCode(1)");
                                    }
                                    node2 = node;
                                    node = node.next;
                                    by = (byte)(0x80 | 0x3F & n4);
                                    if (node.byteValue == by) break block58;
                                    node = SymbolTable.search(node, by);
                                    if (node.byteValue != by) break block59;
                                }
                                if (node.endOffset == 0) continue;
                                UntestedCode.needTest("needCode(1)");
                                continue;
                            }
                            return -1;
                        }
                        this.fError = CharConversionError.invalidSecondHalfOfSurrogatePair();
                        UntestedCode.needTest("needCode(4)");
                        return -1;
                    }
                    this.fError = CharConversionError.missingSecondHalfOfSurrogatePair();
                    UntestedCode.needTest("needCode(5)");
                    return -1;
                }
                this.fError = CharConversionError.invalidFirstHalfOfSurrogatePair();
                UntestedCode.needTest("needCode(6)");
                return -1;
            }
            return -1;
        }
        if (node.handle > 0) {
            return node.handle;
        }
        if (n2 == 0) {
            return 0;
        }
        return -1;
    }

    public int addStringSymbol(String string) {
        int n = this.lookupStringSymbol(string);
        if (n >= 0) {
            return n;
        }
        if (this.fError == null && this.addStringToCache(string, n = this.fSymbolCount++)) {
            return n;
        }
        UntestedCode.needTest("needCode(7)");
        return -1;
    }

    private boolean addStringToCache(String string, int n) {
        int n2;
        int n3;
        int n4 = n * 4;
        if (n4 < this.fSymbols.length) {
            this.fSymbols[n4 + 2] = 0;
            this.fSymbols[n4 + 3] = 0;
        } else {
            this.grow();
        }
        this.fSymbols[n4 + 0] = n3 = this.fStringBuffer.getOffset();
        this.fError = this.fStringBuffer.appendString(string);
        this.fSymbols[n4 + 1] = n2 = this.fStringBuffer.getOffset();
        if (this.fError == null) {
            XMLString xMLString = this.fStringInBuffer;
            this.fStringBuffer.setStringValues(n3, n2, xMLString);
            boolean bl = this.addXMLStringToTree(this.fGlobals, xMLString, n, 0);
            return bl;
        }
        return false;
    }

    public void setStringValues(int n, XMLString xMLString) {
        if (n >= 0) {
            int n2 = n * 4;
            int n3 = this.fSymbols[n2 + 0];
            int n4 = this.fSymbols[n2 + 1];
            this.fStringBuffer.setStringValues(n3, n4, xMLString);
        } else {
            xMLString.clear();
        }
    }

    public void appendToBuffer(int n, XMLStringBuffer xMLStringBuffer) {
        int n2 = n * 4;
        int n3 = this.fSymbols[n2 + 0];
        int n4 = this.fSymbols[n2 + 1];
        this.fStringBuffer.appendToBuffer(n3, n4, xMLStringBuffer);
    }

    public int addSymbol(XMLString xMLString) {
        xMLString = xMLString.normalizeLineBreaks(this.fStringBuffer, this.fStringInBuffer);
        if (xMLString.bytes != null) {
            return this.addSymbolUnbuffered(xMLString);
        }
        return this.addSymbolBuffered(xMLString);
    }

    private Node lookupSymbolUsingXMLString(Node node, XMLString xMLString) {
        if (xMLString.bytes != null) {
            return this.lookupSymbolUsingXMLStringUnbuffered(node, xMLString);
        }
        return this.lookupSymbolUsingXMLStringBuffered(node, xMLString);
    }

    private int addSymbolBuffered(XMLString xMLString) {
        Node node = this.lookupSymbolUsingXMLStringBuffered(this.fGlobals, xMLString);
        if (node != NODE_NULL) {
            return node.handle;
        }
        if (xMLString.length == 0) {
            return 0;
        }
        int n = this.fSymbolCount++;
        this.saveXMLStringForHandle(xMLString, n);
        if (this.addXMLStringToTree(this.fGlobals, xMLString, n, 0)) {
            return n;
        }
        UntestedCode.needTest("needCode(8)");
        return -1;
    }

    private int addSymbolUnbuffered(XMLString xMLString) {
        Node node = this.lookupSymbolUsingXMLStringUnbuffered(this.fGlobals, xMLString);
        if (node != NODE_NULL) {
            return node.handle;
        }
        if (xMLString.length == 0) {
            return 0;
        }
        int n = this.fSymbolCount++;
        this.saveXMLStringForHandle(xMLString, n);
        if (this.addXMLStringToTree(this.fGlobals, xMLString, n, 0)) {
            return n;
        }
        UntestedCode.needTest("needCode(8)");
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node lookupSymbolUsingXMLStringBuffered(Node node, XMLString xMLString) {
        int n;
        DataBuffer dataBuffer;
        Node node2 = node;
        DataBuffer dataBuffer2 = xMLString.firstBuffer;
        byte[] byArray = dataBuffer2.bytes;
        int n2 = xMLString.startOffset;
        if (xMLString.bytes != null) {
            dataBuffer = dataBuffer2;
            n = xMLString.endOffset;
        } else {
            dataBuffer = xMLString.lastBuffer;
            n = dataBuffer2.endOffset;
        }
        block0: while (true) {
            if (n2 < n) {
                int n3;
                node2 = node2.next;
                if (node2 == NODE_NULL) return NODE_NULL;
                byte by = byArray[n2];
                ++n2;
                if (node2.byteValue != by) {
                    node2 = SymbolTable.search(node2, by);
                    if (node2.byteValue != by) return NODE_NULL;
                }
                if ((n3 = node2.endOffset) == 0) continue;
                int n4 = node2.startOffset;
                while (true) {
                    if (n4 >= n3) continue block0;
                    if (n2 < n) {
                        by = byArray[n2];
                        if (this.fDataBytes[n4] != by) return NODE_NULL;
                        ++n2;
                    } else {
                        if (dataBuffer2 == dataBuffer) {
                            return NODE_NULL;
                        }
                        dataBuffer2 = dataBuffer2.next;
                        byArray = dataBuffer2.bytes;
                        n2 = dataBuffer2.startOffset;
                        n = dataBuffer2 == xMLString.lastBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                        --n4;
                    }
                    ++n4;
                }
            }
            if (dataBuffer2 == dataBuffer) break;
            dataBuffer2 = dataBuffer2.next;
            byArray = dataBuffer2.bytes;
            n2 = dataBuffer2.startOffset;
            if (dataBuffer2 == dataBuffer) {
                n = xMLString.endOffset;
                continue;
            }
            n = dataBuffer2.endOffset;
        }
        if (node2.handle > 0) {
            return node2;
        }
        if (xMLString.length == 0) {
            return NODE_NULL;
        }
        if (n != 0) return NODE_NULL;
        UntestedCode.needTest("does this happen?");
        return NODE_NULL;
    }

    private Node lookupSymbolUsingXMLStringUnbuffered(Node node, XMLString xMLString) {
        block6: {
            Node node2 = node.next;
            int n = xMLString.endOffset;
            int n2 = xMLString.startOffset;
            while (true) {
                int n3;
                byte by = xMLString.bytes[n2];
                ++n2;
                if (node2 == NODE_NULL) break block6;
                if (node2.byteValue != by) {
                    node2 = SymbolTable.search(node2, by);
                    if (node2.byteValue != by) break block6;
                }
                if ((n3 = node2.endOffset) != 0) {
                    int n4 = node2.startOffset;
                    while (n4 < n3) {
                        by = xMLString.bytes[n2];
                        if (this.fDataBytes[n4] == by) {
                            ++n2;
                        } else {
                            return NODE_NULL;
                        }
                        ++n4;
                    }
                }
                if (n2 >= n) break;
                node2 = node2.next;
            }
            return node2.handle > 0 ? node2 : NODE_NULL;
        }
        return NODE_NULL;
    }

    private void saveXMLStringForHandle(XMLString xMLString, int n) {
        int n2 = n * 4;
        if (n2 < this.fSymbols.length) {
            this.fSymbols[n2 + 2] = 0;
            this.fSymbols[n2 + 3] = 0;
        } else {
            this.grow();
        }
        this.fSymbols[n2 + 0] = this.fStringBuffer.getOffset();
        this.fStringBuffer.appendXMLString(xMLString);
        this.fSymbols[n2 + 1] = this.fStringBuffer.getOffset();
    }

    private boolean addSymbolToTree(Node node, int n, int n2) {
        int n3 = n * 4;
        int n4 = this.fSymbols[n3 + 0];
        int n5 = this.fSymbols[n3 + 1];
        XMLString xMLString = this.fStringInBuffer;
        this.fStringBuffer.setStringValues(n4, n5, xMLString);
        return this.addXMLStringToTree(node, xMLString, n, n2);
    }

    private Node createEmptyTree(Node node, byte by) {
        Node node2 = this.cacheNodeAllocate();
        node2.byteValue = by;
        node2.count = 1;
        node2.next = node.next;
        node.next = node2;
        return node2;
    }

    private Node createNodeAtLeaf(Node node, Node node2, byte by) {
        Node node3 = this.cacheNodeAllocate();
        node3.byteValue = by;
        node3.count = 1;
        if (by < node2.byteValue) {
            node2.left = node3;
        } else {
            node2.right = node3;
        }
        node.next = this.rebalance(node.next, node2);
        return node3;
    }

    private static int checkNameChar(int n, boolean bl) {
        if (n < 128) {
            if (n > 0) {
                return nameCharMap[n];
            }
            if (n < 0) {
                return 65280;
            }
            return 8;
        }
        if (bl) {
            if (XMLCharacterProperties.nameStartChar10(n)) {
                return 3;
            }
            if (XMLCharacterProperties.nameChar10(n)) {
                return 2;
            }
            return 8;
        }
        if (XMLCharacterProperties.nameStartChar11(n)) {
            return 3;
        }
        if (XMLCharacterProperties.nameChar11(n)) {
            return 2;
        }
        if (n == 133 || n == 8232) {
            return 24;
        }
        return 8;
    }

    private static boolean fixNameChar(Node node, int n, boolean bl) {
        if (SymbolTable.checkNameChar(n, bl) < 4) {
            node.userValue = node.userValue | (bl ? 1 : 2);
            return true;
        }
        return false;
    }

    private boolean charConversionFailure(int n, int n2, int n3, int n4, int n5) {
        this.fError = CharConversionError.invalidUTF8CharacterEncoding(n, n2, n3, n4, n5);
        return false;
    }

    private void needCompressMultibyteCode(int n) {
        UntestedCode.needTest("needCompressMultibyteCode");
    }

    private boolean addXMLStringToTree(Node node, XMLString xMLString, int n, int n2) {
        byte by;
        int n3;
        int n4;
        byte by2;
        DataBuffer dataBuffer;
        int n5;
        DataBuffer dataBuffer2 = xMLString.firstBuffer;
        byte[] byArray = dataBuffer2.bytes;
        int n6 = xMLString.startOffset;
        Node node2 = node;
        if (xMLString.bytes != null) {
            n5 = xMLString.endOffset;
            dataBuffer = xMLString.firstBuffer;
        } else {
            n5 = dataBuffer2.endOffset;
            dataBuffer = xMLString.lastBuffer;
        }
        while (true) {
            if (n6 == n5) {
                if (dataBuffer2 == dataBuffer) {
                    if (node != this.fGlobals) {
                        node2.userValue = n2;
                    }
                    node2.handle = n;
                    return true;
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n5 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
            }
            by2 = byArray[n6++];
            Node node3 = node2;
            node2 = node2.next;
            if (node2 == NODE_NULL) {
                node2 = this.createEmptyTree(node3, by2);
            } else if (node2.byteValue != by2) {
                node2 = SymbolTable.search(node2, by2);
                if (node2.byteValue != by2) {
                    node2 = this.createNodeAtLeaf(node3, node2, by2);
                }
            }
            if (by2 > 0) {
                n4 = node2.endOffset;
                if (n4 == 0) continue;
                n3 = node2.startOffset;
                while (n3 < n4) {
                    if (n6 == n5) {
                        if (dataBuffer2 == dataBuffer) {
                            Node node4 = this.createEmptyTree(node2, this.fDataBytes[n3]);
                            if (n3 + 1 == node2.endOffset) {
                                node4.endOffset = 0;
                                node4.startOffset = 0;
                            } else {
                                node4.startOffset = n3 + 1;
                                node4.endOffset = node2.endOffset;
                            }
                            node4.handle = node2.handle;
                            node4.userValue = node2.userValue;
                            if (n3 == node2.startOffset) {
                                node2.endOffset = 0;
                                node2.startOffset = 0;
                            } else {
                                node2.endOffset = n3;
                            }
                            node2.userValue = node == this.fGlobals ? 0 : n2;
                            node2.handle = n;
                            return true;
                        }
                        dataBuffer2 = dataBuffer2.next;
                        byArray = dataBuffer2.bytes;
                        n6 = dataBuffer2.startOffset;
                        n5 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                    }
                    if (this.fDataBytes[n3] != (by2 = byArray[n6++])) {
                        Node node5 = this.createEmptyTree(node2, this.fDataBytes[n3]);
                        Node node6 = this.createNodeAtLeaf(node2, node5, by2);
                        if (n3 + 1 == node2.endOffset) {
                            node5.endOffset = 0;
                            node5.startOffset = 0;
                        } else {
                            node5.startOffset = n3 + 1;
                            node5.endOffset = node2.endOffset;
                        }
                        node5.handle = node2.handle;
                        node5.userValue = node2.userValue;
                        if (n3 == node2.startOffset) {
                            node2.endOffset = 0;
                            node2.startOffset = 0;
                        } else {
                            node2.endOffset = n3;
                        }
                        node2.handle = 0;
                        node2.userValue = 0;
                        node2 = node6;
                        break;
                    }
                    ++n3;
                }
            }
            if (by2 > 0) continue;
            int n7 = fgMultiByteLength[by2 >> 3 & 0xF];
            if (n7 < 2) {
                return this.charConversionFailure(1, by2 & 0xFF, 0, 0, 0);
            }
            if (n6 == n5) {
                if (dataBuffer2 == dataBuffer) {
                    this.fError = CharConversionError.partialMultiPartCharacterSequence();
                    return false;
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n5 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
            }
            n3 = byArray[n6++];
            node3 = node2;
            node2 = node2.next;
            if (node2 == NODE_NULL) {
                node2 = this.createEmptyTree(node3, (byte)n3);
            } else if (node2.byteValue != n3) {
                node2 = SymbolTable.search(node2, n3);
                if (node2.byteValue != n3) {
                    node2 = this.createNodeAtLeaf(node3, node2, (byte)n3);
                }
            }
            if ((0xC0 & n3) != 128) {
                return this.charConversionFailure(2, by2 & 0xFF, n3 & 0xFF, 0, 0);
            }
            if (n7 == 2) continue;
            if (n6 == n5) {
                if (dataBuffer2 == dataBuffer) {
                    this.fError = CharConversionError.partialMultiPartCharacterSequence();
                    return false;
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n5 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
            }
            n4 = byArray[n6++];
            node3 = node2;
            node2 = node2.next;
            if (node2 == NODE_NULL) {
                node2 = this.createEmptyTree(node3, (byte)n4);
            } else if (node2.byteValue != n4) {
                node2 = SymbolTable.search(node2, n4);
                if (node2.byteValue != n4) {
                    node2 = this.createNodeAtLeaf(node3, node2, (byte)n4);
                }
            }
            if ((0xC0 & n4) != 128) {
                return this.charConversionFailure(3, by2 & 0xFF, n3 & 0xFF, n4 & 0xFF, 0);
            }
            if (n7 == 3) continue;
            if (n6 == n5) {
                if (dataBuffer2 == dataBuffer) {
                    this.fError = CharConversionError.partialMultiPartCharacterSequence();
                    return false;
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n5 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
            }
            by = byArray[n6++];
            node3 = node2;
            node2 = node2.next;
            if (node2 == NODE_NULL) {
                node2 = this.createEmptyTree(node3, by);
            } else if (node2.byteValue != by) {
                node2 = SymbolTable.search(node2, by);
                if (node2.byteValue != by) {
                    node2 = this.createNodeAtLeaf(node3, node2, by);
                }
            }
            if ((0xC0 & by) != 128) break;
        }
        return this.charConversionFailure(4, by2 & 0xFF, n3 & 0xFF, n4 & 0xFF, by & 0xFF);
    }

    private boolean checkNextBuffer(ParsedEntity parsedEntity) {
        parsedEntity.offset = parsedEntity.endOffset;
        return !parsedEntity.load() && parsedEntity.error == null;
    }

    public int scanNCName(ParsedEntity parsedEntity, XMLString xMLString) {
        int n;
        block12: {
            int n2;
            xMLString.setStartPos(parsedEntity.buffer, parsedEntity.offset);
            if (nameStartCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF] == 1) {
                ++parsedEntity.offset;
            } else if (!parsedEntity.skippedNameStartCharacter()) {
                xMLString.clear();
                return 0;
            }
            while (true) {
                if ((n = nameCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF]) < 4) {
                    ++parsedEntity.offset;
                    continue;
                }
                if (n != 8) {
                    if (n == 12) {
                        if (parsedEntity.offset < parsedEntity.endOffset) {
                            n = 8;
                        } else {
                            if (this.checkNextBuffer(parsedEntity)) continue;
                            if (parsedEntity.error != null) {
                                UntestedCode.needTest("needCode(14)");
                                n = 8;
                            } else {
                                n = 8;
                            }
                        }
                    }
                    break block12;
                }
                if (!parsedEntity.skippedNameCharacter()) break;
            }
            if (!(parsedEntity.isXML10 || (parsedEntity.bytes[parsedEntity.offset] & 0xDF) != 194 || (n2 = parsedEntity.decodeCharacter()) != 133 && n2 != 8232)) {
                n = 24;
            }
        }
        xMLString.setEndPos(parsedEntity.buffer, parsedEntity.offset, 0);
        return n >> 2;
    }

    public int scanNmtoken(ParsedEntity parsedEntity, XMLString xMLString) {
        int n;
        block12: {
            int n2;
            xMLString.setStartPos(parsedEntity.buffer, parsedEntity.offset);
            if (nameCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF] <= 4) {
                ++parsedEntity.offset;
            } else if (!parsedEntity.skippedNameCharacter()) {
                xMLString.clear();
                return 0;
            }
            while (true) {
                if ((n = nameCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF]) <= 4) {
                    ++parsedEntity.offset;
                    continue;
                }
                if (n != 8) {
                    if (n == 12) {
                        if (parsedEntity.offset < parsedEntity.endOffset) {
                            n = 8;
                        } else {
                            if (this.checkNextBuffer(parsedEntity)) continue;
                            if (parsedEntity.error != null) {
                                UntestedCode.needTest("needCode(14)");
                                n = 8;
                            } else {
                                n = 8;
                            }
                        }
                    }
                    break block12;
                }
                if (!parsedEntity.skippedNameCharacter()) break;
            }
            if (!(parsedEntity.isXML10 || (parsedEntity.bytes[parsedEntity.offset] & 0xDF) != 194 || (n2 = parsedEntity.decodeCharacter()) != 133 && n2 != 8232)) {
                n = 24;
            }
        }
        xMLString.setEndPos(parsedEntity.buffer, parsedEntity.offset, 0);
        return n >> 2;
    }

    public int scanName(ParsedEntity parsedEntity, QName qName) {
        int n = this.scanName(parsedEntity, this.fQNameString);
        if (n != 0) {
            int n2 = this.addSymbol(this.fQNameString);
            qName.setStartPos(this.fQNameString.firstBuffer, this.fQNameString.startOffset);
            if (this.fQNameString.bytes != null) {
                qName.setEndPos(this.fQNameString.firstBuffer, this.fQNameString.endOffset);
            } else {
                qName.setEndPos(this.fQNameString.lastBuffer, this.fQNameString.endOffset);
            }
            qName.handle = qName.localHandle = n2;
            qName.nsHandle = 0;
            qName.prefixHandle = 0;
        } else {
            qName.clear();
        }
        return n;
    }

    public int scanName(ParsedEntity parsedEntity, XMLString xMLString) {
        int n;
        block20: {
            xMLString.setStartPos(parsedEntity.buffer, parsedEntity.offset);
            if (parsedEntity.unbuffered) {
                int n2;
                byte[] byArray = parsedEntity.bytes;
                byte by = byArray[parsedEntity.offset];
                if (by == 58 || nameStartCharMap[by & 0xFF] == 1) {
                    ++parsedEntity.offset;
                } else if (!parsedEntity.skippedNameStartCharacter()) {
                    xMLString.clear();
                    return 0;
                }
                while (true) {
                    if ((n = nameCharMap[byArray[parsedEntity.offset] & 0xFF]) <= 4) {
                        ++parsedEntity.offset;
                        continue;
                    }
                    if (n != 8) break block20;
                    if (!parsedEntity.skippedNameCharacter()) break;
                }
                if (!(parsedEntity.isXML10 || (byArray[parsedEntity.offset] & 0xDF) != 194 || (n2 = parsedEntity.decodeCharacter()) != 133 && n2 != 8232)) {
                    n = 24;
                }
            } else {
                int n3;
                byte by = parsedEntity.bytes[parsedEntity.offset];
                if (by == 58 || nameStartCharMap[by & 0xFF] == 1) {
                    ++parsedEntity.offset;
                } else if (!parsedEntity.skippedNameStartCharacter()) {
                    xMLString.clear();
                    return 0;
                }
                while (true) {
                    if ((n = nameCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF]) <= 4) {
                        ++parsedEntity.offset;
                        continue;
                    }
                    if (n != 8) {
                        if (n == 12) {
                            if (parsedEntity.offset < parsedEntity.endOffset) {
                                n = 8;
                            } else {
                                if (this.checkNextBuffer(parsedEntity)) continue;
                                if (parsedEntity.error != null) {
                                    UntestedCode.needTest("needCode(6)");
                                    n = 8;
                                } else {
                                    n = 8;
                                }
                            }
                        }
                        break block20;
                    }
                    if (!parsedEntity.skippedNameCharacter()) break;
                }
                if (!(parsedEntity.isXML10 || (parsedEntity.bytes[parsedEntity.offset] & 0xDF) != 194 || (n3 = parsedEntity.decodeCharacter()) != 133 && n3 != 8232)) {
                    n = 24;
                }
            }
        }
        xMLString.setEndPos(parsedEntity.buffer, parsedEntity.offset, 0);
        return n >> 2;
    }

    public void shareQNameValues(QName qName, QName qName2) {
        if (qName.handle >= 0) {
            int n = qName.handle * 4;
            int n2 = this.fSymbols[n + 0];
            int n3 = this.fSymbols[n + 1];
            this.fStringBuffer.setQNameValues(n2, n3, qName2);
            qName2.handle = qName.handle;
            qName2.prefixHandle = qName.prefixHandle;
            qName2.nsHandle = qName.nsHandle;
            qName2.localHandle = qName.localHandle;
        } else {
            qName2.clear();
        }
    }

    public void addQNameSymbol(QName qName) {
        this.fQNameString.setValues(qName);
        qName.handle = this.addSymbol(this.fQNameString);
        this.saveQNameForHandle(qName, qName.handle);
    }

    private void saveQNameForHandle(QName qName, int n) {
        int n2 = n * 4;
        this.fSymbols[n2 + 2] = qName.localHandle;
        this.fSymbols[n2 + 3] = qName.prefixHandle;
    }

    public int scanQNameBuffered(ParsedEntity parsedEntity, QName qName) {
        int n = this.scanASCIIQNameWithinBuffer(parsedEntity, qName);
        if (n == -1) {
            n = this.scanQNameBuffered2(parsedEntity, qName);
        }
        return n;
    }

    public int scanQNameUnbuffered(ParsedEntity parsedEntity, QName qName) {
        int n = this.scanASCIIQNameWithinBuffer(parsedEntity, qName);
        if (n == -1) {
            n = this.scanQNameUnbuffered2(parsedEntity, qName);
        }
        return n;
    }

    private int scanASCIIQNameWithinBuffer(ParsedEntity parsedEntity, QName qName) {
        block10: {
            int n;
            int n2;
            int n3;
            boolean bl;
            Node node;
            Node node2;
            byte by;
            int n4;
            block9: {
                n4 = parsedEntity.offset;
                by = parsedEntity.bytes[n4];
                node2 = this.fGlobals;
                node = node2.next;
                bl = parsedEntity.isXML10;
                int n5 = n3 = bl ? 1 : 2;
                if (node.byteValue == by) break block9;
                node = SymbolTable.search(node, by);
                if (node.byteValue != by) break block10;
            }
            while ((node.userValue & n3) != 0 || SymbolTable.fixNameChar(node, by, bl)) {
                by = parsedEntity.bytes[++n4];
                n2 = node.endOffset;
                if (n2 == 0) {
                    node2 = node;
                    node = node.next;
                    if (node == NODE_NULL) break;
                    if (node.byteValue == by) continue;
                    node = SymbolTable.search(node, by);
                    if (node.byteValue != by) break;
                    continue;
                }
                int n6 = node.startOffset;
                while (n6 < n2) {
                    if (this.fDataBytes[n6] != by) {
                        return -1;
                    }
                    by = parsedEntity.bytes[++n4];
                    ++n6;
                }
                node2 = node;
                node = node.next;
                if (node == NODE_NULL) break;
                if (node.byteValue == by) continue;
                node = SymbolTable.search(node, by);
                if (node.byteValue == by) continue;
            }
            if (node2.handle != 0 && by > 0 && (n = SymbolTable.checkNameChar(by, bl)) > 4) {
                qName.handle = node2.handle;
                n2 = node2.handle * 4;
                qName.localHandle = this.fSymbols[n2 + 2];
                if (qName.localHandle == 0) {
                    qName.localHandle = node2.handle;
                    this.fSymbols[n2 + 2] = node2.handle;
                }
                qName.nsHandle = 0;
                qName.prefixHandle = this.fSymbols[n2 + 3];
                qName.setValues(parsedEntity.buffer, parsedEntity.offset, n4);
                parsedEntity.offset = n4;
                return n >> 2;
            }
            return -1;
        }
        return -1;
    }

    private static int getSepOffset(QName qName, DataBuffer dataBuffer, int n) {
        int n2;
        if (dataBuffer == qName.firstBuffer) {
            n2 = n - qName.startOffset;
        } else {
            DataBuffer dataBuffer2 = qName.firstBuffer;
            n2 = dataBuffer2.endOffset - qName.startOffset;
            dataBuffer2 = dataBuffer2.next;
            while (dataBuffer2 != dataBuffer) {
                n2 += dataBuffer2.endOffset - dataBuffer2.startOffset;
                dataBuffer2 = dataBuffer2.next;
            }
            n2 += n - dataBuffer.startOffset;
        }
        return n2;
    }

    private int scanQNameUnbuffered2(ParsedEntity parsedEntity, QName qName) {
        byte by;
        int n;
        int n2;
        Node node;
        Node node2;
        int n3;
        int n4;
        block23: {
            boolean bl;
            byte[] byArray = parsedEntity.bytes;
            n4 = parsedEntity.offset;
            n3 = 0;
            node2 = this.fGlobals;
            node = node2.next;
            n2 = 0;
            n = 0;
            boolean bl2 = parsedEntity.isXML10;
            qName.setStartPos(parsedEntity.buffer, parsedEntity.offset);
            qName.prefixHandle = 0;
            do {
                int n5;
                block24: {
                    int n6;
                    bl = false;
                    by = byArray[n4];
                    n3 = SymbolTable.checkNameChar(by, bl2);
                    if (node.byteValue != by) {
                        node = SymbolTable.search(node, by);
                        if (node.byteValue != by) {
                            n = 1;
                            break;
                        }
                    }
                    if (n3 != 3) {
                        if (n3 == 65280) {
                            n = 2;
                            break;
                        }
                        qName.clear();
                        return 0;
                    }
                    ++n4;
                    int n7 = node.endOffset;
                    if (n7 != 0) {
                        n5 = n4;
                        n6 = node.startOffset;
                        while (n6 < n7) {
                            by = byArray[n4];
                            n3 = SymbolTable.checkNameChar(by, bl2);
                            if (this.fDataBytes[n6] != by || n3 >= 4) {
                                n4 = n5;
                                n = 6;
                                break block23;
                            }
                            ++n4;
                            ++n6;
                        }
                    }
                    node2 = node;
                    node = node.next;
                    while (true) {
                        by = byArray[n4];
                        n3 = SymbolTable.checkNameChar(by, bl2);
                        if (node == NODE_NULL) break;
                        if (node.byteValue != by) {
                            node = SymbolTable.search(node, by);
                            if (node.byteValue != by) {
                                n = 3;
                                break block24;
                            }
                        }
                        if (n3 >= 4) {
                            if (n3 == 4) {
                                bl = true;
                            } else if (n3 == 65280) {
                                n = 4;
                            } else {
                                UntestedCode.needTest("new multibyte support 4");
                                n = 7;
                            }
                            break block24;
                        }
                        ++n4;
                        n7 = node.endOffset;
                        if (n7 != 0) {
                            n5 = n4;
                            n6 = node.startOffset;
                            while (n6 < n7) {
                                by = byArray[n4];
                                n3 = SymbolTable.checkNameChar(by, bl2);
                                if (this.fDataBytes[n6] != by || n3 >= 4) {
                                    n4 = n5;
                                    n = 6;
                                    break block24;
                                }
                                ++n4;
                                ++n6;
                            }
                        }
                        node2 = node;
                        node = node.next;
                    }
                    if (n3 <= 4 || n3 == 65280 || node2.handle == 0) {
                        n = 5;
                    }
                }
                if (!bl) continue;
                if (qName.prefixHandle == 0) {
                    n5 = node2.handle;
                    if (n5 > 0) {
                        n2 = SymbolTable.getSepOffset(qName, parsedEntity.buffer, n4);
                        qName.prefixHandle = n5;
                        node2 = node;
                        node = node.next;
                        ++n4;
                        if (node != NODE_NULL) continue;
                        by = byArray[n4];
                        n3 = SymbolTable.checkNameChar(by, bl2);
                        n = 1;
                    } else {
                        n = 3;
                    }
                    break;
                }
                qName.clear();
                return 1;
            } while (bl);
        }
        return this.handleNewQName(parsedEntity, qName, node2, node, n, by, n3, n4, n2);
    }

    private int handleNewQName(ParsedEntity parsedEntity, QName qName, Node node, Node node2, int n, byte by, int n2, int n3, int n4) {
        parsedEntity.offset = n3;
        if (n == 0 && node.handle != 0 && n2 > 4) {
            int n5;
            int n6 = node.handle;
            qName.setEndPos(parsedEntity.buffer, n3);
            qName.handle = n6;
            if (qName.prefixHandle != 0 && (n6 = this.fSymbols[(n5 = n6 * 4) + 2]) == 0) {
                int n7 = this.fSymbols[n5 + 0];
                n6 = this.addLocalPartSymbol(n5, n7 + n4);
            }
            qName.localHandle = n6;
            qName.nsHandle = 0;
            return n2 >> 2;
        }
        return this.scanNewQName(parsedEntity, qName, node, node2, n, by, n2, n3, n4);
    }

    /*
     * Unable to fully structure code
     */
    private int scanQNameBuffered2(ParsedEntity var1_1, QName var2_2) {
        block38: {
            var3_3 = var1_1.bytes;
            var4_4 = var1_1.offset;
            var6_5 = 0;
            var7_6 = this.fGlobals;
            var8_7 = var7_6.next;
            var9_8 = 0;
            var11_9 = false;
            var12_10 = 0;
            var13_11 = var1_1.isXML10;
            var2_2.setStartPos(var1_1.buffer, var4_4);
            var2_2.prefixHandle = 0;
            while (true) {
                block46: {
                    block39: {
                        var10_13 = false;
                        var5_12 = var3_3[var4_4];
                        if (var8_7.byteValue != var5_12) {
                            var8_7 = SymbolTable.search(var8_7, var5_12);
                            if (var8_7.byteValue != var5_12) {
                                if (var5_12 != 0 || var4_4 < var1_1.endOffset) {
                                    var6_5 = SymbolTable.checkNameChar(var5_12, var13_11);
                                    var12_10 = 1;
                                    break;
                                }
                                if (this.checkNextBuffer(var1_1)) {
                                    var8_7 = var7_6.next;
                                    var3_3 = var1_1.bytes;
                                    var4_4 = var1_1.offset;
                                    if (var3_3[var4_4] != 0 || var4_4 < var1_1.endOffset) continue;
                                    var5_12 = 0;
                                    var6_5 = 8;
                                    var12_10 = 1;
                                    break;
                                }
                                UntestedCode.needTest("needCode(16)");
                            }
                        }
                        if ((var6_5 = SymbolTable.checkNameChar(var5_12, var13_11)) != 3) {
                            if (var6_5 == 65280) {
                                var12_10 = 2;
                                break;
                            }
                            var2_2.clear();
                            return 0;
                        }
                        ++var4_4;
                        var15_15 = var8_7.endOffset;
                        if (var15_15 == 0) break block39;
                        var16_16 = var4_4;
                        var14_14 = var8_7.startOffset;
                        while (var14_14 < var15_15) {
                            block41: {
                                block40: {
                                    var5_12 = var3_3[var4_4];
                                    var6_5 = SymbolTable.checkNameChar(var5_12, var13_11);
                                    if (this.fDataBytes[var14_14] != var5_12 || var6_5 >= 4) break block40;
                                    ++var4_4;
                                    break block41;
                                }
                                if (var5_12 != 0 || var4_4 < var1_1.endOffset) {
                                    if (var11_9) {
                                        var1_1.resetToMark();
                                    }
                                    var4_4 = var16_16;
                                    var12_10 = 6;
                                    break block38;
                                }
                                if (!var11_9) {
                                    var1_1.setMark();
                                    var11_9 = true;
                                }
                                if (!this.checkNextBuffer(var1_1)) ** GOTO lbl69
                                var3_3 = var1_1.bytes;
                                var4_4 = var1_1.offset;
                                if (var3_3[var4_4] != 0 || var4_4 < var1_1.endOffset) {
                                    --var14_14;
                                } else {
                                    var5_12 = 0;
                                    var6_5 = 8;
                                    var12_10 = 6;
                                    break block38;
lbl69:
                                    // 1 sources

                                    UntestedCode.needTest("needCode(17)");
                                }
                            }
                            ++var14_14;
                        }
                    }
                    if (var11_9) {
                        var1_1.clearMark();
                        var11_9 = false;
                    }
                    var7_6 = var8_7;
                    var8_7 = var8_7.next;
                    block2: while (true) {
                        block42: {
                            block43: {
                                var5_12 = var3_3[var4_4];
                                if (var8_7 == SymbolTable.NODE_NULL) break block42;
                                if (var8_7.byteValue != var5_12) {
                                    var8_7 = SymbolTable.search(var8_7, var5_12);
                                    if (var8_7.byteValue != var5_12) {
                                        if (var5_12 != 0 || var4_4 < var1_1.endOffset) {
                                            var6_5 = SymbolTable.checkNameChar(var5_12, var13_11);
                                            if (var6_5 > 4 && var6_5 != 65280 && var7_6.handle != 0) break;
                                            var12_10 = 3;
                                            break;
                                        }
                                        var16_16 = (int)this.checkNextBuffer(var1_1);
                                        var3_3 = var1_1.bytes;
                                        var4_4 = var1_1.offset;
                                        var8_7 = var7_6.next;
                                        if (var16_16 != 0) {
                                            if (var3_3[var4_4] != 0 || var4_4 < var1_1.endOffset) continue;
                                            var5_12 = 0;
                                            var6_5 = 8;
                                            var12_10 = 3;
                                            break;
                                        }
                                        var5_12 = 0;
                                        var6_5 = 8;
                                        if (var7_6.handle != 0) break;
                                        var12_10 = 3;
                                        break;
                                    }
                                }
                                if ((var6_5 = SymbolTable.checkNameChar(var5_12, var13_11)) < 4) {
                                    ++var4_4;
                                } else {
                                    if (var6_5 == 4) {
                                        var10_13 = true;
                                        break;
                                    }
                                    if (var6_5 == 65280) {
                                        var12_10 = 4;
                                        break;
                                    }
                                    UntestedCode.needTest("new multibyte support 9");
                                    var12_10 = 7;
                                    break;
                                }
                                var15_15 = var8_7.endOffset;
                                if (var15_15 == 0) break block43;
                                var16_16 = var4_4;
                                var14_14 = var8_7.startOffset;
                                while (var14_14 < var15_15) {
                                    block45: {
                                        block44: {
                                            var5_12 = var3_3[var4_4];
                                            var6_5 = SymbolTable.checkNameChar(var5_12, var13_11);
                                            if (this.fDataBytes[var14_14] != var5_12 || var6_5 >= 4) break block44;
                                            ++var4_4;
                                            break block45;
                                        }
                                        if (var5_12 != 0 || var4_4 < var1_1.endOffset) {
                                            if (var11_9) {
                                                var1_1.resetToMark();
                                            }
                                            var4_4 = var16_16;
                                            var12_10 = 6;
                                            break block2;
                                        }
                                        if (!var11_9) {
                                            var1_1.setMark();
                                            var11_9 = true;
                                        }
                                        if (!this.checkNextBuffer(var1_1)) ** GOTO lbl147
                                        var3_3 = var1_1.bytes;
                                        var4_4 = var1_1.offset;
                                        if (var3_3[var4_4] != 0 || var4_4 < var1_1.endOffset) {
                                            --var14_14;
                                        } else {
                                            var5_12 = 0;
                                            var6_5 = 8;
                                            var12_10 = 6;
                                            break block2;
lbl147:
                                            // 1 sources

                                            UntestedCode.needTest("needCode(17)");
                                        }
                                    }
                                    ++var14_14;
                                }
                            }
                            if (var11_9) {
                                var1_1.clearMark();
                                var11_9 = false;
                            }
                            var7_6 = var8_7;
                            var8_7 = var8_7.next;
                            continue;
                        }
                        if (var5_12 != 0 || var4_4 < var1_1.endOffset) {
                            var6_5 = SymbolTable.checkNameChar(var5_12, var13_11);
                            if (var6_5 > 4 && var6_5 != 65280 && var7_6.handle != 0) break;
                            var12_10 = 5;
                            break;
                        }
                        if (this.checkNextBuffer(var1_1)) {
                            var3_3 = var1_1.bytes;
                            var4_4 = var1_1.offset;
                            var5_12 = var3_3[var4_4];
                            var6_5 = SymbolTable.checkNameChar(var5_12, var13_11);
                            if (var6_5 > 4 && var6_5 != 65280 && var7_6.handle != 0) break;
                            var12_10 = 5;
                            break;
                        }
                        UntestedCode.needTest("needCode(18)");
                    }
                    if (!var10_13) break block46;
                    if (var2_2.prefixHandle != 0) ** GOTO lbl198
                    var16_16 = var7_6.handle;
                    if (var16_16 > 0) {
                        var9_8 = SymbolTable.getSepOffset(var2_2, var1_1.buffer, var4_4);
                        var2_2.prefixHandle = var16_16;
                        var7_6 = var8_7;
                        var8_7 = var8_7.next;
                        ++var4_4;
                        if (var8_7 == SymbolTable.NODE_NULL) {
                            var5_12 = var3_3[var4_4];
                            if (var5_12 == 0 && var4_4 == var1_1.endOffset) {
                                if (this.checkNextBuffer(var1_1)) {
                                    var3_3 = var1_1.bytes;
                                    var4_4 = var1_1.offset;
                                    var5_12 = var3_3[var4_4];
                                } else {
                                    var4_4 = var1_1.offset;
                                }
                            }
                            var6_5 = SymbolTable.checkNameChar(var5_12, var13_11);
                            var12_10 = 1;
                            break;
                        }
                    } else {
                        var12_10 = 3;
                        break;
lbl198:
                        // 1 sources

                        var2_2.clear();
                        return 1;
                    }
                }
                if (!var10_13) ** break;
            }
        }
        return this.handleNewQName(var1_1, var2_2, var7_6, var8_7, var12_10, var5_12, var6_5, var4_4, var9_8);
    }

    private Node scanMultiByteChar(ParsedEntity parsedEntity, Node node, int n) {
        byte[] byArray = parsedEntity.bytes;
        int n2 = parsedEntity.offset;
        Node node2 = node.next;
        byte by = byArray[n2];
        int n3 = this.fMultiByteCharInfo[1];
        if (node2 == NODE_NULL) {
            node2 = this.createEmptyTree(node, by);
        } else if (node2.byteValue != by) {
            node2 = SymbolTable.search(node2, by);
            if (node2.byteValue != by) {
                node2 = this.createNodeAtLeaf(node, node2, by);
            }
        }
        if (node2.endOffset != 0) {
            UntestedCode.needTest("needCode(1)");
        }
        node2.userValue |= n;
        if ((by = byArray[++n2]) == 0 && n2 == parsedEntity.endOffset) {
            if (this.checkNextBuffer(parsedEntity)) {
                byArray = parsedEntity.bytes;
                n2 = parsedEntity.offset;
                by = byArray[n2];
            } else {
                UntestedCode.needTest("needCode(16)");
            }
        }
        node = node2;
        node2 = node2.next;
        if (node2 == NODE_NULL) {
            node2 = this.createEmptyTree(node, by);
        } else if (node2.byteValue != by) {
            node2 = SymbolTable.search(node2, by);
            if (node2.byteValue != by) {
                node2 = this.createNodeAtLeaf(node, node2, by);
            }
        }
        if (node2.endOffset != 0) {
            UntestedCode.needTest("needCode(1)");
        }
        node2.userValue |= n;
        if (n3 == 2) {
            parsedEntity.offset = n2;
            return node2;
        }
        if ((by = byArray[++n2]) == 0 && n2 == parsedEntity.endOffset) {
            if (this.checkNextBuffer(parsedEntity)) {
                byArray = parsedEntity.bytes;
                n2 = parsedEntity.offset;
                by = byArray[n2];
            } else {
                UntestedCode.needTest("needCode(16)");
            }
        }
        node = node2;
        node2 = node2.next;
        if (node2 == NODE_NULL) {
            node2 = this.createEmptyTree(node, by);
        } else if (node2.byteValue != by) {
            node2 = SymbolTable.search(node2, by);
            if (node2.byteValue != by) {
                node2 = this.createNodeAtLeaf(node, node2, by);
            }
        }
        if (node2.endOffset != 0) {
            UntestedCode.needTest("needCode(1)");
        }
        node2.userValue |= n;
        if (n3 == 3) {
            parsedEntity.offset = n2;
            return node2;
        }
        if ((by = byArray[++n2]) == 0 && n2 == parsedEntity.endOffset) {
            if (this.checkNextBuffer(parsedEntity)) {
                byArray = parsedEntity.bytes;
                n2 = parsedEntity.offset;
                by = byArray[n2];
            } else {
                UntestedCode.needTest("needCode(16)");
            }
        }
        node = node2;
        node2 = node2.next;
        if (node2 == NODE_NULL) {
            node2 = this.createEmptyTree(node, by);
        } else if (node2.byteValue != by) {
            node2 = SymbolTable.search(node2, by);
            if (node2.byteValue != by) {
                node2 = this.createNodeAtLeaf(node, node2, by);
            }
        }
        if (node2.endOffset != 0) {
            UntestedCode.needTest("needCode(1)");
        }
        node2.userValue |= n;
        parsedEntity.offset = n2;
        return node2;
    }

    /*
     * Unable to fully structure code
     */
    private int scanNewQName(ParsedEntity var1_1, QName var2_2, Node var3_3, Node var4_4, int var5_5, byte var6_6, int var7_7, int var8_8, int var9_9) {
        var12_10 = var1_1.bytes;
        var13_11 = false;
        var14_12 = false;
        var15_13 = var1_1.isXML10;
        var16_14 = var15_13 != false ? 1 : 2;
        block0 : switch (var5_5) {
            case 1: {
                if (var7_7 == 3) {
                    var4_4 = var4_4 == SymbolTable.NODE_NULL ? this.createEmptyTree(var3_3, var6_6) : this.createNodeAtLeaf(var3_3, var4_4, var6_6);
                    var4_4.userValue |= var16_14;
                    break;
                }
                if (var7_7 != 65280) {
                    var2_2.clear();
                    if (var9_9 == 0 || var7_7 != 4) {
                        return 0;
                    }
                    return 1;
                }
            }
            case 2: {
                var1_1.offset = var8_8;
                UTF8Support.decodeCharacter(var1_1, this.fMultiByteCharInfo);
                if (var1_1.error == null && (var7_7 = SymbolTable.checkNameChar(this.fMultiByteCharInfo[0], var15_13)) == 3 && (var4_4 = this.scanMultiByteChar(var1_1, var3_3, var16_14)) != null) {
                    var12_10 = var1_1.bytes;
                    var8_8 = var1_1.offset;
                    break;
                }
                var2_2.clear();
                if (var9_9 == 0 || var7_7 != 4) {
                    return 0;
                }
                return 1;
            }
            case 3: {
                if (var7_7 < 4) {
                    var4_4 = this.createNodeAtLeaf(var3_3, var4_4, var6_6);
                    var4_4.userValue |= var16_14;
                    break;
                }
                if (var7_7 == 4) {
                    if (var9_9 == 0) {
                        var4_4 = this.createNodeAtLeaf(var3_3, var4_4, var6_6);
                        var4_4.userValue |= var16_14;
                        var14_12 = true;
                        break;
                    }
                    var2_2.clear();
                    return 1;
                }
                if (var7_7 != 65280) {
                    var13_11 = true;
                    break;
                }
            }
            case 4: {
                var1_1.offset = var8_8;
                UTF8Support.decodeCharacter(var1_1, this.fMultiByteCharInfo);
                if (var1_1.error == null) {
                    var7_7 = SymbolTable.checkNameChar(this.fMultiByteCharInfo[0], var15_13);
                    if (var7_7 < 4) {
                        var4_4 = this.scanMultiByteChar(var1_1, var3_3, var16_14);
                        if (var4_4 != null) {
                            var12_10 = var1_1.bytes;
                            var8_8 = var1_1.offset;
                            break;
                        }
                        var2_2.clear();
                        return 0;
                    }
                    var13_11 = true;
                    break;
                }
                var2_2.clear();
                return 0;
            }
            case 5: {
                if (var7_7 < 4) {
                    var4_4 = this.createEmptyTree(var3_3, var6_6);
                    var4_4.userValue |= var16_14;
                    break;
                }
                if (var7_7 == 4) {
                    if (var9_9 == 0) {
                        var4_4 = this.createEmptyTree(var3_3, var6_6);
                        var4_4.userValue |= var16_14;
                        var14_12 = true;
                        break;
                    }
                    var2_2.clear();
                    return 1;
                }
                if (var7_7 != 65280) {
                    var13_11 = true;
                    break;
                }
                var1_1.offset = var8_8;
                UTF8Support.decodeCharacter(var1_1, this.fMultiByteCharInfo);
                if (var1_1.error == null) {
                    var7_7 = SymbolTable.checkNameChar(this.fMultiByteCharInfo[0], var15_13);
                    if (var7_7 < 4) {
                        var4_4 = this.scanMultiByteChar(var1_1, var3_3, var16_14);
                        if (var4_4 != null) {
                            var12_10 = var1_1.bytes;
                            var8_8 = var1_1.offset;
                            break;
                        }
                        var2_2.clear();
                        return 0;
                    }
                    var13_11 = true;
                    break;
                }
                var2_2.clear();
                return 0;
            }
            case 6: {
                var11_15 = var4_4.startOffset;
                while (var11_15 < var4_4.endOffset) {
                    var6_6 = var12_10[var8_8];
                    if (this.fDataBytes[var11_15] != var6_6) ** GOTO lbl100
                    ++var8_8;
                    ** GOTO lbl168
lbl100:
                    // 1 sources

                    if (var6_6 != 0 || var8_8 != var1_1.endOffset) ** GOTO lbl109
                    if (!this.checkNextBuffer(var1_1)) ** GOTO lbl108
                    var12_10 = var1_1.bytes;
                    var8_8 = var1_1.offset;
                    var6_6 = var12_10[var8_8];
                    if (this.fDataBytes[var11_15] != var6_6) ** GOTO lbl109
                    ++var8_8;
                    ** GOTO lbl168
lbl108:
                    // 1 sources

                    UntestedCode.needTest("needCode(19)");
lbl109:
                    // 3 sources

                    if ((var7_7 = SymbolTable.checkNameChar(var6_6, var15_13)) < 4 || var7_7 == 4 && var9_9 == 0) {
                        var17_16 = this.createEmptyTree(var4_4, this.fDataBytes[var11_15]);
                        var18_17 = this.createNodeAtLeaf(var4_4, var17_16, var6_6);
                        if (var11_15 + 1 == var4_4.endOffset) {
                            var17_16.endOffset = 0;
                            var17_16.startOffset = 0;
                        } else {
                            var17_16.startOffset = var11_15 + 1;
                            var17_16.endOffset = var4_4.endOffset;
                        }
                        var17_16.handle = var4_4.handle;
                        var17_16.userValue = var4_4.userValue;
                        if (var11_15 == var4_4.startOffset) {
                            var4_4.endOffset = 0;
                            var4_4.startOffset = 0;
                        } else {
                            var4_4.endOffset = var11_15;
                        }
                        var4_4.handle = 0;
                        var4_4.userValue |= var16_14;
                        var3_3 = var4_4;
                        var4_4 = var18_17;
                        var4_4.userValue |= var16_14;
                        var14_12 = var7_7 == 4;
                        break block0;
                    }
                    var17_16 = this.createEmptyTree(var4_4, this.fDataBytes[var11_15]);
                    if (var11_15 + 1 == var4_4.endOffset) {
                        var17_16.endOffset = 0;
                        var17_16.startOffset = 0;
                    } else {
                        var17_16.startOffset = var11_15 + 1;
                        var17_16.endOffset = var4_4.endOffset;
                    }
                    var17_16.handle = var4_4.handle;
                    var17_16.userValue = var4_4.userValue;
                    if (var11_15 == var4_4.startOffset) {
                        var4_4.endOffset = 0;
                        var4_4.startOffset = 0;
                    } else {
                        var4_4.endOffset = var11_15;
                    }
                    var4_4.handle = 0;
                    var4_4.userValue |= var16_14;
                    var3_3 = var4_4;
                    if (var7_7 != 65280) {
                        var13_11 = true;
                        break block0;
                    }
                    var1_1.offset = var8_8;
                    UTF8Support.decodeCharacter(var1_1, this.fMultiByteCharInfo);
                    if (var1_1.error == null) {
                        var7_7 = SymbolTable.checkNameChar(this.fMultiByteCharInfo[0], var15_13);
                        if (var7_7 < 4) {
                            var4_4 = this.scanMultiByteChar(var1_1, var3_3, var16_14);
                            if (var4_4 != null) {
                                var12_10 = var1_1.bytes;
                                var8_8 = var1_1.offset;
                                break block0;
                            }
                            var2_2.clear();
                            return 0;
                        }
                        var13_11 = true;
                        break block0;
                    }
                    var2_2.clear();
                    return 0;
lbl168:
                    // 2 sources

                    ++var11_15;
                }
                break;
            }
            case 7: {
                UntestedCode.needTest("new multibyte support 12");
                var13_11 = true;
            }
        }
        block10: while (!var13_11) {
            block67: {
                block68: {
                    block69: {
                        block70: {
                            block73: {
                                block72: {
                                    block71: {
                                        if (!var14_12) break block70;
                                        var9_9 = SymbolTable.getSepOffset(var2_2, var1_1.buffer, var8_8);
                                        var10_18 = var3_3.handle;
                                        if (var10_18 == 0) {
                                            var3_3.handle = var10_18 = this.fSymbolCount++;
                                            var9_9 = -var9_9;
                                        }
                                        var2_2.prefixHandle = var10_18;
                                        var6_6 = var12_10[++var8_8];
                                        if (var6_6 == 0 && var8_8 == var1_1.endOffset) {
                                            if (this.checkNextBuffer(var1_1)) {
                                                var12_10 = var1_1.bytes;
                                                var8_8 = var1_1.offset;
                                                var6_6 = var12_10[var8_8];
                                            } else {
                                                UntestedCode.needTest("needCode(19)");
                                            }
                                        }
                                        var3_3 = var4_4;
                                        var4_4 = var4_4.next;
                                        var7_7 = SymbolTable.checkNameChar(var6_6, var15_13);
                                        if (var4_4 != SymbolTable.NODE_NULL) break block71;
                                        if (var7_7 == 3) {
                                            var4_4 = this.createEmptyTree(var3_3, var6_6);
                                        }
                                        break block72;
                                    }
                                    if (var4_4.byteValue == var6_6) ** GOTO lbl-1000
                                    var4_4 = SymbolTable.search(var4_4, var6_6);
                                    if (var4_4.byteValue == var6_6) lbl-1000:
                                    // 2 sources

                                    {
                                        if (var4_4.endOffset != 0) {
                                            UntestedCode.needTest("needCode(1)");
                                        }
                                    } else if (var7_7 == 3) {
                                        var4_4 = this.createNodeAtLeaf(var3_3, var4_4, var6_6);
                                    }
                                }
                                if (var7_7 == 3) break block73;
                                if (var7_7 != 65280) ** GOTO lbl225
                                var1_1.offset = var8_8;
                                UTF8Support.decodeCharacter(var1_1, this.fMultiByteCharInfo);
                                if (var1_1.error != null) ** GOTO lbl223
                                var7_7 = SymbolTable.checkNameChar(this.fMultiByteCharInfo[0], var15_13);
                                if (var7_7 != 3) ** GOTO lbl221
                                var4_4 = this.scanMultiByteChar(var1_1, var3_3, var16_14);
                                if (var4_4 != null) {
                                    var12_10 = var1_1.bytes;
                                    var8_8 = var1_1.offset;
                                } else {
                                    var2_2.clear();
                                    return 0;
lbl221:
                                    // 1 sources

                                    var2_2.clear();
                                    return 2;
lbl223:
                                    // 1 sources

                                    var2_2.clear();
                                    return 2;
lbl225:
                                    // 1 sources

                                    var2_2.clear();
                                    var1_1.offset = var8_8;
                                    if (var7_7 == 4) {
                                        return 1;
                                    }
                                    return 2;
                                }
                            }
                            var14_12 = false;
                        }
                        while (true) {
                            block75: {
                                block74: {
                                    if ((var6_6 = var12_10[++var8_8]) == 0 && var8_8 == var1_1.endOffset) {
                                        if (this.checkNextBuffer(var1_1)) {
                                            var12_10 = var1_1.bytes;
                                            var8_8 = var1_1.offset;
                                            var6_6 = var12_10[var8_8];
                                        } else {
                                            var8_8 = var1_1.offset;
                                        }
                                    }
                                    var3_3 = var4_4;
                                    var4_4 = var4_4.next;
                                    var7_7 = SymbolTable.checkNameChar(var6_6, var15_13);
                                    if (var4_4 != SymbolTable.NODE_NULL) break block74;
                                    if (var7_7 < 4 || var7_7 == 4 && var9_9 == 0) {
                                        var4_4 = this.createEmptyTree(var3_3, var6_6);
                                        var4_4.userValue |= var16_14;
                                    }
                                    break block75;
                                }
                                if (var4_4.byteValue == var6_6) ** GOTO lbl-1000
                                var4_4 = SymbolTable.search(var4_4, var6_6);
                                if (var4_4.byteValue == var6_6) lbl-1000:
                                // 2 sources

                                {
                                    if (var4_4.endOffset != 0) {
                                        UntestedCode.needTest("needCode(1)");
                                    }
                                } else if (var7_7 < 4 || var7_7 == 4 && var9_9 == 0) {
                                    var4_4 = this.createNodeAtLeaf(var3_3, var4_4, var6_6);
                                    var4_4.userValue |= var16_14;
                                }
                            }
                            if (var7_7 < 4) continue;
                            if (var7_7 != 65280) break block67;
                            var1_1.offset = var8_8;
                            UTF8Support.decodeCharacter(var1_1, this.fMultiByteCharInfo);
                            if (var1_1.error != null) break block68;
                            if (!(var15_13 || this.fMultiByteCharInfo[0] != 133 && this.fMultiByteCharInfo[0] != 8232)) {
                                var7_7 = 24;
                                var13_11 = true;
                                continue block10;
                            }
                            var7_7 = SymbolTable.checkNameChar(this.fMultiByteCharInfo[0], var15_13);
                            if (var7_7 >= 4) break block69;
                            var4_4 = this.scanMultiByteChar(var1_1, var3_3, var16_14);
                            if (var4_4 == null) break;
                            var12_10 = var1_1.bytes;
                            var8_8 = var1_1.offset;
                        }
                        var2_2.clear();
                        return 0;
                    }
                    var13_11 = true;
                    continue;
                }
                var2_2.clear();
                return 0;
            }
            if (var7_7 == 4) {
                if (var9_9 == 0) {
                    var14_12 = true;
                    continue;
                }
                var2_2.clear();
                var1_1.offset = var8_8;
                return 1;
            }
            var13_11 = true;
        }
        var2_2.setEndPos(var1_1.buffer, var8_8);
        var1_1.offset = var8_8;
        return this.scanQNameResult(var2_2, var3_3, var9_9, var7_7);
    }

    private int scanQNameResult(QName qName, Node node, int n, int n2) {
        int n3;
        int n4 = node.handle;
        if (n4 == 0) {
            node.handle = this.fSymbolCount++;
        }
        qName.handle = node.handle;
        int n5 = node.handle * 4;
        if (n4 == 0) {
            n4 = node.handle;
            if (n5 < this.fSymbols.length) {
                this.fSymbols[n5 + 2] = 0;
                this.fSymbols[n5 + 3] = 0;
            } else {
                this.grow();
            }
            this.fSymbols[n5 + 0] = this.fStringBuffer.getOffset();
            this.fStringBuffer.appendQName(qName);
            this.fSymbols[n5 + 1] = this.fStringBuffer.getOffset();
        }
        if ((n3 = this.fSymbols[n5 + 2]) != 0) {
            qName.localHandle = n3;
            qName.prefixHandle = this.fSymbols[n5 + 3];
        } else {
            this.fSymbols[n5 + 3] = qName.prefixHandle;
            if (n == 0) {
                this.fSymbols[n5 + 2] = n4;
            } else {
                int n6 = this.fSymbols[n5 + 0];
                if (n > 0) {
                    n4 = this.addLocalPartSymbol(n5, n6 + n);
                } else {
                    n = -n;
                    n4 = this.addLocalPartSymbol(n5, n6 + n);
                    n5 = qName.prefixHandle * 4;
                    this.fSymbols[n5 + 0] = n6;
                    this.fSymbols[n5 + 1] = n6 + n;
                }
            }
            qName.localHandle = n4;
        }
        qName.nsHandle = 0;
        return n2 >> 2;
    }

    private int addLocalPartSymbol(int n, int n2) {
        int n3;
        int n4 = this.fSymbols[n + 1];
        XMLString xMLString = this.fStringInBuffer;
        this.fStringBuffer.setStringValues(n2 + 1, n4, xMLString);
        Node node = this.lookupSymbolUsingXMLString(this.fGlobals, xMLString);
        if (node != NODE_NULL) {
            int n5 = node.handle;
            this.fSymbols[n + 2] = n5;
            return n5;
        }
        if (this.addXMLStringToTree(this.fGlobals, xMLString, n3 = this.fSymbolCount++, 0)) {
            this.fSymbols[n + 2] = n3;
            n = n3 * 4;
            if (n < this.fSymbols.length) {
                this.fSymbols[n + 2] = 0;
                this.fSymbols[n + 3] = 0;
            } else {
                this.grow();
            }
            this.fSymbols[n + 0] = n2 + 1;
            this.fSymbols[n + 1] = n4;
            return n3;
        }
        UntestedCode.needTest("needCode(9)");
        return -1;
    }

    private void initDebugNodeStack() {
        this.fSymbolDebugStackDepth = 0;
        this.fSymbolDebugNodeStack = new Node[32];
        this.fSymbolDebugIntStack = new int[32];
    }

    private void pushDebugNode(int n, Node node) {
        int n2;
        if ((n2 = this.fSymbolDebugStackDepth++) == this.fSymbolDebugNodeStack.length) {
            Node[] nodeArray = new Node[n2 << 1];
            System.arraycopy(this.fSymbolDebugNodeStack, 0, nodeArray, 0, n2);
            this.fSymbolDebugNodeStack = nodeArray;
            int[] nArray = new int[n2 << 1];
            System.arraycopy(this.fSymbolDebugIntStack, 0, nArray, 0, n2);
            this.fSymbolDebugIntStack = nArray;
        }
        this.fSymbolDebugNodeStack[n2] = node;
        this.fSymbolDebugIntStack[n2] = n;
    }

    private Node popDebugNode(int[] nArray) {
        int n = --this.fSymbolDebugStackDepth;
        nArray[0] = this.fSymbolDebugIntStack[n];
        return this.fSymbolDebugNodeStack[n];
    }

    private static Node saveNode(Node node, StreamCompressor streamCompressor) throws IOException {
        streamCompressor.writeInt(node.count);
        streamCompressor.writeInt(node.byteValue);
        streamCompressor.writeInt(node.handle);
        streamCompressor.writeInt(node.userValue);
        streamCompressor.writeInt(node.startOffset);
        streamCompressor.writeInt(node.endOffset);
        streamCompressor.writeBoolean(node.left != SymbolTable.NODE_NULL);
        streamCompressor.writeBoolean(node.right != SymbolTable.NODE_NULL);
        streamCompressor.writeBoolean(node.next != SymbolTable.NODE_NULL);
        return node;
    }

    private void flattenNodesToStream(Node node, StreamCompressor streamCompressor) throws IOException {
        if (this.fSymbolDebugNodeStack == null) {
            this.initDebugNodeStack();
        }
        Node node2 = SymbolTable.saveNode(node, streamCompressor);
        this.pushDebugNode(0, node2);
        block0: while (true) {
            if (node2.left != NODE_NULL) {
                if (node2.handle != 0 || node2.next != NODE_NULL || node2.right != NODE_NULL) {
                    this.pushDebugNode(0, node2);
                }
                node2 = SymbolTable.saveNode(node2.left, streamCompressor);
                continue;
            }
            do {
                if (node2.next != NODE_NULL) {
                    if (node2.right != NODE_NULL) {
                        this.pushDebugNode(1, node2);
                    }
                    node2 = SymbolTable.saveNode(node2.next, streamCompressor);
                    continue block0;
                }
                if (node2.right != NODE_NULL) {
                    node2 = SymbolTable.saveNode(node2.right, streamCompressor);
                    continue block0;
                }
                node2 = this.popDebugNode(this.fMultiByteCharInfo);
                if (node2 != node) continue;
                return;
            } while (this.fMultiByteCharInfo[0] == 0);
            node2 = SymbolTable.saveNode(node2.right, streamCompressor);
        }
    }

    private Node restoreNode(Node node, StreamCompressor streamCompressor) throws IOException {
        node.count = streamCompressor.readInt();
        node.byteValue = streamCompressor.readInt();
        node.handle = streamCompressor.readInt();
        node.userValue = streamCompressor.readInt();
        node.startOffset = streamCompressor.readInt();
        node.endOffset = streamCompressor.readInt();
        if (streamCompressor.readBoolean()) {
            if (node.left == NODE_NULL) {
                node.left = this.cacheNodeAllocate();
            }
        } else if (node.left != NODE_NULL) {
            this.cacheNodeDeallocate(node.left);
            node.left = NODE_NULL;
        }
        if (streamCompressor.readBoolean()) {
            if (node.right == NODE_NULL) {
                node.right = this.cacheNodeAllocate();
            }
        } else if (node.right != NODE_NULL) {
            this.cacheNodeDeallocate(node.right);
            node.right = NODE_NULL;
        }
        if (streamCompressor.readBoolean()) {
            if (node.next == NODE_NULL) {
                node.next = this.cacheNodeAllocate();
            }
        } else if (node.next != NODE_NULL) {
            this.cacheNodeDeallocate(node.next);
            node.next = NODE_NULL;
        }
        return node;
    }

    private void resurrectNodesFromStream(Node node, StreamCompressor streamCompressor) throws IOException {
        if (this.fSymbolDebugNodeStack == null) {
            this.initDebugNodeStack();
        }
        Node node2 = this.restoreNode(node, streamCompressor);
        this.pushDebugNode(0, node2);
        block0: while (true) {
            if (node2.left != NODE_NULL) {
                if (node2.handle != 0 || node2.next != NODE_NULL || node2.right != NODE_NULL) {
                    this.pushDebugNode(0, node2);
                }
                node2 = this.restoreNode(node2.left, streamCompressor);
                continue;
            }
            do {
                if (node2.next != NODE_NULL) {
                    if (node2.right != NODE_NULL) {
                        this.pushDebugNode(1, node2);
                    }
                    node2 = this.restoreNode(node2.next, streamCompressor);
                    continue block0;
                }
                if (node2.right != NODE_NULL) {
                    node2 = this.restoreNode(node2.right, streamCompressor);
                    continue block0;
                }
                node2 = this.popDebugNode(this.fMultiByteCharInfo);
                if (node2 != node) continue;
                return;
            } while (this.fMultiByteCharInfo[0] == 0);
            node2 = this.restoreNode(node2.right, streamCompressor);
        }
    }

    private void saveToStream(StreamCompressor streamCompressor) throws IOException {
        streamCompressor.writeInt(this.fNodeCount);
        streamCompressor.writeInt(this.fTreeCount);
        streamCompressor.writeInt(this.fSymbolCount);
        this.flattenNodesToStream(this.fGlobals, streamCompressor);
        this.flattenNodesToStream(this.fPrefixes, streamCompressor);
        int n = 0;
        while (n < this.fTreeCount) {
            this.flattenNodesToStream(this.fTrees[n], streamCompressor);
            ++n;
        }
        streamCompressor.writeInts(this.fSymbols, this.fSymbolCount * 4);
    }

    private boolean restoreFromStream(StreamCompressor streamCompressor) throws IOException {
        int n = streamCompressor.readInt();
        int n2 = streamCompressor.readInt();
        int n3 = streamCompressor.readInt();
        this.resurrectNodesFromStream(this.fGlobals, streamCompressor);
        this.resurrectNodesFromStream(this.fPrefixes, streamCompressor);
        int n4 = n2;
        while (n4 < this.fTreeCount) {
            this.cacheNodeDeallocate(this.fTrees[n4]);
            this.fTrees[n4] = null;
            ++n4;
        }
        if (n2 > this.fTrees.length) {
            int n5 = this.fTrees.length << 1;
            while (n2 > n5) {
                n5 <<= 1;
            }
            Node[] nodeArray = new Node[n5];
            System.arraycopy(this.fTrees, 0, nodeArray, 0, this.fTreeCount);
            this.fTrees = nodeArray;
        }
        n4 = this.fTreeCount;
        while (n4 < n2) {
            this.fTrees[n4] = this.cacheNodeAllocate();
            ++n4;
        }
        this.fTreeCount = n2;
        n4 = 0;
        while (n4 < n2) {
            this.resurrectNodesFromStream(this.fTrees[n4], streamCompressor);
            ++n4;
        }
        int n6 = n3 * 4;
        while (this.fSymbols.length < n6) {
            this.grow();
        }
        streamCompressor.readInts(this.fSymbols, n6);
        if (streamCompressor.finish()) {
            this.fSymbolCount = n3;
            if (this.fNodeCount != n) {
                this.fNodeCount = n;
            }
            if (this.fTreeCount != n2) {
                this.fTreeCount = n2;
            }
            return true;
        }
        return false;
    }

    private static void writeHeaderInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write((byte)(n >> 24));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    private static int readHeaderInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        n = n << 8 | inputStream.read();
        n = n << 8 | inputStream.read();
        return n << 8 | inputStream.read();
    }

    public boolean save(OutputStream outputStream, boolean bl) throws IOException {
        boolean bl2;
        int n;
        if (bl && this.fDataBytes.length < (n = this.fStringBuffer.getOffset())) {
            int n2 = this.fDataBytes.length << 1;
            while (n2 < n) {
                n2 <<= 1;
            }
            this.fDataBuffer.bytes = new byte[n2];
            this.fDataBytes = this.fDataBuffer.bytes;
        }
        SymbolTable.writeHeaderInt(outputStream, -1162215424);
        this.compressSymbols();
        if (bl) {
            this.compressTrees();
            SymbolTable.writeHeaderInt(outputStream, this.fDataBuffer.endOffset - this.fDataBuffer.startOffset);
        } else {
            SymbolTable.writeHeaderInt(outputStream, 0);
        }
        if (this.fStreamCompressor == null) {
            this.fStreamCompressor = new StreamCompressor();
        }
        this.fStreamCompressor.setOutputStream(outputStream);
        this.saveToStream(this.fStreamCompressor);
        this.fStreamCompressor.flush();
        if (!bl) {
            bl2 = this.fStringBuffer.save(outputStream);
        } else {
            outputStream.write(this.fDataBytes, this.fDataBuffer.startOffset, this.fDataBuffer.endOffset - this.fDataBuffer.startOffset);
            bl2 = true;
        }
        return bl2;
    }

    public boolean restore(InputStream inputStream) throws IOException {
        boolean bl;
        int n = SymbolTable.readHeaderInt(inputStream);
        if (n != -1162215424) {
            return false;
        }
        int n2 = SymbolTable.readHeaderInt(inputStream);
        if (n2 == 0) {
            if (this.fDataBytes == null) {
                this.fDataBuffer.bytes = new byte[8192];
                this.fDataBytes = this.fDataBuffer.bytes;
            }
        } else {
            if (this.fDataBytes == null) {
                int n3 = 8192;
                while (n3 < n2) {
                    n3 <<= 1;
                }
                this.fDataBytes = new byte[n3];
            } else if (this.fDataBytes.length < n2) {
                int n4 = this.fDataBytes.length;
                while (n4 < n2) {
                    n4 <<= 1;
                }
                this.fDataBytes = new byte[n4];
            }
            this.fDataBuffer.bytes = this.fDataBytes;
            this.fDataBuffer.startOffset = 0;
            this.fDataBuffer.endOffset = n2;
        }
        if (this.fStreamCompressor == null) {
            this.fStreamCompressor = new StreamCompressor();
        }
        this.fStreamCompressor.setInputStream(inputStream);
        if (!this.restoreFromStream(this.fStreamCompressor)) {
            return false;
        }
        if (n2 == 0) {
            bl = this.fStringBuffer.restore(inputStream);
        } else {
            if (inputStream.read(this.fDataBytes, this.fDataBuffer.startOffset, n2) != n2) {
                return false;
            }
            this.fStringBuffer.reset(true);
            this.fStringBuffer.appendBytes(this.fDataBytes, 1, n2);
            bl = true;
        }
        return bl;
    }

    private void writePrintableString(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            byte by;
            if ((by = byArray[n++]) > 0) {
                System.err.print((char)by);
                continue;
            }
            System.err.print("&#" + Integer.toString(by & 0xFF) + ";");
        }
    }

    private void writePrintableXMLString(XMLString xMLString) {
        int n = xMLString.length;
        if (xMLString.bytes != null) {
            this.writePrintableString(xMLString.bytes, xMLString.startOffset, n);
        } else {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            int n2 = xMLString.startOffset;
            while (dataBuffer != xMLString.lastBuffer) {
                this.writePrintableString(dataBuffer.bytes, n2, dataBuffer.endOffset - n2);
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
            }
            this.writePrintableString(dataBuffer.bytes, n2, xMLString.endOffset - n2);
        }
    }

    private void compressSymbols() {
        int n;
        int n2;
        int n3;
        XMLString xMLString = this.fStringInBuffer;
        this.fStringBuffer.setStringValues(0, this.fStringBuffer.getOffset(), xMLString);
        byte[] byArray = new byte[xMLString.length];
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer;
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer;
        }
        int n4 = 0;
        int n5 = xMLString.startOffset;
        while (true) {
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            n2 = n3 - n5;
            System.arraycopy(dataBuffer.bytes, n5, byArray, n4, n2);
            n4 += n2;
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n5 = dataBuffer.startOffset;
        }
        int[] nArray = new int[this.fSymbolCount * 3];
        int n6 = 1;
        while (n6 < this.fSymbolCount) {
            n3 = n6 * 4;
            n5 = this.fSymbols[n3 + 0];
            int n7 = this.fSymbols[n3 + 1];
            int n8 = n7 - n5;
            n2 = 1;
            n = 3;
            while (n2 < n6) {
                if (n8 > nArray[n + 2]) break;
                if (n8 == nArray[n + 2]) {
                    int n9 = nArray[n + 1];
                    boolean bl = true;
                    n4 = 0;
                    while (n4 < n8) {
                        if (byArray[n5 + n4] < byArray[n9 + n4]) break;
                        if (byArray[n5 + n4] > byArray[n9 + n4]) {
                            bl = false;
                            break;
                        }
                        ++n4;
                    }
                    if (bl) break;
                }
                n = ++n2 * 3;
            }
            if (n2 < n6) {
                System.arraycopy(nArray, n, nArray, n + 3, (n6 - n2) * 3);
            }
            nArray[n + 0] = n6++;
            nArray[n + 1] = n5;
            nArray[n + 2] = n8;
        }
        int n10 = 1;
        int n11 = 0;
        n = 3;
        int n12 = nArray[n + 2];
        this.fDataBytes[0] = 0;
        System.arraycopy(byArray, nArray[n + 1], this.fDataBytes, n10, n12);
        int n13 = n10;
        nArray[n + 1] = n13;
        n5 = n13;
        n10 += n12;
        n6 = 2;
        while (n6 < this.fSymbolCount) {
            n = n6 * 3;
            n5 = nArray[n + 1];
            n3 = nArray[n + 2];
            if (n3 < n12) {
                n11 = n10;
                n12 = n3;
            }
            if ((n4 = SymbolTable.substring(this.fDataBytes, n11, byArray, n5, n3)) != 0) {
                int n14 = n4;
                nArray[n + 1] = n14;
                n5 = n14;
            } else {
                System.arraycopy(byArray, n5, this.fDataBytes, n10, n3);
                int n15 = n10;
                nArray[n + 1] = n15;
                n5 = n15;
                n10 += n3;
            }
            ++n6;
        }
        byArray = null;
        this.fDataBuffer.startOffset = 0;
        this.fDataBuffer.endOffset = n10;
        this.fStringBuffer.reset(true);
        this.fStringBuffer.appendBytes(this.fDataBytes, 1, n10);
        n6 = 1;
        while (n6 < this.fSymbolCount) {
            n = n6 * 3;
            n3 = nArray[n + 0] * 4;
            this.fSymbols[n3 + 0] = nArray[n + 1];
            this.fSymbols[n3 + 1] = nArray[n + 1] + nArray[n + 2];
            ++n6;
        }
        nArray = null;
    }

    private void compressTrees() {
        this.compressTree(this.fGlobals);
        this.compressTree(this.fPrefixes);
        int n = 0;
        while (n < this.fTreeCount) {
            this.compressTree(this.fTrees[n]);
            ++n;
        }
    }

    private Node compressNode(Node node) {
        if (node.next != NODE_NULL) {
            int n;
            Node node2;
            block9: {
                boolean bl;
                node2 = node.next;
                n = 0;
                boolean bl2 = bl = node.handle == 0 && node.byteValue != 58 && node.byteValue >= 0;
                if (bl) {
                    while (true) {
                        boolean bl3 = bl = node2.left == NODE_NULL && node2.right == NODE_NULL && node2.byteValue != 58 && node2.byteValue >= 0;
                        if (!bl) break;
                        ++n;
                        if (node2.handle == 0 && node2.next != NODE_NULL) {
                            node2 = node2.next;
                            continue;
                        }
                        break block9;
                        break;
                    }
                    Node node3 = node;
                    n = 0;
                    while (node3.next != node2) {
                        node3 = node3.next;
                        ++n;
                    }
                    node2 = node3;
                } else {
                    n = 0;
                }
            }
            if (n > 0) {
                int n2 = 0;
                Node node4 = node2;
                while (node2.handle == 0) {
                    ++n2;
                    node2 = node2.next;
                }
                int n3 = node2.handle * 4;
                int n4 = this.fSymbols[n3 + 0];
                int n5 = this.fSymbols[n3 + 1];
                node.startOffset = n4 = (n5 -= n2) - n;
                node.endOffset = n5;
                node2 = node.next;
                while (node2 != node4) {
                    node.next = node2.next;
                    node2.next = NODE_NULL;
                    this.cacheNodeDeallocate(node2);
                    node2 = node.next;
                }
                node.handle = node2.handle;
                node.userValue = node2.userValue;
                node.next = node2.next;
                node2.next = NODE_NULL;
                this.cacheNodeDeallocate(node2);
            }
        }
        return node;
    }

    private void compressTree(Node node) {
        if (this.fSymbolDebugNodeStack == null) {
            this.initDebugNodeStack();
        }
        this.pushDebugNode(0, node);
        Node node2 = this.compressNode(node.next);
        block0: while (true) {
            if (node2.left != NODE_NULL) {
                if (node2.handle != 0 || node2.next != NODE_NULL || node2.right != NODE_NULL) {
                    this.pushDebugNode(0, node2);
                }
                node2 = this.compressNode(node2.left);
                continue;
            }
            do {
                if (node2.next != NODE_NULL) {
                    if (node2.right != NODE_NULL) {
                        this.pushDebugNode(1, node2);
                    }
                    node2 = this.compressNode(node2.next);
                    continue block0;
                }
                if (node2.right != NODE_NULL) {
                    node2 = this.compressNode(node2.right);
                    continue block0;
                }
                node2 = this.popDebugNode(this.fMultiByteCharInfo);
                if (node2 != node) continue;
                return;
            } while (this.fMultiByteCharInfo[0] == 0);
            node2 = this.compressNode(node2.right);
        }
    }

    private static int substring(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 1;
        int n5 = n - n3;
        while (n4 < n5) {
            if (byArray[n4] == byArray2[n2]) {
                int n6 = 1;
                while (n6 < n3) {
                    if (byArray[n4 + n6] != byArray2[n2 + n6]) break;
                    ++n6;
                }
                if (n6 == n3) {
                    return n4;
                }
            }
            ++n4;
        }
        return 0;
    }

    public int treeAllocate() {
        if (this.fTreeCount < this.fTrees.length) {
            Node node;
            this.fTrees[this.fTreeCount] = node = this.cacheNodeAllocate();
            return this.fTreeCount++;
        }
        Node[] nodeArray = new Node[this.fTreeCount << 1];
        System.arraycopy(this.fTrees, 0, nodeArray, 0, this.fTreeCount);
        this.fTrees = nodeArray;
        return this.treeAllocate();
    }

    public boolean copySymbolToTree(int n, int n2, int n3) {
        if (n2 > 0) {
            Node node = this.fTrees[n];
            return this.addSymbolToTree(node, n2, n3);
        }
        return false;
    }

    public boolean setTreeUserValue(int n, int n2, int n3) {
        if (n2 > 0) {
            int n4 = n2 * 4;
            int n5 = this.fSymbols[n4 + 0];
            int n6 = this.fSymbols[n4 + 1];
            XMLString xMLString = this.fStringInBuffer;
            Node node = this.fTrees[n];
            this.fStringBuffer.setStringValues(n5, n6, xMLString);
            Node node2 = this.lookupSymbolUsingXMLString(node, xMLString);
            if (node2 != NODE_NULL) {
                node2.userValue = n3;
            }
            return true;
        }
        return false;
    }

    public int scanAnyQNameBuffered(ScannerHelper scannerHelper, ParsedEntity parsedEntity, QName qName) {
        int n = this.scanQNameBuffered(parsedEntity, qName);
        if (n != 0 && !scannerHelper.setNamespaceURI(qName)) {
            qName.nsHandle = -1;
        }
        return n;
    }

    public int scanAnyQNameUnbuffered(ScannerHelper scannerHelper, ParsedEntity parsedEntity, QName qName) {
        int n = this.scanQNameUnbuffered(parsedEntity, qName);
        if (n != 0 && !scannerHelper.setNamespaceURI(qName)) {
            qName.nsHandle = -1;
        }
        return n;
    }

    public int scanMatchingQNameBuffered(ScannerHelper scannerHelper, ParsedEntity parsedEntity, int n, XMLString xMLString, int[] nArray, QName qName) {
        int n2 = this.matchQExpectedBuffered(parsedEntity, qName, xMLString, n);
        if (n2 != 0) {
            if (!scannerHelper.setNamespaceURI(qName)) {
                qName.nsHandle = -1;
            }
            nArray[0] = 1;
            return n2;
        }
        nArray[0] = -1;
        return this.scanAnyQNameBuffered(scannerHelper, parsedEntity, qName);
    }

    public int scanMatchingQNameUnbuffered(ScannerHelper scannerHelper, ParsedEntity parsedEntity, int n, XMLString xMLString, int[] nArray, QName qName) {
        int n2 = this.matchQExpectedUnbuffered(parsedEntity, qName, xMLString, n);
        if (n2 != 0) {
            if (!scannerHelper.setNamespaceURI(qName)) {
                qName.nsHandle = -1;
            }
            nArray[0] = 1;
            return n2;
        }
        nArray[0] = -1;
        return this.scanAnyQNameUnbuffered(scannerHelper, parsedEntity, qName);
    }

    public int scanQNameChoicesBuffered(ScannerHelper scannerHelper, ParsedEntity parsedEntity, int n, int[] nArray, QName qName) {
        int n2 = this.matchQChoiceBuffered(parsedEntity, qName, n, nArray);
        if (n2 != 0) {
            if (!scannerHelper.setNamespaceURI(qName)) {
                qName.nsHandle = -1;
            }
        } else {
            n2 = this.scanAnyQNameBuffered(scannerHelper, parsedEntity, qName);
        }
        return n2;
    }

    public int scanQNameChoicesUnbuffered(ScannerHelper scannerHelper, ParsedEntity parsedEntity, int n, int[] nArray, QName qName) {
        int n2 = this.matchQChoiceUnbuffered(parsedEntity, qName, n, nArray);
        if (n2 != 0) {
            if (!scannerHelper.setNamespaceURI(qName)) {
                qName.nsHandle = -1;
            }
        } else {
            n2 = this.scanAnyQNameUnbuffered(scannerHelper, parsedEntity, qName);
        }
        return n2;
    }

    private int matchQExpectedBuffered(ParsedEntity parsedEntity, QName qName, XMLString xMLString, int n) {
        int n2;
        boolean bl = xMLString.bytes != null;
        byte[] byArray = nameCharMap;
        byte[] byArray2 = parsedEntity.bytes;
        int n3 = n2 = parsedEntity.offset;
        boolean bl2 = false;
        qName.setStartPos(parsedEntity.buffer, n2);
        qName.nsHandle = 0;
        qName.prefixHandle = 0;
        while (true) {
            int n4;
            int n5;
            Object object;
            boolean bl3 = true;
            if (bl) {
                object = xMLString.bytes;
                n5 = xMLString.endOffset;
                n4 = xMLString.startOffset;
                while (n4 < n5) {
                    if (object[n4] == byArray2[n2]) {
                        ++n4;
                        ++n2;
                        continue;
                    }
                    if (byArray2[n2] != 0 || n2 < parsedEntity.endOffset) {
                        bl3 = false;
                        break;
                    }
                    if (!bl2) {
                        parsedEntity.setMark();
                        bl2 = true;
                    }
                    if (this.checkNextBuffer(parsedEntity)) {
                        byArray2 = parsedEntity.bytes;
                        n2 = parsedEntity.offset;
                        continue;
                    }
                    parsedEntity.resetToMark();
                    return 0;
                }
            } else {
                object = xMLString.firstBuffer;
                byte[] byArray3 = object.bytes;
                n4 = object.endOffset;
                int n6 = xMLString.startOffset;
                while (true) {
                    if (n6 < n4) {
                        if (byArray3[n6] == byArray2[n2]) {
                            ++n6;
                            ++n2;
                            continue;
                        }
                        if (byArray2[n2] != 0 || n2 < parsedEntity.endOffset) {
                            bl3 = false;
                            break;
                        }
                        if (!bl2) {
                            parsedEntity.setMark();
                            bl2 = true;
                        }
                        if (this.checkNextBuffer(parsedEntity)) {
                            byArray2 = parsedEntity.bytes;
                            n2 = parsedEntity.offset;
                            continue;
                        }
                        parsedEntity.resetToMark();
                        return 0;
                    }
                    if (object == xMLString.lastBuffer) break;
                    object = object.next;
                    byArray3 = object.bytes;
                    n6 = object.startOffset;
                    n4 = object == xMLString.lastBuffer ? xMLString.endOffset : object.endOffset;
                }
            }
            if (bl3) {
                block9: while (true) {
                    int n7 = byArray2[n2];
                    n5 = byArray[n7 & 0xFF];
                    switch (n5) {
                        case 2: 
                        case 3: {
                            break block9;
                        }
                        case 4: {
                            if (qName.prefixHandle == 0) break block9;
                            if (bl2) {
                                parsedEntity.resetToMark();
                            }
                            qName.clear();
                            return n5 >> 2;
                        }
                        case 12: {
                            if (n2 < parsedEntity.endOffset) break block9;
                            if (!bl2) {
                                parsedEntity.setMark();
                                bl2 = true;
                            }
                            if (this.checkNextBuffer(parsedEntity)) {
                                byArray2 = parsedEntity.bytes;
                                n2 = parsedEntity.offset;
                                continue block9;
                            }
                            parsedEntity.resetToMark();
                            return 0;
                        }
                        case 8: {
                            if (!bl2) {
                                parsedEntity.setMark();
                                bl2 = true;
                            }
                            parsedEntity.offset = n2;
                            if (parsedEntity.skippedNameCharacter()) break block9;
                            if (!(parsedEntity.isXML10 || (n7 & 0xDF) != 194 || (n7 = parsedEntity.decodeCharacter()) != 133 && n7 != 8232)) {
                                n5 = 24;
                            }
                        }
                        default: {
                            parsedEntity.offset = n2;
                            if (bl2) {
                                parsedEntity.clearMark();
                            }
                            qName.setEndPos(parsedEntity.buffer, n2);
                            qName.localHandle = n;
                            if (qName.prefixHandle == 0) {
                                qName.handle = n;
                            } else {
                                this.addQNameSymbol(qName);
                            }
                            return n5 >> 2;
                        }
                    }
                    break;
                }
            }
            if (bl2) {
                parsedEntity.resetToMark();
                bl2 = false;
            }
            parsedEntity.offset = n3;
            if (qName.prefixHandle != 0) {
                return 0;
            }
            parsedEntity.setMark();
            bl2 = true;
            if (!this.matchPChoiceBuffered(parsedEntity, qName)) {
                parsedEntity.clearMark();
                return 0;
            }
            byArray2 = parsedEntity.bytes;
            n2 = ++parsedEntity.offset;
        }
    }

    private int matchQExpectedUnbuffered(ParsedEntity parsedEntity, QName qName, XMLString xMLString, int n) {
        byte[] byArray = xMLString.bytes;
        if (byArray != null) {
            int n2;
            int n3 = xMLString.startOffset;
            int n4 = xMLString.endOffset;
            byte[] byArray2 = parsedEntity.bytes;
            int n5 = n2 = parsedEntity.offset;
            qName.nsHandle = 0;
            qName.prefixHandle = 0;
            while (n3 < n4) {
                if (byArray[n3] == byArray2[n2]) {
                    ++n3;
                    ++n2;
                    continue;
                }
                if (this.matchPChoiceUnbuffered(parsedEntity, qName)) {
                    n2 = ++parsedEntity.offset;
                    n3 = xMLString.startOffset;
                    while (n3 < n4) {
                        if (byArray[n3] == byArray2[n2]) {
                            ++n3;
                            ++n2;
                            continue;
                        }
                        parsedEntity.offset = n5;
                        return 0;
                    }
                    break;
                }
                parsedEntity.offset = n5;
                return 0;
            }
            byte by = nameCharMap[byArray2[n2] & 0xFF];
            if (by > 12) {
                qName.setValues(parsedEntity.buffer, n5, n2);
                parsedEntity.offset = n2;
                qName.localHandle = n;
                if (qName.prefixHandle == 0) {
                    qName.handle = n;
                } else {
                    this.addQNameSymbol(qName);
                }
                return by >> 2;
            }
            parsedEntity.offset = n5;
        }
        return this.matchQExpectedBuffered(parsedEntity, qName, xMLString, n);
    }

    private int matchQChoiceBuffered(ParsedEntity parsedEntity, QName qName, int n, int[] nArray) {
        block25: {
            boolean bl = false;
            qName.setStartPos(parsedEntity.buffer, parsedEntity.offset);
            qName.nsHandle = 0;
            qName.prefixHandle = 0;
            do {
                block24: {
                    byte[] byArray = parsedEntity.bytes;
                    int n2 = ++parsedEntity.offset;
                    Node node = this.fTrees[n];
                    block1: while (true) {
                        int n3;
                        byte by;
                        if ((by = byArray[n2]) < 0 || (n3 = nameCharMap[by]) < 4) {
                            int n4;
                            if (parsedEntity.isXML10 || (by & 0xDF) != 194 || (n4 = parsedEntity.decodeCharacter()) != 133 && n4 != 8232) {
                                node = node.next;
                                if (node == NODE_NULL) break block24;
                                if (node.byteValue != by) {
                                    node = SymbolTable.search(node, by);
                                    if (node.byteValue != by) break block24;
                                }
                                ++n2;
                                int n5 = node.endOffset;
                                if (n5 == 0) continue;
                                int n6 = node.startOffset;
                                while (true) {
                                    if (n6 >= n5) continue block1;
                                    by = byArray[n2];
                                    if (this.fDataBytes[n6] == by) {
                                        ++n2;
                                    } else {
                                        if (by != 0 || n2 < parsedEntity.endOffset) break block24;
                                        if (!bl) {
                                            parsedEntity.setMark();
                                            bl = true;
                                        }
                                        if (!this.checkNextBuffer(parsedEntity) || (byArray = parsedEntity.bytes)[n2 = parsedEntity.offset] == 0 && n2 >= parsedEntity.endOffset) break block24;
                                        --n6;
                                    }
                                    ++n6;
                                }
                            }
                            n3 = 24;
                        }
                        if (by == 58) break;
                        if (by != 0) {
                            if (node.userValue != 0) {
                                if (bl) {
                                    parsedEntity.clearMark();
                                }
                                parsedEntity.offset = n2;
                                qName.setEndPos(parsedEntity.buffer, n2);
                                qName.localHandle = node.handle;
                                nArray[0] = node.userValue;
                                if (qName.prefixHandle == 0) {
                                    qName.handle = qName.localHandle;
                                } else {
                                    this.addQNameSymbol(qName);
                                }
                                return n3 >> 2;
                            }
                        } else if (n2 >= parsedEntity.endOffset) {
                            if (!bl) {
                                parsedEntity.setMark();
                                bl = true;
                            }
                            if (this.checkNextBuffer(parsedEntity)) {
                                byArray = parsedEntity.bytes;
                                n2 = parsedEntity.offset;
                                continue;
                            }
                        }
                        break block24;
                        break;
                    }
                    if (qName.prefixHandle != 0) {
                        if (bl) {
                            parsedEntity.resetToMark();
                        }
                        qName.clear();
                        nArray[0] = -1;
                        return 1;
                    }
                }
                if (bl) {
                    parsedEntity.resetToMark();
                    bl = false;
                }
                if (qName.prefixHandle != 0) break block25;
                parsedEntity.setMark();
                bl = true;
                if (this.matchPChoiceBuffered(parsedEntity, qName)) continue;
                parsedEntity.clearMark();
                nArray[0] = -1;
                return 0;
            } while (qName.prefixHandle != 1);
            parsedEntity.resetToMark();
            nArray[0] = -1;
            return 0;
        }
        nArray[0] = -1;
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int matchQChoiceUnbuffered(ParsedEntity var1_1, QName var2_2, int var3_3, int[] var4_4) {
        block25: {
            block24: {
                var10_6 = var9_5 = var1_1.offset;
                var2_2.nsHandle = 0;
                var2_2.prefixHandle = 0;
                var8_7 = this.fTrees[var3_3];
                block0: while (true) {
                    var7_9 = var8_7;
                    var8_7 = var8_7.next;
                    var5_8 = var1_1.bytes[var10_6];
                    if (var8_7 == SymbolTable.NODE_NULL) break block24;
                    if (var8_7.byteValue != var5_8) {
                        var8_7 = SymbolTable.search(var8_7, var5_8);
                        if (var8_7.byteValue != var5_8) break block24;
                    }
                    ++var10_6;
                    var12_11 = var8_7.endOffset;
                    if (var12_11 == 0) continue;
                    var11_10 = var8_7.startOffset;
                    while (true) {
                        if (var11_10 < var12_11) ** break;
                        continue block0;
                        if (this.fDataBytes[var11_10] != var1_1.bytes[var10_6]) {
                            var5_8 = -1;
                            break block24;
                        }
                        ++var10_6;
                        ++var11_10;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    if (var5_8 >= 0) {
                        var6_12 = SymbolTable.nameCharMap[var5_8];
                        if (var6_12 <= 4) {
                            break block25;
                        }
                    } else {
                        if (var1_1.isXML10 || ((var5_8 & 255) != 194 || var1_1.bytes[var10_6 + 1] != 133) && ((var5_8 & 255) != 226 || var1_1.bytes[var10_6 + 1] != 128 || var1_1.bytes[var10_6 + 2] != 168)) break block25;
                        var6_12 = 24;
                    }
                    var1_1.offset = var10_6;
                    var2_2.setValues(var1_1.buffer, var9_5, var10_6);
                    var2_2.handle = var2_2.localHandle = var7_9.handle;
                    var4_4[0] = var7_9.userValue;
                    return var6_12 >> 2;
                }
            }
            ** while (var7_9.userValue != 0)
        }
        if (this.matchPChoiceUnbuffered(var1_1, var2_2) && var2_2.prefixHandle != 1) {
            block27: {
                block26: {
                    var10_6 = var1_1.offset + 1;
                    var8_7 = this.fTrees[var3_3];
                    block3: while (true) {
                        var7_9 = var8_7;
                        var8_7 = var8_7.next;
                        var5_8 = var1_1.bytes[var10_6];
                        if (var8_7 == SymbolTable.NODE_NULL) break block26;
                        if (var8_7.byteValue != var5_8) {
                            var8_7 = SymbolTable.search(var8_7, var5_8);
                            if (var8_7.byteValue != var5_8) break block26;
                        }
                        ++var10_6;
                        var12_11 = var8_7.endOffset;
                        if (var12_11 == 0) continue;
                        var11_10 = var8_7.startOffset;
                        while (true) {
                            if (var11_10 < var12_11) ** break;
                            continue block3;
                            if (this.fDataBytes[var11_10] != var1_1.bytes[var10_6]) {
                                var5_8 = -1;
                                break block26;
                            }
                            ++var10_6;
                            ++var11_10;
                        }
                        break;
                    }
                    while (true) {
                        if (var5_8 >= 0) {
                            var6_12 = SymbolTable.nameCharMap[var5_8];
                            if (var6_12 <= 4) {
                                break block27;
                            }
                        } else {
                            if (var1_1.isXML10 || ((var5_8 & 255) != 194 || var1_1.bytes[var10_6 + 1] != 133) && ((var5_8 & 255) != 226 || var1_1.bytes[var10_6 + 1] != 128 || var1_1.bytes[var10_6 + 2] != 168)) break block27;
                            var6_12 = 24;
                        }
                        var1_1.offset = var10_6;
                        var2_2.setValues(var1_1.buffer, var9_5, var10_6);
                        var2_2.localHandle = var7_9.handle;
                        this.fQNameString.setValues(var2_2);
                        var8_7 = this.lookupSymbolUsingXMLStringUnbuffered(this.fGlobals, this.fQNameString);
                        if (var8_7 != SymbolTable.NODE_NULL) {
                            var2_2.handle = var8_7.handle;
                        } else {
                            var2_2.handle = this.fSymbolCount++;
                            this.saveXMLStringForHandle(this.fQNameString, var2_2.handle);
                            if (this.addXMLStringToTree(this.fGlobals, this.fQNameString, var2_2.handle, 0)) {
                                this.saveQNameForHandle(var2_2, var2_2.handle);
                            } else {
                                UntestedCode.needTest("need code for CharConversionError");
                            }
                        }
                        var4_4[0] = var7_9.userValue;
                        return var6_12 >> 2;
                    }
                }
                if (var7_9.userValue != 0) ** continue;
            }
            if (var5_8 == 58) {
                var2_2.clear();
                var1_1.offset = var9_5;
                var4_4[0] = -1;
                return 1;
            }
        }
        var2_2.clear();
        var1_1.offset = var9_5;
        var4_4[0] = -1;
        return 0;
    }

    private boolean matchPChoiceBuffered(ParsedEntity parsedEntity, QName qName) {
        byte by;
        boolean bl;
        int n;
        byte[] byArray;
        block33: {
            DataBuffer dataBuffer = null;
            int n2 = 0;
            byArray = parsedEntity.bytes;
            n = parsedEntity.offset;
            bl = false;
            Node node = this.fPrefixes;
            while ((by = byArray[n]) != 58) {
                Node node2 = node;
                node = node.next;
                if (by != 0) {
                    if (node == NODE_NULL) break block33;
                    if (node.byteValue != by) {
                        node = SymbolTable.search(node, by);
                        if (node.byteValue != by) break block33;
                    }
                    ++n;
                    int n3 = node.endOffset;
                    if (n3 == 0) continue;
                    int n4 = node.startOffset;
                    while (n4 < n3) {
                        by = byArray[n];
                        if (this.fDataBytes[n4] == by) {
                            ++n;
                        } else {
                            if (by != 0 || n < parsedEntity.endOffset) break block33;
                            if (!bl) {
                                dataBuffer = parsedEntity.buffer;
                                n2 = parsedEntity.offset;
                                parsedEntity.setMark();
                                bl = true;
                            }
                            if (!this.checkNextBuffer(parsedEntity) || (byArray = parsedEntity.bytes)[n = parsedEntity.offset] == 0 && n >= parsedEntity.endOffset) break block33;
                            --n4;
                        }
                        ++n4;
                    }
                    continue;
                }
                if (n >= parsedEntity.endOffset) {
                    if (!bl) {
                        dataBuffer = parsedEntity.buffer;
                        n2 = parsedEntity.offset;
                        parsedEntity.setMark();
                        bl = true;
                    }
                    if (this.checkNextBuffer(parsedEntity)) {
                        byArray = parsedEntity.bytes;
                        n = parsedEntity.offset;
                        node = node2;
                        continue;
                    }
                }
                break block33;
            }
            if (bl) {
                parsedEntity.clearMark();
            }
            if (node.userValue != 0) {
                parsedEntity.offset = n;
                qName.prefixHandle = node.handle;
                return true;
            }
            if (dataBuffer == null) {
                this.fStringInBuffer.setValues(parsedEntity.buffer, parsedEntity.offset, n, 0);
                qName.prefixHandle = this.addSymbolUnbuffered(this.fStringInBuffer);
            } else {
                this.fStringInBuffer.setValues(dataBuffer, parsedEntity.buffer, n2, n, 0);
                qName.prefixHandle = this.addSymbolBuffered(this.fStringInBuffer);
            }
            parsedEntity.offset = n;
            this.addXMLStringToTree(this.fPrefixes, this.fStringInBuffer, qName.prefixHandle, qName.prefixHandle);
            return true;
        }
        if (bl) {
            parsedEntity.resetToMark();
            bl = false;
        }
        byArray = parsedEntity.bytes;
        n = parsedEntity.offset;
        this.fStringInBuffer.setStartPos(parsedEntity.buffer, n);
        by = byArray[n];
        if (nameCharMap[by & 0xFF] == 3) {
            ++n;
        } else if (by < 0) {
            parsedEntity.setMark();
            bl = true;
            if (!parsedEntity.skippedNameStartCharacter()) {
                parsedEntity.resetToMark();
                return false;
            }
            byArray = parsedEntity.bytes;
            n = parsedEntity.offset;
        } else {
            return false;
        }
        while (true) {
            if (n < parsedEntity.endOffset) {
                by = byArray[n];
                if (nameCharMap[by & 0xFF] < 4) {
                    ++n;
                    continue;
                }
                if (by == 58) {
                    parsedEntity.offset = n;
                    if (bl) {
                        parsedEntity.clearMark();
                    }
                    this.fStringInBuffer.setEndPos(parsedEntity.buffer, n, 0);
                    qName.prefixHandle = this.addSymbol(this.fStringInBuffer);
                    this.addXMLStringToTree(this.fPrefixes, this.fStringInBuffer, qName.prefixHandle, qName.prefixHandle);
                    return true;
                }
                if (by < 0) {
                    if (!bl) {
                        parsedEntity.setMark();
                        bl = true;
                    }
                    parsedEntity.offset = n;
                    if (!parsedEntity.skippedNameStartCharacter()) {
                        parsedEntity.resetToMark();
                        return false;
                    }
                    byArray = parsedEntity.bytes;
                    n = parsedEntity.offset;
                    continue;
                }
                if (bl) {
                    parsedEntity.resetToMark();
                }
                return false;
            }
            if (!bl) {
                parsedEntity.setMark();
                bl = true;
            }
            if (!this.checkNextBuffer(parsedEntity)) break;
            byArray = parsedEntity.bytes;
            n = parsedEntity.offset;
        }
        parsedEntity.resetToMark();
        return false;
    }

    private boolean matchPChoiceUnbuffered(ParsedEntity parsedEntity, QName qName) {
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        Node node = this.fPrefixes;
        Node node2 = node.next;
        byte by = byArray[n];
        block0: while (node2 != NODE_NULL) {
            if (node2.byteValue != by) {
                node2 = SymbolTable.search(node2, by);
                if (node2.byteValue != by) break;
            }
            ++n;
            int n2 = node2.endOffset;
            if (n2 != 0) {
                int n3 = node2.startOffset;
                while (n3 < n2) {
                    if (this.fDataBytes[n3] != byArray[n]) break block0;
                    ++n;
                    ++n3;
                }
            }
            if ((by = byArray[n]) != 58) {
                node2 = node2.next;
                continue;
            }
            if (node2.userValue != 0) {
                qName.prefixHandle = node2.handle;
                parsedEntity.offset = n;
                return true;
            }
            this.fStringInBuffer.setValues(parsedEntity.buffer, parsedEntity.offset, n, 0);
            parsedEntity.offset = n;
            qName.prefixHandle = this.addSymbolUnbuffered(this.fStringInBuffer);
            this.addXMLStringToTree(this.fPrefixes, this.fStringInBuffer, qName.prefixHandle, qName.prefixHandle);
            return true;
        }
        n = parsedEntity.offset;
        this.fStringInBuffer.setStartPos(parsedEntity.buffer, n);
        by = byArray[n];
        if (nameCharMap[by & 0xFF] == 3) {
            ++n;
        } else if (by < 0) {
            if (!parsedEntity.skippedNameStartCharacter()) {
                return false;
            }
            n = parsedEntity.offset;
        } else {
            return false;
        }
        while (n < parsedEntity.endOffset) {
            by = byArray[n];
            if (nameCharMap[by & 0xFF] < 4) {
                ++n;
                continue;
            }
            if (by == 58) {
                parsedEntity.offset = n;
                this.fStringInBuffer.setEndPos(parsedEntity.buffer, n, 0);
                qName.prefixHandle = this.addSymbolUnbuffered(this.fStringInBuffer);
                this.addXMLStringToTree(this.fPrefixes, this.fStringInBuffer, qName.prefixHandle, qName.prefixHandle);
                return true;
            }
            if (by < 0) {
                parsedEntity.offset = n;
                if (!parsedEntity.skippedNameStartCharacter()) {
                    return false;
                }
                n = parsedEntity.offset;
                continue;
            }
            return false;
        }
        return false;
    }

    private void grow() {
        int n = this.fSymbols.length;
        int[] nArray = new int[n << 1];
        System.arraycopy(this.fSymbols, 0, nArray, 0, n);
        this.fSymbols = nArray;
    }

    private Node cacheNodeAllocate() {
        ++this.fNodeCount;
        if (this.fFreeList == NODE_NULL) {
            Node node = new Node();
            node.left = NODE_NULL;
            node.right = NODE_NULL;
            node.next = NODE_NULL;
            return node;
        }
        Node node = this.fFreeList;
        this.fFreeList = node.next;
        node.next = NODE_NULL;
        return node;
    }

    private void cacheNodeDeallocate(Node node) {
        Node node2;
        do {
            --this.fNodeCount;
            node.count = 0;
            node.byteValue = 0;
            node.handle = 0;
            node.userValue = 0;
            node.startOffset = 0;
            node.endOffset = 0;
            if (node.left != NODE_NULL) {
                this.cacheNodeDeallocate(node.left);
                node.left = NODE_NULL;
            }
            if (node.right != NODE_NULL) {
                this.cacheNodeDeallocate(node.right);
                node.right = NODE_NULL;
            }
            node2 = node.next;
            node.next = this.fFreeList;
            this.fFreeList = node;
        } while ((node = node2) != NODE_NULL);
    }

    private void dumpCache(Node node) {
        if (node == this.fGlobals && this.fSymbolCount == 1) {
            return;
        }
        if (this.fSymbolDebugBytes == null) {
            this.fSymbolDebugBytes = new byte[256];
            if (this.fSymbolDebugNodeStack == null) {
                this.initDebugNodeStack();
            }
        }
        this.pushDebugNode(0, node);
        Node node2 = node.next;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        block0: while (true) {
            if (node2.left != NODE_NULL) {
                if (node2.handle != 0 || node2.next != NODE_NULL || node2.right != NODE_NULL) {
                    this.pushDebugNode(-(n + 1), node2);
                }
                node2 = node2.left;
                continue;
            }
            while (true) {
                if (node2.handle != 0) {
                    ++n3;
                }
                n2 = this.dumpCacheRecord(node2, n);
                if (node2.next != NODE_NULL) {
                    if (node2.right != NODE_NULL) {
                        this.pushDebugNode(n, node2);
                    }
                    n = n2;
                    node2 = node2.next;
                    continue block0;
                }
                if (node2.right != NODE_NULL) {
                    node2 = node2.right;
                    continue block0;
                }
                node2 = this.popDebugNode(this.fMultiByteCharInfo);
                if (node2 == node) {
                    if (node == this.fGlobals && n3 != this.fSymbolCount) {
                        System.err.println("ERROR: All symbols not accounted for (expected " + this.fSymbolCount + ", actual " + n3 + ")");
                    }
                    return;
                }
                n2 = this.fMultiByteCharInfo[0];
                if (n2 >= 0) {
                    n = n2;
                    node2 = node2.right;
                    continue block0;
                }
                n = -(n2 + 1);
            }
            break;
        }
    }

    private int dumpCacheRecord(Node node, int n) {
        int n2 = node.startOffset;
        int n3 = node.byteValue;
        while (true) {
            if (n == this.fSymbolDebugBytes.length) {
                byte[] byArray = new byte[n << 1];
                System.arraycopy(this.fSymbolDebugBytes, 0, byArray, 0, n);
                this.fSymbolDebugBytes = byArray;
            }
            this.fSymbolDebugBytes[n] = (byte)n3;
            ++n;
            if (n2 == node.endOffset) break;
            n3 = this.fDataBytes[n2++];
        }
        if (node.handle != 0) {
            int n4 = node.handle * 4;
            int n5 = this.fSymbols[n4 + 0];
            int n6 = this.fSymbols[n4 + 1];
            this.fStringBuffer.setStringValues(n5, n6, this.fDebugString);
            if (!this.fDebugString.equalsString(this.fSymbolDebugBytes, 0, n)) {
                System.err.println("bytesOffset " + n + ", offset " + n5 + ", endOffset " + n6);
                System.err.print("ERROR: Symbol " + node.handle + " has inconsistent values: \"");
                this.writePrintableString(this.fSymbolDebugBytes, 0, n);
                System.err.print("\" vs. \"");
                this.writePrintableXMLString(this.fDebugString);
                System.err.println("\"");
            }
        }
        return n;
    }

    private static Node search(Node node, int n) {
        Node node2;
        block1: {
            Node node3 = node;
            do {
                node2 = node3;
                node3 = n < node3.byteValue ? node3.left : node3.right;
                if (node3 == NODE_NULL) break block1;
            } while (n != node3.byteValue);
            return node3;
        }
        return node2;
    }

    private int findParents(Node node, Node node2) {
        Node node3 = node;
        int n = 0;
        while (node3 != node2) {
            if (n == this.fParents.length) {
                Node[] nodeArray = new Node[n << 1];
                System.arraycopy(this.fParents, 0, nodeArray, 0, n);
                this.fParents = nodeArray;
            }
            this.fParents[n++] = node3;
            node3 = node2.byteValue < node3.byteValue ? node3.left : node3.right;
        }
        return n;
    }

    private static Node rotLR(Node node, Node node2) {
        Node node3 = node2.right;
        node.left = node3.right;
        node.count = node.left.count + node.right.count + 1;
        node3.right = node;
        node2.right = node3.left;
        node2.count = node2.left.count + node2.right.count + 1;
        node3.left = node2;
        return node3;
    }

    private static Node rotRL(Node node, Node node2) {
        Node node3 = node2.left;
        node.right = node3.left;
        node.count = node.left.count + node.right.count + 1;
        node3.left = node;
        node2.left = node3.right;
        node2.count = node2.left.count + node2.right.count + 1;
        node3.right = node2;
        return node3;
    }

    private void printNode(Node node, int n) {
    }

    private void printTree(Node node, boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     */
    private Node rebalance(Node node, Node node2) {
        int n = this.findParents(node, node2);
        boolean bl = false;
        while (true) {
            Node node3;
            block11: {
                block12: {
                    node2.count = node2.right.count + node2.left.count + 1;
                    if (n == 0) {
                        return node2;
                    }
                    node3 = this.fParents[--n];
                    if (node3.left.count <= node3.right.count) break block12;
                    node2 = node3.left;
                    if (node2.left.count > node2.right.count && node2.left.count > node3.right.count) {
                        node3.left = node2.right;
                        node3.count = node3.left.count + node3.right.count + 1;
                        node2.right = node3;
                        break block11;
                    } else if (node2.left.count <= node2.right.count && node2.right.count > node3.right.count) {
                        node2 = SymbolTable.rotLR(node3, node2);
                        break block11;
                    } else {
                        node2 = node3;
                        continue;
                    }
                }
                node2 = node3.right;
                if (node2.right.count > node2.left.count && node2.right.count > node3.left.count) {
                    node3.right = node2.left;
                    node3.count = node3.left.count + node3.right.count + 1;
                    node2.left = node3;
                } else if (node2.right.count <= node2.left.count && node2.left.count > node3.left.count) {
                    node2 = SymbolTable.rotRL(node3, node2);
                } else {
                    node2 = node3;
                    continue;
                }
            }
            if (n <= 0) continue;
            Node node4 = this.fParents[n - 1];
            if (node4.left == node3) {
                node4.left = node2;
                continue;
            }
            node4.right = node2;
        }
    }

    private void loadPredefinedSymbol(int n, int n2, String string) {
        if (this.lookupStringSymbol(string) >= 0) {
            UntestedCode.needTest("predefined symbol already defined");
        }
        if (n2 != n || n != this.fSymbolCount++) {
            UntestedCode.needTest("predefined symbol handle inconsistent");
        }
        if (!this.addStringToCache(string, n)) {
            UntestedCode.needTest("predefined symbol error");
        }
    }

    private void loadPredefinedSymbols() {
        int n = 1;
        int n2 = 1;
        this.loadPredefinedSymbol(n++, n2, "xmlns");
        n2 = 2;
        this.loadPredefinedSymbol(n++, n2, "xml");
        n2 = 3;
        this.loadPredefinedSymbol(n++, n2, "http://www.w3.org/2000/xmlns/");
        n2 = 4;
        this.loadPredefinedSymbol(n++, n2, "http://www.w3.org/XML/1998/namespace");
        n2 = 5;
        this.loadPredefinedSymbol(n++, n2, "lt");
        n2 = 6;
        this.loadPredefinedSymbol(n++, n2, "gt");
        n2 = 7;
        this.loadPredefinedSymbol(n++, n2, "amp");
        n2 = 8;
        this.loadPredefinedSymbol(n++, n2, "apos");
        n2 = 9;
        this.loadPredefinedSymbol(n++, n2, "quot");
        n2 = 10;
        this.loadPredefinedSymbol(n++, n2, "EMPTY");
        n2 = 11;
        this.loadPredefinedSymbol(n++, n2, "ANY");
        n2 = 12;
        this.loadPredefinedSymbol(n++, n2, "MIXED");
        n2 = 13;
        this.loadPredefinedSymbol(n++, n2, "CHILDREN");
        n2 = 14;
        this.loadPredefinedSymbol(n++, n2, "CDATA");
        n2 = 15;
        this.loadPredefinedSymbol(n++, n2, "ID");
        n2 = 16;
        this.loadPredefinedSymbol(n++, n2, "IDREF");
        n2 = 17;
        this.loadPredefinedSymbol(n++, n2, "IDREFS");
        n2 = 18;
        this.loadPredefinedSymbol(n++, n2, "ENTITY");
        n2 = 19;
        this.loadPredefinedSymbol(n++, n2, "ENTITIES");
        n2 = 20;
        this.loadPredefinedSymbol(n++, n2, "NMTOKEN");
        n2 = 21;
        this.loadPredefinedSymbol(n++, n2, "NMTOKENS");
        n2 = 22;
        this.loadPredefinedSymbol(n++, n2, "NOTATION");
        n2 = 23;
        this.loadPredefinedSymbol(n++, n2, "#FIXED");
        n2 = 24;
        this.loadPredefinedSymbol(n++, n2, "#REQUIRED");
        n2 = 25;
        this.loadPredefinedSymbol(n++, n2, "http://www.w3.org/TR/2000/REC-xml-20001006#NT-document");
        n2 = 26;
        this.loadPredefinedSymbol(n++, n2, "http://w3.xml.ibm.com/#XLXP");
        n2 = 27;
        this.loadPredefinedSymbol(n++, n2, "http://www.w3.org/TR/2000/REC-xml-20001006");
        n2 = 28;
        this.loadPredefinedSymbol(n++, n2, "version");
        n2 = 29;
        this.loadPredefinedSymbol(n++, n2, "encoding");
        n2 = 30;
        this.loadPredefinedSymbol(n++, n2, "standalone");
        n2 = 31;
        this.loadPredefinedSymbol(n++, n2, "http://www.w3.org/2001/XMLSchema");
        n2 = 32;
        this.loadPredefinedSymbol(n++, n2, "http://www.w3.org/2001/XMLSchema-instance");
        n2 = 33;
        this.loadPredefinedSymbol(n++, n2, "xsi");
        n2 = 34;
        this.loadPredefinedSymbol(n++, n2, "xsd");
        n2 = 35;
        this.loadPredefinedSymbol(n++, n2, "type");
        n2 = 36;
        this.loadPredefinedSymbol(n++, n2, "nil");
        n2 = 37;
        this.loadPredefinedSymbol(n++, n2, "schemaLocation");
        n2 = 38;
        this.loadPredefinedSymbol(n++, n2, "noNamespaceSchemaLocation");
        n2 = 39;
        this.loadPredefinedSymbol(n++, n2, "anyType");
        n2 = 40;
        this.loadPredefinedSymbol(n++, n2, "anySimpleType");
        n2 = 41;
        this.loadPredefinedSymbol(n++, n2, "string");
        n2 = 42;
        this.loadPredefinedSymbol(n++, n2, "boolean");
        n2 = 43;
        this.loadPredefinedSymbol(n++, n2, "decimal");
        n2 = 44;
        this.loadPredefinedSymbol(n++, n2, "float");
        n2 = 45;
        this.loadPredefinedSymbol(n++, n2, "double");
        n2 = 46;
        this.loadPredefinedSymbol(n++, n2, "duration");
        n2 = 47;
        this.loadPredefinedSymbol(n++, n2, "dateTime");
        n2 = 48;
        this.loadPredefinedSymbol(n++, n2, "time");
        n2 = 49;
        this.loadPredefinedSymbol(n++, n2, "date");
        n2 = 50;
        this.loadPredefinedSymbol(n++, n2, "gYearMonth");
        n2 = 51;
        this.loadPredefinedSymbol(n++, n2, "gYear");
        n2 = 52;
        this.loadPredefinedSymbol(n++, n2, "gMonthDay");
        n2 = 53;
        this.loadPredefinedSymbol(n++, n2, "gDay");
        n2 = 54;
        this.loadPredefinedSymbol(n++, n2, "gMonth");
        n2 = 55;
        this.loadPredefinedSymbol(n++, n2, "hexBinary");
        n2 = 56;
        this.loadPredefinedSymbol(n++, n2, "base64Binary");
        n2 = 57;
        this.loadPredefinedSymbol(n++, n2, "anyURI");
        n2 = 58;
        this.loadPredefinedSymbol(n++, n2, "QName");
        n2 = 59;
        this.loadPredefinedSymbol(n++, n2, "normalizedString");
        n2 = 60;
        this.loadPredefinedSymbol(n++, n2, "token");
        n2 = 61;
        this.loadPredefinedSymbol(n++, n2, "language");
        n2 = 62;
        this.loadPredefinedSymbol(n++, n2, "Name");
        n2 = 63;
        this.loadPredefinedSymbol(n++, n2, "NCName");
        n2 = 64;
        this.loadPredefinedSymbol(n++, n2, "integer");
        n2 = 65;
        this.loadPredefinedSymbol(n++, n2, "nonPositiveInteger");
        n2 = 66;
        this.loadPredefinedSymbol(n++, n2, "negativeInteger");
        n2 = 67;
        this.loadPredefinedSymbol(n++, n2, "long");
        n2 = 68;
        this.loadPredefinedSymbol(n++, n2, "int");
        n2 = 69;
        this.loadPredefinedSymbol(n++, n2, "short");
        n2 = 70;
        this.loadPredefinedSymbol(n++, n2, "byte");
        n2 = 71;
        this.loadPredefinedSymbol(n++, n2, "nonNegativeInteger");
        n2 = 72;
        this.loadPredefinedSymbol(n++, n2, "unsignedLong");
        n2 = 73;
        this.loadPredefinedSymbol(n++, n2, "unsignedInt");
        n2 = 74;
        this.loadPredefinedSymbol(n++, n2, "unsignedShort");
        n2 = 75;
        this.loadPredefinedSymbol(n++, n2, "unsignedByte");
        n2 = 76;
        this.loadPredefinedSymbol(n++, n2, "positiveInteger");
        if (n != 77) {
            UntestedCode.needTest("predefined symbol list inconsistent");
        }
        this.addSymbolToTree(this.fPrefixes, 1, 1);
        this.addSymbolToTree(this.fPrefixes, 33, 33);
        this.addSymbolToTree(this.fPrefixes, 34, 34);
    }

    /*
     * Opcode count of 33913 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        Node node;
        nameStartCharMap = new byte[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        nameCharMap = new byte[]{12, 8, 8, 8, 8, 8, 8, 8, 8, 24, 24, 8, 8, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 2, 2, 16, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 32, 8, 28, 20, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
        fgMultiByteLength = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
        node.right = node.next = (node = new Node());
        node.left = node.next;
        NODE_NULL = node;
        predefinedState = new byte[]{-70, -70, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 21, 0, 7, 1, 77, 0, 26, 1, 1, 0, 3, 1, 25, 0, 3, 1, 103, 0, 16, 3, 1, 1, 1, 0, 3, 1, 13, 0, 3, 1, 97, 0, 16, 3, 1, 1, 1, 0, 3, 1, 8, 0, 3, 1, 69, 0, 16, 3, 1, 1, 1, 0, 3, 1, 3, 0, 3, 1, 65, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 35, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 70, 0, 17, 2, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 88, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 68, 0, 3, 1, 23, 0, 18, 1, 1, 0, 3, 1, 82, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 81, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 85, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 82, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 68, 0, 3, 1, 24, 0, 18, 1, 1, 0, 3, 1, 78, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 89, 0, 3, 1, 11, 0, 18, 1, 1, 0, 3, 1, 67, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 72, 0, 16, 1, 1, 0, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 68, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 65, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 65, 0, 3, 1, 14, 0, 18, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 76, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 68, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 82, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 78, 0, 3, 1, 13, 0, 18, 1, 2, 0, 3, 1, 77, 0, 17, 2, 1, 1, 0, 3, 1, 1, 0, 3, 1, 80, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 89, 0, 3, 1, 10, 0, 18, 1, 1, 0, 3, 1, 78, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 89, 0, 3, 1, 18, 0, 12, 1, 1, 0, 5, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 83, 0, 3, 1, 19, 0, 18, 1, 4, 0, 3, 1, 77, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 68, 0, 3, 1, 15, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 82, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 70, 0, 3, 1, 16, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 83, 0, 3, 1, 17, 0, 18, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 88, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 68, 0, 3, 1, 12, 0, 18, 1, 2, 0, 3, 1, 78, 0, 17, 2, 1, 1, 0, 3, 1, 4, 0, 3, 1, 79, 0, 16, 3, 1, 1, 1, 0, 3, 1, 2, 0, 3, 1, 77, 0, 16, 1, 1, 0, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 67, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 78, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 63, 0, 18, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 79, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 75, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 78, 0, 3, 1, 20, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 83, 0, 3, 1, 21, 0, 18, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 65, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 79, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 78, 0, 3, 1, 22, 0, 18, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 62, 0, 18, 1, 1, 0, 3, 1, 81, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 78, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 58, 0, 18, 1, 3, 0, 3, 1, 110, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 112, 0, 3, 1, 7, 0, 18, 1, 1, 0, 3, 1, 121, 0, 18, 1, 1, 0, 3, 1, 3, 0, 3, 1, 84, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 83, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 112, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 121, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 112, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 40, 0, 18, 1, 1, 0, 3, 1, 121, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 112, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 39, 0, 18, 1, 1, 0, 3, 1, 85, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 82, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 3, 1, 57, 0, 18, 1, 1, 0, 3, 1, 112, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 3, 1, 8, 0, 18, 1, 4, 0, 3, 1, 100, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 98, 0, 18, 1, 1, 0, 3, 1, 3, 0, 3, 1, 111, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 54, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 52, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 66, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 121, 0, 3, 1, 56, 0, 18, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 3, 1, 42, 0, 18, 1, 1, 0, 3, 1, 121, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 70, 0, 18, 1, 4, 0, 3, 1, 111, 0, 16, 3, 1, 1, 1, 0, 3, 1, 2, 0, 3, 1, 101, 0, 16, 1, 1, 0, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 49, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 3, 1, 43, 0, 18, 1, 1, 0, 3, 1, 117, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 98, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 45, 0, 18, 1, 1, 0, 3, 1, 117, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 3, 1, 46, 0, 18, 1, 2, 0, 3, 1, 101, 0, 17, 2, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 100, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 3, 1, 29, 0, 18, 1, 1, 0, 3, 1, 102, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 3, 1, 44, 0, 18, 1, 4, 0, 3, 1, 89, 0, 16, 3, 1, 1, 1, 0, 3, 1, 2, 0, 3, 1, 77, 0, 16, 1, 1, 0, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 68, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 121, 0, 3, 1, 53, 0, 18, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 104, 0, 3, 1, 54, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 68, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 121, 0, 3, 1, 52, 0, 18, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 3, 1, 51, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 77, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 104, 0, 3, 1, 50, 0, 18, 1, 1, 0, 3, 1, 116, 0, 3, 1, 6, 0, 18, 1, 11, 0, 3, 1, 113, 0, 16, 3, 1, 1, 1, 0, 3, 1, 5, 0, 3, 1, 108, 0, 16, 3, 1, 1, 1, 0, 3, 1, 2, 0, 3, 1, 104, 0, 17, 2, 1, 1, 0, 3, 1, 2, 0, 3, 1, 116, 0, 16, 1, 1, 0, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 120, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 66, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 121, 0, 3, 1, 55, 0, 18, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 112, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 58, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 119, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 119, 0, 16, 1, 1, 0, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 51, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 46, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 120, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 46, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 98, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 46, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 35, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 88, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 76, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 88, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 80, 0, 3, 1, 26, 0, 18, 1, 1, 0, 3, 1, 119, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 46, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 119, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 51, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 46, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 3, 0, 3, 1, 84, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 50, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 48, 0, 17, 2, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 120, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 3, 1, 3, 0, 18, 1, 1, 0, 3, 1, 49, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 88, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 77, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 76, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 83, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 104, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 3, 1, 31, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 45, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 32, 0, 18, 1, 1, 0, 3, 1, 82, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 50, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 82, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 67, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 45, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 120, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 45, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 50, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 49, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 54, 0, 3, 1, 27, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 35, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 78, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 84, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 45, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 100, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 117, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 3, 1, 25, 0, 14, 0, 4, 1, 1, 0, 3, 1, 88, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 77, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 76, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 49, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 57, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 57, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 56, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 47, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 112, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 4, 0, 18, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 3, 1, 68, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 3, 1, 64, 0, 18, 1, 3, 0, 3, 1, 111, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 117, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 61, 0, 18, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 3, 1, 67, 0, 18, 1, 1, 0, 3, 1, 116, 0, 3, 1, 5, 0, 18, 1, 2, 0, 3, 1, 110, 0, 17, 2, 1, 1, 0, 3, 1, 3, 0, 3, 1, 105, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 118, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 3, 1, 66, 0, 18, 1, 1, 0, 3, 1, 108, 0, 3, 1, 36, 0, 18, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 3, 0, 3, 1, 110, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 78, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 112, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 83, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 104, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 76, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 3, 1, 38, 0, 18, 1, 2, 0, 3, 1, 80, 0, 16, 1, 1, 0, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 78, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 118, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 3, 1, 71, 0, 18, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 118, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 3, 1, 65, 0, 18, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 122, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 100, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 83, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 3, 1, 59, 0, 18, 1, 1, 0, 3, 1, 112, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 118, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 3, 1, 76, 0, 18, 1, 1, 0, 3, 1, 117, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 3, 1, 9, 0, 18, 1, 5, 0, 3, 1, 118, 0, 16, 3, 1, 1, 1, 0, 3, 1, 3, 0, 3, 1, 116, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 3, 0, 3, 1, 104, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 104, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 76, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 99, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 3, 1, 37, 0, 18, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 3, 1, 69, 0, 18, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 97, 0, 17, 2, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 100, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 97, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 30, 0, 18, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 3, 1, 41, 0, 18, 1, 3, 0, 3, 1, 111, 0, 16, 3, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 109, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 48, 0, 18, 1, 1, 0, 3, 1, 107, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 3, 1, 60, 0, 18, 1, 1, 0, 3, 1, 121, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 112, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 35, 0, 18, 1, 1, 0, 3, 1, 117, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 100, 0, 18, 1, 1, 0, 3, 1, 4, 0, 3, 1, 76, 0, 16, 3, 1, 1, 1, 0, 3, 1, 2, 0, 3, 1, 73, 0, 16, 1, 1, 0, 1, 1, 1, 0, 3, 1, 1, 0, 3, 1, 66, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 121, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 101, 0, 3, 1, 75, 0, 18, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 3, 1, 73, 0, 18, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 103, 0, 3, 1, 72, 0, 18, 1, 1, 0, 3, 1, 83, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 104, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 116, 0, 3, 1, 74, 0, 18, 1, 1, 0, 3, 1, 101, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 114, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 105, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 111, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 3, 1, 28, 0, 18, 1, 1, 0, 3, 1, 120, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 109, 0, 17, 2, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 3, 1, 2, 0, 14, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 3, 1, 1, 0, 18, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 105, 0, 3, 1, 33, 0, 12, 1, 1, 0, 5, 1, 1, 0, 3, 1, 100, 0, 3, 1, 34, 0, 41, 1, 1, 0, 3, 1, 1, 0, 3, 1, 120, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 109, 0, 17, 2, 1, 1, 0, 3, 1, 1, 0, 3, 1, 108, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 110, 0, 18, 1, 1, 0, 3, 1, 1, 0, 3, 1, 115, 0, 3, 1, 1, 0, 3, 1, 1, 0, 14, 1, 1, 0, 3, 1, 115, 0, 18, 1, 1, 0, 3, 1, 2, 0, 3, 1, 105, 0, 3, 1, 33, 0, 3, 1, 33, 0, 8, 1, 1, 0, 5, 1, 1, 0, 3, 1, 100, 0, 3, 1, 34, 0, 3, 1, 34, 0, 30, 1, -101, 0, 3, 1, -96, 0, 11, 1, 31, 0, 3, 1, 34, 0, 11, 1, -124, 0, 3, 1, -95, 0, 11, 1, 96, 0, 3, 1, -124, 0, 10, 2, 2, -118, 0, 2, 2, 2, -116, 0, 10, 2, 2, -120, 0, 2, 2, 2, -118, 0, 10, 2, 2, 124, 0, 2, 2, 2, 127, 0, 10, 2, 2, 93, 0, 2, 2, 2, 97, 0, 10, 2, 2, 109, 0, 2, 2, 2, 113, 0, 10, 2, 2, 63, 0, 2, 2, 2, 68, 0, 10, 2, 2, 121, 0, 2, 2, 2, 124, 0, 10, 2, 2, 68, 0, 2, 2, 2, 73, 0, 10, 2, 1, -83, 0, 2, 2, 1, -75, 0, 10, 2, 2, 58, 0, 2, 2, 2, 63, 0, 10, 2, 2, 28, 0, 2, 2, 2, 30, 0, 10, 2, 2, 28, 0, 2, 2, 2, 33, 0, 10, 2, 2, 28, 0, 2, 2, 2, 34, 0, 10, 2, 2, 22, 0, 2, 2, 2, 28, 0, 10, 2, 1, -75, 0, 2, 2, 1, -67, 0, 10, 2, 1, -67, 0, 2, 2, 1, -60, 0, 10, 2, 1, -67, 0, 2, 2, 1, -59, 0, 10, 2, 1, -59, 0, 2, 2, 1, -51, 0, 10, 2, 2, 16, 0, 2, 2, 2, 22, 0, 10, 2, 1, -110, 0, 2, 2, 1, -101, 0, 11, 1, 1, 0, 3, 1, 55, 0, 11, 1, -95, 0, 3, 1, -68, 0, 11, 1, 1, 0, 3, 1, 43, 0, 10, 2, 2, 9, 0, 2, 2, 2, 16, 0, 10, 2, 1, -35, 0, 2, 2, 1, -27, 0, 10, 2, 1, -120, 0, 2, 2, 1, -110, 0, 11, 1, 55, 0, 3, 1, 87, 0, 11, 1, 55, 0, 3, 1, 96, 0, 10, 2, 2, -123, 0, 2, 2, 2, -120, 0, 10, 2, 2, -126, 0, 2, 2, 2, -123, 0, 10, 2, 2, 117, 0, 2, 2, 2, 121, 0, 10, 2, 2, 127, 0, 2, 2, 2, -126, 0, 10, 2, 1, 39, 0, 2, 2, 1, 53, 0, 11, 1, -68, 0, 3, 1, -43, 0, 10, 2, 1, -19, 0, 2, 2, 1, -12, 0, 10, 2, 1, 53, 0, 2, 2, 1, 66, 0, 10, 2, 2, 52, 0, 2, 2, 2, 58, 0, 10, 2, 1, -12, 0, 2, 2, 1, -5, 0, 10, 2, 1, -5, 0, 2, 2, 2, 2, 0, 10, 2, 2, 78, 0, 2, 2, 2, 83, 0, 10, 2, 2, 46, 0, 2, 2, 2, 52, 0, 10, 2, 1, -43, 0, 2, 2, 1, -35, 0, 10, 2, 1, -51, 0, 2, 2, 1, -43, 0, 10, 2, 2, 113, 0, 2, 2, 2, 117, 0, 10, 2, 1, -51, 0, 2, 2, 1, -47, 0, 10, 2, 1, 126, 0, 2, 2, 1, -120, 0, 10, 2, 1, 126, 0, 2, 2, 1, -125, 0, 10, 2, 1, -101, 0, 2, 2, 1, -92, 0, 10, 2, 2, 101, 0, 2, 2, 2, 105, 0, 10, 2, 1, -101, 0, 2, 2, 1, -95, 0, 10, 2, 1, -92, 0, 2, 2, 1, -83, 0, 10, 2, 1, 79, 0, 2, 2, 1, 91, 0, 10, 2, 2, 40, 0, 2, 2, 2, 46, 0, 10, 2, 2, 73, 0, 2, 2, 2, 78, 0, 11, 1, -7, 0, 2, 2, 1, 9, 0, 10, 2, 2, 88, 0, 2, 2, 2, 93, 0, 10, 2, 1, -27, 0, 2, 2, 1, -19, 0, 11, 1, -66, 0, 3, 1, -62, 0, 10, 2, 2, 34, 0, 2, 2, 2, 40, 0, 10, 2, 2, 2, 0, 2, 2, 2, 9, 0, 11, 1, -25, 0, 3, 1, -7, 0, 10, 2, 1, 9, 0, 2, 2, 1, 24, 0, 10, 2, 2, 105, 0, 2, 2, 2, 109, 0, 10, 2, 2, 2, 0, 2, 2, 2, 5, 0, 10, 2, 2, 83, 0, 2, 2, 2, 88, 0, 10, 2, 2, 97, 0, 2, 2, 2, 101, 0, 11, 1, -43, 0, 3, 1, -25, 0, 10, 2, 1, 103, 0, 2, 2, 1, 115, 0, 10, 2, 1, 115, 0, 2, 2, 1, 126, 0, 10, 2, 1, 66, 0, 2, 2, 1, 79, 0, 10, 2, 1, 91, 0, 2, 2, 1, 103, 0, 10, 2, 1, 24, 0, 2, 2, 1, 39, 0, 8, -1, 0, 0, 2, -116, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 50, 48, 48, 48, 47, 82, 69, 67, 45, 120, 109, 108, 45, 50, 48, 48, 48, 49, 48, 48, 54, 35, 78, 84, 45, 100, 111, 99, 117, 109, 101, 110, 116, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 50, 48, 48, 49, 47, 88, 77, 76, 83, 99, 104, 101, 109, 97, 45, 105, 110, 115, 116, 97, 110, 99, 101, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 88, 77, 76, 47, 49, 57, 57, 56, 47, 110, 97, 109, 101, 115, 112, 97, 99, 101, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 50, 48, 48, 48, 47, 120, 109, 108, 110, 115, 47, 104, 116, 116, 112, 58, 47, 47, 119, 51, 46, 120, 109, 108, 46, 105, 98, 109, 46, 99, 111, 109, 47, 35, 88, 76, 88, 80, 110, 111, 78, 97, 109, 101, 115, 112, 97, 99, 101, 83, 99, 104, 101, 109, 97, 76, 111, 99, 97, 116, 105, 111, 110, 110, 111, 110, 78, 101, 103, 97, 116, 105, 118, 101, 73, 110, 116, 101, 103, 101, 114, 110, 111, 110, 80, 111, 115, 105, 116, 105, 118, 101, 73, 110, 116, 101, 103, 101, 114, 110, 111, 114, 109, 97, 108, 105, 122, 101, 100, 83, 116, 114, 105, 110, 103, 110, 101, 103, 97, 116, 105, 118, 101, 73, 110, 116, 101, 103, 101, 114, 112, 111, 115, 105, 116, 105, 118, 101, 73, 110, 116, 101, 103, 101, 114, 115, 99, 104, 101, 109, 97, 76, 111, 99, 97, 116, 105, 111, 110, 97, 110, 121, 83, 105, 109, 112, 108, 101, 84, 121, 112, 101, 117, 110, 115, 105, 103, 110, 101, 100, 83, 104, 111, 114, 116, 98, 97, 115, 101, 54, 52, 66, 105, 110, 97, 114, 121, 117, 110, 115, 105, 103, 110, 101, 100, 66, 121, 116, 101, 117, 110, 115, 105, 103, 110, 101, 100, 76, 111, 110, 103, 117, 110, 115, 105, 103, 110, 101, 100, 73, 110, 116, 103, 89, 101, 97, 114, 77, 111, 110, 116, 104, 115, 116, 97, 110, 100, 97, 108, 111, 110, 101, 35, 82, 69, 81, 85, 73, 82, 69, 68, 103, 77, 111, 110, 116, 104, 68, 97, 121, 104, 101, 120, 66, 105, 110, 97, 114, 121, 67, 72, 73, 76, 68, 82, 69, 78, 69, 78, 84, 73, 84, 73, 69, 83, 78, 77, 84, 79, 75, 69, 78, 83, 78, 79, 84, 65, 84, 73, 79, 78, 100, 97, 116, 101, 84, 105, 109, 101, 100, 117, 114, 97, 116, 105, 111, 110, 101, 110, 99, 111, 100, 105, 110, 103, 108, 97, 110, 103, 117, 97, 103, 101, 97, 110, 121, 84, 121, 112, 101, 98, 111, 111, 108, 101, 97, 110, 100, 101, 99, 105, 109, 97, 108, 105, 110, 116, 101, 103, 101, 114, 118, 101, 114, 115, 105, 111, 110, 35, 70, 73, 88, 69, 68, 69, 78, 84, 73, 84, 89, 73, 68, 82, 69, 70, 83, 78, 67, 78, 97, 109, 101, 97, 110, 121, 85, 82, 73, 100, 111, 117, 98, 108, 101, 115, 116, 114, 105, 110, 103, 67, 68, 65, 84, 65, 69, 77, 80, 84, 89, 77, 73, 88, 69, 68, 81, 78, 97, 109, 101, 102, 108, 111, 97, 116, 115, 104, 111, 114, 116, 116, 111, 107, 101, 110, 97, 112, 111, 115, 98, 121, 116, 101, 103, 68, 97, 121, 108, 111, 110, 103, 113, 117, 111, 116, 116, 105, 109, 101, 116, 121, 112, 101, 65, 78, 89, 97, 109, 112, 110, 105, 108, 120, 115, 100, 120, 115, 105, 103, 116, 108, 116};
    }

    static class Node {
        Node left;
        Node right;
        Node next;
        int count;
        int byteValue;
        int handle;
        int userValue;
        int startOffset;
        int endOffset;

        Node() {
        }
    }

    private static final class StreamCompressor {
        OutputStream fOutStream;
        InputStream fInStream;
        byte[] fBuffer = new byte[8192];
        int fOffset = 0;
        int fCount = 0;

        private void setOutputStream(OutputStream outputStream) {
            this.fOutStream = outputStream;
            this.fOffset = 0;
            this.fCount = 8192;
        }

        private void compressBuffer() throws IOException {
            block8: {
                int n;
                boolean bl;
                int n2 = 0;
                int n3 = this.fOffset;
                boolean bl2 = bl = this.fBuffer[n2] == 0;
                block0: while (true) {
                    if (bl) {
                        n = 1;
                        while (++n2 < n3) {
                            if (this.fBuffer[n2] == 0) {
                                if (n < 254) {
                                    ++n;
                                    continue;
                                }
                                this.fOutStream.write(0);
                                this.fOutStream.write(n);
                                n = 1;
                                continue;
                            }
                            this.fOutStream.write(0);
                            this.fOutStream.write(n);
                            bl = false;
                            continue block0;
                        }
                        this.fOutStream.write(0);
                        this.fOutStream.write(n);
                        break block8;
                    }
                    n = 1;
                    while (++n2 < n3) {
                        if (this.fBuffer[n2] != 0) {
                            if (n < 254) {
                                ++n;
                                continue;
                            }
                            this.fOutStream.write(n);
                            this.fOutStream.write(this.fBuffer, n2 - n, n);
                            n = 1;
                            continue;
                        }
                        this.fOutStream.write(n);
                        this.fOutStream.write(this.fBuffer, n2 - n, n);
                        bl = true;
                        continue block0;
                    }
                    break;
                }
                this.fOutStream.write(n);
                this.fOutStream.write(this.fBuffer, n2 - n, n);
            }
            this.fOffset = 0;
        }

        private void writeByte(byte by) throws IOException {
            if (this.fOffset == this.fCount) {
                this.compressBuffer();
            }
            this.fBuffer[this.fOffset] = by;
            ++this.fOffset;
        }

        private void flush() throws IOException {
            if (this.fOffset > 0) {
                this.compressBuffer();
            }
            this.fOutStream.write(255);
        }

        private void writeBoolean(boolean bl) throws IOException {
            this.writeByte(bl ? (byte)1 : 0);
        }

        private void writeInt(int n) throws IOException {
            this.writeByte((byte)(n >> 24));
            this.writeByte((byte)(n >> 16));
            this.writeByte((byte)(n >> 8));
            this.writeByte((byte)n);
        }

        private void writeInts(int[] nArray, int n) throws IOException {
            int n2 = 0;
            while (n2 < n) {
                this.writeInt(nArray[n2]);
                ++n2;
            }
        }

        private void setInputStream(InputStream inputStream) {
            this.fInStream = inputStream;
            this.fOffset = 0;
            this.fCount = 0;
        }

        private boolean finish() throws IOException {
            return this.fInStream == null || this.fInStream.read() == 255;
        }

        private void zeroBytes(int n) {
            int n2 = this.fOffset + n;
            if (n2 > this.fCount) {
                byte[] byArray = new byte[this.fCount << 1];
                System.arraycopy(this.fBuffer, 0, byArray, 0, this.fCount);
                this.fBuffer = byArray;
                this.fCount <<= 1;
            }
            while (this.fOffset < n2) {
                this.fBuffer[this.fOffset] = 0;
                ++this.fOffset;
            }
        }

        private boolean copyBytes(int n) throws IOException {
            int n2 = this.fOffset + n;
            if (n2 > this.fCount) {
                byte[] byArray = new byte[this.fCount << 1];
                System.arraycopy(this.fBuffer, 0, byArray, 0, this.fCount);
                this.fBuffer = byArray;
                this.fCount <<= 1;
            }
            if (this.fInStream.read(this.fBuffer, this.fOffset, n) != n) {
                return false;
            }
            this.fOffset = n2;
            return true;
        }

        private boolean decompressBuffer() throws IOException {
            block4: {
                this.fOffset = 0;
                this.fCount = 8192;
                int n = this.fInStream.read();
                while (true) {
                    if (n == 0) {
                        n = this.fInStream.read();
                        this.zeroBytes(n);
                        if (this.fOffset == this.fCount) break block4;
                        n = this.fInStream.read();
                    }
                    if (n <= 0) continue;
                    if (n >= 255) break;
                    if (!this.copyBytes(n)) {
                        return false;
                    }
                    if (this.fOffset != this.fCount) {
                        n = this.fInStream.read();
                        continue;
                    }
                    break block4;
                    break;
                }
                this.fInStream = null;
            }
            this.fCount = this.fOffset;
            this.fOffset = 0;
            return true;
        }

        private int readByte() throws IOException {
            if (this.fOffset == this.fCount && !this.decompressBuffer()) {
                return -1;
            }
            int n = this.fBuffer[this.fOffset] & 0xFF;
            ++this.fOffset;
            return n;
        }

        private boolean readBoolean() throws IOException {
            return this.readByte() != 0;
        }

        private int readInt() throws IOException {
            int n = this.readByte();
            n = n << 8 | this.readByte();
            n = n << 8 | this.readByte();
            return n << 8 | this.readByte();
        }

        private void readInts(int[] nArray, int n) throws IOException {
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.readInt();
                ++n2;
            }
        }
    }
}

