/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;

public class XMLString {
    public static final int FLAGS_NOTWHITESPACE = 1;
    public static final int FLAGS_ALLWHITESPACE = 2;
    public static final int FLAGS_NORMALIZE_EOL = 4;
    public static final int FLAGS_NORMALIZE_EOL11 = 8;
    public static final int FLAGS_NORMALIZE_EOL_MASK = 12;
    public byte[] bytes;
    public int startOffset;
    public int endOffset;
    public int length;
    public int flags;
    public int hashcode;
    public DataBuffer firstBuffer;
    public DataBuffer lastBuffer;
    protected char[][] fConvertedChars;
    protected int[] fConvertedCharsOffset;
    protected int[] fMultiByteCharInfo;
    protected final DataBufferReferrer fBufferReferrer = new DataBufferReferrer(){

        public boolean hasReferenceTo(DataBuffer dataBuffer) {
            if (XMLString.this.firstBuffer == dataBuffer) {
                return true;
            }
            if (XMLString.this.bytes != null) {
                return false;
            }
            if (XMLString.this.lastBuffer != null) {
                DataBuffer dataBuffer2 = XMLString.this.firstBuffer.next;
                while (true) {
                    if (dataBuffer2 == dataBuffer) {
                        return true;
                    }
                    if (dataBuffer2 == XMLString.this.lastBuffer) {
                        return false;
                    }
                    dataBuffer2 = dataBuffer2.next;
                }
            }
            if (XMLString.this.firstBuffer.next == null) {
                return false;
            }
            DataBuffer dataBuffer3 = XMLString.this.firstBuffer.next;
            while (dataBuffer3 != dataBuffer) {
                if (dataBuffer3 == null) {
                    return false;
                }
                dataBuffer3 = dataBuffer3.next;
            }
            return true;
        }
    };
    protected DataBufferFactory fBufferFactory;

    public XMLString() {
    }

    public XMLString(XMLString xMLString) {
        this();
        this.bytes = xMLString.bytes;
        this.startOffset = xMLString.startOffset;
        this.endOffset = xMLString.endOffset;
        this.length = xMLString.length;
        this.flags = xMLString.flags;
        this.hashcode = xMLString.hashcode;
        this.firstBuffer = xMLString.firstBuffer;
        this.lastBuffer = xMLString.lastBuffer;
        this.fBufferFactory = xMLString.fBufferFactory;
        if (this.fBufferFactory != null) {
            this.fBufferFactory.addReferrer(this.fBufferReferrer);
        }
        this.fBufferReferrer.active = this.firstBuffer != null;
    }

    public void clear() {
        if (this.firstBuffer != null) {
            this.bytes = null;
            this.startOffset = 0;
            this.endOffset = 0;
            this.length = 0;
            this.flags = 0;
            this.hashcode = 0;
            this.firstBuffer = null;
            this.lastBuffer = null;
            this.fBufferReferrer.active = false;
        }
    }

    public void unregister() {
        this.clear();
        if (this.fBufferFactory != null) {
            this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            this.fBufferFactory = null;
        }
    }

    public final void setValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        this.setValues(dataBuffer, dataBuffer2, n, n2, 0);
    }

    public final void setValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, int n3) {
        if (dataBuffer2 == null && n < dataBuffer.endOffset) {
            this.setValues(dataBuffer, n, n2, n3);
        } else {
            this.setStartPos(dataBuffer, n);
            this.setEndPos(dataBuffer2, n2, n3);
        }
    }

    public final void setValues(DataBuffer dataBuffer, int n, int n2) {
        this.setValues(dataBuffer, n, n2, 0);
    }

    public final void setValues(DataBuffer dataBuffer, int n, int n2, int n3) {
        if (this.lastBuffer == null && n < dataBuffer.endOffset) {
            this.startOffset = n;
            this.endOffset = n2;
            this.length = n2 - n;
            this.bytes = dataBuffer.bytes;
            this.flags = n3;
            this.hashcode = 0;
            if (this.firstBuffer == dataBuffer) {
                return;
            }
            this.firstBuffer = dataBuffer;
        } else {
            this.setStartPos(dataBuffer, n);
            this.setEndPos(dataBuffer, n2, n3);
        }
        if (this.fBufferFactory != this.firstBuffer.factory) {
            if (this.fBufferFactory != null) {
                this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            }
            this.fBufferFactory = dataBuffer.factory;
            this.fBufferFactory.addReferrer(this.fBufferReferrer);
        }
        this.fBufferReferrer.active = true;
    }

    public final void setStartPos(DataBuffer dataBuffer, int n) {
        this.startOffset = n;
        this.bytes = null;
        this.flags = 0;
        this.hashcode = 0;
        this.firstBuffer = dataBuffer;
        this.lastBuffer = null;
        if (this.fBufferFactory != this.firstBuffer.factory) {
            if (this.fBufferFactory != null) {
                this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            }
            this.fBufferFactory = this.firstBuffer.factory;
            this.fBufferFactory.addReferrer(this.fBufferReferrer);
        }
        this.fBufferReferrer.active = true;
    }

    public final void setEndPos(DataBuffer dataBuffer, int n) {
        this.setEndPos(dataBuffer, n, 0);
    }

    public final void setEndPos(DataBuffer dataBuffer, int n, int n2) {
        this.flags = n2;
        while (dataBuffer != this.firstBuffer) {
            if (this.startOffset < this.firstBuffer.endOffset) {
                if (n > dataBuffer.startOffset) {
                    this.setEndPosAcrossBuffers(dataBuffer, n);
                    return;
                }
                dataBuffer = this.fixEndPos(dataBuffer);
                n = dataBuffer.endOffset;
                continue;
            }
            this.fixStartPos();
        }
        this.endOffset = n;
        this.length = n - this.startOffset;
        this.bytes = dataBuffer.bytes;
        this.lastBuffer = null;
    }

    public void clearEndPos() {
        this.bytes = null;
        this.lastBuffer = null;
    }

    private final void setEndPosAcrossBuffers(DataBuffer dataBuffer, int n) {
        this.bytes = null;
        DataBuffer dataBuffer2 = this.firstBuffer;
        this.length = dataBuffer2.endOffset - this.startOffset;
        while ((dataBuffer2 = dataBuffer2.next) != dataBuffer) {
            this.length += dataBuffer2.endOffset - dataBuffer2.startOffset;
        }
        this.length += n - dataBuffer2.startOffset;
        this.lastBuffer = dataBuffer2;
        this.endOffset = n;
    }

    private final void fixStartPos() {
        this.firstBuffer = this.firstBuffer.next;
        this.startOffset = this.firstBuffer.startOffset;
    }

    private final DataBuffer fixEndPos(DataBuffer dataBuffer) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        while (dataBuffer2.next != dataBuffer) {
            dataBuffer2 = dataBuffer2.next;
        }
        return dataBuffer2;
    }

    public void setValues(XMLString xMLString) {
        if (xMLString != null && xMLString.firstBuffer != null) {
            this.bytes = xMLString.bytes;
            this.startOffset = xMLString.startOffset;
            this.endOffset = xMLString.endOffset;
            this.length = xMLString.length;
            this.flags = xMLString.flags;
            this.hashcode = xMLString.hashcode;
            this.firstBuffer = xMLString.firstBuffer;
            this.lastBuffer = xMLString.lastBuffer;
            if (this.fBufferFactory != this.firstBuffer.factory) {
                if (this.fBufferFactory != null) {
                    this.fBufferFactory.removeReferrer(this.fBufferReferrer);
                }
                this.fBufferFactory = this.firstBuffer.factory;
                this.fBufferFactory.addReferrer(this.fBufferReferrer);
            }
            this.fBufferReferrer.active = true;
        } else {
            this.clear();
        }
    }

    public final boolean isAllWhitespace() {
        if ((this.flags & 2) != 0) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            return false;
        }
        return this.checkWhitespace();
    }

    private boolean checkWhitespace() {
        boolean bl;
        boolean bl2 = bl = (this.flags & 8) != 0;
        if (this.length > 0) {
            int n = this.startOffset;
            if (this.bytes != null) {
                while (n < this.endOffset) {
                    byte by;
                    if ((by = this.bytes[n++]) == 32 || by == 10 || by == 9 || by == 13) continue;
                    if (bl && (by & 0xDF) == 194) {
                        if (n == this.endOffset) {
                            this.flags |= 1;
                            return false;
                        }
                        if ((by & 0xFF) == 194 && (this.bytes[n] & 0xFF) == 133) {
                            ++n;
                            continue;
                        }
                        if ((by & 0xFF) != 226 || (this.bytes[n] & 0xFF) != 128) continue;
                        if (n + 1 < this.endOffset) {
                            if ((this.bytes[n + 1] & 0xFF) != 168) continue;
                            n += 2;
                            continue;
                        }
                        this.flags |= 1;
                        return false;
                    }
                    this.flags |= 1;
                    return false;
                }
            } else {
                DataBuffer dataBuffer = this.firstBuffer;
                byte[] byArray = dataBuffer.bytes;
                int n2 = dataBuffer.endOffset;
                while (true) {
                    if (n < n2) {
                        byte by;
                        if ((by = byArray[n++]) == 32 || by == 10 || by == 9 || by == 13) continue;
                        if (bl && (by & 0xDF) == 194) {
                            if (n == n2) {
                                if (dataBuffer == this.lastBuffer) {
                                    this.flags |= 1;
                                    return false;
                                }
                                dataBuffer = dataBuffer.next;
                                byArray = dataBuffer.bytes;
                                n = dataBuffer.startOffset;
                                int n3 = n2 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                            }
                            if ((by & 0xFF) == 194 && (byArray[n] & 0xFF) == 133) {
                                ++n;
                                continue;
                            }
                            if ((by & 0xFF) != 226 || (byArray[n] & 0xFF) != 128) continue;
                            if (n + 1 < n2) {
                                if ((byArray[n + 1] & 0xFF) != 168) continue;
                                n += 2;
                                continue;
                            }
                            if (dataBuffer != this.lastBuffer && (dataBuffer.next.bytes[dataBuffer.next.startOffset] & 0xFF) == 168) {
                                dataBuffer = dataBuffer.next;
                                byArray = dataBuffer.bytes;
                                n = dataBuffer.startOffset + 1;
                                n2 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                                continue;
                            }
                            this.flags |= 1;
                            return false;
                        }
                        this.flags |= 1;
                        return false;
                    }
                    if (dataBuffer == this.lastBuffer) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    if (dataBuffer == this.lastBuffer) {
                        n2 = this.endOffset;
                        continue;
                    }
                    n2 = dataBuffer.endOffset;
                }
            }
        }
        this.flags |= 2;
        return true;
    }

    public final boolean isNormalized() {
        byte by;
        if (this.length == 0) {
            return true;
        }
        if (this.bytes != null) {
            int n = this.startOffset;
            while (n < this.endOffset) {
                byte by2 = this.bytes[n];
                if (by2 < 0 || by2 > 32) {
                    while ((by2 < 0 || by2 > 32) && ++n < this.endOffset) {
                        by2 = this.bytes[n];
                    }
                    if (n >= this.endOffset || by2 >= 32 && ++n != this.endOffset) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n = this.startOffset;
        int n2 = dataBuffer.endOffset;
        while ((by = byArray[n]) < 0 || by > 32) {
            while (by < 0 || by > 32) {
                if (++n < n2) {
                    by = byArray[n];
                    continue;
                }
                if (dataBuffer == this.lastBuffer) {
                    return true;
                }
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                by = byArray[n];
            }
            if (by < 32) {
                return false;
            }
            if (++n != n2) continue;
            if (dataBuffer == this.lastBuffer) {
                return false;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n = dataBuffer.startOffset;
            if (dataBuffer == this.lastBuffer) {
                n2 = this.endOffset;
                continue;
            }
            n2 = dataBuffer.endOffset;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected final boolean equalsXMLString(XMLString var1_1) {
        block6: {
            block7: {
                if (var1_1 == this) {
                    return true;
                }
                if (this.length <= 0 || this.length != var1_1.length) break block6;
                if (this.bytes == null || var1_1.bytes == null) break block7;
                var2_2 = this.length;
                if (this.bytes[this.startOffset] == var1_1.bytes[var1_1.startOffset]) ** GOTO lbl10
                return false;
lbl-1000:
                // 1 sources

                {
                    if (this.bytes[this.startOffset + var2_2] == var1_1.bytes[var1_1.startOffset + var2_2]) continue;
                    return false;
lbl10:
                    // 2 sources

                    ** while (--var2_2 > 0)
                }
lbl11:
                // 1 sources

                return true;
            }
            var2_3 = this.firstBuffer;
            var3_4 = var1_1.firstBuffer;
            var4_5 = var2_3.bytes;
            var6_7 = this.startOffset;
            var5_6 = var3_4.bytes;
            var7_8 = var1_1.startOffset;
            if (var4_5[var6_7] != var5_6[var7_8]) {
                return false;
            }
            var8_9 = this.lastBuffer != null ? this.lastBuffer : var2_3;
            var9_10 = var1_1.lastBuffer != null ? var1_1.lastBuffer : var3_4;
            var10_11 = this.lastBuffer != null ? var2_3.endOffset : this.endOffset;
            var11_12 = var1_1.lastBuffer != null ? var3_4.endOffset : var1_1.endOffset;
            var12_13 = this.length;
            while (--var12_13 > 0) {
                if (++var6_7 == var10_11) {
                    var2_3 = var2_3.next;
                    var4_5 = var2_3.bytes;
                    var6_7 = var2_3.startOffset;
                    v0 = var10_11 = var2_3 != var8_9 ? var2_3.endOffset : this.endOffset;
                }
                if (++var7_8 == var11_12) {
                    var3_4 = var3_4.next;
                    var5_6 = var3_4.bytes;
                    var7_8 = var3_4.startOffset;
                    v1 = var11_12 = var3_4 != var9_10 ? var3_4.endOffset : var1_1.endOffset;
                }
                if (var4_5[var6_7] == var5_6[var7_8]) continue;
                return false;
            }
            return true;
        }
        return this.length == var1_1.length;
    }

    protected final boolean equalsString(String string) {
        int n = this.startOffset;
        if (this.bytes != null) {
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c == this.bytes[n]) {
                    ++n;
                } else {
                    if (c < '\u0080') {
                        return false;
                    }
                    return this.toString().equals(string);
                }
                ++n3;
            }
            return n == this.endOffset;
        }
        return this.toString().equals(string);
    }

    public final boolean equalsString(byte[] byArray, int n, int n2) {
        if (n + this.length == n2) {
            if (this.length > 0) {
                int n3 = this.startOffset;
                if (this.bytes != null) {
                    while (this.bytes[n3++] == byArray[n] && ++n < n2) {
                    }
                    return n == n2;
                }
                DataBuffer dataBuffer = this.firstBuffer;
                while (true) {
                    int n4;
                    byte[] byArray2 = dataBuffer.bytes;
                    int n5 = n4 = dataBuffer != this.lastBuffer ? dataBuffer.endOffset : this.endOffset;
                    while (byArray2[n3] == byArray[n++] && ++n3 < n4) {
                    }
                    if (n3 != n4) break;
                    if (dataBuffer == this.lastBuffer) {
                        return true;
                    }
                    dataBuffer = dataBuffer.next;
                    n3 = dataBuffer.startOffset;
                }
                return false;
            }
            return n == n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        int n = this.startOffset;
        if (this.bytes != null) {
            while (n < this.endOffset) {
                CharConversionError charConversionError;
                byte by = this.bytes[n];
                if (by >= 0) {
                    this.hashcode = this.hashcode * 31 + by;
                    ++n;
                    continue;
                }
                if (this.fMultiByteCharInfo == null) {
                    this.fMultiByteCharInfo = new int[2];
                }
                if ((charConversionError = UTF8Support.decodeCharacter(this.bytes, n, this.endOffset, this.fMultiByteCharInfo)) == null) {
                    int n2 = this.fMultiByteCharInfo[0];
                    if (n2 < 65536) {
                        this.hashcode = this.hashcode * 31 + n2;
                    } else {
                        int n3 = n2 - 65536;
                        n2 = 55296 + (n3 >> 10);
                        this.hashcode = this.hashcode * 31 + n2;
                        n2 = 56320 + (n3 & 0x3FF);
                        this.hashcode = this.hashcode * 31 + n2;
                    }
                    n += this.fMultiByteCharInfo[1];
                    continue;
                }
                UntestedCode.needTest("error?");
                throw new RuntimeException("need test");
            }
            return this.hashcode;
        } else {
            DataBuffer dataBuffer = this.firstBuffer;
            block1: while (true) {
                int n4;
                byte[] byArray = dataBuffer.bytes;
                int n5 = n4 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                while (true) {
                    CharConversionError charConversionError;
                    byte by;
                    if ((by = byArray[n]) >= 0) {
                        this.hashcode = this.hashcode * 31 + by;
                        if (++n != n4) continue;
                        if (dataBuffer == this.lastBuffer) return this.hashcode;
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                        continue block1;
                    }
                    if (this.fMultiByteCharInfo == null) {
                        this.fMultiByteCharInfo = new int[2];
                    }
                    if ((charConversionError = UTF8Support.decodeCharacter(dataBuffer, n, this.lastBuffer, this.endOffset, this.fMultiByteCharInfo)) != null) break block1;
                    int n6 = this.fMultiByteCharInfo[0];
                    if (n6 < 65536) {
                        this.hashcode = this.hashcode * 31 + n6;
                    } else {
                        int n7 = n6 - 65536;
                        n6 = 55296 + (n7 >> 10);
                        this.hashcode = this.hashcode * 31 + n6;
                        n6 = 56320 + (n7 & 0x3FF);
                        this.hashcode = this.hashcode * 31 + n6;
                    }
                    if ((n += this.fMultiByteCharInfo[1]) == n4) {
                        if (dataBuffer == this.lastBuffer) return this.hashcode;
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                        continue block1;
                    }
                    if (n >= n4) break;
                }
                if (dataBuffer == this.lastBuffer) return this.hashcode;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset + (n - n4);
                if (dataBuffer == this.lastBuffer && n == this.endOffset) return this.hashcode;
            }
            UntestedCode.needTest("error?");
            throw new RuntimeException("need test");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XMLString) {
            return this.equalsXMLString((XMLString)object);
        }
        if (object instanceof String) {
            return this.equalsString((String)object);
        }
        return false;
    }

    public XMLString normalizeLineBreaks(XMLStringBuffer xMLStringBuffer, XMLString xMLString) {
        if (this.firstBuffer != null && (this.flags & 0xC) != 0) {
            return xMLStringBuffer.addXMLString(this, xMLString);
        }
        return this;
    }

    public final CharConversionError getChars(char[][] cArray, int[] nArray) {
        if (this.firstBuffer != null && (this.bytes != null || this.lastBuffer != null)) {
            if ((this.flags & 0xC) != 0) {
                return UTF8Support.normalizeBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray, (this.flags & 8) != 0);
            }
            return UTF8Support.convertBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray);
        }
        return null;
    }

    public final int lengthAsCharacters(int[] nArray) {
        return UTF8Support.lengthAsCharacters(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, this.flags, nArray);
    }

    public final String toString() {
        if (this.firstBuffer != null && (this.bytes != null || this.lastBuffer != null)) {
            CharConversionError charConversionError = this.convertToChars();
            if (charConversionError == null) {
                return new String(this.fConvertedChars[0], 0, this.fConvertedCharsOffset[0]);
            }
            return null;
        }
        return null;
    }

    protected final CharConversionError convertToChars() {
        if (this.fConvertedChars == null) {
            int n = 16;
            while (n < this.length) {
                n <<= 1;
            }
            this.fConvertedChars = new char[1][];
            this.fConvertedChars[0] = new char[n];
            this.fConvertedCharsOffset = new int[1];
        }
        this.fConvertedCharsOffset[0] = 0;
        return this.getChars(this.fConvertedChars, this.fConvertedCharsOffset);
    }
}

