/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xcollator;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.SearchIterator;
import com.ibm.icu.text.StringSearch;
import com.ibm.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xtq.xml.xcollator.CollatorImplBase;
import com.ibm.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xtq.xml.xcollator.Messages;
import com.ibm.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xtq.xml.xcollator.ParamDecomposition;
import com.ibm.xtq.xml.xcollator.ParamStrength;
import com.ibm.xtq.xml.xcollator.Range;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

final class ICUCollator
extends CollatorImplBase {
    private static final Locale[] s_Locales = RuleBasedCollator.getAvailableLocales();
    private static final ArrayList s_LocaleNames = new ArrayList();
    private final RuleBasedCollator m_collator;
    private final SearchIterator m_search;

    ICUCollator(CollatorDeclarationImpl collatorDeclarationImpl) {
        super(collatorDeclarationImpl, LocaleUtility.IETFToValidLocale(collatorDeclarationImpl.getLanguage(), s_Locales, s_LocaleNames));
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)Collator.getInstance((Locale)this.m_locale);
        ICUCollator.setDecomposition(ruleBasedCollator, collatorDeclarationImpl.getDecompositionType());
        ICUCollator.setStrength(ruleBasedCollator, collatorDeclarationImpl.getStrengthType());
        ruleBasedCollator = ICUCollator.setRules(ruleBasedCollator, collatorDeclarationImpl.getRules(), this.m_messages);
        ICUCollator.setCaseOrder(ruleBasedCollator, collatorDeclarationImpl.getCaseOrderType());
        this.m_collator = ruleBasedCollator;
        this.m_search = new StringSearch("pat", (CharacterIterator)new StringCharacterIterator("t"), this.m_collator);
    }

    @Override
    public Object getComparator(String string) {
        return this.m_collator.getCollationKey(string);
    }

    @Override
    public int compare(Object object, Object object2) {
        int n = 0;
        n = object instanceof CollationKey && object2 instanceof CollationKey ? ((CollationKey)object).compareTo((CollationKey)object2) : this.m_collator.compare((String)object, (String)object2);
        return ICUCollator.formatCompareReturn(n);
    }

    private static final RuleBasedCollator setRules(RuleBasedCollator ruleBasedCollator, String string, Stack stack) {
        if (string != null) {
            String string2 = ruleBasedCollator.getRules();
            try {
                ruleBasedCollator = new RuleBasedCollator(string2 + string);
            }
            catch (Exception exception) {
                String string3 = Messages.createMessage("INVALID_ATTR_VALUE_IGNORED", new Object[]{"rules", string});
                Messages.Message message = new Messages.Message(string3, 3);
                stack.push(message);
            }
        }
        return ruleBasedCollator;
    }

    private static void setDecomposition(RuleBasedCollator ruleBasedCollator, ParamDecomposition paramDecomposition) {
        if (paramDecomposition != null) {
            int n = paramDecomposition == ParamDecomposition.NO ? 16 : (paramDecomposition == ParamDecomposition.CANONICAL ? 17 : (paramDecomposition == ParamDecomposition.FULL ? 17 : 17));
            ruleBasedCollator.setDecomposition(n);
        }
    }

    private static void setStrength(RuleBasedCollator ruleBasedCollator, ParamStrength paramStrength) {
        if (paramStrength != null) {
            int n = -1;
            if (paramStrength == ParamStrength.PRIMARY) {
                n = 0;
            } else if (paramStrength == ParamStrength.SECONDARY) {
                n = 1;
            } else if (paramStrength == ParamStrength.TERTIARY) {
                n = 2;
            } else if (paramStrength == ParamStrength.IDENTICAL) {
                n = 15;
            }
            ruleBasedCollator.setStrength(n);
        }
    }

    private static void setCaseOrder(RuleBasedCollator ruleBasedCollator, ParamCaseOrder paramCaseOrder) {
        if (paramCaseOrder == null) {
            return;
        }
        if (paramCaseOrder == ParamCaseOrder.UPPER_FIRST) {
            ruleBasedCollator.setUpperCaseFirst(true);
        } else if (paramCaseOrder == ParamCaseOrder.LOWER_FIRST) {
            ruleBasedCollator.setLowerCaseFirst(true);
        }
    }

    @Override
    Range[] allOccurances(String string, String string2) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        ((StringSearch)this.m_search).setPattern(string2);
        this.m_search.setTarget((CharacterIterator)stringCharacterIterator);
        this.m_search.setOverlapping(true);
        Vector<Range> vector = null;
        int n = -1;
        int n2 = this.m_search.first();
        while (n2 != -1) {
            n = this.m_search.getMatchLength();
            if (n > 0) {
                if (vector == null) {
                    vector = new Vector<Range>();
                }
                vector.add(new Range(n2, n2 + n));
            }
            n2 = this.m_search.next();
        }
        Range[] rangeArray = vector == null ? null : ICUCollator.convertFromVector(vector);
        return rangeArray;
    }

    @Override
    Range firstOccurance(String string, String string2) {
        Range range = null;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        ((StringSearch)this.m_search).setPattern(string2);
        this.m_search.setTarget((CharacterIterator)stringCharacterIterator);
        this.m_search.setOverlapping(true);
        int n = -1;
        int n2 = this.m_search.first();
        while (n2 != -1) {
            n = this.m_search.getMatchLength();
            if (n > 0) {
                range = new Range(n2, n2 + n);
                break;
            }
            n2 = this.m_search.next();
        }
        return range;
    }

    @Override
    Range lastOccurance(String string, String string2) {
        Range range = null;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        ((StringSearch)this.m_search).setPattern(string2);
        this.m_search.setTarget((CharacterIterator)stringCharacterIterator);
        this.m_search.setOverlapping(true);
        int n = -1;
        int n2 = this.m_search.first();
        while (n2 != -1) {
            n = this.m_search.getMatchLength();
            if (n > 0) {
                range = new Range(n2, n2 + n);
            }
            n2 = this.m_search.next();
        }
        return range;
    }

    static Locale getLocaleSupported(String string) {
        Locale locale = LocaleUtility.stringToLocale(string, s_Locales, s_LocaleNames);
        return locale;
    }

    static {
        for (int i = 0; i < s_Locales.length; ++i) {
            s_LocaleNames.add(s_Locales[i].toString());
        }
    }
}

