/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.xslt.drivers.Linker;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class StandaloneXSLTCompilerLinker {
    static final Logger s_logger = Logger.getInstance(StandaloneXSLTCompilerLinker.class);

    public static void main(String[] stringArray) {
        Serializable serializable;
        LogManager.initializeLogger();
        if (stringArray.length == 0) {
            s_logger.info("Usage: StandaloneXSLTCompilerLinker\n        [-split n]\n        [-dumpxylem]\n        [-disablejavac]\n        [-classloaderproxy]\n        [-standardserializer]\n        [-generateBCEL]\n        [-suppressComments]\n        filename+ | -command file-with-list-of-filenames");
            return;
        }
        int n = 0;
        XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = Linker.parseOptions(xSLTLinkerSettings, stringArray, n, s_logger);
            if (n2 > 0) {
                n = n2 + 1;
                continue;
            }
            if (string.equals("-split")) {
                if (++n == stringArray.length) {
                    s_logger.error("-split requires parameter");
                    return;
                }
                xSLTCompilerSettings.setPrereductionSplitLimit(Integer.parseInt(stringArray[n++]));
                continue;
            }
            if (string.equals("-newsplit")) {
                if (++n == stringArray.length) {
                    s_logger.error("-newsplit missing parameter");
                    return;
                }
                try {
                    xSLTLinkerSettings.getCodeGenerationSettings().setPostReductionSplitLimit(Integer.parseInt(stringArray[n]));
                }
                catch (NumberFormatException numberFormatException) {
                    s_logger.error("invalid split limit: " + stringArray[n]);
                    return;
                }
                ++n;
                continue;
            }
            if (string.equals("-dumpxylem")) {
                xSLTLinkerSettings.setDumpXylem(true);
                ++n;
                continue;
            }
            if (string.equals("-disablejavac")) {
                xSLTLinkerSettings.getCodeGenerationSettings().getJavaCSettings().setJavaCDisabled(true);
                ++n;
                continue;
            }
            if (string.equals("-classloaderproxy")) {
                xSLTLinkerSettings.setGenerateClassLoadingProxy(true);
                ++n;
                continue;
            }
            if (string.equals("-standardserializer")) {
                xSLTCompilerSettings.setStreamResultOnly(false);
                ++n;
                continue;
            }
            if (string.equals("-generateBCEL")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setTargetLanguage(2);
                ++n;
                continue;
            }
            if (string.equals("-suppressComments")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setSuppressComments(true);
                ++n;
                continue;
            }
            if (string.equals("-xhtmlCompatability")) {
                xSLTCompilerSettings.setXHTMLCompatability(true);
                ++n;
                continue;
            }
            if (!string.equals("-command")) break;
            if (++n == stringArray.length) {
                s_logger.error("-command requires parameter");
                return;
            }
            try {
                String string2;
                serializable = new ArrayList();
                FileReader fileReader = new FileReader(stringArray[n]);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0) continue;
                    ((ArrayList)serializable).add(string2);
                }
                bufferedReader.close();
                fileReader.close();
            }
            catch (IOException iOException) {
                s_logger.error("Could not read command file " + stringArray[n], iOException);
                return;
            }
            stringArray = ((ArrayList)serializable).toArray(new String[0]);
            n = 0;
            break;
        }
        try {
            for (int i = 0; i < stringArray.length - n; ++i) {
                String string = null;
                try {
                    serializable = new File(stringArray[i + n]);
                    if (stringArray[(i += 2) + n - 1].equals("-classname")) {
                        string = stringArray[n + i];
                        if (i == stringArray.length) {
                            s_logger.error("-classname missing parameter");
                            throw new RuntimeException();
                        }
                    }
                    XSLTLinker.compileStylesheet(((File)serializable).toURL(), string, xSLTCompilerSettings, xSLTLinkerSettings);
                    continue;
                }
                catch (Throwable throwable) {
                    s_logger.error(throwable);
                }
            }
            s_logger.info("Done");
        }
        catch (Exception exception) {
            s_logger.error("", exception);
        }
    }
}

