/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.IBinding;
import com.ibm.xylem.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

public final class BindingEnvironment
implements Serializable {
    private static final long serialVersionUID = 4270935933497681989L;
    protected HashMap m_variableTypes;
    public BindingEnvironment m_parent;
    private static final Logger s_logger = Logger.getInstance(BindingEnvironment.class);

    public BindingEnvironment() {
        this(null);
    }

    public BindingEnvironment(BindingEnvironment bindingEnvironment) {
        this.m_parent = bindingEnvironment;
    }

    public int getSize() {
        return this.m_variableTypes.size();
    }

    public void prepareHashMap() {
        this.prepareHashMap(64);
    }

    public void prepareHashMap(int n) {
        this.m_variableTypes = new HashMap(n);
    }

    public BindingEnvironment(BindingEnvironment bindingEnvironment, IBinding iBinding) {
        this.m_parent = bindingEnvironment;
        this.m_variableTypes = new HashMap(2);
        this.setVariableBinding(iBinding);
    }

    public void setVariableBinding(IBinding iBinding) {
        if (this.m_variableTypes == null) {
            this.m_variableTypes = new HashMap();
        }
        this.m_variableTypes.put(iBinding.getName(), iBinding);
    }

    public IBinding getVariableBinding(Object object) {
        IBinding iBinding;
        block2: {
            BindingEnvironment bindingEnvironment = this;
            do {
                iBinding = null;
                if (bindingEnvironment.m_variableTypes != null) {
                    iBinding = (IBinding)bindingEnvironment.m_variableTypes.get(object);
                }
                if (iBinding != null || bindingEnvironment.m_parent == null) break block2;
            } while ((bindingEnvironment = bindingEnvironment.m_parent) != null);
            return null;
        }
        return iBinding;
    }

    public void accumulateAvailableBindings(Set set) {
        if (this.m_variableTypes != null) {
            set.addAll(this.m_variableTypes.values());
        }
        if (this.m_parent != null) {
            this.m_parent.accumulateAvailableBindings(set);
        }
    }

    public String toString() {
        if (null == this.m_variableTypes) {
            return "#" + this.hashCode() + ": []";
        }
        return "#" + this.hashCode() + ": " + new TreeSet(this.m_variableTypes.keySet()).toString();
    }

    public void dump() {
        if (!s_logger.isDebugEnabled()) {
            return;
        }
        s_logger.debug("<BE.dump> " + this);
        for (Object k : this.m_variableTypes.keySet()) {
            s_logger.debug("  key=" + k + " value='" + this.m_variableTypes.get(k) + "'");
        }
        s_logger.debug("</BE.dump>");
    }

    public void unregisterBinding(Object object) {
        this.m_variableTypes.remove(object);
    }
}

