/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.ILUBResolver;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.LUBConstraint;
import com.ibm.xylem.Module;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.ForwardTypeReference;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class TypeEnvironment
implements Serializable {
    private static final long serialVersionUID = 6412426351623830994L;
    protected HashMap m_typeVariableAssignments;
    protected HashMap m_typeVariableEquivalenceClasses;
    public TypeEnvironment m_original;
    protected Module m_program;
    public Instruction m_parseInstruction;

    public String toString() {
        return this.m_typeVariableAssignments.toString();
    }

    public TypeEnvironment(Module module) {
        this.m_program = module;
        this.m_typeVariableAssignments = new HashMap(5, 10.0f);
        this.m_typeVariableEquivalenceClasses = new HashMap(5, 10.0f);
        this.m_original = this;
    }

    public Module getModule() {
        return this.m_program;
    }

    public Object clone() {
        TypeEnvironment typeEnvironment = new TypeEnvironment(this.m_program, this);
        return typeEnvironment;
    }

    public TypeEnvironment copy() {
        TypeEnvironment typeEnvironment = new TypeEnvironment(this.m_program);
        try {
            typeEnvironment.incorporate(this);
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
            throw new RuntimeException();
        }
        return typeEnvironment;
    }

    protected TypeEnvironment(Module module, TypeEnvironment typeEnvironment) {
        this.m_original = typeEnvironment.m_original;
        this.m_program = module;
        this.m_typeVariableAssignments = (HashMap)typeEnvironment.m_typeVariableAssignments.clone();
        this.m_typeVariableEquivalenceClasses = (HashMap)typeEnvironment.m_typeVariableEquivalenceClasses.clone();
    }

    public Type resolveTypeVariable(TypeVariable typeVariable) {
        Type type = (Type)this.m_typeVariableAssignments.get(typeVariable);
        if (type == null && this.m_original != this && this.m_original != null) {
            type = this.m_original.resolveTypeVariable(typeVariable);
        }
        return type;
    }

    public boolean areTypeVariablesInSameEquivalenceClass(TypeVariable typeVariable, TypeVariable typeVariable2) {
        Type type = (Type)this.m_typeVariableAssignments.get(typeVariable);
        Type type2 = (Type)this.m_typeVariableAssignments.get(typeVariable2);
        if (type == null && type2 == null) {
            Set set = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable);
            Set set2 = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable2);
            if (set == null || set2 == null) {
                return false;
            }
            return set.contains(typeVariable2);
        }
        return false;
    }

    protected final void markTypeVariablesAsEquivalent(TypeVariable typeVariable, TypeVariable typeVariable2, Instruction instruction) throws TypeCheckException {
        Type type = (Type)this.m_typeVariableAssignments.get(typeVariable);
        Type type2 = (Type)this.m_typeVariableAssignments.get(typeVariable2);
        if (type == null && type2 == null) {
            HashSet<TypeVariable> hashSet = (HashSet<TypeVariable>)this.m_typeVariableEquivalenceClasses.get(typeVariable);
            Set set = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable2);
            if (hashSet == null) {
                if (set == null) {
                    hashSet = new HashSet<TypeVariable>();
                    hashSet.add(typeVariable);
                    hashSet.add(typeVariable2);
                    this.m_typeVariableEquivalenceClasses.put(typeVariable, hashSet);
                    this.m_typeVariableEquivalenceClasses.put(typeVariable2, hashSet);
                    return;
                }
                set.add(typeVariable);
                this.m_typeVariableEquivalenceClasses.put(typeVariable, set);
                return;
            }
            if (set == null) {
                hashSet.add(typeVariable2);
                this.m_typeVariableEquivalenceClasses.put(typeVariable2, hashSet);
                return;
            }
            hashSet.addAll(set);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.m_typeVariableEquivalenceClasses.put(iterator.next(), hashSet);
            }
            return;
        }
        if (type != null && type2 != null) {
            this.unify(type, type2, instruction);
            return;
        }
        if (type == null && type2 != null) {
            Set set = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable);
            if (set == null) {
                this.assignTypeVariable(typeVariable, type2);
                return;
            }
            this.assignTypeToEquivalenceClass(set, type2);
            return;
        }
        if (type != null && type2 == null) {
            Set set = (Set)this.m_typeVariableEquivalenceClasses.get(typeVariable2);
            if (set == null) {
                this.assignTypeVariable(typeVariable2, type);
                return;
            }
            this.assignTypeToEquivalenceClass(set, type);
            return;
        }
    }

    protected final void assignTypeToEquivalenceClass(Set set, Type type) {
        for (Object e : set) {
            if (!(type instanceof StreamType) || ((StreamType)type).getElementType().equals(e)) {
                // empty if block
            }
            this.assignTypeVariable((TypeVariable)e, type);
            this.m_typeVariableEquivalenceClasses.remove(e);
        }
    }

    final void assignTypeVariable(TypeVariable typeVariable, Type type) {
        if (TypeEnvironment.contains(type, typeVariable)) {
            throw new XylemError("ERR_SYSTEM", "One type contains another: " + type + " contains " + typeVariable);
        }
        this.m_typeVariableAssignments.put(typeVariable, type);
    }

    static final boolean contains(Type type, TypeVariable typeVariable) {
        if (type.equals(typeVariable)) {
            return true;
        }
        int n = type.getChildTypeCount();
        for (int i = 0; i < n; ++i) {
            if (!TypeEnvironment.contains(type.getChildType(i), typeVariable)) continue;
            return true;
        }
        return false;
    }

    public boolean resolveLUBConstraints(Set hashSet, ILUBResolver iLUBResolver, boolean bl) throws TypeCheckException {
        if (hashSet.isEmpty()) {
            return true;
        }
        HashSet hashSet2 = new HashSet();
        hashSet2.addAll(hashSet);
        hashSet = hashSet2;
        Set set = iLUBResolver.getTops();
        do {
            LUBConstraint lUBConstraint;
            int n = hashSet.size();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                lUBConstraint = (LUBConstraint)iterator.next();
                HashSet hashSet3 = new HashSet();
                Type type = null;
                for (Object e : lUBConstraint.m_set) {
                    Type type2 = ((Type)e).resolveType(this);
                    if (type2 != null) {
                        if (!set.contains(type = type != null ? iLUBResolver.lub(type, type2) : type2)) continue;
                        break;
                    }
                    Object v = this.m_typeVariableEquivalenceClasses.get(lUBConstraint.m_t);
                    Object v2 = this.m_typeVariableEquivalenceClasses.get(e);
                    if (v != null && v2 != null && v.equals(v2)) continue;
                    hashSet3.add(e);
                }
                if (type != null && (set.contains(type) || hashSet3.isEmpty())) {
                    this.unify(lUBConstraint.m_t, type, null);
                    iterator.remove();
                    continue;
                }
                lUBConstraint.m_set = hashSet3;
                if (hashSet3.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                if (type == null) continue;
                hashSet3.add(type);
            }
            if (n != hashSet.size() || n <= 0) continue;
            if (bl) {
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    lUBConstraint = (LUBConstraint)iterator.next();
                    if (lUBConstraint.m_t.resolveType(this) == null) {
                        this.unify(lUBConstraint.m_t, iLUBResolver.getDefaultTop(), null);
                    }
                    iterator.remove();
                }
                return true;
            }
            return false;
        } while (!hashSet.isEmpty());
        this.sanityCheck();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unify(Type type, Type type2, Instruction instruction) throws TypeCheckException {
        if (type == null) throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Null-valued type in unification of '" + type + "','" + type2 + "'"), instruction);
        if (type2 == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Null-valued type in unification of '" + type + "','" + type2 + "'"), instruction);
        }
        if (type instanceof TypeVariable) {
            if (type2 instanceof TypeVariable) {
                this.markTypeVariablesAsEquivalent((TypeVariable)type, (TypeVariable)type2, instruction);
                return;
            }
            Type type3 = (Type)this.m_typeVariableAssignments.get(type);
            if (type3 != null) {
                this.unify(type3, type2, instruction);
                return;
            }
            Set set = (Set)this.m_typeVariableEquivalenceClasses.get(type);
            if (set == null) {
                this.assignTypeVariable((TypeVariable)type, type2);
                return;
            }
            this.assignTypeToEquivalenceClass(set, type2);
            return;
        }
        if (type2 instanceof TypeVariable) {
            Type type4 = (Type)this.m_typeVariableAssignments.get(type2);
            if (type4 != null) {
                this.unify(type, type4, instruction);
                return;
            }
            Set set = (Set)this.m_typeVariableEquivalenceClasses.get(type2);
            if (set == null) {
                this.assignTypeVariable((TypeVariable)type2, type);
                return;
            }
            this.assignTypeToEquivalenceClass(set, type);
            return;
        }
        if (type.getClass() == type2.getClass()) {
            type.unify(this, type2, instruction);
            return;
        }
        if (type.equals(type2)) return;
        if (type instanceof ForwardTypeReference) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unresolved forward referenced type " + type + "."), instruction);
        }
        if (!(type2 instanceof ForwardTypeReference)) throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Expected value of type " + type2.prettyPrint() + " but found type " + type.prettyPrint() + " instead"), instruction);
        throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unresolved forward referenced type " + type2 + "."), instruction);
    }

    protected void sanityCheck() {
    }

    public void redirectFrom(TypeEnvironment typeEnvironment) {
        this.m_typeVariableAssignments = typeEnvironment.m_typeVariableAssignments;
        this.m_typeVariableEquivalenceClasses = typeEnvironment.m_typeVariableEquivalenceClasses;
    }

    public void incorporate(TypeEnvironment typeEnvironment) throws TypeCheckException {
        Type type;
        if (typeEnvironment.m_typeVariableAssignments == this.m_typeVariableAssignments) {
            return;
        }
        for (Object object : typeEnvironment.m_typeVariableAssignments.keySet()) {
            type = (Type)typeEnvironment.m_typeVariableAssignments.get(object);
            this.unify((Type)object, type, null);
        }
        for (Object object : typeEnvironment.m_typeVariableEquivalenceClasses.values()) {
            type = null;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Type type2 = (Type)iterator.next();
                if (type == null) {
                    type = type2;
                    continue;
                }
                this.unify(type, type2, null);
            }
        }
    }
}

