/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.ExtantGenerationState;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.interpreter.Closure;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class ApplyInstruction
extends NaryPrimopInstruction {
    protected Instruction m_lambda;
    private Object m_tailLoopApply = null;
    private IBinding[] m_tailLoopParams = null;
    private boolean m_isPure = true;
    protected LambdaType m_lambdaType;

    public ApplyInstruction() {
    }

    public ApplyInstruction(Instruction instruction, Instruction[] instructionArray, boolean bl) {
        super(instructionArray);
        this.m_lambda = instruction;
        this.m_isPure = bl;
    }

    public ApplyInstruction(Instruction instruction, List list, boolean bl) {
        super(list);
        this.m_lambda = instruction;
        this.m_isPure = bl;
    }

    @Override
    public boolean isPure() {
        return this.m_isPure;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    public Instruction getLambda() {
        return this.m_lambda;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_lambdaType.getReturnType();
        Type type2 = type.resolveType(typeEnvironment);
        return null != type2 ? type2 : type;
    }

    protected void setupType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_lambda.getType(typeEnvironment, bindingEnvironment);
        if (type instanceof LambdaType) {
            this.m_lambdaType = (LambdaType)type;
        } else if (this.m_lambdaType == null) {
            Type[] typeArray = new Type[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                typeArray[i] = new TypeVariable();
            }
            this.m_lambdaType = new LambdaType(typeArray, new TypeVariable(), this.m_isPure);
            try {
                typeEnvironment.unify(this.m_lambdaType, this.m_lambda.getType(typeEnvironment, bindingEnvironment), this);
            }
            catch (TypeCheckException typeCheckException) {
                typeCheckException.printStackTrace();
            }
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        this.setupType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_lambda = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_lambda, bindingEnvironment);
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
        this.setupType(reductionHelper.m_typeEnvironment, bindingEnvironment);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = new TypeVariable();
            typeEnvironment.unify(this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), typeArray[i], this);
        }
        Type type = this.setCachedType(new TypeVariable());
        LambdaType lambdaType = new LambdaType(typeArray, type, this.m_isPure);
        typeEnvironment.unify(this.m_lambda.typeCheck(typeEnvironment, bindingEnvironment, linkedList), lambdaType, this);
        return type;
    }

    @Override
    public Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_lambda;
            }
        }
        return this.m_parameters[n - 1];
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_lambda = instruction;
                break;
            }
            default: {
                this.m_parameters[n - 1] = instruction;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        return new ApplyInstruction(this.m_lambda.cloneWithoutTypeInformation(), instructionArray, this.m_isPure);
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        return new ApplyInstruction(this.m_lambda, instructionArray, this.m_isPure);
    }

    @Override
    public String innerToString() {
        return "apply";
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        if (this.isTailLoopApply()) {
            String string3;
            String string4;
            int n;
            dataFlowCodeGenerationHelper.append("// calling self loop '" + this.m_tailLoopApply + "' via tail recursion\n");
            String[] stringArray = new String[this.m_parameters.length];
            for (n = 0; n < this.m_parameters.length; ++n) {
                string4 = codeGenerationTracker.generateConventionally(this.m_parameters[n], dataFlowCodeGenerationHelper);
                string3 = codeGenerationTracker.generateConventionally(this.m_tailLoopParams[n], dataFlowCodeGenerationHelper, false);
                if (string3 != string4) {
                    for (int i = 0; i < this.m_parameters.length; ++i) {
                        if (string4 != codeGenerationTracker.generateConventionally(this.m_tailLoopParams[i], dataFlowCodeGenerationHelper, false)) continue;
                        String string5 = string4;
                        string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
                        dataFlowCodeGenerationHelper.appendAssignment(string4, codeGenerationTracker.resolveType(this.m_parameters[i]), string5, codeGenerationTracker);
                        break;
                    }
                }
                stringArray[n] = string4;
            }
            for (n = 0; n < this.m_parameters.length; ++n) {
                string4 = stringArray[n];
                string3 = codeGenerationTracker.generateConventionally(this.m_tailLoopParams[n], dataFlowCodeGenerationHelper, false);
                if (string3.equals(string4)) continue;
                dataFlowCodeGenerationHelper.append(string3 + " = " + string4 + ";\n");
            }
            String string6 = "__tailrecurse_loop_" + this.m_tailLoopApply + "__";
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                dataFlowCodeGenerationHelper.append("if (true) {\n");
                dataFlowCodeGenerationHelper.append("continue " + string6 + ";\n");
                dataFlowCodeGenerationHelper.append("}\n");
            } else {
                dataFlowCodeGenerationHelper.append("goto " + string6 + ";\n");
            }
            return "__tailrecurse_loop_" + this.m_tailLoopApply + "_result__";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            String string7 = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
            codeGenerationTracker.resolveType(this.m_parameters[i]).generateParam(stringBuffer, dataFlowCodeGenerationHelper, string7, codeGenerationTracker.getCurrentModule());
            if (i >= this.m_parameters.length - 1) continue;
            stringBuffer.append(", ");
        }
        String string8 = codeGenerationTracker.generateConventionally(this.m_lambda, dataFlowCodeGenerationHelper, false);
        dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string8 + ".invoke(" + stringBuffer.toString() + ")", codeGenerationTracker);
        return string2;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        if (this.isTailLoopApply()) {
            int n;
            for (n = this.m_parameters.length - 1; n >= 0; --n) {
                if (this.m_parameters[n] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n]).getVariable().equals(this.m_tailLoopParams[n].getName())) continue;
                codeGenerationTracker.generateConventionally(this.m_parameters[n], bCELCodeGenerationHelper, instructionHandle, instructionListBuilder);
            }
            for (n = 0; n < this.m_parameters.length; ++n) {
                if (this.m_parameters[n] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n]).getVariable().equals(this.m_tailLoopParams[n].getName())) continue;
                ExtantGenerationState extantGenerationState = (ExtantGenerationState)codeGenerationTracker.getGenerationState(this.m_tailLoopParams[n]);
                instructionListBuilder.appendStore(this.m_tailLoopParams[n].getBindingType(), extantGenerationState.getRegister());
            }
            instructionListBuilder.appendGoto((InstructionHandle)this.m_tailLoopApply);
            return;
        }
        codeGenerationTracker.generateConventionally(this.m_lambda, bCELCodeGenerationHelper, null, instructionListBuilder);
        com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[this.m_parameters.length];
        LambdaType lambdaType = (LambdaType)codeGenerationTracker.resolveType(this.m_lambda);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_parameters[i], bCELCodeGenerationHelper, null, instructionListBuilder);
            typeArray[i] = lambdaType.getElementTypes()[i].getImplementationType(bCELCodeGenerationHelper);
        }
        instructionListBuilder.append(instructionListBuilder.getClassGenerationHelper().m_if.createInvoke(lambdaType.getImplementationName(bCELCodeGenerationHelper), "invoke", lambdaType.getReturnType().getImplementationType(bCELCodeGenerationHelper), typeArray, (short)182));
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Closure closure = (Closure)this.m_lambda.evaluate(environment, function, iDebuggerInterceptor, false);
        Object[] objectArray = new Object[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Object object;
            objectArray[i] = object = this.m_parameters[i].evaluate(environment, function, iDebuggerInterceptor, false);
        }
        Debugger.enterContext(iDebuggerInterceptor, closure);
        Object object = closure.evaluate(environment, objectArray, iDebuggerInterceptor);
        Debugger.leaveContext(iDebuggerInterceptor, closure, object);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_isPure = readObjectFileHelper.readBoolean();
        this.m_lambda = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeBoolean(this.m_isPure);
        writeObjectFileHelper.writeInstruction(this.m_lambda);
    }

    public void setTailLoopApply(Object object, IBinding[] iBindingArray) {
        this.m_tailLoopApply = object;
        this.m_tailLoopParams = iBindingArray;
    }

    public boolean isTailLoopApply() {
        return null != this.m_tailLoopApply;
    }
}

