/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.ClosureGenerationUtilities;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.ILazyStreamFixedIndexOptimizationInstruction;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.LazyStreamFixedIndexOptimizationStyle;
import com.ibm.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.interpreter.Closure;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.LazyStream;
import com.ibm.xylem.optimizers.FindFreeVariables;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.LazyStreamType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TupleType;
import com.ibm.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class BuildLazyStreamInstruction
extends Instruction
implements ISpecialForm,
ILazyStreamFixedIndexOptimizationInstruction {
    protected Instruction m_body;
    protected Binding[] m_hintBindings;
    protected Instruction[] m_initialHints;
    protected Type m_tupleType;
    protected Type m_elementType;

    public BuildLazyStreamInstruction() {
    }

    public BuildLazyStreamInstruction(Instruction[] instructionArray, Object[] objectArray, Instruction instruction) {
        if (instructionArray.length != objectArray.length) {
            throw new IllegalArgumentException();
        }
        this.m_initialHints = instructionArray;
        this.m_hintBindings = new Binding[objectArray.length];
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            this.m_hintBindings[i] = new Binding(objectArray[i], (Type)new TypeVariable(), this);
        }
        this.m_body = instruction;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction) {
        this.m_body = instruction;
    }

    @Override
    public int getChildInstructionCount() {
        return 1 + this.m_initialHints.length;
    }

    @Override
    public Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_body;
            }
        }
        return this.m_initialHints[n - 1];
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_body = instruction;
                break;
            }
            default: {
                this.m_initialHints[n - 1] = instruction;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_initialHints.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_initialHints[i].cloneWithoutTypeInformation();
        }
        BuildLazyStreamInstruction buildLazyStreamInstruction = new BuildLazyStreamInstruction(instructionArray, Binding.getNames(this.m_hintBindings), this.m_body.cloneWithoutTypeInformation());
        if (this.m_tupleType != null) {
            buildLazyStreamInstruction.m_tupleType = this.m_tupleType;
        }
        buildLazyStreamInstruction.m_elementType = this.m_elementType;
        return buildLazyStreamInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        BuildLazyStreamInstruction buildLazyStreamInstruction = new BuildLazyStreamInstruction((Instruction[])this.m_initialHints.clone(), Binding.getNames(this.m_hintBindings), this.m_body.cloneWithoutTypeInformation());
        if (this.m_tupleType != null) {
            buildLazyStreamInstruction.m_tupleType = this.m_tupleType;
        }
        buildLazyStreamInstruction.m_elementType = this.m_elementType;
        return buildLazyStreamInstruction;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[2 + this.m_initialHints.length];
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        for (int i = 0; i < this.m_initialHints.length; ++i) {
            Type type = this.m_initialHints[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            typeArray[i + 2] = type;
            this.m_hintBindings[i].setType(type);
            bindingEnvironment2.setVariableBinding(this.m_hintBindings[i]);
        }
        this.m_elementType = new TypeVariable();
        typeArray[0] = this.m_elementType.getStreamType();
        typeArray[1] = BooleanType.s_booleanType;
        this.m_tupleType = new TupleType(typeArray);
        typeEnvironment.unify(this.m_tupleType, this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList), this);
        return this.setCachedType(new LazyStreamType(this.m_elementType));
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return new LazyStreamType(this.m_elementType);
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            set.remove(this.m_hintBindings[i]);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            set.remove(this.m_hintBindings[i]);
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        for (int i = 0; i < this.m_initialHints.length; ++i) {
            this.m_initialHints[i].typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
            this.m_hintBindings[i].setType(this.m_initialHints[i].getType(typeEnvironment, bindingEnvironment));
            bindingEnvironment.setVariableBinding(this.m_hintBindings[i]);
        }
        this.m_body.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        int n;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        BindingEnvironment bindingEnvironment = codeGenerationTracker.m_bindingEnvironment;
        codeGenerationTracker.generateFreeBindings(this, dataFlowCodeGenerationHelper);
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        LazyStreamType lazyStreamType = (LazyStreamType)codeGenerationTracker.resolveType(this);
        Type type = lazyStreamType.getElementType();
        AbstractDataType.Constructor constructor = ((NamedType)this.m_tupleType).resolveNameToADT(typeEnvironment).getConstructor(0);
        String string3 = lazyStreamType.getImplementationName(dataFlowCodeGenerationHelper);
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        HashSet hashSet = new HashSet();
        this.m_body.accumulateNonLiteralFreeBindings(hashSet, codeGenerationTracker.m_bindingEnvironment);
        String[] stringArray = new String[this.m_initialHints.length];
        Type[] typeArray = new Type[this.m_initialHints.length];
        String[] stringArray2 = new String[this.m_initialHints.length];
        for (n = 0; n < this.m_initialHints.length; ++n) {
            stringArray[n] = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
            typeArray[n] = this.m_hintBindings[n].getBindingType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment);
            dataFlowCodeGenerationHelper.appendAssignment(stringArray[n], typeArray[n], codeGenerationTracker.generateConventionally(this.m_initialHints[n], dataFlowCodeGenerationHelper), codeGenerationTracker);
            stringArray2[n] = dataFlowCodeGenerationHelper.generateNewMemberVariableName();
            codeGenerationTracker2.registerExtantBinding(this.m_hintBindings[n], stringArray2[n]);
            hashSet.remove(this.m_hintBindings[n]);
        }
        dataFlowCodeGenerationHelper.append("final " + string3 + " " + string2 + " = new " + string3 + "() {\n");
        if (dataFlowCodeGenerationHelper.getSettings().isBufferDiagnostics()) {
            dataFlowCodeGenerationHelper.append("{ System.err.println(\">> instantiating new \" + getClass()); }\n");
        }
        for (n = 0; n < this.m_initialHints.length; ++n) {
            dataFlowCodeGenerationHelper.append(typeArray[n].getImplementationName(dataFlowCodeGenerationHelper) + " " + stringArray2[n] + " = " + stringArray[n] + ";\n");
        }
        dataFlowCodeGenerationHelper.append("public final void evaluateMore(int newIndex) {\n");
        dataFlowCodeGenerationHelper.append(type.getImplementationName(dataFlowCodeGenerationHelper) + "[] buffer_stream;\n");
        dataFlowCodeGenerationHelper.append("int buffer_size = m_length;\n");
        dataFlowCodeGenerationHelper.append("if (m_data == null) {\n");
        dataFlowCodeGenerationHelper.append("buffer_stream = new " + type.getImplementationName(dataFlowCodeGenerationHelper) + "[1];\n");
        dataFlowCodeGenerationHelper.append("} else {\n");
        dataFlowCodeGenerationHelper.append("buffer_stream = m_data;\n");
        dataFlowCodeGenerationHelper.append("}\n");
        dataFlowCodeGenerationHelper.append("do {\n");
        if (this.m_body.supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, typeEnvironment, bindingEnvironment)) {
            String string4 = ((IStreamInADTOptimizationInstruction)((Object)this.m_body)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, "buffer", constructor.m_parameters[0], codeGenerationTracker2, true, false);
            dataFlowCodeGenerationHelper.append("if (" + string4 + "_" + constructor.getConstructorQualifiedFieldName(1, dataFlowCodeGenerationHelper) + ") {\nm_complete = true;\n}\n");
            for (int i = 0; i < this.m_initialHints.length; ++i) {
                dataFlowCodeGenerationHelper.append(stringArray2[i] + " = " + string4 + "_" + constructor.getConstructorQualifiedFieldName(2 + i, dataFlowCodeGenerationHelper) + ";\n");
            }
        } else {
            String string5 = this.m_body.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker2, null, false);
            dataFlowCodeGenerationHelper.append("if (" + string5 + "." + constructor.getConstructorQualifiedFieldName(1, dataFlowCodeGenerationHelper) + ") {\nm_complete = true;\n}\n");
            for (int i = 0; i < this.m_initialHints.length; ++i) {
                dataFlowCodeGenerationHelper.append(stringArray2[i] + " = " + string5 + "." + constructor.getConstructorQualifiedFieldName(2 + i, dataFlowCodeGenerationHelper) + ";\n");
            }
            StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, "buffer", type.getStreamType(), string5 + "." + constructor.getConstructorQualifiedFieldName(0, dataFlowCodeGenerationHelper), -1);
        }
        dataFlowCodeGenerationHelper.append("} while (!m_complete && newIndex >= m_length);\n");
        dataFlowCodeGenerationHelper.append("m_data = buffer_stream;\n");
        dataFlowCodeGenerationHelper.append("m_length = buffer_size;\n");
        dataFlowCodeGenerationHelper.append("}\n");
        ClosureGenerationUtilities.generateClosureInitSuffix(string3, hashSet, codeGenerationTracker, dataFlowCodeGenerationHelper, true);
        return string2;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            this.m_initialHints[i] = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_initialHints[i], bindingEnvironment);
        }
        ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            reductionHelper2.upgradeBinding(this.m_hintBindings[i]);
            bindingEnvironment.setVariableBinding(this.m_hintBindings[i]);
        }
        this.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        int n2;
        String string = "build-lazy-stream";
        prettyPrinter.printFormOpen(string, n);
        prettyPrinter.print(" (");
        for (n2 = 0; n2 < this.m_hintBindings.length; ++n2) {
            prettyPrinter.printIdentifier(this.m_hintBindings[n2].getName(), n + 2);
        }
        prettyPrinter.printFormClose(n + 1);
        for (n2 = 0; n2 < this.m_hintBindings.length; ++n2) {
            this.m_initialHints[n2].toString(prettyPrinter, n + 1);
        }
        this.m_body.toString(prettyPrinter, n + 1);
        prettyPrinter.print(")");
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        Object[] objectArray;
        Object object2;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        BindingEnvironment bindingEnvironment = this.evaluateBindingEnvironment(function);
        Set set = FindFreeVariables.findFreeVariables(this);
        Iterator iterator = set.iterator();
        int n = 0;
        IBinding[] iBindingArray = new IBinding[set.size()];
        Object[] objectArray2 = new Object[set.size()];
        while (iterator.hasNext()) {
            object2 = iterator.next();
            objectArray = bindingEnvironment.getVariableBinding(object2);
            iBindingArray[n] = objectArray;
            object = environment.lookupBinding((IBinding)objectArray);
            objectArray2[n++] = object;
        }
        object2 = new Closure(iBindingArray, objectArray2, function, this.m_body, this.m_hintBindings, this.m_sourceFilename, this.m_sourceLineNumber);
        objectArray = new Object[this.m_initialHints.length];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = this.m_initialHints[n].evaluate(environment, function, iDebuggerInterceptor, false);
        }
        object = new LazyStream((Closure)object2, environment, iDebuggerInterceptor, objectArray);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof LazyStreamFixedIndexOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    @Override
    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Object[] objectArray = new Object[this.m_hintBindings.length];
        Instruction[] instructionArray = new Instruction[this.m_hintBindings.length];
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            Object object = iNewNameGenerator.getNewName();
            map.put(this.m_hintBindings[i].getName(), new IdentifierInstruction(object));
            objectArray[i] = object;
            instructionArray[i] = this.m_initialHints[i].assignNewNames(map, iNewNameGenerator);
        }
        BuildLazyStreamInstruction buildLazyStreamInstruction = new BuildLazyStreamInstruction(instructionArray, objectArray, this.m_body.assignNewNames(map, iNewNameGenerator));
        if (this.m_tupleType != null && this.m_tupleType instanceof NamedType) {
            buildLazyStreamInstruction.m_tupleType = this.m_tupleType;
        }
        buildLazyStreamInstruction.m_elementType = this.m_elementType;
        return buildLazyStreamInstruction;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        int n = readObjectFileHelper.readInt();
        this.m_initialHints = new Instruction[n];
        for (int i = 0; i < n; ++i) {
            this.m_initialHints[i] = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
        this.m_hintBindings = readObjectFileHelper.readTypeSpecificBindingSet();
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
        if (readObjectFileHelper.readBoolean()) {
            this.m_tupleType = readObjectFileHelper.readType();
        }
        if (readObjectFileHelper.readBoolean()) {
            this.m_elementType = readObjectFileHelper.readType();
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        int n = this.m_initialHints.length;
        writeObjectFileHelper.writeInt(n);
        for (int i = 0; i < n; ++i) {
            writeObjectFileHelper.writeInstruction(this.m_initialHints[i]);
        }
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_hintBindings);
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeBoolean(this.m_tupleType != null);
        if (this.m_tupleType != null) {
            writeObjectFileHelper.writeType(this.m_tupleType);
        }
        writeObjectFileHelper.writeBoolean(this.m_elementType != null);
        if (this.m_elementType != null) {
            writeObjectFileHelper.writeType(this.m_elementType);
        }
    }

    @Override
    public int getTypeParameterCount() {
        return 2 + this.m_initialHints.length;
    }

    @Override
    public Type getTypeParameter(int n) {
        return n == 0 ? this.m_tupleType : (n == 1 ? this.m_elementType : this.m_hintBindings[n - 2].getBindingType());
    }

    @Override
    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_tupleType = type;
        } else if (n == 1) {
            this.m_elementType = type;
        } else {
            this.m_hintBindings[n - 2].setType(type);
        }
    }

    @Override
    public boolean isChildInstructionBody(int n) {
        return n == 0;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int n) {
        if (n != 0) {
            return null;
        }
        return this.m_hintBindings;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int n) {
        return false;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, int n) {
        String string2;
        int n2;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        BindingEnvironment bindingEnvironment = codeGenerationTracker.m_bindingEnvironment;
        codeGenerationTracker.generateFreeBindings(this, dataFlowCodeGenerationHelper);
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        String string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        LazyStreamType lazyStreamType = (LazyStreamType)codeGenerationTracker.resolveType(this);
        Type type = lazyStreamType.getElementType();
        AbstractDataType.Constructor constructor = ((NamedType)this.m_tupleType).resolveNameToADT(typeEnvironment).getConstructor(0);
        type.appendHolderVariableDeclaration(dataFlowCodeGenerationHelper, string3, false, null, codeGenerationTracker);
        dataFlowCodeGenerationHelper.append("final boolean " + string3 + "__completed;\n");
        dataFlowCodeGenerationHelper.append("{\n");
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        String[] stringArray = new String[this.m_initialHints.length];
        Type[] typeArray = new Type[this.m_initialHints.length];
        String[] stringArray2 = new String[this.m_initialHints.length];
        for (n2 = 0; n2 < this.m_initialHints.length; ++n2) {
            stringArray[n2] = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
            typeArray[n2] = this.m_hintBindings[n2].getBindingType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment);
            dataFlowCodeGenerationHelper.appendAssignment(stringArray[n2], typeArray[n2], codeGenerationTracker.generateConventionally(this.m_initialHints[n2], dataFlowCodeGenerationHelper), codeGenerationTracker);
            stringArray2[n2] = dataFlowCodeGenerationHelper.generateNewMemberVariableName();
            codeGenerationTracker2.registerExtantBinding(this.m_hintBindings[n2], stringArray2[n2]);
        }
        for (n2 = 0; n2 < this.m_initialHints.length; ++n2) {
            dataFlowCodeGenerationHelper.append(typeArray[n2].getImplementationName(dataFlowCodeGenerationHelper) + " " + stringArray2[n2] + " = " + stringArray[n2] + ";\n");
        }
        String string5 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        dataFlowCodeGenerationHelper.append("int " + string5 + " = " + n + ";\n");
        StreamType streamType = type.getStreamType();
        streamType.appendHolderVariableDeclaration(dataFlowCodeGenerationHelper, string4, false, null, codeGenerationTracker);
        boolean bl = this.m_body.supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, typeEnvironment, bindingEnvironment);
        String string6 = null;
        if (bl) {
            string2 = "_";
            string6 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
            StreamType.generateCreateStream(string6, 0, type.getStreamType(), dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append(string4 + " = " + string6 + "_stream;\n");
        } else {
            string2 = ".";
            dataFlowCodeGenerationHelper.append(string4 + " = null;\n");
        }
        dataFlowCodeGenerationHelper.append("do {\n");
        String string7 = bl ? ((IStreamInADTOptimizationInstruction)((Object)this.m_body)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string6, constructor.m_parameters[0], codeGenerationTracker2, true, false) : this.m_body.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker2, null, false);
        dataFlowCodeGenerationHelper.append("if (" + string7 + string2 + constructor.getConstructorQualifiedFieldName(1, dataFlowCodeGenerationHelper) + ") {\nbreak;\n}\n");
        for (int i = 0; i < this.m_initialHints.length; ++i) {
            dataFlowCodeGenerationHelper.append(stringArray2[i] + " = " + string7 + string2 + constructor.getConstructorQualifiedFieldName(2 + i, dataFlowCodeGenerationHelper) + ";\n");
        }
        String string8 = bl ? string6 + "_size" : string7 + string2 + constructor.getConstructorQualifiedFieldName(0, dataFlowCodeGenerationHelper) + ".length";
        dataFlowCodeGenerationHelper.append(string5 + " -= " + string8 + ";\n");
        if (!bl) {
            streamType.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string4, string7 + string2 + constructor.getConstructorQualifiedFieldName(0, dataFlowCodeGenerationHelper), false, null, codeGenerationTracker);
        }
        dataFlowCodeGenerationHelper.append("} while (" + string5 + " >= 0);\n");
        if (bl) {
            StreamType.generateReleaseLastBuffer(string6, type.getStreamType(), dataFlowCodeGenerationHelper);
        }
        dataFlowCodeGenerationHelper.append(string3 + "__completed = " + string5 + " < 0;\n");
        dataFlowCodeGenerationHelper.append("if (" + string3 + "__completed && " + string4 + " != null) {\n");
        string8 = bl ? string6 + "_size" : string4 + ".length";
        type.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string3, string4 + "[" + string8 + " + " + string5 + "]", false, null, codeGenerationTracker);
        dataFlowCodeGenerationHelper.append("} else { \n");
        type.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string3, type.getDefaultValue(), false, null, codeGenerationTracker);
        dataFlowCodeGenerationHelper.append("}\n");
        dataFlowCodeGenerationHelper.append("}\n");
        return string3;
    }
}

