/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.interpreter.CharArrayWriterStream;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IAppendableStream;
import com.ibm.xylem.interpreter.IConvertible;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.interpreter.ListStream;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.ICollectionType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ForEachInstruction
extends Instruction
implements IStreamOptimizationInstruction,
ISpecialForm {
    protected Instruction m_source;
    protected Instruction m_body;
    protected Binding m_binding;
    protected Binding m_indexBinding = null;
    protected Type m_collectionType;

    public ForEachInstruction() {
    }

    public ForEachInstruction(Instruction instruction, Object object, Instruction instruction2) {
        this(instruction, object, null, instruction2);
    }

    public ForEachInstruction(Instruction instruction, Object object, Object object2, Instruction instruction2) {
        this.m_source = instruction;
        this.m_binding = new Binding(object, (Type)new TypeVariable(), this);
        if (object2 != null) {
            this.m_indexBinding = new Binding(object2, (Type)IntType.s_intType, this);
        }
        this.m_body = instruction2;
    }

    public ForEachInstruction(Instruction instruction, Object object, Instruction instruction2, ICollectionType iCollectionType) {
        this(instruction, object, null, instruction2, iCollectionType);
    }

    public ForEachInstruction(Instruction instruction, Object object, Object object2, Instruction instruction2, ICollectionType iCollectionType) {
        this.m_source = instruction;
        this.m_binding = new Binding(object, iCollectionType.getElementType(), this);
        if (object2 != null) {
            this.m_indexBinding = new Binding(object2, (Type)IntType.s_intType, this);
        }
        this.m_body = instruction2;
        this.m_collectionType = (Type)((Object)iCollectionType);
    }

    public void setCollectionType(Type type) {
        this.m_collectionType = type;
    }

    public Binding getVarBinding() {
        return this.m_binding;
    }

    public Object getIndexVar() {
        return this.m_indexBinding == null ? null : this.m_indexBinding.getName();
    }

    public IBinding getIndexBinding() {
        return this.m_indexBinding;
    }

    public void setIndexVar(Object object) {
        this.m_indexBinding = object == null ? null : new Binding(object, (Type)IntType.s_intType, this);
    }

    public Instruction getSource() {
        return this.m_source;
    }

    public Object getVarName() {
        return this.m_binding.getName();
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction) {
        this.m_body = instruction;
    }

    @Override
    public int getChildInstructionCount() {
        return 2;
    }

    @Override
    public Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_body;
            }
        }
        return null;
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_source = instruction;
                break;
            }
            case 1: {
                this.m_body = instruction;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        if (this.m_binding.getBindingType() instanceof TypeVariable) {
            return new ForEachInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_binding.getName(), this.m_indexBinding == null ? null : this.m_indexBinding.getName(), this.m_body.cloneWithoutTypeInformation());
        }
        return new ForEachInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_binding.getName(), this.m_indexBinding == null ? null : this.m_indexBinding.getName(), this.m_body.cloneWithoutTypeInformation(), (ICollectionType)((Object)this.m_collectionType));
    }

    @Override
    public Instruction cloneShallow() {
        if (this.m_binding.getBindingType() instanceof TypeVariable) {
            return new ForEachInstruction(this.m_source, this.m_binding.getName(), this.m_indexBinding == null ? null : this.m_indexBinding.getName(), this.m_body);
        }
        return new ForEachInstruction(this.m_source, this.m_binding.getName(), this.m_indexBinding == null ? null : this.m_indexBinding.getName(), this.m_body, (ICollectionType)((Object)this.m_collectionType));
    }

    public Type getCollectionType() {
        return this.m_collectionType;
    }

    void setVarType(Type type) {
        this.m_binding.setType(type);
    }

    Type getVarType() {
        return this.m_binding.getBindingType();
    }

    public boolean overriddenCollectionType() {
        return !(this.getVarType() instanceof TypeVariable);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (this.getVarType() instanceof TypeVariable) {
            this.m_collectionType = new StreamType(this.getVarType());
        }
        if (this.m_indexBinding != null) {
            this.m_indexBinding.setTypeEnvironment(typeEnvironment);
            bindingEnvironment = new BindingEnvironment(bindingEnvironment, this.m_indexBinding);
        }
        typeEnvironment.unify(this.m_collectionType, this.m_source.typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        this.m_binding.setTypeEnvironment(typeEnvironment);
        bindingEnvironment2.setVariableBinding(this.m_binding);
        Type type = this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList);
        typeEnvironment.unify(type, new TypeVariable().getStreamType(), this);
        return this.setCachedType(type);
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_body.getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        set.remove(this.m_binding);
        if (this.m_indexBinding != null) {
            set.remove(this.m_indexBinding);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set, bindingEnvironment);
        set.remove(this.m_binding);
        if (this.m_indexBinding != null) {
            set.remove(this.m_indexBinding);
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        if (this.m_collectionType == null) {
            this.m_collectionType = this.m_source.getType(typeEnvironment, bindingEnvironment);
        }
        if (!(this.m_collectionType instanceof ICollectionType)) {
            throw new XylemError("ERR_SYSTEM", "source is not a collection in foreach " + this);
        }
        this.setVarType(((ICollectionType)((Object)this.m_collectionType)).getElementType());
        bindingEnvironment.setVariableBinding(this.m_binding);
        if (this.m_indexBinding != null) {
            bindingEnvironment.setVariableBinding(this.m_indexBinding);
        }
        this.m_body.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        BindingEnvironment bindingEnvironment = codeGenerationTracker.m_bindingEnvironment;
        codeGenerationTracker.generateFreeBindings(this, bCELCodeGenerationHelper, instructionListBuilder, ((IdentifierInstruction)this.m_source).getBinding(bindingEnvironment));
        boolean bl = this.m_indexBinding != null && codeGenerationTracker.isBindingUsed(this.m_indexBinding);
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this);
        int[] nArray = StreamType.generateCreateStream(instructionListBuilder, 32, streamType, bCELCodeGenerationHelper, codeGenerationTracker);
        ICollectionType iCollectionType = (ICollectionType)((Object)this.m_collectionType);
        ICollectionType.BCELLoopState bCELLoopState = iCollectionType.generateLoopStart(bCELCodeGenerationHelper, this.m_source, codeGenerationTracker, instructionListBuilder);
        codeGenerationTracker.startLoop(this);
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        if (bl) {
            codeGenerationTracker2.registerExtantBinding(this.m_indexBinding, bCELLoopState.m_indexVar, BasicType.INT);
        }
        codeGenerationTracker2.registerExtantBinding(this.m_binding, bCELLoopState.m_elementVar, iCollectionType.getElementType().getImplementationType(bCELCodeGenerationHelper));
        codeGenerationTracker2.generateAddToStream(this.m_body, nArray, instructionListBuilder, (StreamType)codeGenerationTracker.resolveType(this), bCELCodeGenerationHelper, null);
        codeGenerationTracker.endLoop();
        iCollectionType.generateLoopEnd(bCELCodeGenerationHelper, bCELLoopState, codeGenerationTracker, instructionListBuilder);
        StreamType.generateCompactStream(nArray, instructionListBuilder, streamType, bCELCodeGenerationHelper, codeGenerationTracker);
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        codeGenerationTracker.generateFreeBindings(this, dataFlowCodeGenerationHelper);
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        Type type = codeGenerationTracker.resolveType(this);
        StreamType.generateCreateStream(string2, 128, (StreamType)type, dataFlowCodeGenerationHelper);
        boolean bl2 = this.m_indexBinding != null && codeGenerationTracker.isBindingUsed(this.m_indexBinding);
        String string3 = null;
        if (bl2) {
            string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
            dataFlowCodeGenerationHelper.append("int " + string3 + " = 0;\n");
        }
        String string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(this.m_binding.getName());
        String string5 = ((ICollectionType)((Object)this.m_collectionType)).generateDataFlowLoopStart(dataFlowCodeGenerationHelper, this.m_source, string4, codeGenerationTracker);
        codeGenerationTracker.startLoop(this);
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        if (bl2) {
            codeGenerationTracker2.registerExtantBinding(this.m_indexBinding, string3);
        }
        codeGenerationTracker2.registerExtantBinding(this.m_binding, string4);
        codeGenerationTracker2.generateAddToStream(this.m_body, string2, (StreamType)type, dataFlowCodeGenerationHelper, false);
        if (bl2) {
            dataFlowCodeGenerationHelper.append("++" + string3 + ";\n");
        }
        codeGenerationTracker.endLoop();
        ((ICollectionType)((Object)this.m_collectionType)).generateDataFlowLoopEnd(dataFlowCodeGenerationHelper, string5, string4, codeGenerationTracker);
        StreamType.generateCompactStream(string2, (StreamType)type, dataFlowCodeGenerationHelper);
        return string2;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        Instruction instruction = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_source, bindingEnvironment);
        ForEachInstruction forEachInstruction = this;
        forEachInstruction.m_source = instruction;
        ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        reductionHelper2.upgradeBinding(this.m_binding);
        bindingEnvironment.setVariableBinding(forEachInstruction.m_binding);
        if (this.m_indexBinding != null) {
            reductionHelper2.upgradeBinding(this.m_indexBinding);
            bindingEnvironment.setVariableBinding(forEachInstruction.m_indexBinding);
        }
        forEachInstruction.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        instructionArray[0] = forEachInstruction;
        this.m_bindingEnvironment = null;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        String string;
        prettyPrinter.newline();
        String string2 = string = this.m_indexBinding == null ? "foreach" : "foreach-c";
        if (this.getVarType() instanceof TypeVariable) {
            prettyPrinter.printFormOpen(string, n);
        } else {
            prettyPrinter.printFormOpen(string + "@" + this.m_collectionType.prettyPrint(), n);
        }
        prettyPrinter.printIdentifier(this.m_binding.getName(), n + 1);
        this.m_source.toString(prettyPrinter, n + 1);
        if (this.m_indexBinding != null) {
            prettyPrinter.printIdentifier(this.m_indexBinding.getName(), n + 1);
        }
        this.m_body.toString(prettyPrinter, n + 1);
        prettyPrinter.print(")");
    }

    @Override
    public void evaluate(IAppendableStream iAppendableStream, Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        IStream iStream = (IStream)this.m_source.evaluate(environment, function, iDebuggerInterceptor, false);
        Iterator iterator = iStream.iterator();
        Object object = environment.lookupBinding(this.m_binding);
        Object object2 = null;
        int n = 0;
        if (this.m_indexBinding != null) {
            object2 = environment.lookupBinding(this.m_indexBinding);
        }
        while (iterator.hasNext()) {
            environment.bind(this.m_binding, iterator.next());
            if (this.m_indexBinding != null) {
                environment.bind(this.m_indexBinding, new Integer(n));
                ++n;
            }
            this.m_body.evaluate(iAppendableStream, environment, function, iDebuggerInterceptor);
        }
        environment.bind(this.m_binding, object);
        if (this.m_indexBinding != null) {
            environment.bind(this.m_indexBinding, object2);
        }
        Debugger.leave(iDebuggerInterceptor, this, environment, function, null);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        IStream iStream = (IStream)this.m_source.evaluate(environment, function, iDebuggerInterceptor, false);
        IConvertible iConvertible = CharType.s_charType.getStreamType().equals(this.getCachedType()) ? new CharArrayWriterStream() : new ListStream();
        Iterator iterator = iStream.iterator();
        Object object = environment.lookupBinding(this.m_binding);
        Object object2 = null;
        int n = 0;
        if (this.m_indexBinding != null) {
            object2 = environment.lookupBinding(this.m_indexBinding);
        }
        while (iterator.hasNext()) {
            environment.bind(this.m_binding, iterator.next());
            if (this.m_indexBinding != null) {
                environment.bind(this.m_indexBinding, new Integer(n));
                ++n;
            }
            this.m_body.evaluate((IAppendableStream)((Object)iConvertible), environment, function, iDebuggerInterceptor);
        }
        environment.bind(this.m_binding, object);
        if (this.m_indexBinding != null) {
            environment.bind(this.m_indexBinding, object2);
        }
        IConvertible iConvertible2 = iConvertible;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, iConvertible2);
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    @Override
    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        codeGenerationTracker.generateFreeBindings(this, dataFlowCodeGenerationHelper);
        boolean bl2 = this.m_indexBinding != null && codeGenerationTracker.isBindingUsed(this.m_indexBinding);
        String string2 = null;
        if (bl2) {
            string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
            dataFlowCodeGenerationHelper.append("int " + string2 + " = 0;\n");
        }
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(this.m_binding.getName());
        String string4 = ((ICollectionType)((Object)this.m_collectionType)).generateDataFlowLoopStart(dataFlowCodeGenerationHelper, this.m_source, string3, codeGenerationTracker);
        codeGenerationTracker.startLoop(this);
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        if (bl2) {
            codeGenerationTracker2.registerExtantBinding(this.m_indexBinding, string2);
        }
        codeGenerationTracker2.registerExtantBinding(this.m_binding, string3);
        codeGenerationTracker2.generateAddToStream(this.m_body, string, (StreamType)codeGenerationTracker.resolveType(this), dataFlowCodeGenerationHelper, false);
        if (bl2) {
            dataFlowCodeGenerationHelper.append("++" + string2 + ";\n");
        }
        codeGenerationTracker.endLoop();
        ((ICollectionType)((Object)this.m_collectionType)).generateDataFlowLoopEnd(dataFlowCodeGenerationHelper, string4, string3, codeGenerationTracker);
    }

    @Override
    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
        BindingEnvironment bindingEnvironment = codeGenerationTracker.m_bindingEnvironment;
        codeGenerationTracker.generateFreeBindings(this, bCELCodeGenerationHelper, instructionListBuilder, ((IdentifierInstruction)this.m_source).getBinding(bindingEnvironment));
        boolean bl = this.m_indexBinding != null && codeGenerationTracker.isBindingUsed(this.m_indexBinding);
        ICollectionType iCollectionType = (ICollectionType)((Object)this.m_collectionType);
        ICollectionType.BCELLoopState bCELLoopState = iCollectionType.generateLoopStart(bCELCodeGenerationHelper, this.m_source, codeGenerationTracker, instructionListBuilder);
        codeGenerationTracker.startLoop(this);
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        if (bl) {
            codeGenerationTracker2.registerExtantBinding(this.m_indexBinding, bCELLoopState.m_indexVar, BasicType.INT);
        }
        codeGenerationTracker2.registerExtantBinding(this.m_binding, bCELLoopState.m_elementVar, iCollectionType.getElementType().getImplementationType(bCELCodeGenerationHelper));
        codeGenerationTracker2.generateAddToStream(this.m_body, nArray, instructionListBuilder, (StreamType)codeGenerationTracker.resolveType(this), bCELCodeGenerationHelper, null);
        codeGenerationTracker.endLoop();
        iCollectionType.generateLoopEnd(bCELCodeGenerationHelper, bCELLoopState, codeGenerationTracker, instructionListBuilder);
    }

    @Override
    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Object object = iNewNameGenerator.getNewName();
        map.put(this.m_binding.getName(), new IdentifierInstruction(object));
        Object object2 = null;
        if (this.m_indexBinding != null) {
            object2 = iNewNameGenerator.getNewName();
            map.put(this.m_indexBinding.getName(), new IdentifierInstruction(object2));
        }
        if (this.getVarType() instanceof TypeVariable) {
            return new ForEachInstruction(this.m_source.assignNewNames(map, iNewNameGenerator), object, object2, this.m_body.assignNewNames(map, iNewNameGenerator));
        }
        return new ForEachInstruction(this.m_source.assignNewNames(map, iNewNameGenerator), object, object2, this.m_body.assignNewNames(map, iNewNameGenerator), (ICollectionType)((Object)this.m_collectionType));
    }

    public void setSource(Instruction instruction) {
        this.m_source = instruction;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_source = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_binding = new Binding(readObjectFileHelper.readBindingName(), (Type)new TypeVariable(), this);
        if (readObjectFileHelper.readBoolean()) {
            this.m_indexBinding = new Binding(readObjectFileHelper.readBindingName(), (Type)IntType.s_intType, this);
        }
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_collectionType = readObjectFileHelper.readType();
        if (this.m_collectionType instanceof ICollectionType) {
            this.m_binding.setType(((ICollectionType)((Object)this.m_collectionType)).getElementType());
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_source);
        writeObjectFileHelper.writeBindingName(this.m_binding.getName());
        writeObjectFileHelper.writeBoolean(this.m_indexBinding != null);
        if (this.m_indexBinding != null) {
            writeObjectFileHelper.writeBindingName(this.m_indexBinding.getName());
        }
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeType(this.m_collectionType);
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_collectionType == null ? 0 : 1;
    }

    @Override
    public Type getTypeParameter(int n) {
        return n == 0 ? this.m_collectionType : null;
    }

    @Override
    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_collectionType = type;
        }
    }

    @Override
    public boolean isChildInstructionBody(int n) {
        return n == 1;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int n) {
        if (n != 1) {
            return null;
        }
        if (this.m_indexBinding == null) {
            return new IBinding[]{this.m_binding};
        }
        return new IBinding[]{this.m_binding, this.m_indexBinding};
    }

    @Override
    public boolean isChildInstructionInTailPosition(int n) {
        return false;
    }
}

