/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.ConventionalBasedOptimizationStyle;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.UnionType;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class UnionMatchInstruction
extends Instruction
implements ISpecialForm {
    protected Binding[] m_bindings;
    protected Instruction[] m_handlers;
    protected Instruction m_toMatch;

    public UnionMatchInstruction() {
    }

    public UnionMatchInstruction(Instruction instruction, Binding[] bindingArray, Instruction[] instructionArray) {
        this.m_toMatch = instruction;
        this.m_bindings = bindingArray;
        this.m_handlers = instructionArray;
        if (this.m_bindings.length == 0 || this.m_handlers.length == 0 || this.m_bindings.length != this.m_handlers.length) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_handlers.length + 1;
    }

    @Override
    public Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_toMatch;
            }
        }
        return this.m_handlers[n - 1];
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_toMatch = instruction;
                break;
            }
            default: {
                this.m_handlers[n - 1] = instruction;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_handlers.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_handlers[i].cloneWithoutTypeInformation();
        }
        return new UnionMatchInstruction(this.m_toMatch.cloneWithoutTypeInformation(), Binding.cloneBindings(this.m_bindings), instructionArray);
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = new Instruction[this.m_handlers.length];
        System.arraycopy(this.m_handlers, 0, instructionArray, 0, instructionArray.length);
        return new UnionMatchInstruction(this.m_toMatch, Binding.cloneBindings(this.m_bindings), instructionArray);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_handlers.length];
        Type type = null;
        for (int i = 0; i < this.m_handlers.length; ++i) {
            BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment, this.m_bindings[i]);
            Type type2 = this.m_handlers[i].typeCheck(typeEnvironment, bindingEnvironment2, linkedList);
            if (type == null) {
                type = type2;
            } else {
                typeEnvironment.unify(type, type2, this.m_handlers[i]);
            }
            typeArray[i] = this.m_bindings[i].getBindingType();
        }
        typeEnvironment.unify(new UnionType(typeArray), this.m_toMatch.typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        return this.setCachedType(type);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            bindingEnvironment.setVariableBinding(this.m_bindings[i]);
            this.m_handlers[i].typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        }
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_handlers[0].getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        throw new UnsupportedOperationException("UnionMatchInstruction should be removed by PolimorphicADTDesugarer.");
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        throw new UnsupportedOperationException("UnionMatchInstruction should be removed by PolimorphicADTDesugarer.");
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        Instruction instruction;
        this.m_toMatch = instruction = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_toMatch, bindingEnvironment);
        int n = this.m_handlers.length;
        for (int i = 0; i < n; ++i) {
            Instruction instruction2 = this.m_handlers[i];
            ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
            reductionHelper2.upgradeBinding(this.m_bindings[i]);
            bindingEnvironment.setVariableBinding(this.m_bindings[i]);
            this.m_handlers[i] = reductionHelper2.reduce(instruction2, bindingEnvironment);
        }
        this.m_bindingEnvironment = null;
        instructionArray[0] = this;
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            for (int i = 0; i < this.m_handlers.length; ++i) {
                if (this.m_handlers[i].supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment)) continue;
                return false;
            }
            return false;
        }
        if (codeGenerationOptimizationStyle instanceof StreamInADTOptimizationStyle || codeGenerationOptimizationStyle instanceof ConventionalBasedOptimizationStyle) {
            for (int i = 0; i < this.m_handlers.length; ++i) {
                if (this.m_handlers[i].supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment)) continue;
                return false;
            }
            return false;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof UnionMatchInstruction)) {
            return false;
        }
        return super.equals(object);
    }

    public boolean canGenerateObjectless(TypeEnvironment typeEnvironment) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            if (((IStreamInADTOptimizationInstruction)((Object)this.m_handlers[i])).canGenerateObjectless(typeEnvironment)) continue;
            return false;
        }
        return false;
    }

    public Instruction getToMatch() {
        return this.m_toMatch;
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("union-match", n);
        this.m_toMatch.toString(prettyPrinter, n + 1);
        for (int i = 0; i < this.m_handlers.length; ++i) {
            prettyPrinter.printFormOpen("case", n + 1);
            prettyPrinter.printFormOpen(this.m_bindings[i].getBindingType().prettyPrint(), n + 2);
            prettyPrinter.printIdentifier(this.m_bindings[i].getName(), n + 3);
            prettyPrinter.printFormClose(n + 2);
            this.m_handlers[i].toString(prettyPrinter, n + 2);
            prettyPrinter.printFormClose(n + 1);
        }
        prettyPrinter.printFormClose(n);
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set.remove(this.m_bindings[i]);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set.remove(this.m_bindings[i]);
        }
    }

    @Override
    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Instruction[] instructionArray = new Instruction[this.m_handlers.length];
        Binding[] bindingArray = new Binding[this.m_handlers.length];
        for (int i = 0; i < this.m_handlers.length; ++i) {
            instructionArray[i] = this.m_handlers[i].cloneShallow();
            Object object = iNewNameGenerator.getNewName();
            map.put(this.m_bindings[i].getName(), new IdentifierInstruction(object));
            bindingArray[i].setName(object);
            bindingArray[i].setType(this.m_bindings[i].getBindingType());
            instructionArray[i].assignNewNames(map, iNewNameGenerator);
        }
        return new UnionMatchInstruction(this.m_toMatch.assignNewNames(map, iNewNameGenerator), bindingArray, instructionArray);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_toMatch);
        int n = this.m_bindings.length;
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_bindings);
        for (int i = 0; i < n; ++i) {
            writeObjectFileHelper.writeInstruction(this.m_handlers[i]);
        }
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_toMatch = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_bindings = readObjectFileHelper.readTypeSpecificBindingSet();
        int n = this.m_bindings.length;
        this.m_handlers = new Instruction[n];
        for (int i = 0; i < n; ++i) {
            this.m_handlers[i] = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
        if (this.m_bindings.length == 0 || this.m_handlers.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isChildInstructionBody(int n) {
        return this.getChildInstructionBindings(n) != null;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int n) {
        switch (n) {
            case -1: {
                return NO_BINDINGS;
            }
            case 0: {
                return null;
            }
        }
        return new Binding[]{this.m_bindings[n - 1]};
    }

    @Override
    public boolean isChildInstructionInTailPosition(int n) {
        return this.getChildInstructionBindings(n) != null;
    }
}

