/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Function;
import com.ibm.xylem.IImperativeInstruction;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.PureInstruction;
import java.util.HashSet;

public class ImperitivityOptimizer
extends Optimizer {
    private HashSet m_impureFunctions = new HashSet();
    private HashSet m_inProcessFunctions = new HashSet();

    @Override
    public Instruction optimize(Instruction instruction) {
        return instruction;
    }

    private boolean isProvablyPure(Function function) {
        if (!function.isImpure()) {
            return true;
        }
        if (this.m_impureFunctions.contains(function)) {
            return false;
        }
        if (this.m_inProcessFunctions.contains(function)) {
            return false;
        }
        Instruction instruction = function.getBody();
        this.m_inProcessFunctions.add(function);
        boolean bl = this.isProvablyPure(instruction);
        if (bl) {
            function.setImpurity(false);
        } else {
            this.m_impureFunctions.add(function);
        }
        this.m_inProcessFunctions.remove(function);
        return bl;
    }

    private boolean isProvablyPure(Instruction instruction) {
        if (instruction instanceof PureInstruction) {
            return true;
        }
        if (instruction instanceof IImperativeInstruction) {
            return false;
        }
        int n = instruction.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction2 = instruction.getChildInstruction(i);
            if (this.isProvablyPure(instruction2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void optimizeFunction(Function function) {
        this.isProvablyPure(function);
    }
}

