/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.StreamInstruction;

public class SimpleUnflattenStreamOptimizer
extends Optimizer {
    protected int m_limit;

    public SimpleUnflattenStreamOptimizer(int n) {
        this.m_limit = n;
    }

    @Override
    public void optimizeFunction(Function function) {
        if (function.getName().indexOf("xdm-") == -1) {
            super.optimizeFunction(function);
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction) {
        if (instruction instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            if (streamInstruction.isStoredAsString()) {
                return null;
            }
            int n = instruction.accumulateByteCodeSize();
            int n2 = streamInstruction.getChildInstructionCount();
            if (this.m_limit > 0 && n > this.m_limit && n2 > 4) {
                StreamInstruction streamInstruction2 = (StreamInstruction)streamInstruction.cloneWithoutTypeInformation();
                streamInstruction2.split();
                instruction = this.doTypeCheck(instruction, streamInstruction2, instruction.getBindingEnvironment());
            }
        }
        return instruction;
    }
}

