/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogMode;
import com.ibm.gsk.ikeyman.gui.controls.ButtonFactory;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.BrowseAction;
import com.ibm.gsk.ikeyman.gui.panels.FileNameEnum;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanel$1;
import com.ibm.gsk.ikeyman.gui.panels.KeymanPanel;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public abstract class FileNamePanel
extends KeymanPanel
implements ItemListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private MnemonicLabel comboLabel = null;
    private JComboBox dbTypeCombo = null;
    private MnemonicLabel fileNameLabel = null;
    private JTextField fileNameField = null;
    private JButton browseBtn = null;
    private MnemonicLabel jLabel11 = null;
    private JTextField locationField = null;
    private boolean fileNameLocationChanged = false;
    private boolean fileNameLocationEventEnabled = false;
    private GUIConstants$DialogMode mode;
    private KeymanPanel textPanel = null;
    private KeymanPanel mainPanel = null;
    private FileName databaseName = null;
    private BrowseAction browseAction = new BrowseAction(this);

    protected FileNamePanel(GUIConstants$DialogMode gUIConstants$DialogMode, FileName fileName) {
        this.mode = gUIConstants$DialogMode;
        this.databaseName = fileName;
        this.initialize();
        this.populateNameAndLocation();
        this.fileNameLocationEventEnabled = true;
    }

    protected FileName getDatabaseName() {
        return this.databaseName;
    }

    private void initialize() {
        this.jLabel11 = new MnemonicLabel();
        this.jLabel11.setText(Messages.getStringWithMnemonics("Label.Location"));
        this.jLabel11.setName(ControlNames.FileNamePanelLocationLabel.toString());
        this.fileNameLabel = new MnemonicLabel();
        this.fileNameLabel.setText(this.getFileNameLabel());
        this.fileNameLabel.setName(ControlNames.FileNamePanelFileNameLabel.toString());
        this.setSize(507, 106);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
        this.extraInitialize();
    }

    protected void extraInitialize() {
    }

    protected abstract String getComboLabel();

    protected abstract String getFileNameLabel();

    protected abstract Object[] getComboValues();

    protected abstract FileFilter getFileFilter();

    protected abstract Map getDefaultLocationMap();

    protected abstract String getComboTooltip();

    protected abstract String getFileNameTooltip();

    protected String getLocationTooltip() {
        return Messages.getString("Tooltip.FileLocation");
    }

    protected boolean fileNameFieldEnabled() {
        return true;
    }

    protected boolean locationFieldEnabled() {
        return true;
    }

    protected boolean browseButtonEnabled() {
        return true;
    }

    public void updateDefaultLocation() {
        this.getDefaultLocationMap().put(this.getComboValue(), this.getFile().getParent());
    }

    private String getDefaultLocation() {
        if (this.getDefaultLocationMap().containsKey(this.getComboValue())) {
            return (String)this.getDefaultLocationMap().get(this.getComboValue());
        }
        return this.getDatabaseName().getDirectory();
    }

    protected FileName getDefaultFileName() {
        String string = ((FileNameEnum)this.getComboValue()).getDefaultFileName();
        String string2 = this.getDefaultLocation();
        return new FileName(new File(string2, string));
    }

    protected JComboBox getDbTypeCombo() {
        if (this.dbTypeCombo == null) {
            this.dbTypeCombo = new JComboBox<Object>(this.getComboValues());
            this.dbTypeCombo.setSelectedIndex(0);
            this.dbTypeCombo.addItemListener(this);
            this.dbTypeCombo.setToolTipText(this.getComboTooltip());
            this.dbTypeCombo.getAccessibleContext().setAccessibleDescription(this.getComboTooltip());
            this.dbTypeCombo.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(this.getComboLabel()));
            this.dbTypeCombo.setName(ControlNames.FileNamePanelCombo.toString());
        }
        return this.dbTypeCombo;
    }

    protected Object getComboValue() {
        return this.dbTypeCombo.getSelectedItem();
    }

    protected JLabel getComboLabelControl() {
        if (this.comboLabel == null) {
            this.comboLabel = new MnemonicLabel();
            this.comboLabel.setText(this.getComboLabel());
            this.comboLabel.setName(ControlNames.FileNamePanelComboLabel.toString());
        }
        return this.comboLabel;
    }

    private JTextField getFileNameField() {
        if (this.fileNameField == null) {
            this.fileNameField = new JTextField();
            this.fileNameField.setColumns(30);
            this.fileNameField.setToolTipText(this.getFileNameTooltip());
            this.fileNameField.getDocument().addDocumentListener(this);
            this.fileNameField.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(this.getFileNameLabel()));
            this.fileNameField.getAccessibleContext().setAccessibleDescription(this.getFileNameTooltip());
            this.fileNameField.setName(ControlNames.FileNamePanelFileNameField.toString());
        }
        return this.fileNameField;
    }

    private JButton getBrowseBtn() {
        if (this.browseBtn == null) {
            this.browseBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.Browse"), ControlNames.FileNamePanelBrowseButton);
            this.browseBtn.addActionListener(new FileNamePanel$1(this));
        }
        return this.browseBtn;
    }

    private void browseAction() {
        File file = this.browseAction.getFileName(this.getFileFilter(), this.getSelectedFile(), this.getMode());
        if (file != null) {
            this.locationField.setText(file.getParent());
            this.fileNameField.setText(file.getName());
        }
    }

    private JTextField getLocationField() {
        if (this.locationField == null) {
            this.locationField = new JTextField();
            this.locationField.setColumns(30);
            this.locationField.setName(ControlNames.FileNamePanelLocationField.toString());
            this.locationField.setToolTipText(this.getLocationTooltip());
            this.locationField.getDocument().addDocumentListener(this);
            this.locationField.getAccessibleContext().setAccessibleName(Messages.getString("Label.Location"));
            this.locationField.getAccessibleContext().setAccessibleDescription(this.getLocationTooltip());
        }
        return this.locationField;
    }

    public File getSelectedFile() {
        return new File(this.locationField.getText(), this.fileNameField.getText());
    }

    private JPanel getTextPanel() {
        if (this.textPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 5, 4, 0);
            gridBagConstraints.ipadx = 50;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.ipady = 10;
            gridBagConstraints2.ipadx = 5;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(10, 10, 4, 4);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 12;
            gridBagConstraints3.ipady = -5;
            gridBagConstraints3.ipadx = 3;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.insets = new Insets(5, 5, 4, 7);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 18;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 4);
            gridBagConstraints4.ipadx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridwidth = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 4);
            gridBagConstraints5.ipadx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.fill = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 18;
            gridBagConstraints6.ipady = 5;
            gridBagConstraints6.ipadx = 59;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(5, 10, 10, 4);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.ipady = 5;
            gridBagConstraints7.ipadx = 53;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(5, 10, 4, 4);
            this.textPanel = new KeymanPanel();
            this.textPanel.setLayout(new GridBagLayout());
            this.textPanel.add((Component)this.fileNameLabel, gridBagConstraints7);
            this.textPanel.add((Component)this.jLabel11, gridBagConstraints6);
            this.textPanel.add((Component)this.getFileNameField(), gridBagConstraints5);
            this.textPanel.add((Component)this.getLocationField(), gridBagConstraints4);
            this.textPanel.add((Component)this.getBrowseBtn(), gridBagConstraints3);
            if (this.getComboLabelControl() != null) {
                this.textPanel.add((Component)this.getComboLabelControl(), gridBagConstraints2);
                this.textPanel.add((Component)this.getDbTypeCombo(), gridBagConstraints);
                this.getComboLabelControl().setLabelFor(this.getDbTypeCombo());
            }
            this.jLabel11.setLabelFor(this.locationField);
            this.fileNameLabel.setLabelFor(this.fileNameField);
        }
        return this.textPanel;
    }

    public abstract ParameterMap getParameters() throws KeyManagerException;

    protected File getFile() {
        return new File(this.locationField.getText(), this.fileNameField.getText());
    }

    public boolean isValidInput() {
        if (this.fileNameField.isEnabled() && this.fileNameField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("Message.CannotLeaveBlank"), Messages.getString("Message.FileName")), Messages.getString("GUI.Title.Validation"), 0);
            return false;
        }
        if (this.locationField.isEnabled() && this.locationField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("Message.CannotLeaveBlank"), Messages.getString("Message.Location")), Messages.getString("GUI.Title.Validation"), 0);
            return false;
        }
        return true;
    }

    protected GUIConstants$DialogMode getMode() {
        return this.mode;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new KeymanPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getTextPanel(), "Center");
        }
        return this.mainPanel;
    }

    public void setMode(GUIConstants$DialogMode gUIConstants$DialogMode) {
        this.mode = gUIConstants$DialogMode;
    }

    private void populateNameAndLocation() {
        FileName fileName = this.getDefaultFileName();
        this.fileNameField.setText(fileName != null ? fileName.getFile() : "");
        this.locationField.setText(fileName != null ? fileName.getDirectory() + File.separatorChar : "");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.dbTypeCombo)) {
            this.fileNameLocationEventEnabled = false;
            if (!this.fileNameLocationChanged) {
                this.populateNameAndLocation();
            }
            this.fileNameField.setEnabled(this.fileNameFieldEnabled());
            this.locationField.setEnabled(this.locationFieldEnabled());
            this.browseBtn.setEnabled(this.browseButtonEnabled());
            this.fileNameLocationEventEnabled = true;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleInputFieldChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleInputFieldChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleInputFieldChange();
    }

    private void handleInputFieldChange() {
        if (this.fileNameLocationEventEnabled) {
            this.fileNameLocationChanged = true;
        }
    }

    public void setFile(String string) {
        FileName fileName = new FileName(string);
        this.fileNameField.setText(fileName.getFile());
        this.locationField.setText(fileName.getDirectory());
    }

    static void access$000(FileNamePanel fileNamePanel) {
        fileNamePanel.browseAction();
    }
}

