/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.EntryFilterFactory$EntryFilter;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$ExtensionItem;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;

class EntryFilterFactory$CertReqEntryFilter
implements EntryFilterFactory$EntryFilter {
    private boolean certRequests;

    public EntryFilterFactory$CertReqEntryFilter(boolean bl) {
        this.certRequests = bl;
    }

    public boolean isEntry(KeyStore keyStore, String string, String string2) throws KeyManagerException {
        try {
            if (keyStore.isKeyEntry(string)) {
                X509Certificate x509Certificate;
                try {
                    x509Certificate = (X509Certificate)keyStore.getCertificate(this.getCertForAlias(keyStore, string));
                }
                catch (Exception exception) {
                    x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                }
                if (x509Certificate == null) {
                    return false;
                }
                return !(this.certRequests ^ EntryFilterFactory$CertReqEntryFilter.isCertRequest(x509Certificate));
            }
            return false;
        }
        catch (KeyStoreException keyStoreException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)keyStoreException);
        }
    }

    private String getCertForAlias(KeyStore keyStore, String string) throws KeyManagerException {
        ArrayList<String> arrayList;
        try {
            arrayList = Collections.list(keyStore.aliases());
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
        for (String string2 : arrayList) {
            if (!string2.matches(string.toLowerCase() + "cert[\\d]+")) continue;
            return string2;
        }
        return null;
    }

    protected static boolean isCertRequest(X509Certificate x509Certificate) throws KeyManagerException {
        for (DisplayItemFactory$ExtensionItem displayItemFactory$ExtensionItem : DisplayItemFactory.getExtensionItems(x509Certificate)) {
            byte[] byArray;
            if (!(displayItemFactory$ExtensionItem.getExtension() instanceof SubjectKeyIdentifierExtension)) continue;
            SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = (SubjectKeyIdentifierExtension)displayItemFactory$ExtensionItem.getExtension();
            try {
                byArray = subjectKeyIdentifierExtension.get("key_id").getIdentifier();
            }
            catch (IOException iOException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
            }
            String string = new String(byArray);
            if (!string.equals("IkeymanCertificateRequest")) continue;
            return true;
        }
        return false;
    }

    public boolean isEntry(Object object, String string, String string2) throws KeyManagerException {
        return this.isEntry((KeyStore)object, string, string2);
    }
}

