/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory$EntryInterface;
import com.ibm.gsk.ikeyman.keystore.EntryValidatorFactory;
import com.ibm.gsk.ikeyman.keystore.EntryValidatorFactory$EntryValidator;
import com.ibm.gsk.ikeyman.keystore.KeyCreatorFactory$KeyCreator;
import com.ibm.gsk.ikeyman.keystore.KeyStoreItemFactory$KeyStoreItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$CMSDatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreDefaultCert;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem$ValidationMode;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreModifyCert;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStorePasswordExpiry;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStorePasswordStash;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import java.security.interfaces.DSAPrivateKey;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class KeyStoreItemFactory$CMSKeyStoreItemImpl
extends KeyStoreItemFactory$KeyStoreItemImpl
implements KeyStoreDefaultCert,
KeyStoreModifyCert,
KeyStorePasswordExpiry,
KeyStorePasswordStash {
    private static Map entryValidators = null;

    public KeyStoreItemFactory$CMSKeyStoreItemImpl(EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface, DatabaseDescriptorFactory$CMSDatabaseDescriptor databaseDescriptorFactory$CMSDatabaseDescriptor, KeyCreatorFactory$KeyCreator keyCreatorFactory$KeyCreator) {
        super(entryInterfaceFactory$EntryInterface, databaseDescriptorFactory$CMSDatabaseDescriptor, keyCreatorFactory$KeyCreator, DatabaseDescriptorFactory$CMSDatabaseDescriptor.class);
    }

    public void setDefaultCertificate(String string) throws KeyManagerException {
        Entry entry = this.getItem(string);
        if (!(entry instanceof CMSKeyItem)) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_KEY_FOR_LABEL, new String[]{string});
        }
        CMSKeyItem cMSKeyItem = (CMSKeyItem)entry;
        cMSKeyItem.setDefault(true);
        this.addValidItem(cMSKeyItem);
    }

    public String getDefaultCertificate() throws KeyManagerException {
        Collection collection = this.getPersonalCerts();
        for (CertificateKeyItem certificateKeyItem : collection) {
            if (certificateKeyItem instanceof CMSKeyItem) {
                if (!((CMSKeyItem)certificateKeyItem).isDefault()) continue;
                return certificateKeyItem.getLabel();
            }
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.INVALID_KEY_ITEM_TYPE, new String[]{certificateKeyItem.getClass().toString()});
        }
        throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_DEFAULT_CERTIFICATE);
    }

    public void modifyCertificate(String string, boolean bl) throws KeyManagerException {
        Entry entry = this.getItem(string);
        if (!(entry instanceof CMSCertificateItem)) {
            if (entry instanceof CMSKeyItem) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.CANNOT_MODIFY_PERSONAL_CERT_TRUST);
            }
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.INVALID_CERTIFICATE_TYPE, new String[]{string, entry.getClass().toString()});
        }
        CMSCertificateItem cMSCertificateItem = (CMSCertificateItem)entry;
        cMSCertificateItem.setTrusted(bl);
        this.addValidItem(cMSCertificateItem);
        this.save();
    }

    public Date getPasswordExpiry() throws KeyManagerException {
        if (((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.getDescriptor()).getPasswordExpiryTime() == 0) {
            return null;
        }
        return new Date((long)((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.getDescriptor()).getPasswordExpiryTime() * 1000L);
    }

    public void stashPassword(boolean bl) throws KeyManagerException {
        this.useStash(true);
        if (bl) {
            this.useV1Stash(true);
        }
        this.save();
    }

    public void useStash(boolean bl) {
        ((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.getDescriptor()).setStash(bl);
    }

    public void useV1Stash(boolean bl) {
        ((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.getDescriptor()).setV1Stash(bl);
    }

    public void setPQC(boolean bl) {
        ((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.getDescriptor()).setPQC(bl);
    }

    public void changePassword(CommandParameters commandParameters) throws KeyManagerException {
        if (commandParameters.isParameterPresent(Constants$Parameter.Expire)) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, commandParameters.getExpire());
            ((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.getDescriptor()).setPasswordExpiryTimeSinceEpoch((int)(calendar.getTimeInMillis() / 1000L));
        }
        if (commandParameters.isParameterPresent(Constants$Parameter.StashPassword)) {
            this.useStash(commandParameters.isStash());
        }
        if (commandParameters.isParameterPresent(Constants$Parameter.StashV1Password)) {
            this.useV1Stash(commandParameters.isV1Stash());
        }
        if (commandParameters.isParameterPresent(Constants$Parameter.Pqc)) {
            this.setPQC(commandParameters.isPQC());
        }
        super.changePassword(commandParameters);
        ((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.getDescriptor()).setPasswordProtected(!this.getPassword().equals(KeymanSettings.PASSWORDLESS_CMS_PASSWORD));
    }

    protected List getEntryValidators(KeyStoreItem$ValidationMode keyStoreItem$ValidationMode) {
        if (entryValidators == null) {
            entryValidators = new HashMap();
            ArrayList<EntryValidatorFactory$EntryValidator> arrayList = new ArrayList<EntryValidatorFactory$EntryValidator>();
            arrayList.addAll(super.getEntryValidators(KeyStoreItem$ValidationMode.IMPORT));
            arrayList.add(EntryValidatorFactory.newPrivateKeyTypeValidator(DSAPrivateKey.class));
            entryValidators.put(KeyStoreItem$ValidationMode.ADD, arrayList);
            entryValidators.put(KeyStoreItem$ValidationMode.IMPORT, arrayList);
        }
        return (List)entryValidators.get((Object)keyStoreItem$ValidationMode);
    }

    public void validate() throws KeyManagerException {
        if (this.getPasswordExpiry() != null && this.getPasswordExpiry().before(Calendar.getInstance().getTime())) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.DATABASE_PASSWORD_EXPIRED, new String[]{this.getPasswordExpiry().toString()});
        }
    }
}

