/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.FileModificationTracker;
import com.ibm.gsk.ikeyman.io.LockedFileOutputStream;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory$AbstractKeyStoreProxy;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

class KeyStoreProxyCreatorFactory$FileKeyStoreProxy
extends KeyStoreProxyCreatorFactory$AbstractKeyStoreProxy {
    private final FileModificationTracker tracker;

    public KeyStoreProxyCreatorFactory$FileKeyStoreProxy(KeyStore keyStore, DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, boolean bl) throws KeyManagerException, CancelledException {
        super(keyStore, databaseDescriptorFactory$DatabaseDescriptor, bl);
        this.tracker = new FileModificationTracker(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString());
    }

    protected void load() throws KeyManagerException, CancelledException {
        this.tracker.loaded();
        InputStream inputStream = null;
        try {
            inputStream = this.create ? null : new FileInputStream(this.descriptor.getFileNameString());
            this.performLoad(inputStream, this.create);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INPUT_FILE_NOT_FOUND, fileNotFoundException, new String[]{this.descriptor.getFileName().toString()});
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_LOAD_ERROR, (Throwable)certificateException);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null) {
                if (iOException.getMessage().contains("Illegal key size")) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)iOException);
                }
                if (iOException.getMessage().toLowerCase().contains("locked")) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.DATABASE_LOCKED, (Throwable)iOException);
                }
                if (iOException.getMessage().toLowerCase().contains("incorrect") || iOException.getMessage().toLowerCase().contains("unable to verify mac")) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_PASSWORD, iOException, new String[]{this.descriptor.getType().toString()});
                }
                throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR_MSG, iOException, new String[]{iOException.getMessage()});
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
        catch (CancelledException cancelledException) {
            throw cancelledException;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() != null && runtimeException.getCause() instanceof KeyManagerException) {
                KeyManagerException keyManagerException = (KeyManagerException)runtimeException.getCause();
                throw new KeyManagerException(keyManagerException.getReason(), runtimeException, keyManagerException.getDetails());
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_STORE_LOAD_ERROR, runtimeException, new String[]{runtimeException.getLocalizedMessage()});
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
                }
            }
        }
    }

    protected void performLoad(InputStream inputStream, boolean bl) throws NoSuchAlgorithmException, CertificateException, IOException, KeyManagerException, CancelledException {
        this.keyStore.load(inputStream, this.descriptor.getPassword(true, bl).toCharArray());
    }

    public boolean needsRefresh() {
        return this.tracker.needsRefresh();
    }

    public void save(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException {
        try {
            this.performSave(databaseDescriptorFactory$DatabaseDescriptor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (new File(databaseDescriptorFactory$DatabaseDescriptor.getFileName().getDirectory()).exists()) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_WRITE_PERMISSION, fileNotFoundException, new String[]{databaseDescriptorFactory$DatabaseDescriptor.getFileNameString()});
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_CREATION_ERROR, fileNotFoundException, new String[]{databaseDescriptorFactory$DatabaseDescriptor.getFileNameString()});
        }
        catch (KeyStoreException keyStoreException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_STORE_ERROR, (Throwable)certificateException);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().contains("Illegal key size")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)iOException);
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
    }

    protected void performSave(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagerException {
        LockedFileOutputStream lockedFileOutputStream = new LockedFileOutputStream(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString());
        this.keyStore.store(lockedFileOutputStream, databaseDescriptorFactory$DatabaseDescriptor.getPassword().toCharArray());
        ((OutputStream)lockedFileOutputStream).close();
    }

    public void close() {
    }

    public void delete() throws KeyManagerException {
        File file = new File(this.descriptor.getFileNameString());
        if (!file.delete()) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.DELETION_FAILED, new String[]{file.toString()});
        }
    }
}

