/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CertifiedKeyPair;
import com.ibm.security.cmp.PKIStatusInfo;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;

public final class KeyRecRepContent
extends CMPDerObject {
    private PKIStatusInfo status;
    public Certificate newSigCert;
    public Certificate[] caCerts;
    public CertifiedKeyPair[] keyPairHist;
    private static final byte TAG_NEW_SIG_CERT = 0;
    private static final byte TAG_CA_CERTS = 1;
    private static final byte TAG_KEY_PAIR_HIST = 2;

    public KeyRecRepContent(PKIStatusInfo pKIStatusInfo, Certificate certificate, Certificate[] certificateArray, CertifiedKeyPair[] certifiedKeyPairArray) {
        if (pKIStatusInfo == null) {
            throw new IllegalArgumentException("KeyRecRepContent error, status info not specified");
        }
        this.status = pKIStatusInfo;
        this.newSigCert = certificate;
        if (certificateArray != null) {
            int n = 0;
            while (n < certificateArray.length) {
                if (!(certificateArray[n] instanceof X509Certificate)) {
                    throw new IllegalArgumentException("KeyRecRepContent error, invalid certificate type for caCerts[" + n + "]. Only X509 certificate is supported");
                }
                ++n;
            }
        }
        this.caCerts = certificateArray;
        this.keyPairHist = certifiedKeyPairArray;
    }

    public KeyRecRepContent(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new KeyRecRepContent(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void decode(DerValue var1_1) throws IOException {
        block20: {
            block19: {
                block18: {
                    if (var1_1.getTag() != 48) {
                        throw new IOException("KeyRecRepContent parsing error, not a SEQUENCE");
                    }
                    this.status = null;
                    this.newSigCert = null;
                    this.caCerts = null;
                    this.keyPairHist = null;
                    if (var1_1.getData().available() == 0) {
                        throw new IOException("KeyRecRepContent parsing error, missing data");
                    }
                    var2_2 = var1_1.getData().getDerValue();
                    this.status = new PKIStatusInfo(var2_2.toByteArray());
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                    if (var2_2.isContextSpecific((byte)0) && var2_2.isConstructed()) {
                        try {
                            this.newSigCert = new X509CertImpl(var2_2.getData().getDerValue());
                        }
                        catch (CertificateException var3_3) {
                            throw new IOException("KeyRecRepContent parsing error, " + var3_3);
                        }
                        if (var1_1.getData().available() != 0) {
                            var2_2 = var1_1.getData().getDerValue();
                        } else {
                            return;
                        }
                    }
                    if (!var2_2.isContextSpecific((byte)1) || !var2_2.isConstructed()) break block18;
                    var3_4 = new Vector<X509CertImpl>();
                    if ((var2_2 = var2_2.getData().getDerValue()).getTag() == 48) ** GOTO lbl36
                    throw new IOException("KeyRecRepContent parsing error, not a SEQUENCE OF");
lbl-1000:
                    // 1 sources

                    {
                        var4_5 = var2_2.getData().getDerValue();
                        try {
                            var5_9 /* !! */  = new X509CertImpl(var4_5);
                            var3_4.add(var5_9 /* !! */ );
                            continue;
                        }
                        catch (CertificateException var5_10) {
                            throw new IOException("KeyRecRepContent parsing error, " + var5_10);
                        }
lbl36:
                        // 2 sources

                        ** while (var2_2.getData().available() != 0)
                    }
lbl37:
                    // 1 sources

                    if (var3_4.size() > 0) {
                        this.caCerts = new X509CertImpl[var3_4.size()];
                        var4_6 = 0;
                        while (var4_6 < var3_4.size()) {
                            this.caCerts[var4_6] = (X509CertImpl)var3_4.elementAt(var4_6);
                            ++var4_6;
                        }
                    }
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                }
                if (!var2_2.isContextSpecific((byte)2) || !var2_2.isConstructed()) break block19;
                var3_4 = new Vector<E>();
                if ((var2_2 = var2_2.getData().getDerValue()).getTag() == 48) ** GOTO lbl56
                throw new IOException("KeyRecRepContent parsing error, not a SEQUENCE OF");
lbl-1000:
                // 1 sources

                {
                    var4_7 = var2_2.getData().getDerValue();
                    var5_9 /* !! */  = new CertifiedKeyPair(var4_7.toByteArray());
                    var3_4.add(var5_9 /* !! */ );
lbl56:
                    // 2 sources

                    ** while (var2_2.getData().available() != 0)
                }
lbl57:
                // 1 sources

                if (var3_4.size() > 0) {
                    this.keyPairHist = new CertifiedKeyPair[var3_4.size()];
                    var4_8 = 0;
                    while (var4_8 < var3_4.size()) {
                        this.keyPairHist[var4_8] = (CertifiedKeyPair)var3_4.elementAt(var4_8);
                        ++var4_8;
                    }
                }
                break block20;
            }
            throw new IOException("KeyRecRepContent parsing error, data overrun");
        }
        if (var1_1.getData().available() != 0) {
            throw new IOException("KeyRecRepContent parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n;
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2;
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        if (this.status == null) {
            throw new IOException("KeyRecRepContent encoding error, status not specified");
        }
        this.status.encode((OutputStream)derOutputStream3);
        if (this.newSigCert != null) {
            derOutputStream2 = new DerOutputStream();
            try {
                derOutputStream2.write(this.newSigCert.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("KeyRecRepContent encoding error, " + certificateEncodingException);
            }
            derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        }
        if (this.caCerts != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream = new DerOutputStream();
            n = 0;
            while (n < this.caCerts.length) {
                try {
                    derOutputStream2.write(this.caCerts[n].getEncoded());
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("KeyRecRepContent encoding error, " + certificateEncodingException);
                }
                ++n;
            }
            derOutputStream.write((byte)48, derOutputStream2);
            derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream);
        }
        if (this.keyPairHist != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream = new DerOutputStream();
            n = 0;
            while (n < this.keyPairHist.length) {
                this.keyPairHist[n].encode((OutputStream)derOutputStream2);
                ++n;
            }
            derOutputStream.write((byte)48, derOutputStream2);
            derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream);
        }
        derOutputStream4.write((byte)48, derOutputStream3);
        outputStream.write(derOutputStream4.toByteArray());
    }

    public boolean equals(KeyRecRepContent keyRecRepContent) {
        DerValue derValue;
        DerValue derValue2;
        if (keyRecRepContent == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            keyRecRepContent.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof KeyRecRepContent) {
            return this.equals((KeyRecRepContent)object);
        }
        return false;
    }

    public Certificate[] getCACerts() {
        if (this.caCerts == null) {
            return null;
        }
        return (X509CertImpl[])this.caCerts.clone();
    }

    public CertifiedKeyPair[] getKeyPairHist() {
        if (this.keyPairHist == null) {
            return null;
        }
        return (CertifiedKeyPair[])this.keyPairHist.clone();
    }

    public Certificate getNewSigCert() {
        if (this.newSigCert == null) {
            return null;
        }
        try {
            byte[] byArray = this.newSigCert.getEncoded();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public PKIStatusInfo getStatusInfo() {
        return (PKIStatusInfo)this.status.clone();
    }

    public String toString() {
        int n;
        String string = "KeyRecRepContent:";
        if (this.status != null) {
            string = String.valueOf(string) + "\r\n\tstatus: " + this.status.toString();
        }
        string = this.newSigCert != null ? String.valueOf(string) + "\r\n\tcertificate: " + this.newSigCert.toString() : String.valueOf(string) + "\r\n\rno certificate";
        if (this.caCerts == null || this.caCerts.length == 0) {
            string = String.valueOf(string) + "\r\n\tno ca certificates";
        } else {
            n = 0;
            while (n < this.caCerts.length) {
                string = String.valueOf(string) + "\r\n\tca cert[" + n + "]: " + this.caCerts[n];
                ++n;
            }
        }
        if (this.keyPairHist == null || this.keyPairHist.length == 0) {
            string = String.valueOf(string) + "\r\n\tno key pair hist ";
        } else {
            n = 0;
            while (n < this.keyPairHist.length) {
                string = String.valueOf(string) + "\r\n\tkey pair hist[" + n + "]: " + this.keyPairHist[n];
                ++n;
            }
        }
        return string;
    }
}

