/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public final class PKIFreeText
extends CMPDerObject {
    private String[] pkiFreeTexts;

    public PKIFreeText(byte[] byArray) throws IOException {
        super(byArray);
    }

    public PKIFreeText(String[] stringArray) {
        this.pkiFreeTexts = stringArray;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new PKIFreeText(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("PKIFreeText parsing error, not a SEQUENCE OF");
        }
        Vector<String> vector = new Vector<String>();
        this.pkiFreeTexts = null;
        while (derValue.getData().available() != 0) {
            String string = null;
            try {
                string = new String(derValue.getData().getOctetString(), "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            vector.add(string);
        }
        if (vector.size() > 0) {
            this.pkiFreeTexts = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                this.pkiFreeTexts[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.pkiFreeTexts != null && this.pkiFreeTexts.length != 0) {
            int n = 0;
            while (n < this.pkiFreeTexts.length) {
                try {
                    derOutputStream.putOctetString(this.pkiFreeTexts[n].getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                ++n;
            }
        } else {
            throw new IOException("PKIFreeText encoding error, free text not specified");
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(PKIFreeText pKIFreeText) {
        DerValue derValue;
        DerValue derValue2;
        if (pKIFreeText == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pKIFreeText.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof PKIFreeText) {
            return this.equals((PKIFreeText)object);
        }
        return false;
    }

    public String[] getFreeText() {
        return (String[])this.pkiFreeTexts.clone();
    }

    public String toString() {
        String string = "PKIFreeText: ";
        if (this.pkiFreeTexts == null || this.pkiFreeTexts.length == 0) {
            string = String.valueOf(string) + "\r\n\tno free text";
        } else {
            int n = 0;
            while (n < this.pkiFreeTexts.length) {
                string = String.valueOf(string) + "\r\n\tfree text[" + n + "]: " + this.pkiFreeTexts[n];
                ++n;
            }
        }
        return string;
    }
}

