/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs;

import com.ibm.net.rdma.jverbs.RdmaJVerbsProvider;
import com.ibm.net.rdma.jverbs.cm.RdmaCM;
import com.ibm.net.rdma.jverbs.verbs.RdmaJVerbs;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import sun.reflect.misc.ConstructorUtil;

class NativeRdmaJVerbsProvider
implements RdmaJVerbsProvider {
    private static final String RDMA_NATIVE_CONNECTION_MANAGEMENT_IMPL_CLASS = "com.ibm.net.rdma.jverbs.cm.NativeRdmaCM";
    private static final String RDMA_NATIVE_JVERBS_IMPL_CLASS = "com.ibm.net.rdma.jverbs.verbs.NativeRdmaJVerbs";
    private RdmaJVerbs jVerbs = (RdmaJVerbs)this.invokeConstructor("com.ibm.net.rdma.jverbs.verbs.NativeRdmaJVerbs", null, null);
    private RdmaCM cm = (RdmaCM)this.invokeConstructor("com.ibm.net.rdma.jverbs.cm.NativeRdmaCM", null, null);

    private Object invokeConstructor(String string, final Class[] classArray, Object[] objectArray) {
        final Class[] classArray2 = new Class[]{};
        Object[] objectArray2 = new Object[]{};
        try {
            final Class<?> clazz = Class.forName(string);
            Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Constructor<?> constructor = ConstructorUtil.getConstructor(clazz, classArray == null ? classArray2 : classArray);
                    constructor.setAccessible(true);
                    return constructor;
                }
            });
            return constructor.newInstance(objectArray == null ? objectArray2 : objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public RdmaCM openConnection() throws IOException {
        if (this.cm == null) {
            throw new IOException("JVerbs CM cannot be initialized");
        }
        return this.cm;
    }

    @Override
    public RdmaJVerbs openJVerbs() throws IOException {
        if (this.jVerbs == null) {
            throw new IOException("JVerbs verbs cannot be initialized");
        }
        return this.jVerbs;
    }

    @Override
    public void initialize() throws IOException {
        if (this.initialize0() == -1) {
            throw new IOException("JVerbs Native library symbol initialization failed!");
        }
        this.attachShutDownHook();
    }

    @Override
    public void cleanup() {
        this.cm.cleanup();
        this.jVerbs.cleanup();
        this.cleanup0();
    }

    private void attachShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                NativeRdmaJVerbsProvider.this.cleanup();
            }
        });
    }

    native int initialize0();

    native int cleanup0();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("jverbs");
                return null;
            }
        });
    }
}

