/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs;

import com.ibm.net.rdma.jverbs.RdmaJVerbsProvider;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.reflect.misc.ConstructorUtil;
import sun.security.action.GetPropertyAction;

public class RdmaJVerbsProviderFactory {
    private static final String RDMA_PROVIDER_PROPERTY_NAME = "com.ibm.net.rdma.jverbs.provider";
    private static final String NATIVE_RDMA_PROVIDER = "native";
    private static final String JAVA_RDMA_PROVIDER = "java";
    private static final String RDMA_NATIVE_PROVIDER_IMPL_CLASS = "com.ibm.net.rdma.jverbs.NativeRdmaJVerbsProvider";
    private static RdmaJVerbsProvider provider = null;

    private RdmaJVerbsProviderFactory() {
    }

    private static synchronized void createProvider() throws Exception {
        if (provider != null) {
            return;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction(RDMA_PROVIDER_PROPERTY_NAME));
        if (string == null) {
            string = NATIVE_RDMA_PROVIDER;
        }
        switch (string) {
            case "native": {
                provider = RdmaJVerbsProviderFactory.createProviderInstance(RDMA_NATIVE_PROVIDER_IMPL_CLASS);
                break;
            }
            default: {
                provider = RdmaJVerbsProviderFactory.createProviderInstance(RDMA_NATIVE_PROVIDER_IMPL_CLASS);
            }
        }
        if (provider != null) {
            provider.initialize();
        }
    }

    private static RdmaJVerbsProvider createProviderInstance(String string) {
        try {
            return (RdmaJVerbsProvider)RdmaJVerbsProviderFactory.invokeConstructor(string, null, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object invokeConstructor(String string, final Class[] classArray, Object[] objectArray) {
        final Class[] classArray2 = new Class[]{};
        Object[] objectArray2 = new Object[]{};
        try {
            final Class<?> clazz = Class.forName(string);
            Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Constructor<?> constructor = ConstructorUtil.getConstructor(clazz, classArray == null ? classArray2 : classArray);
                    constructor.setAccessible(true);
                    return constructor;
                }
            });
            return constructor.newInstance(objectArray == null ? objectArray2 : objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RdmaJVerbsProvider getProvider() {
        return provider;
    }

    static {
        try {
            RdmaJVerbsProviderFactory.createProvider();
        }
        catch (Exception exception) {
            provider = null;
        }
    }
}

