/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.cm;

import com.ibm.net.rdma.jverbs.RdmaJVerbsProvider;
import com.ibm.net.rdma.jverbs.RdmaJVerbsProviderFactory;
import com.ibm.net.rdma.jverbs.cm.ConnectionEvent;
import com.ibm.net.rdma.jverbs.cm.ConnectionId;
import com.ibm.net.rdma.jverbs.cm.ConnectionParameter;
import com.ibm.net.rdma.jverbs.cm.EventChannel;
import com.ibm.net.rdma.jverbs.cm.PortSpace;
import com.ibm.net.rdma.jverbs.verbs.ProtectionDomain;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.QueuePairInitAttribute;
import java.io.IOException;
import java.net.SocketAddress;

public abstract class RdmaCM {
    protected static RdmaCM open() throws IOException {
        RdmaJVerbsProvider rdmaJVerbsProvider = RdmaJVerbsProviderFactory.getProvider();
        if (rdmaJVerbsProvider == null) {
            throw new IOException("Could not initialize RDMA Connection. No provider found");
        }
        return rdmaJVerbsProvider.openConnection();
    }

    protected abstract EventChannel createEventChannel() throws IOException;

    protected abstract ConnectionId createConnectionId(EventChannel var1, PortSpace var2) throws IllegalArgumentException, IOException;

    protected abstract QueuePair createQueuePair(ConnectionId var1, ProtectionDomain var2, QueuePairInitAttribute var3) throws IllegalArgumentException, IOException;

    protected abstract void bindAddress(ConnectionId var1, SocketAddress var2) throws IllegalArgumentException, IOException;

    protected abstract void listen(ConnectionId var1, int var2) throws IOException;

    protected abstract void resolveAddress(ConnectionId var1, SocketAddress var2, SocketAddress var3, int var4) throws IllegalArgumentException, IOException;

    protected abstract void resolveRoute(ConnectionId var1, int var2) throws IOException;

    protected abstract ConnectionEvent getConnectionEvent(EventChannel var1, int var2) throws IOException;

    protected abstract void connect(ConnectionId var1, ConnectionParameter var2) throws IllegalArgumentException, IOException;

    protected abstract void accept(ConnectionId var1, ConnectionParameter var2) throws IllegalArgumentException, IOException;

    protected abstract void ackConnectionEvent(ConnectionEvent var1) throws IOException;

    protected abstract void disconnect(ConnectionId var1) throws IOException;

    protected abstract void destroyEventChannel(EventChannel var1) throws IOException;

    protected abstract void destroyConnectionId(ConnectionId var1) throws IOException;

    protected abstract void destroyQueuePair(ConnectionId var1) throws IOException;

    protected abstract SocketAddress getSourceAddress(ConnectionId var1) throws IOException;

    protected abstract SocketAddress getDestinationAddress(ConnectionId var1) throws IOException;

    protected abstract int getSourcePort(ConnectionId var1) throws IOException;

    protected abstract int getDestinationPort(ConnectionId var1) throws IOException;

    protected abstract void destroyEndpoint(ConnectionId var1) throws IOException;

    public abstract void cleanup();
}

