/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.common;

import com.ibm.net.rdma.jverbs.common.MemoryBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.TreeMap;
import sun.nio.ch.DirectBuffer;

public class MemoryBufferPool {
    private static MemoryBufferPool instance = null;
    private TreeMap<String, MemoryBuffer> table = new TreeMap();

    public static synchronized MemoryBufferPool getInstance() {
        if (instance == null) {
            instance = new MemoryBufferPool();
        }
        return instance;
    }

    private MemoryBufferPool() {
    }

    public static synchronized MemoryBuffer wrap(ByteBuffer byteBuffer) {
        if (byteBuffer instanceof DirectBuffer) {
            long l = ((DirectBuffer)((Object)byteBuffer)).address();
            return new MemoryBuffer(MemType.DIRECT, byteBuffer, l, null);
        }
        return null;
    }

    public synchronized MemoryBuffer allocate(int n, MemType memType) {
        String string;
        if (memType == MemType.DIRECT && this.table.containsKey(string = this.generateKey(n, memType))) {
            MemoryBuffer memoryBuffer = this.table.remove(string);
            memoryBuffer.getBuffer().clear();
            return memoryBuffer;
        }
        return this._allocate(n, memType);
    }

    public synchronized void cache(MemoryBuffer memoryBuffer) {
        if (memoryBuffer.getType() == MemType.DIRECT) {
            String string = this.generateKey(memoryBuffer.getBuffer().capacity(), memoryBuffer.getType());
            if (!this.table.containsKey(string)) {
                this.table.put(string, memoryBuffer);
            } else {
                memoryBuffer.free();
            }
        }
    }

    private String generateKey(int n, MemType memType) {
        String string = n + ":" + (Object)((Object)memType);
        return string;
    }

    private MemoryBuffer _allocate(int n, MemType memType) {
        if (memType == MemType.INDIRECT) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            byteBuffer.order(ByteOrder.nativeOrder());
            long l = 0L;
            return new MemoryBuffer(MemType.INDIRECT, byteBuffer, l, this);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        long l = ((DirectBuffer)((Object)byteBuffer)).address();
        return new MemoryBuffer(MemType.DIRECT, byteBuffer, l, this);
    }

    public synchronized void cleanupBuffers() {
        for (MemoryBuffer memoryBuffer : this.table.values()) {
            if (memoryBuffer.getType() != MemType.DIRECT) continue;
            memoryBuffer.free();
        }
        this.table.clear();
    }

    public static enum MemType {
        INDIRECT,
        DIRECT;

    }
}

