/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.endpoints;

import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpoint;
import com.ibm.net.rdma.jverbs.verbs.ProtectionDomain;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

class RdmaEndpointProvider {
    private static RdmaEndpointProvider provider = null;
    protected ConcurrentHashMap<Integer, ProtectionDomain> pdMap = new ConcurrentHashMap();

    private RdmaEndpointProvider() {
    }

    public static synchronized RdmaEndpointProvider getEndpointProvider() {
        if (provider == null) {
            provider = new RdmaEndpointProvider();
        }
        return provider;
    }

    public synchronized ProtectionDomain createProtectionDomain(RdmaEndpoint rdmaEndpoint) throws IllegalArgumentException, IOException {
        VerbsContext verbsContext = rdmaEndpoint.getConnectionId().getVerbsContext();
        if (verbsContext != null) {
            ProtectionDomain protectionDomain = null;
            int n = verbsContext.getFD();
            if (!this.pdMap.containsKey(n)) {
                protectionDomain = verbsContext.allocProtectionDomain();
                this.pdMap.put(verbsContext.getFD(), protectionDomain);
            }
            protectionDomain = this.pdMap.get(verbsContext.getFD());
            return protectionDomain;
        }
        throw new IllegalArgumentException("Setting up protection domain, no context found");
    }
}

