/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.endpoints;

import com.ibm.net.rdma.jverbs.cm.ConnectionEvent;
import com.ibm.net.rdma.jverbs.cm.ConnectionId;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpoint;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpointGroup;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.LinkedBlockingDeque;

public class RdmaServerEndpoint<C extends RdmaEndpoint> {
    private static int CONN_STATE_INITIALIZED = 0;
    private static int CONN_STATE_READY_FOR_ACCEPT = 1;
    private static int CONN_STATE_CLOSED = 2;
    protected int endpointId;
    protected ConnectionId idPriv;
    private RdmaEndpointGroup<C> group;
    private LinkedBlockingDeque<C> requested;
    private int connState;

    protected RdmaServerEndpoint(RdmaEndpointGroup<C> rdmaEndpointGroup, ConnectionId connectionId) {
        this.endpointId = rdmaEndpointGroup.getNextId();
        this.group = rdmaEndpointGroup;
        this.idPriv = connectionId;
        this.connState = CONN_STATE_INITIALIZED;
        this.requested = new LinkedBlockingDeque();
    }

    public synchronized RdmaServerEndpoint<C> bind(SocketAddress socketAddress, int n) throws IOException {
        if (this.connState != CONN_STATE_INITIALIZED) {
            throw new IOException("Endpoint has to be disconnected for bind");
        }
        this.connState = CONN_STATE_READY_FOR_ACCEPT;
        this.idPriv.bindAddress(socketAddress);
        this.idPriv.listen(n);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C accept() throws IOException, InterruptedException {
        Object object = this;
        synchronized (object) {
            if (this.connState != CONN_STATE_READY_FOR_ACCEPT) {
                throw new IOException("Bind needs to be called before accept, current state =" + this.connState);
            }
            if (this.requested.peek() == null) {
                this.wait();
            }
        }
        object = (RdmaEndpoint)this.requested.poll();
        ((RdmaEndpoint)object).accept();
        return (C)object;
    }

    protected synchronized void dispatchConnectionEvent(ConnectionEvent connectionEvent) throws IOException {
        ConnectionEvent.EventType eventType = connectionEvent.getEventType();
        if (eventType == ConnectionEvent.EventType.RDMA_CM_EVENT_CONNECT_REQUEST) {
            ConnectionId connectionId = connectionEvent.getConnectionId();
            C c = this.group.createEndpoint(connectionId);
            ((RdmaEndpoint)c).dispatchConnectionEvent(connectionEvent);
            this.requested.add(c);
            this.notifyAll();
        } else if (eventType == ConnectionEvent.EventType.RDMA_CM_EVENT_DISCONNECTED) {
            this.connState = CONN_STATE_CLOSED;
        }
    }

    public synchronized void close() throws IOException {
        if (this.connState != CONN_STATE_CLOSED) {
            this.connState = CONN_STATE_CLOSED;
            this.idPriv.destroy();
        }
        this.group.unregisterServerEndpoint(this);
    }

    public synchronized boolean isBound() {
        return this.connState == CONN_STATE_READY_FOR_ACCEPT;
    }

    public synchronized boolean isClosed() {
        return this.connState == CONN_STATE_CLOSED;
    }

    public SocketAddress getSourceAddress() throws IOException {
        return this.idPriv.getSourceAddress();
    }

    public int getSourcePort() throws IOException {
        return this.idPriv.getSourcePort();
    }

    public ConnectionId getConnectionId() {
        return this.idPriv;
    }

    protected int getEndpointId() {
        return this.endpointId;
    }
}

