/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.NativeSizeConstants;
import com.ibm.net.rdma.jverbs.common.MemoryBuffer;
import com.ibm.net.rdma.jverbs.common.MemoryBufferPool;
import com.ibm.net.rdma.jverbs.verbs.NativeRdmaJVerbs;
import com.ibm.net.rdma.jverbs.verbs.NativeReceiveWorkRequest;
import com.ibm.net.rdma.jverbs.verbs.PostReceiveMethod;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.QueuePairLimit;
import com.ibm.net.rdma.jverbs.verbs.ReceiveWorkRequest;
import com.ibm.net.rdma.jverbs.verbs.ScatterGatherElement;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

class NativePostReceiveMethod
extends PostReceiveMethod {
    private MemoryBufferPool memAlloc;
    private NativeRdmaJVerbs verbsImpl;
    private int qpNum = -1;
    private LinkedList<NativeReceiveWorkRequest> wrNatList;
    private LinkedList<ScatterGatherElement> sgeNatList;
    private MemoryBuffer cmd;
    private boolean valid = false;
    private boolean success = false;

    public NativePostReceiveMethod(NativeRdmaJVerbs nativeRdmaJVerbs, MemoryBufferPool memoryBufferPool, QueuePair queuePair, List<ReceiveWorkRequest> list) throws IOException {
        this.verbsImpl = nativeRdmaJVerbs;
        this.memAlloc = memoryBufferPool;
        this.wrNatList = new LinkedList();
        this.sgeNatList = new LinkedList();
        this.qpNum = queuePair.getQueuePairNum();
        QueuePairLimit queuePairLimit = queuePair.getQueuePairLimit();
        int n = list.size();
        if (n > queuePairLimit.getMaxReceiveWorkRequest()) {
            throw new IOException("QueuePair Limit exceeded for work request");
        }
        this.wrNatList.clear();
        this.sgeNatList.clear();
        int n2 = 0;
        long l = n * NativeSizeConstants.IBV_RECV_WR_SIZE;
        long l2 = NativeSizeConstants.IBV_RECV_WR_SIZE;
        int n3 = queuePairLimit.getMaxReceiveSge();
        for (ReceiveWorkRequest object : list) {
            NativeReceiveWorkRequest nativeReceiveWorkRequest = new NativeReceiveWorkRequest(object);
            nativeReceiveWorkRequest.setPtr_sge_list(l);
            nativeReceiveWorkRequest.setNext(l2);
            this.wrNatList.add(nativeReceiveWorkRequest);
            this.sgeNatList.addAll(object.getSgeList());
            int n4 = object.getSgeList().size();
            n2 += NativeSizeConstants.IBV_RECV_WR_SIZE;
            n2 += n4 * NativeSizeConstants.IBV_SGE_SIZE;
            l2 += (long)NativeSizeConstants.IBV_RECV_WR_SIZE;
            l += (long)(n4 * NativeSizeConstants.IBV_SGE_SIZE);
            if (n4 <= n3) continue;
            throw new IOException("QueuePair SGE Limit (" + n3 + ") exceeded for number of sge (" + n4 + ")");
        }
        this.cmd = memoryBufferPool.allocate(n2, MemoryBufferPool.MemType.DIRECT);
        for (NativeReceiveWorkRequest nativeReceiveWorkRequest : this.wrNatList) {
            nativeReceiveWorkRequest.shiftAddress(this.cmd.getAddress());
        }
        this.wrNatList.getLast().setNext(0L);
        for (NativeReceiveWorkRequest nativeReceiveWorkRequest : this.wrNatList) {
            nativeReceiveWorkRequest.writeBack(this.cmd.getBuffer());
        }
        for (ScatterGatherElement scatterGatherElement : this.sgeNatList) {
            this.cmd.getBuffer().putLong(scatterGatherElement.getAddress());
            this.cmd.getBuffer().putInt(scatterGatherElement.getLength());
            this.cmd.getBuffer().putInt(scatterGatherElement.getLocalKey());
        }
        this.valid = true;
    }

    @Override
    public PostReceiveMethod execute() {
        this.success = false;
        if (!this.valid) {
            return this;
        }
        int n = this.verbsImpl.postRecv0(this.qpNum, this.cmd.getAddress());
        if (n >= 0) {
            this.success = true;
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public PostReceiveMethod free() {
        if (this.cmd != null) {
            this.cmd.free();
            this.cmd = null;
        }
        this.valid = false;
        return this;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }
}

