/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.NativeSizeConstants;
import com.ibm.net.rdma.jverbs.common.MemoryBuffer;
import com.ibm.net.rdma.jverbs.common.MemoryBufferPool;
import com.ibm.net.rdma.jverbs.verbs.NativeRdmaJVerbs;
import com.ibm.net.rdma.jverbs.verbs.NativeScatterGatherElement;
import com.ibm.net.rdma.jverbs.verbs.NativeSendWorkRequest;
import com.ibm.net.rdma.jverbs.verbs.PostSendMethod;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.QueuePairLimit;
import com.ibm.net.rdma.jverbs.verbs.ScatterGatherElement;
import com.ibm.net.rdma.jverbs.verbs.SendWorkRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class NativePostSendMethod
extends PostSendMethod {
    private NativeRdmaJVerbs verbsImpl;
    private MemoryBufferPool memAlloc;
    private ArrayList<NativeSendWorkRequest> wrNatList;
    private ArrayList<NativeScatterGatherElement> sgeNatList;
    private int qpNum;
    private MemoryBuffer cmd;
    private boolean valid = false;
    private boolean success = false;

    public NativePostSendMethod(NativeRdmaJVerbs nativeRdmaJVerbs, MemoryBufferPool memoryBufferPool, QueuePair queuePair, List<SendWorkRequest> list) throws IOException {
        this.verbsImpl = nativeRdmaJVerbs;
        this.memAlloc = memoryBufferPool;
        this.cmd = null;
        this.wrNatList = new ArrayList();
        this.sgeNatList = new ArrayList();
        this.qpNum = queuePair.getQueuePairNum();
        QueuePairLimit queuePairLimit = queuePair.getQueuePairLimit();
        int n = list.size();
        if (n > queuePairLimit.getMaxSendWorkRequest()) {
            throw new IOException("QueuePair Limit exceeded for work request");
        }
        this.wrNatList.clear();
        this.sgeNatList.clear();
        int n2 = 0;
        long l = n * NativeSizeConstants.IBV_SEND_WR_SIZE;
        long l2 = NativeSizeConstants.IBV_SEND_WR_SIZE;
        int n3 = queuePairLimit.getMaxSendSge();
        for (SendWorkRequest object : list) {
            LinkedList<ScatterGatherElement> linkedList = new LinkedList<ScatterGatherElement>();
            for (ScatterGatherElement scatterGatherElement : object.getSgeList()) {
                NativeScatterGatherElement nativeScatterGatherElement = new NativeScatterGatherElement(this, scatterGatherElement);
                linkedList.add(nativeScatterGatherElement);
                this.sgeNatList.add(nativeScatterGatherElement);
            }
            NativeSendWorkRequest nativeSendWorkRequest = new NativeSendWorkRequest(this, object, linkedList);
            nativeSendWorkRequest.setPtr_sge_list(l);
            nativeSendWorkRequest.setNext(l2);
            this.wrNatList.add(nativeSendWorkRequest);
            int n4 = object.getSgeList().size();
            n2 += NativeSizeConstants.IBV_SEND_WR_SIZE;
            n2 += n4 * NativeSizeConstants.IBV_SGE_SIZE;
            l2 += (long)NativeSizeConstants.IBV_SEND_WR_SIZE;
            l += (long)(n4 * NativeSizeConstants.IBV_SGE_SIZE);
            if (n4 <= n3) continue;
            throw new IOException("QueuePair SGE Limit (" + n3 + ") exceeded for number of sge (" + n4 + ")");
        }
        this.cmd = memoryBufferPool.allocate(n2, MemoryBufferPool.MemType.DIRECT);
        for (NativeSendWorkRequest nativeSendWorkRequest : this.wrNatList) {
            nativeSendWorkRequest.shiftAddress(this.cmd.getAddress());
        }
        this.wrNatList.get(this.wrNatList.size() - 1).setNext(0L);
        for (NativeSendWorkRequest nativeSendWorkRequest : this.wrNatList) {
            nativeSendWorkRequest.setBufPosition(this.cmd.getBuffer().position());
            nativeSendWorkRequest.writeBack(this.cmd.getBuffer());
        }
        for (NativeScatterGatherElement nativeScatterGatherElement : this.sgeNatList) {
            nativeScatterGatherElement.setBufPosition(this.cmd.getBuffer().position());
            this.cmd.getBuffer().putLong(nativeScatterGatherElement.getAddress());
            this.cmd.getBuffer().putInt(nativeScatterGatherElement.getLength());
            this.cmd.getBuffer().putInt(nativeScatterGatherElement.getLocalKey());
        }
        this.valid = true;
    }

    @Override
    public PostSendMethod execute() {
        this.success = false;
        if (!this.valid) {
            return this;
        }
        int n = this.verbsImpl.postSend0(this.qpNum, this.cmd.getAddress());
        if (n >= 0) {
            this.success = true;
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public PostSendMethod free() {
        if (this.cmd != null) {
            this.cmd.free();
            this.cmd = null;
        }
        this.valid = false;
        return this;
    }

    @Override
    public PostSendMethod.StatefulWorkRequest getStatefulWorkRequest(int n) throws IndexOutOfBoundsException {
        return this.wrNatList.get(n);
    }

    void setWr_id(NativeSendWorkRequest nativeSendWorkRequest, int n, long l) {
        int n2 = nativeSendWorkRequest.getBufPosition() + n;
        this.cmd.getBuffer().putLong(n2, nativeSendWorkRequest.getWorkRequestId());
    }

    public void setRemote_addr(NativeSendWorkRequest.NatRdma natRdma, int n) {
        int n2 = natRdma.getBufPosition() + n;
        this.cmd.getBuffer().putLong(n2, natRdma.getRemoteAddress());
    }

    public void setRkey(NativeSendWorkRequest.NatRdma natRdma, int n) {
        int n2 = natRdma.getBufPosition() + n;
        this.cmd.getBuffer().putInt(n2, natRdma.getRemoteKey());
    }

    public void setReserved(NativeSendWorkRequest.NatRdma natRdma, int n) {
        int n2 = natRdma.getBufPosition() + n;
        this.cmd.getBuffer().putInt(n2, 0);
    }

    public void setAddr(NativeScatterGatherElement nativeScatterGatherElement, int n) {
        int n2 = nativeScatterGatherElement.getBufPosition() + n;
        this.cmd.getBuffer().putLong(n2, nativeScatterGatherElement.getAddress());
    }

    public void setLength(NativeScatterGatherElement nativeScatterGatherElement, int n) {
        int n2 = nativeScatterGatherElement.getBufPosition() + n;
        this.cmd.getBuffer().putInt(n2, nativeScatterGatherElement.getLength());
    }

    public void setLkey(NativeScatterGatherElement nativeScatterGatherElement, int n) {
        int n2 = nativeScatterGatherElement.getBufPosition() + n;
        this.cmd.getBuffer().putInt(n2, nativeScatterGatherElement.getLocalKey());
    }
}

