/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.NativeSizeConstants;
import com.ibm.net.rdma.jverbs.verbs.ReceiveWorkRequest;
import java.nio.ByteBuffer;

class NativeReceiveWorkRequest
extends ReceiveWorkRequest {
    private long next = 0L;
    private long ptr_sge_list = 0L;

    public NativeReceiveWorkRequest(ReceiveWorkRequest receiveWorkRequest) {
        this.workRequestId = receiveWorkRequest.getWorkRequestId();
        this.numSge = receiveWorkRequest.getNumSge();
    }

    public void writeBack(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.putLong(this.workRequestId);
        if (NativeSizeConstants.INT_SIZE == NativeSizeConstants.VOID_POINTER_SIZE) {
            byteBuffer.putInt((int)this.next);
            byteBuffer.putInt((int)this.ptr_sge_list);
        } else {
            byteBuffer.putLong(this.next);
            byteBuffer.putLong(this.ptr_sge_list);
        }
        byteBuffer.putInt(this.numSge);
        int n2 = n + NativeSizeConstants.IBV_RECV_WR_SIZE;
        byteBuffer.position(n2);
    }

    public long getNext() {
        return this.next;
    }

    public void setNext(long l) {
        this.next = l;
    }

    public long getPtr_sge_list() {
        return this.ptr_sge_list;
    }

    public void setPtr_sge_list(long l) {
        this.ptr_sge_list = l;
    }

    public void shiftAddress(long l) {
        this.next += l;
        this.ptr_sge_list += l;
    }
}

