/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.NativeSizeConstants;
import com.ibm.net.rdma.jverbs.verbs.NativePostSendMethod;
import com.ibm.net.rdma.jverbs.verbs.PostSendMethod;
import com.ibm.net.rdma.jverbs.verbs.ScatterGatherElement;
import com.ibm.net.rdma.jverbs.verbs.SendWorkRequest;
import java.nio.ByteBuffer;
import java.util.LinkedList;

class NativeSendWorkRequest
extends SendWorkRequest
implements PostSendMethod.StatefulWorkRequest {
    private NativePostSendMethod postSendCall;
    private int bufPosition;
    private long next = 0L;
    private long ptr_sge_list = 0L;

    public NativeSendWorkRequest(NativePostSendMethod nativePostSendMethod, SendWorkRequest sendWorkRequest, LinkedList<ScatterGatherElement> linkedList) {
        super(new NatRdma(sendWorkRequest.getRdma(), nativePostSendMethod), null, null, linkedList);
        this.workRequestId = sendWorkRequest.getWorkRequestId();
        this.sgeCount = sendWorkRequest.getSgeCount();
        this.opCode = sendWorkRequest.getOpcode();
        this.sendFlags = sendWorkRequest.getSendFlags();
        this.immediateData = sendWorkRequest.getImmediateData();
        this.postSendCall = nativePostSendMethod;
        this.bufPosition = 0;
    }

    public void writeBack(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.putLong(this.workRequestId);
        if (NativeSizeConstants.INT_SIZE == NativeSizeConstants.VOID_POINTER_SIZE) {
            byteBuffer.putInt((int)this.next);
            byteBuffer.putInt((int)this.ptr_sge_list);
        } else {
            byteBuffer.putLong(this.next);
            byteBuffer.putLong(this.ptr_sge_list);
        }
        byteBuffer.putInt(this.sgeCount);
        byteBuffer.putInt(this.opCode.getValue());
        byteBuffer.putInt(this.sendFlags);
        byteBuffer.putInt(this.immediateData);
        byteBuffer.putLong(this.rdma.getRemoteAddress());
        byteBuffer.putInt(this.rdma.getRemoteKey());
        byteBuffer.putInt(this.rdma.getReserved());
        int n2 = n + NativeSizeConstants.IBV_SEND_WR_SIZE;
        byteBuffer.position(n2);
    }

    public long getNext() {
        return this.next;
    }

    public void setNext(long l) {
        this.next = l;
    }

    public int getCsize() {
        return NativeSizeConstants.IBV_SEND_WR_SIZE;
    }

    public long getPtr_sge_list() {
        return this.ptr_sge_list;
    }

    public void setPtr_sge_list(long l) {
        this.ptr_sge_list = l;
    }

    public void shiftAddress(long l) {
        this.next += l;
        this.ptr_sge_list += l;
    }

    public int getBufPosition() {
        return this.bufPosition;
    }

    public void setBufPosition(int n) {
        this.bufPosition = n;
        ((NatRdma)this.rdma).setBufPosition(n + 40);
    }

    @Override
    public void setWorkRequestId(long l) {
        super.setWorkRequestId(l);
        this.postSendCall.setWr_id(this, 0, l);
    }

    @Override
    public PostSendMethod.StatefulRdma getStatefulRdma() {
        return (PostSendMethod.StatefulRdma)((Object)this.rdma);
    }

    @Override
    public PostSendMethod.StatefulSge getStatefulSge(int n) throws IndexOutOfBoundsException {
        return (PostSendMethod.StatefulSge)this.sgeList.get(n);
    }

    public static class NatRdma
    extends SendWorkRequest.Rdma
    implements PostSendMethod.StatefulRdma {
        private NativePostSendMethod postSendCall;
        private int bufPosition;

        public NatRdma(SendWorkRequest.Rdma rdma, NativePostSendMethod nativePostSendMethod) {
            this.remoteAddress = rdma.getRemoteAddress();
            this.reserved = rdma.getReserved();
            this.remoteKey = rdma.getRemoteKey();
            this.postSendCall = nativePostSendMethod;
            this.bufPosition = 0;
        }

        @Override
        public void setRemoteAddress(long l) {
            super.setRemoteAddress(l);
            this.postSendCall.setRemote_addr(this, 0);
        }

        @Override
        public void setRemoteKey(int n) {
            super.setRemoteKey(n);
            this.postSendCall.setRkey(this, NativeSizeConstants.LONG_SIZE);
        }

        public int getBufPosition() {
            return this.bufPosition;
        }

        public void setBufPosition(int n) {
            this.bufPosition = n;
        }
    }
}

