/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class DSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.DSAPrivateKey,
Serializable {
    static final long serialVersionUID = 6681063074876594473L;
    private BigInteger x;
    private static final String z;

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.x = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z + iOException.getMessage());
        }
    }

    public DSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    protected void parseKeyBits() throws IOException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public void zeroize() {
        this.x = BigInteger.ZERO;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "\u0002.#v\u0010A/9nT%\u0004\u0004:\u0011\u000f\"9~\u0011A9l:".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 97;
                            break;
                        }
                        case 1: {
                            n7 = 65;
                            break;
                        }
                        case 2: {
                            n7 = 86;
                            break;
                        }
                        case 3: {
                            n7 = 26;
                            break;
                        }
                        default: {
                            n7 = 116;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
    }
}

