/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ECNamedCurve;
import com.ibm.crypto.fips.provider.ECParameterGenerator;
import com.ibm.crypto.fips.provider.ECPrivateKey;
import com.ibm.crypto.fips.provider.ECPublicKey;
import com.ibm.crypto.fips.provider.ECUtils;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.IBMJCEFIPS;
import com.ibm.crypto.fips.provider.PrimeCurve;
import com.ibm.crypto.fips.provider.PrimeField;
import com.ibm.crypto.fips.provider.SHA2withECDSA;
import com.ibm.crypto.fips.provider.SelfTest;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int a = 256;
    SecureRandom b = null;
    ECParameterSpec c;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 192 || n2 > 521 || n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new InvalidParameterException(z[0]);
        }
        this.a = n2;
        this.b = IBMJCEFIPS.f();
        this.c = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.c = ECUtils.getPrimeParameterSpec((ECParameterSpec)algorithmParameterSpec);
            this.b = IBMJCEFIPS.f();
            this.a = this.c.getCurve().getField().getFieldSize();
            return;
        }
        if (!(algorithmParameterSpec instanceof ECGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[3]);
        }
        this.c = ECNamedCurve.getECParameterSpec(((ECGenParameterSpec)algorithmParameterSpec).getName());
        if (this.c == null) {
            throw new InvalidAlgorithmParameterException(z[4]);
        }
        this.b = secureRandom;
        this.a = this.c.getCurve().getField().getFieldSize();
    }

    @Override
    public KeyPair generateKeyPair() {
        String string = z[2];
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        KeyPair keyPair = this.a();
        if (!this.a(keyPair)) {
            SelfTest.failure = new FIPSRuntimeException(string);
            SelfTest.state = SelfTest.ERROR;
            throw new FIPSRuntimeException(string);
        }
        return keyPair;
    }

    protected KeyPair a() {
        if (this.b == null) {
            this.b = IBMJCEFIPS.f();
        }
        if (this.c == null) {
            this.b();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        int n3 = 64;
        BigInteger bigInteger = new BigInteger(n2 + n3, this.b);
        bigInteger = bigInteger.abs();
        try {
            PrimeCurve primeCurve = ECUtils.getPrimeCurve(this.c.getCurve());
            BigInteger bigInteger2 = ((ECFieldFp)primeCurve.getField()).getP().subtract(BigInteger.ONE);
            BigInteger bigInteger3 = bigInteger.mod(bigInteger2).add(BigInteger.ONE);
            ECPoint eCPoint = primeCurve.multiply(((PrimeField)primeCurve.getField()).bigIntegerTointernal(bigInteger3), primeCurve.toEllipticPoint(this.c.getGenerator())).getAffine();
            ECPublicKey eCPublicKey = new ECPublicKey(eCPoint, this.c);
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger3, this.c, eCPublicKey);
            KeyPair keyPair = new KeyPair(eCPublicKey, eCPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void b() {
        switch (this.a) {
            case 192: {
                PrimeField primeField = ECUtils.getField(192, ECParameterGenerator.a, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.a), ECParameterGenerator.c, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.f, ECParameterGenerator.b, 1);
                break;
            }
            case 224: {
                PrimeField primeField = ECUtils.getField(224, ECParameterGenerator.g, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.g), ECParameterGenerator.i, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.l, ECParameterGenerator.h, 1);
                break;
            }
            case 256: {
                PrimeField primeField = ECUtils.getField(256, ECParameterGenerator.m, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.m), ECParameterGenerator.o, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.r, ECParameterGenerator.n, 1);
                break;
            }
            case 384: {
                PrimeField primeField = ECUtils.getField(384, ECParameterGenerator.s, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.s), ECParameterGenerator.u, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.x, ECParameterGenerator.t, 1);
                break;
            }
            case 521: {
                PrimeField primeField = ECUtils.getField(521, ECParameterGenerator.y, true);
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, ECParameterGenerator.E.mod(ECParameterGenerator.y), ECParameterGenerator.A, 1);
                this.c = new ECParameterSpec(primeCurve, ECParameterGenerator.D, ECParameterGenerator.z, 1);
            }
        }
    }

    private boolean a(KeyPair keyPair) {
        PrivateKey privateKey;
        PublicKey publicKey;
        byte[] byArray = z[1].getBytes();
        try {
            publicKey = keyPair.getPublic();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            privateKey = keyPair.getPrivate();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            SHA2withECDSA sHA2withECDSA = new SHA2withECDSA();
            sHA2withECDSA.a(privateKey);
            sHA2withECDSA.a(byArray, 0, byArray.length);
            byte[] byArray2 = sHA2withECDSA.c();
            sHA2withECDSA.a(publicKey);
            sHA2withECDSA.a(byArray, 0, byArray.length);
            if (!sHA2withECDSA.a(byArray2)) {
                ((ECPublicKey)publicKey).zeroize();
                ((ECPrivateKey)privateKey).zeroize();
                return false;
            }
        }
        catch (Exception exception) {
            ((ECPublicKey)publicKey).zeroize();
            ((ECPrivateKey)privateKey).zeroize();
            return false;
        }
        return true;
    }

    protected void finalize() {
        this.b = null;
        this.c = null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "(H{{IXI{lIXWgeXXXw6C\u0016_2yJB\u001a#/\u001eT\u001a $\u0018T\u001a #\u001aT\u001a!.\u0018T\u001a'$\u001d";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 120;
                                break;
                            }
                            case 1: {
                                n9 = 58;
                                break;
                            }
                            case 2: {
                                n9 = 18;
                                break;
                            }
                            case 3: {
                                n9 = 22;
                                break;
                            }
                            default: {
                                n9 = 44;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "9xQRi>}Z_f3v_Xc(k@Ex-lEN{\"";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "=yVEmXi{qBX\u001c2@I\nSto\f,_ab\f>[{zI\u001c\u00142BD\u001d\u001a[Ta2yWPe(i2f^\u0017L{rI\n\u001a{e\f\u0011T2wBXS|uC\u0016I{eX\u001dTf6_\f[fs\u0002XhweX\u0019Hf6X\u0010_2\\M\u000e[2@E\nNgw@XwsuD\u0011Tw8\f1\\2bD\u001d\u001awd^\u0017H2fI\nI{eX\u000b\u00162f@\u001d[as\f\u001bU|bM\u001bN2_n5\u001aAc\\\bU`b\u0002";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "([`wA\u000b\u001a\u007fc_\f\u001aps\f\u0011TabM\u0016Yw6C\u001e\u001aWU|\u0019Hs{I\f_`E\\\u001dY2y^X\u007fQQI\u0016jsdM\u0015_fs^+Jwu";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ";O``IXTs{IXT}b\f\n_qyK\u0016ShsHXU`6B\u0017N2eY\bJ}dX\u001d^";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

