/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.EllipticPoint;
import com.ibm.crypto.fips.provider.PrimeField;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;

public class GenericPrimeField
extends ECFieldFp
implements PrimeField {
    public GenericPrimeField(BigInteger bigInteger) {
        super(bigInteger);
    }

    @Override
    public BigInteger multiply(Object object, Object object2) {
        BigInteger bigInteger = (BigInteger)object;
        bigInteger = bigInteger.multiply((BigInteger)object2).mod(this.getP());
        return bigInteger;
    }

    @Override
    public BigInteger divide(Object object, Object object2) {
        BigInteger bigInteger = (BigInteger)object;
        BigInteger bigInteger2 = (BigInteger)object2;
        bigInteger2 = bigInteger2.modInverse(this.getP());
        bigInteger = bigInteger.multiply(bigInteger2).mod(this.getP());
        return bigInteger;
    }

    @Override
    public BigInteger add(Object object, Object object2) {
        BigInteger bigInteger = (BigInteger)object;
        bigInteger = bigInteger.add((BigInteger)object2).mod(this.getP());
        return bigInteger;
    }

    @Override
    public BigInteger subtract(Object object, Object object2) {
        BigInteger bigInteger = (BigInteger)object;
        bigInteger = bigInteger.subtract((BigInteger)object2).mod(this.getP());
        return bigInteger;
    }

    @Override
    public BigInteger shiftLeft(Object object, int n2) {
        BigInteger bigInteger = (BigInteger)object;
        bigInteger = bigInteger.shiftLeft(n2).mod(this.getP());
        return bigInteger;
    }

    @Override
    public BigInteger shiftRight(Object object, int n2) {
        BigInteger bigInteger = (BigInteger)object;
        bigInteger = bigInteger.shiftRight(n2).mod(this.getP());
        return bigInteger;
    }

    @Override
    public boolean isInternalZero(Object object) {
        return object == BigInteger.ZERO || BigInteger.ZERO.compareTo((BigInteger)object) == 0;
    }

    @Override
    public boolean isInternalOne(Object object) {
        return object == BigInteger.ONE || BigInteger.ONE.compareTo((BigInteger)object) == 0;
    }

    @Override
    public boolean isInternalEqual(Object object, Object object2) {
        return ((BigInteger)object).compareTo((BigInteger)object2) == 0;
    }

    @Override
    public BigInteger internalZero() {
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger internalOne() {
        return BigInteger.ONE;
    }

    @Override
    public BigInteger internalToBigInteger(Object object) {
        return (BigInteger)object;
    }

    @Override
    public BigInteger bigIntegerTointernal(BigInteger bigInteger) {
        return bigInteger;
    }

    @Override
    public EllipticPoint internalMontgomeryLadderMultiply(Object object, EllipticPoint ellipticPoint) {
        EllipticPoint ellipticPoint2 = ellipticPoint;
        EllipticPoint ellipticPoint3 = ellipticPoint.infinity();
        byte[] byArray = ((BigInteger)object).toByteArray();
        block0: for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            int n2 = byArray[i2];
            boolean bl = i2 == 0;
            int n3 = 0;
            while (n3 < 8) {
                if ((n2 & 1) == 1) {
                    ellipticPoint3.add(ellipticPoint2);
                }
                if (bl && n2 == 1) continue block0;
                ellipticPoint2.doublee();
                ++n3;
                n2 >>= 1;
            }
        }
        return ellipticPoint3;
    }
}

