/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.DHParameters;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.DHKey;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class DHPublicKey
extends X509Key
implements javax.crypto.interfaces.DHPublicKey,
PublicKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -2993913181811776154L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger y = null;
    private DHParameters dhParams = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private transient boolean destroyed = false;
    private transient DHKey dhKey = null;
    private static final String[] z;

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        this.dhParams = new DHParameters(iBMJCEPlusProvider);
        try {
            this.dhParams.engineInit(new DHParameterSpec(bigInteger2, bigInteger3, n2));
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[20]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z[19]);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, DHParameters dHParameters) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        this.dhParams = dHParameters;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[5]);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, DHKey dHKey) {
        try {
            this.provider = iBMJCEPlusProvider;
            byte[] byArray = this.a(dHKey.getPublicKeyBytes());
            this.dhKey = dHKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[6], (Throwable)exception);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.a(byArray);
            byte[] byArray2 = this.a();
            this.dhKey = DHKey.createPublicKey(iBMJCEPlusProvider.a(), this.encodedKey);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[21]);
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[22], (Throwable)exception);
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new IOException(z[10]);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new IOException(z[11]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new IOException(z[17]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new IOException(z[16]);
            }
            if (derValue3.getTag() != 48) {
                throw new IOException(z[13]);
            }
            derValue3.getData().reset();
            BigInteger bigInteger = derValue3.getData().getInteger();
            BigInteger bigInteger2 = derValue3.getData().getInteger();
            int n2 = -1;
            if (derValue3.getData().available() != 0) {
                n2 = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new IOException(z[14]);
            }
            this.key = derValue.getData().getBitString();
            this.parseKeyBits();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(z[15]);
            }
            DHParameters dHParameters = this.dhParams = new DHParameters(this.provider);
            DHParameterSpec dHParameterSpec = n2 == -1 ? new DHParameterSpec(bigInteger, bigInteger2, this.y.bitLength()) : new DHParameterSpec(bigInteger, bigInteger2, n2);
            dHParameters.engineInit(dHParameterSpec);
            this.encodedKey = (byte[])byArray.clone();
            DerValue derValue4 = new DerValue(2, this.key);
            return derValue4.toByteArray();
        }
        catch (IOException | NumberFormatException exception) {
            throw new IOException(z[8], exception);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException(z[9], invalidKeyException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[12], invalidParameterSpecException);
        }
    }

    private byte[] a() throws Exception {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.y.toByteArray()), new DerValue(2, this.dhParams.a().toByteArray()), new DerValue(2, this.dhParams.b().toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.a(derOutputStream);
        }
        return derOutputStream.toByteArray();
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    @Override
    public DHParameterSpec getParams() {
        this.c();
        try {
            return this.dhParams.engineGetParameterSpec(DHParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw this.provider.a(z[18], (Throwable)invalidParameterSpecException);
        }
    }

    @Override
    public String getAlgorithm() {
        this.c();
        return z[4];
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncoded() {
        this.c();
        DerOutputStream derOutputStream = null;
        DerOutputStream derOutputStream2 = null;
        DerOutputStream derOutputStream3 = null;
        DerOutputStream derOutputStream4 = null;
        if (this.encodedKey == null) {
            try {
                derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(this.dhParams.a());
                derOutputStream.putInteger(this.dhParams.b());
                if (this.dhParams.c() != 0) {
                    derOutputStream.putInteger(BigInteger.valueOf(this.dhParams.c()));
                }
                DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream2);
                derOutputStream3.putBitString(this.key);
                derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
                this.a(derOutputStream);
                this.a(derOutputStream2);
                this.a(derOutputStream3);
                this.a(derOutputStream4);
            }
            catch (IOException iOException) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                this.a(derOutputStream);
                this.a(derOutputStream2);
                this.a(derOutputStream3);
                this.a(derOutputStream4);
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        this.c();
        return this.y;
    }

    DHKey b() {
        return this.dhKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.dhKey = null;
            this.y = null;
            this.dhParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[7]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[0] + this.y.toString() + z[1] + this.dhParams.a().toString() + z[3] + this.dhParams.b().toString());
        if (this.dhParams.c() != 0) {
            stringBuffer.append(z[2] + this.dhParams.c());
        }
        return stringBuffer.toString();
    }

    private void a(DerOutputStream derOutputStream) {
        try {
            derOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.y, this.dhParams.a(), this.dhParams.b()};
        return Arrays.hashCode(objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof javax.crypto.interfaces.DHPublicKey)) {
            return false;
        }
        javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)object;
        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
        if (this.y.compareTo(dHPublicKey.getY()) != 0) return false;
        if (this.dhParams.a().compareTo(dHParameterSpec.getP()) != 0) return false;
        if (this.dhParams.b().compareTo(dHParameterSpec.getG()) != 0) return false;
        if (object instanceof DHPublicKey) {
            return true;
        }
        if (this.hashCode() != object.hashCode()) return false;
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[23];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "6\u0017w\u0016\u000f:\u0005V)?_\u0011S:*\u00160\u0017\u0014)\u00139W=\"_\u0005O> \u00166\u001a\u0017)\u0006o0%vu";
        int n3 = -1;
        block30: while (true) {
            char[] cArray;
            block34: {
                int n4;
                int n5;
                block33: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block33;
                    n5 = n5;
                    if (n5 <= n4) break block34;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 127;
                            break;
                        }
                        case 1: {
                            n6 = 85;
                            break;
                        }
                        case 2: {
                            n6 = 58;
                            break;
                        }
                        case 3: {
                            n6 = 92;
                            break;
                        }
                        default: {
                            n6 = 76;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "u%\u0000V";
                    n3 = 0;
                    continue block30;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "u9\u0000Vl_u\u001a";
                    n3 = 1;
                    continue block30;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "u2\u0000V";
                    n3 = 2;
                    continue block30;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ";\u001d";
                    n3 = 3;
                    continue block30;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "<4T2#\u000buJ.#\u001b Y9l>\u0006tr}_0T?#\u001b<T;";
                    n3 = 4;
                    continue block30;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "94S09\r0\u001a5\"_\u0011r\f9\u001d9S?\u0007\u001a,";
                    n3 = 5;
                    continue block30;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "+=S/l\u00140C|%\fuT3l\u0013:T;)\ruL= \u00161";
                    n3 = 6;
                    continue block30;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ":'H3>_%[.?\u0016;]|'\u001a,\u001a9\"\u001c:^5\"\u0018";
                    n3 = 7;
                    continue block30;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = ":'H3>_%[.?\u0016;]|'\u001a,\u001a1-\u000b0H5-\u0013";
                    n3 = 8;
                    continue block30;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "6;L= \u00161\u001a7)\u0006u\\3>\u00124N";
                    n3 = 9;
                    continue block30;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = ">9]\u0015(_<I|\"\u0010!\u001a=l,\u0010k\t\t1\u0016\u007f";
                    n3 = 10;
                    continue block30;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = ":'H3>_6H9-\u000b<T;l;\u001dj=>\u001e8_()\r&";
                    n3 = 11;
                    continue block30;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "/4H=!\u001a!_.?_;U(l\u001eui\u0019\u001d*\u0010t\u001f\t";
                    n3 = 12;
                    continue block30;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = ":-N.-_%[.-\u00120N9>_1[(-";
                    n3 = 13;
                    continue block30;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = ":-Y9?\fuQ95_1[(-";
                    n3 = 14;
                    continue block30;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "1 V0l\u000f4H=!\u001a!_.?";
                    n3 = 15;
                    continue block30;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "/4H=!\u001a!_.?_8S/?\u0016;]";
                    n3 = 16;
                    continue block30;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "94S09\r0\u001a5\"_\u0011r\f9\u001d9S?\u0007\u001a,";
                    n3 = 17;
                    continue block30;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "<4T2#\u000buS2%\u000b<[0%\u00050\u001a,-\r4W98\u001a'I";
                    n3 = 18;
                    continue block30;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "<4T2#\u000buJ.#\u001b Y9l>\u0006tr}_0T?#\u001b<T;";
                    n3 = 19;
                    continue block30;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "6;L= \u00161\u001a7)\u0006u\\3>\u00124N";
                    n3 = 20;
                    continue block30;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "94S09\r0\u001a5\"_\u0011r\f9\u001d9S?\u0007\u001a,";
                    n3 = 21;
                    continue block30;
                }
                case 21: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

