/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.DSAKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class DSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.DSAPrivateKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -358600541133686399L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger x;
    private transient boolean destroyed = false;
    private transient DSAKey dsaKey = null;
    private static final String[] z;

    public DSAPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        this.provider = iBMJCEPlusProvider;
        this.x = bigInteger;
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[3] + iOException.getMessage());
        }
        try {
            byte[] byArray = this.b();
            this.dsaKey = DSAKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[2]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public DSAPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
        try {
            byte[] byArray2 = this.b();
            this.dsaKey = DSAKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray2);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[0]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public DSAPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, DSAKey dSAKey) throws InvalidKeyException {
        try {
            this.provider = iBMJCEPlusProvider;
            this.algid = new AlgorithmId(AlgorithmId.DSA_oid, dSAKey.getParameters());
            this.key = this.a(dSAKey.getPrivateKeyBytes());
            this.dsaKey = dSAKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[4]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    @Override
    public DSAParams getParams() {
        if (this.algid instanceof DSAParams) {
            return (DSAParams)this.algid;
        }
        try {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    @Override
    public String getAlgorithm() {
        this.c();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.c();
        return super.getEncoded();
    }

    DSAKey a() {
        return this.dsaKey;
    }

    protected void parseKeyBits() throws IOException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new IOException(z[5], iOException);
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(6);
        BigInteger bigInteger = derValueArray[5].getInteger();
        DerValue derValue = new DerValue(2, bigInteger.toByteArray());
        return derValue.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] b() throws IOException {
        DSAParams dSAParams = this.getParams();
        BigInteger bigInteger = dSAParams.getG().modPow(this.x, dSAParams.getP());
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, dSAParams.getP().toByteArray()), new DerValue(2, dSAParams.getQ().toByteArray()), new DerValue(2, dSAParams.getG().toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, this.x.toByteArray())};
        try (DerOutputStream derOutputStream = new DerOutputStream();){
            derOutputStream.putSequence(derValueArray);
            byte[] byArray = derOutputStream.toByteArray();
            return byArray;
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.dsaKey = null;
            this.x = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[1]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0000K7\u0005.\"\n*\u0006k%X;\b?#\n\u001a:\nfZ,\u0000='^;I #S";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                block16: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block16;
                    n5 = n5;
                    if (n5 <= n4) break block17;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 70;
                            break;
                        }
                        case 1: {
                            n6 = 42;
                            break;
                        }
                        case 2: {
                            n6 = 94;
                            break;
                        }
                        case 3: {
                            n6 = 105;
                            break;
                        }
                        default: {
                            n6 = 75;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0012B7\u001ak-O'I\"5\n0\u0006k*E0\u000e.4\n(\b'/N";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0000K7\u0005.\"\n*\u0006k%X;\b?#\n\u001a:\nfZ,\u0000='^;I #S";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "%E+\u0005/fD1\u001dk\u0002o\fI.(I1\r.fRdI";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0000K7\u0005.\"\n*\u0006k%X;\b?#\n\u001a:\nfZ,\u0000='^;I #S";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u000fD(\b'/N~-\u0018\u0007\n.\u001b\"0K*\fk-O'";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

