/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.XECKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509Key;
import ibm.security.internal.interfaces.EdECPublicKey;
import ibm.security.internal.spec.EdECPoint;
import ibm.security.internal.spec.NamedParameterSpec;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.util.Arrays;

public final class EdDSAPublicKeyImpl
extends X509Key
implements EdECPublicKey {
    private static final long serialVersionUID = 1L;
    private EdECPoint point;
    private IBMJCEPlusProvider provider = null;
    private NamedParameterSpec paramSpec;
    private transient XECKey xecKey = null;
    private static final String[] z;

    private void a(NamedParameterSpec.CURVE cURVE) throws Exception {
        byte[] byArray = this.xecKey.getPublicKeyBytes();
        this.setKey(new BitArray(byArray.length * 8, byArray));
        this.paramSpec = new NamedParameterSpec(cURVE);
        byte by = byArray[byArray.length - 1];
        int n2 = byArray.length - 1;
        byArray[n2] = (byte)(byArray[n2] & 0x7F);
        boolean bl = (by & 0x80) != 0;
        boolean bl2 = bl;
        EdDSAPublicKeyImpl.b(byArray);
        BigInteger bigInteger = new BigInteger(1, byArray);
        this.point = new EdECPoint(bl2, bigInteger);
    }

    public EdDSAPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, XECKey xECKey, NamedParameterSpec.CURVE cURVE) throws InvalidKeyException {
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[8]);
        }
        if (xECKey == null) {
            throw new InvalidKeyException(z[7]);
        }
        this.provider = iBMJCEPlusProvider;
        this.xecKey = xECKey;
        try {
            this.algid = XECKey.getAlgId(cURVE);
            this.a(cURVE);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[6]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public EdDSAPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, NamedParameterSpec namedParameterSpec, EdECPoint edECPoint) throws InvalidKeyException {
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[0]);
        }
        this.paramSpec = namedParameterSpec;
        this.point = edECPoint;
        try {
            this.algid = XECKey.getAlgId(namedParameterSpec.getCurve());
            byte[] byArray = edECPoint.getY().toByteArray();
            EdDSAPublicKeyImpl.b(byArray);
            byArray = Arrays.copyOf(byArray, NamedParameterSpec.getPublicCurveSize((NamedParameterSpec.CURVE)namedParameterSpec.getCurve()));
            int n2 = edECPoint.isXOdd() ? 128 : 0;
            byte by = (byte)n2;
            int n3 = byArray.length - 1;
            byArray[n3] = (byte)(byArray[n3] | by);
            this.setKey(new BitArray(byArray.length * 8, byArray));
            byte[] byArray2 = this.b();
            byte[] byArray3 = this.a(byArray2);
            this.xecKey = XECKey.createPublicKey(iBMJCEPlusProvider.a(), byArray3);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[1]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
        this.a(namedParameterSpec);
    }

    public EdDSAPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[2]);
        }
        this.provider = iBMJCEPlusProvider;
        this.decode(byArray);
        try {
            byte[] byArray2 = this.getKey().toByteArray();
            byte by = byArray2[byArray2.length - 1];
            int n2 = byArray2.length - 1;
            byArray2[n2] = (byte)(byArray2[n2] & 0x7F);
            boolean bl = (by & 0x80) != 0;
            boolean bl2 = bl;
            EdDSAPublicKeyImpl.b(byArray2);
            BigInteger bigInteger = new BigInteger(1, byArray2);
            this.point = new EdECPoint(bl2, bigInteger);
            byte[] byArray3 = this.b();
            this.xecKey = XECKey.createPublicKey(iBMJCEPlusProvider.a(), byArray3);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[3]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
        this.a(this.paramSpec);
    }

    private byte[] a(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        ObjectIdentifier objectIdentifier = this.a(derValueArray[0].toDerInputStream(), derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        if (derValueArray.length <= 1) {
            throw new IOException(z[5]);
        }
        Object object = derValueArray[1].getBitString();
        derOutputStream.putBitString(object);
        object = new DerOutputStream();
        object.write((byte)48, derOutputStream);
        return object.toByteArray();
    }

    void a(NamedParameterSpec namedParameterSpec) throws InvalidKeyException {
        if (NamedParameterSpec.getPublicCurveSize((NamedParameterSpec.CURVE)namedParameterSpec.getCurve()) * 8 != this.getKey().length()) {
            throw new InvalidKeyException(z[4] + NamedParameterSpec.getPublicCurveSize((NamedParameterSpec.CURVE)namedParameterSpec.getCurve()));
        }
    }

    public byte[] getEncodedPoint() {
        return this.getKey().toByteArray();
    }

    public EdECPoint getPoint() {
        return this.point;
    }

    public NamedParameterSpec getParams() {
        return this.paramSpec;
    }

    public String getAlgorithm() {
        return this.algid.getName();
    }

    XECKey a() {
        return this.xecKey;
    }

    private ObjectIdentifier a(DerInputStream derInputStream, DerOutputStream derOutputStream) throws IOException {
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        XECKey.checkOid(objectIdentifier);
        NamedParameterSpec.CURVE cURVE = XECKey.getCurve(objectIdentifier, null);
        if (derOutputStream != null) {
            derOutputStream.putOID(objectIdentifier);
        }
        this.paramSpec = new NamedParameterSpec(cURVE);
        return objectIdentifier;
    }

    private byte[] b() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOID(this.algid.getOID());
        derOutputStream.write((byte)48, derOutputStream3.toByteArray());
        derOutputStream.putBitString(this.key);
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public byte[] getEncoded() {
        try {
            NamedParameterSpec.CURVE cURVE = this.paramSpec.getCurve();
            if (this.encodedKey == null) {
                this.encodedKey = this.a(super.getEncoded());
            }
            return (byte[])this.encodedKey.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.encodedKey = (byte[])byArray.clone();
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            if (derValueArray.length < 2) {
                throw new InvalidKeyException(z[10]);
            }
            DerInputStream derInputStream2 = derValueArray[0].toDerInputStream();
            ObjectIdentifier objectIdentifier = this.a(derInputStream2, null);
            this.algid = XECKey.getAlgId(this.paramSpec.getCurve());
            this.key = derValueArray[1].getBitString();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[9]);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private static void b(byte[] byArray) throws IOException {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by = byArray[i2];
            byArray[i2] = byArray[byArray.length - 1 - i2];
            byArray[byArray.length - 1 - i2] = by;
        }
    }

    private static void a(byte[] byArray, int n2, int n3) {
        byte by = byArray[n2];
        byArray[n2] = byArray[n3];
        byArray[n3] = by;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[11];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0013\u0017dO4\u0007\u0000y\u0019>\u0002\u000beV)C\u0007n\u00193\u0016\tg";
        int n3 = -1;
        block18: while (true) {
            char[] cArray;
            block22: {
                int n4;
                int n5;
                block21: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block21;
                    n5 = n5;
                    if (n5 <= n4) break block22;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 99;
                            break;
                        }
                        case 1: {
                            n6 = 101;
                            break;
                        }
                        case 2: {
                            n6 = 11;
                            break;
                        }
                        case 3: {
                            n6 = 57;
                            break;
                        }
                        default: {
                            n6 = 93;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "%\u0004bU8\u0007E\u007fV}\u0000\u0017nX)\u0006EN]\u00190$+I(\u0001\tbZ}\b\u0000r";
                    n3 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0013\u0017dO4\u0007\u0000y\u0019>\u0002\u000beV)C\u0007n\u00193\u0016\tg";
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "%\u0004bU8\u0007E\u007fV}\u0000\u0017nX)\u0006EN]\u00190$+I(\u0001\tbZ}\b\u0000r";
                    n3 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\b\u0000r\u00191\u0006\u000blM5C\b~J)C\u0007n\u0019";
                    n3 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "' Y\u0019.\u0006\u0014~\\3\u0000\u0000+]2\u0006\u0016+W2\u0017EhV3\u0017\u0004bW}\u0013\u0010iU4\u0000E`\\$";
                    n3 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "%\u0004bU8\u0007E\u007fV}\u0000\u0017nX)\u0006ES|\u001eC\u0015~[1\n\u0006+R8\u001a";
                    n3 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001b\u0000hr8\u001aEhX3\r\n\u007f\u0019?\u0006EeL1\u000f";
                    n3 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0013\u0017dO4\u0007\u0000y\u0019>\u0002\u000beV)C\u0007n\u00193\u0016\tg";
                    n3 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "(\u0000r\u00199\f\u0000x\u00193\f\u0011+X-\u0013\u0000jK}\u0017\n+[8C\u0004+|9'6J\u00196\u0006\u001c";
                    n3 = 8;
                    continue block18;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "(\u0000r\u00199\f\u0000x\u00193\f\u0011+X-\u0013\u0000jK}\u0017\n+[8C\u0004+|9'6J\u00196\u0006\u001c";
                    n3 = 9;
                    continue block18;
                }
                case 9: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

