/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.RSAKey;
import com.ibm.crypto.plus.provider.q;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -4315189411360884318L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger modulus;
    private BigInteger privateExponent;
    private BigInteger publicExponent = BigInteger.ZERO;
    private BigInteger primeP = BigInteger.ZERO;
    private BigInteger primeQ = BigInteger.ZERO;
    private BigInteger primeExponentP = BigInteger.ZERO;
    private BigInteger primeExponentQ = BigInteger.ZERO;
    private BigInteger crtCoefficient = BigInteger.ZERO;
    private transient boolean destroyed = false;
    private transient RSAKey rsaKey = null;
    private AlgorithmParameterSpec keyParams;
    private static final String[] z;

    public RSAPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.rsaPrivateKey(this.algid, iBMJCEPlusProvider, bigInteger, bigInteger2);
    }

    public RSAPrivateKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.rsaPrivateKey(this.algid, iBMJCEPlusProvider, bigInteger, bigInteger2);
    }

    public void rsaPrivateKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        block8: {
            this.provider = iBMJCEPlusProvider;
            this.modulus = bigInteger;
            this.privateExponent = bigInteger2;
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
            if (this.modulus != null && this.privateExponent != null) break block8;
            throw new InvalidKeyException(z[7]);
        }
        q.a(this.provider, this.modulus.bitLength(), null);
        try {
            this.key = RSAPrivateKey.a(bigInteger, bigInteger2);
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[9] + iOException.getMessage());
        }
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[8]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[1] + iOException.getMessage());
        }
        q.a(iBMJCEPlusProvider, this.modulus.bitLength(), null);
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[0]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.algid = new AlgIdRSA();
        this.rsaPrivateKey(this.algid, iBMJCEPlusProvider, rSAKey);
    }

    public RSAPrivateKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.rsaPrivateKey(algorithmId, iBMJCEPlusProvider, rSAKey);
    }

    public void rsaPrivateKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = algorithmId;
            this.key = rSAKey.getPrivateKeyBytes();
            this.rsaKey = rSAKey;
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[3]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public static RSAPrivateKey newKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(iBMJCEPlusProvider, byArray);
        return rSAPrivateKey;
    }

    public static RSAPrivateKey newKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(iBMJCEPlusProvider, bigInteger, bigInteger2);
        return rSAPrivateKey;
    }

    @Override
    public String getAlgorithm() {
        this.b();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.b();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.b();
        return super.getEncoded();
    }

    RSAKey a() {
        return this.rsaKey;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            int n2 = derValue.getData().getInteger().intValue();
            if (n2 != 0) {
                throw new IOException(z[6]);
            }
            this.modulus = derValue.getData().getPositiveBigInteger();
            this.publicExponent = derValue.getData().getPositiveBigInteger();
            this.privateExponent = derValue.getData().getPositiveBigInteger();
            this.primeP = derValue.getData().getPositiveBigInteger();
            this.primeQ = derValue.getData().getPositiveBigInteger();
            this.primeExponentP = derValue.getData().getPositiveBigInteger();
            this.primeExponentQ = derValue.getData().getPositiveBigInteger();
            this.crtCoefficient = derValue.getData().getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[5]);
            }
        }
        catch (IOException iOException) {
            throw new IOException(z[4], iOException);
        }
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger2.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    @Override
    public BigInteger getPrivateExponent() {
        this.b();
        return this.privateExponent;
    }

    @Override
    public BigInteger getModulus() {
        this.b();
        return this.modulus;
    }

    private Object writeReplace() throws ObjectStreamException {
        this.b();
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.rsaKey = null;
            this.modulus = null;
            this.publicExponent = null;
            this.privateExponent = null;
            this.primeP = null;
            this.primeQ = null;
            this.primeExponentP = null;
            this.primeExponentQ = null;
            this.crtCoefficient = null;
            this.keyParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void b() {
        if (this.destroyed) {
            throw new IllegalStateException(z[2]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u007f#\u0006\u0000l]b\u001b\u0003)Z0\n\r}\\b=?H\u00192\u001d\u0005\u007fX6\nLb\\;";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                block20: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block20;
                    n5 = n5;
                    if (n5 <= n4) break block21;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 57;
                            break;
                        }
                        case 1: {
                            n6 = 66;
                            break;
                        }
                        case 2: {
                            n6 = 111;
                            break;
                        }
                        case 3: {
                            n6 = 108;
                            break;
                        }
                        default: {
                            n6 = 9;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Z-\u001a\u0000m\u0019,\u0000\u0018)}\u0007=LlW!\u0000\bl\u0003b";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "m*\u0006\u001f)R'\u0016L`Jb\u0001\u0003)U-\u0001\u000blKb\u0019\reP&";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u007f#\u0006\u0000l]b\u001b\u0003)Z0\n\r}\\b=?H\u00192\u001d\u0005\u007fX6\nLb\\;";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "p,\u0019\reP&O>Zxb\u001f\u001e`O#\u001b\t)R'\u0016";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "p,\u0019\reP&O>Zx\u0012\u001d\u0005\u007fX6\n'l@b\n\u0002jV&\u0006\u0002n\u0015b\u000b\r}Xb\u0000\u001alK0\u001a\u0002";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "o'\u001d\u001f`V,O\u0001|J6O\u000el\u0019r";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "k\u0011.LB\\;O\u001chK#\u0002\t}\\0\u001cLjX,\u0001\u0003}\u0019 \nLgL.\u0003";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u007f#\u0006\u0000l]b\u001b\u0003)Z0\n\r}\\b=?H\u00192\u001d\u0005\u007fX6\nLb\\;";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "Z-\u001a\u0000m\u0019,\u0000\u0018)}\u0007=LlW!\u0000\bl\u0003b";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

