/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.MonitoringDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentInfo;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterClientConnectedException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthCenter
implements HealthCenterMBean {
    static final String DEBUG_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.debug";
    public static final int UNLIMITED_MAXSEND = -1;
    public static final boolean isDebug = System.getProperty("com.ibm.java.diagnostics.healthcenter.agent.debug") != null;
    private int currentSession = -1;
    private static final int MIN_SESSION_NUMBER = 0;
    private final List<DataProvider> dataProviders;
    private final int _processId;
    private static final int DEFAULT_CLIENT_TIMEOUT = 600000;
    private int clientTimeout = 600000;
    private long lastConnectTime = 0L;
    private HealthCenterOptionHandler handler;
    private AgentInfo agentInfo;

    public static native String[] getProviders();

    public static native boolean isTraceSubscriberAvailable();

    public HealthCenter(int processId, HealthCenterOptionHandler handler) {
        this.handler = handler;
        this._processId = processId;
        this.dataProviders = new ArrayList<DataProvider>();
        this.agentInfo = new AgentInfo();
        this.registerDataProviders(handler);
    }

    @Override
    public byte[] getJMXData(int dataProviderIndex, int session) throws HealthCenterClientConnectedException {
        this.checkValidSession(session);
        if (dataProviderIndex >= 0 && dataProviderIndex < this.dataProviders.size()) {
            DataProvider provider = this.dataProviders.get(dataProviderIndex);
            try {
                return provider.getJMXData();
            }
            catch (UnsatisfiedLinkError uLE) {
                return provider.getJMXData();
            }
        }
        String message = MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), dataProviderIndex);
        return message.getBytes();
    }

    @Override
    public void resetJMXData(int dataProviderIndex, int session) throws HealthCenterClientConnectedException {
        this.checkValidSession(session);
        if (dataProviderIndex >= 0 && dataProviderIndex < this.dataProviders.size()) {
            DataProvider provider = this.dataProviders.get(dataProviderIndex);
            provider.resetData();
        } else {
            System.out.println(MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), dataProviderIndex));
        }
    }

    public void resetForHeadless(int dataProviderIndex, int session) {
        if (dataProviderIndex >= 0 && dataProviderIndex < this.dataProviders.size()) {
            DataProvider provider = this.dataProviders.get(dataProviderIndex);
            provider.headlessFileInitialise();
        } else {
            System.out.println(MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), dataProviderIndex));
        }
    }

    private void registerDataProviders(HealthCenterOptionHandler handler) {
        String[] sources = HealthCenter.getProviders();
        for (int i = 0; i < sources.length; ++i) {
            this.addDataProvider(new MonitoringDataProvider(sources[i]));
        }
    }

    private void addDataProvider(DataProvider dataProvider) {
        this.dataProviders.add(dataProvider);
        if (isDebug) {
            System.out.println(MessageFormat.format("Added value {0} to position {1}  in _sources array", dataProvider, this.dataProviders.size()));
        }
    }

    @Override
    public List<Map<String, String>> getLiveSourceDetails() {
        ArrayList<Map<String, String>> liveSourceDetails = new ArrayList<Map<String, String>>();
        for (DataProvider dataProvider : this.dataProviders) {
            liveSourceDetails.add(dataProvider.getLiveSourceDetails());
        }
        return liveSourceDetails;
    }

    @Override
    public synchronized int startSession() {
        if (this.handler.getDataCollectionLevel() == DataCollectionLevel.OFF) {
            this.handler.setDataCollectionLevel(DataCollectionLevel.FULL);
        }
        Iterator<DataProvider> it = this.dataProviders.iterator();
        while (it.hasNext()) {
            DataProvider dataProvider = it.next();
            dataProvider.startSession();
            boolean dataAvailable = dataProvider.isDataSupported();
            if (dataAvailable) continue;
            if (isDebug) {
                System.out.println(MessageFormat.format("Removing value {0} from position {1} in dataProviders list", dataProvider, this.dataProviders.indexOf(dataProvider)));
            }
            it.remove();
        }
        if (this.currentSession < Integer.MAX_VALUE) {
            ++this.currentSession;
            this.lastConnectTime = System.currentTimeMillis();
        }
        return this.currentSession;
    }

    private void checkValidSession(int session) throws HealthCenterClientConnectedException {
        if (isDebug) {
            String template = Messages.getString("HealthCenter.checking.session");
            System.out.println(MessageFormat.format(template, session, this.currentSession));
        }
        if (session > this.currentSession || session < 0) {
            throw new IllegalArgumentException(Messages.getString("HealthCenter.invalid.session.identifier"));
        }
        if (session != this.currentSession) {
            String message = Messages.getString("HealthCenter.invalid.session.error.message");
            throw new HealthCenterClientConnectedException(message);
        }
        this.lastConnectTime = System.currentTimeMillis();
    }

    @Override
    public boolean isClientsConnected() {
        boolean isConnected = false;
        if (this.currentSession >= 0) {
            long interval = System.currentTimeMillis() - this.lastConnectTime;
            isConnected = interval < (long)this.clientTimeout;
        }
        return isConnected;
    }

    @Override
    public void setClientTimeout(int time) {
        this.clientTimeout = time;
    }

    @Override
    public void modify(int source, int session, String command, String ... params) throws HealthCenterClientConnectedException, ProviderModificationException {
        this.checkValidSession(session);
        if (source >= 0 && source < this.dataProviders.size()) {
            DataProvider provider = this.dataProviders.get(source);
            provider.modify(command, params);
        }
    }

    @Override
    public void restartProvider(int dataProviderIndex, int session) throws HealthCenterClientConnectedException {
        this.checkValidSession(session);
        if (dataProviderIndex >= 0 && dataProviderIndex < this.dataProviders.size()) {
            DataProvider provider = this.dataProviders.get(dataProviderIndex);
            provider.restartProvider();
        } else {
            System.out.println(MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), dataProviderIndex));
        }
    }

    @Override
    public boolean isHardRealtimeVM() {
        if (System.getProperty("com.ibm.jvm.realtime") != null) {
            return System.getProperty("com.ibm.jvm.realtime").contains("hard");
        }
        return false;
    }

    @Override
    public boolean isSoftRealtimeVM() {
        if (System.getProperty("com.ibm.jvm.realtime") != null) {
            return System.getProperty("com.ibm.jvm.realtime").contains("soft");
        }
        return false;
    }

    @Override
    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public static native void isLoaded();
}

